/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.datasetcontainer.transform.uvscale;

import java.io.IOException;
import javax.swing.JOptionPane;
import no.uib.cipr.matrix.Matrix;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.common.Threader;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.common.swing.EvinceBorderFactory;
import se.prediktera.map.datasetcontainer.datainfo.AbstractDataInfo;
import se.prediktera.map.datasetcontainer.datainfo.AbstractInnerColumn;
import se.prediktera.map.datasetcontainer.datainfo.InnerColumnBooleanScaleWithClasses;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.datasetcontainer.transform.AbstractDataTransform;
import se.prediktera.map.datasetcontainer.transform.AbstractTransform;
import se.prediktera.map.datasetcontainer.transform.Transformations;

public class TUVScale
extends AbstractDataTransform {
    public static final String Name = "UV Scale";
    private boolean ispareto = false;

    public TUVScale(AbstractDataInfo abstractDataInfo, boolean bl, boolean bl2) {
        super(abstractDataInfo, bl);
        this.ispareto = bl2;
        this.setLayerName(this.getName());
    }

    public TUVScale(RandomInputStream randomInputStream, MapProperty mapProperty) throws IOException {
        super(randomInputStream, mapProperty);
        this.ispareto = mapProperty.getPropertyBoolean("pareto");
    }

    public TUVScale(Transformations transformations, AbstractDataTransform abstractDataTransform, boolean bl) {
        super(transformations, abstractDataTransform);
        this.ispareto = bl;
        this.setLayerName(this.getName());
    }

    @Override
    public AbstractDataMatrix applyTransformationLocal(final AbstractDataMatrix abstractDataMatrix, Matrix matrix, final ProgressManager progressManager) throws Exception {
        int n = abstractDataMatrix.getK();
        final int n2 = abstractDataMatrix.getN();
        if (n > 0 && n2 > 0) {
            this.intermediateMatrix.beginCalculations();
            final byte[] byArray = this.getIncludedData();
            Threader threader = new Threader(this){
                final /* synthetic */ TUVScale this$0;
                {
                    this.this$0 = tUVScale;
                }

                @Override
                protected void doOp(boolean bl, int n, int n22) {
                    double[] dArray = this.this$0.intermediateMatrix.getDoubleMatrix().getData();
                    for (int i = n; i < n22; ++i) {
                        if (dArray[i] != 0.0 && (byArray == null || byArray[i] > 0)) {
                            int n3 = abstractDataMatrix.getMissingCountForColumn(i);
                            for (int j = 0; j < n2; ++j) {
                                if (!(n3 != 0 && abstractDataMatrix.isMissing(j, i) || i >= dArray.length)) {
                                    abstractDataMatrix.multValue(j, i, dArray[i]);
                                }
                                if (!bl || progressManager == null) continue;
                                progressManager.incStep(2);
                            }
                            continue;
                        }
                        if (!bl || progressManager == null) continue;
                        progressManager.incStep(2 * n2);
                    }
                }
            };
            threader.execute(n);
            this.intermediateMatrix.endCalculations();
        }
        return abstractDataMatrix;
    }

    @Override
    public AbstractTransform<Boolean> cloneThis(Transformations transformations) {
        return new TUVScale(transformations, this, this.ispareto);
    }

    @Override
    public AbstractInnerColumn<Boolean> createInnerColumn(String string, Transformations transformations) {
        return new InnerColumnBooleanScaleWithClasses(string, transformations, null, -1);
    }

    @Override
    public String getName() {
        if (this.ispareto) {
            return "Pareto";
        }
        return Name;
    }

    @Override
    public String getShortName() {
        if (this.ispareto) {
            return "Pareto";
        }
        return "UV";
    }

    @Override
    public AbstractTransform.Type getTransformationType() {
        return AbstractTransform.Type.localUpdate;
    }

    @Override
    public byte getTreeType() {
        return 1;
    }

    @Override
    public boolean isScale() {
        return true;
    }

    @Override
    public void reverseTransformationLocal(final AbstractDataMatrix abstractDataMatrix, Matrix matrix, boolean bl) throws Exception {
        final double[] dArray = this.intermediateMatrix.getDoubleMatrix().getData();
        int n = Math.min(abstractDataMatrix.getK(), dArray.length);
        final int n2 = abstractDataMatrix.getN();
        final byte[] byArray = this.getIncludedData();
        Threader threader = new Threader(this){

            @Override
            protected void doOp(boolean bl, int n, int n22) {
                for (int i = n; i < n22; ++i) {
                    if (dArray[i] == 0.0 || byArray != null && byArray[i] <= 0) continue;
                    for (int j = 0; j < n2; ++j) {
                        if (abstractDataMatrix.isMissing(j, i)) continue;
                        double d = abstractDataMatrix.getValue(j, i);
                        abstractDataMatrix.setValue(j, i, d / dArray[i]);
                    }
                }
            }
        };
        threader.execute(n);
    }

    @Override
    public void SaveProperty(RandomOutputStream randomOutputStream) throws IOException {
        super.SaveProperty(randomOutputStream);
        randomOutputStream.writePropertyBoolean("pareto", this.ispareto);
    }

    @Override
    public double scaleValue(AbstractDataMatrix abstractDataMatrix, int n, int n2, double d) {
        double d2;
        if (this.isIncluded(n2) && (d2 = abstractDataMatrix.getVariableStandardDeviation(n2)) != 0.0) {
            if (this.ispareto) {
                d2 = Math.sqrt(d2);
            }
            return d / d2;
        }
        return d;
    }

    @Override
    public double transformValue(AbstractDataMatrix abstractDataMatrix, int n, int n2, int n3, int n4, double d) {
        double d2;
        if (n2 < this.intermediateMatrix.getN() && this.isIncluded(n4) && (d2 = this.intermediateMatrix.getValue(n2, 0)) != 0.0) {
            return d * d2;
        }
        return d;
    }

    @Override
    protected void calculateIntermediateMatrix(ProgressManager progressManager, AbstractDataMatrix abstractDataMatrix, boolean bl) throws Exception {
        int n = abstractDataMatrix.getK();
        if (bl || this.intermediateMatrix == null || this.intermediateMatrix.getN() < n) {
            this.createIntermediateMatrix(abstractDataMatrix);
            if (this.ispareto) {
                this.intermediateMatrix.setName("1/sqrt(standard deviation of " + String.valueOf(abstractDataMatrix) + ")");
            } else {
                this.intermediateMatrix.setName("1/(standard deviation of " + String.valueOf(abstractDataMatrix) + ")");
            }
            abstractDataMatrix.getVariableStandardDeviation(progressManager, this.intermediateMatrix);
            StringBuilder stringBuilder = null;
            for (int i = 0; i < n; ++i) {
                double d = this.intermediateMatrix.getValue(i, 0);
                if (d > 0.0) {
                    if (this.ispareto) {
                        d = Math.sqrt(d);
                    }
                    d = 1.0 / d;
                    this.intermediateMatrix.setValue(i, 0, d);
                    if (!(d < 1.0E-25)) continue;
                    if (stringBuilder == null) {
                        stringBuilder = new StringBuilder(abstractDataMatrix.getColumnDescription(i, 0));
                        continue;
                    }
                    stringBuilder.append(", ").append(abstractDataMatrix.getColumnDescription(i, 0));
                    continue;
                }
                this.intermediateMatrix.setValue(i, 0, 0.0);
            }
            if (stringBuilder != null) {
                JOptionPane jOptionPane = new JOptionPane("When UV-scaling, very small scales for the following variables were found:\n" + String.valueOf(stringBuilder) + "\nIt is recommended you exclude them and recalculate the model.", 2, -1){

                    @Override
                    public int getMaxCharactersPerLineCount() {
                        return 60;
                    }
                };
                jOptionPane.createDialog(progressManager.getWindow(), "Warning").setVisible(true);
            }
        }
    }

    @Override
    protected byte changeEffects() {
        return 2;
    }

    @Override
    protected void initiateGUILocal() {
        super.initiateGUILocal();
        this.mainPanel.setBorder(EvinceBorderFactory.createEvinceBorder(this.getName()));
    }
}

