/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.datasetcontainer.transform.value;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import se.prediktera.map.common.CMenu;
import se.prediktera.map.common.JValidateNumberField;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.common.interaction.InteractionArray;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.common.swing.flat.JFlatButton;
import se.prediktera.map.dataimport.FastDecimal;
import se.prediktera.map.datasetcontainer.DataTreeInterface;
import se.prediktera.map.datasetcontainer.datainfo.AbstractDataInfo;
import se.prediktera.map.datasetcontainer.datainfo.AbstractInnerColumn;
import se.prediktera.map.datasetcontainer.datainfo.DataInfoEvent;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.datasetcontainer.transform.AbstractTransform;
import se.prediktera.map.datasetcontainer.transform.Transformations;
import se.prediktera.map.datasetcontainer.transform.value.AddedValueSettingsPanel;
import se.prediktera.map.datasetcontainer.value.InnerColumnValue;
import se.prediktera.map.main.Main_GUI;
import se.prediktera.map.main.Project_GUI;
import se.prediktera.map.main.script.ScriptHelper;

public class AddedValue
extends AbstractTransform<FastDecimal> {
    private final JValidateNumberField valueTextfield = new JValidateNumberField(true);
    private AddedValueSettingsPanel panel;
    private AbstractDataMatrix matrix;
    private boolean defaultYvalue;

    public AddedValue(AbstractDataInfo abstractDataInfo, boolean bl, AbstractInnerColumn<FastDecimal> abstractInnerColumn) {
        super(abstractDataInfo, bl);
        this.ic = abstractInnerColumn;
        this.setLayerName(this.getName());
    }

    public AddedValue(AbstractDataInfo abstractDataInfo, String string, boolean bl) {
        super(abstractDataInfo, bl, string);
    }

    public AddedValue(RandomInputStream randomInputStream, MapProperty mapProperty) throws IOException {
        super(randomInputStream, mapProperty);
        this.defaultYvalue = mapProperty.getPropertyBoolean("yv", true);
    }

    public AddedValue(Transformations transformations, AddedValue addedValue) {
        super(transformations, addedValue);
    }

    public void addSetSelectedMenuItems(CMenu cMenu) {
        cMenu.add(new AbstractAction("Set value"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                double d = AddedValue.this.setNewValue(Main_GUI.get(), false);
                if (Double.isNaN(d)) {
                    AddedValue.this.setValue(0.0, true);
                } else if (d != -1.0) {
                    AddedValue.this.setValue(d, false);
                }
            }
        });
        cMenu.add(new AbstractAction("Clear value"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AddedValue.this.setValue(0.0, true);
            }
        });
    }

    @Override
    public AbstractDataMatrix applyTransformation(AbstractDataMatrix abstractDataMatrix, ProgressManager progressManager, boolean bl) {
        if (this.isObs) {
            this.createResults(this.ic.getSize(), 1);
        } else {
            this.createResults(1, this.ic.getSize());
        }
        String[] stringArray = new String[]{this.toString()};
        this.results.beginCalculations();
        InnerColumnValue innerColumnValue = (InnerColumnValue)this.ic;
        for (int i = 0; i < this.ic.getSize(); ++i) {
            double d = innerColumnValue.getDoubleLocal(i);
            boolean bl2 = innerColumnValue.isMissingLocal(i);
            if (this.isObs) {
                this.results.setValue(i, 0, d, bl2);
                continue;
            }
            this.results.setValue(0, i, d, bl2);
        }
        if (this.isObs) {
            this.setVarDescription(this.results, stringArray);
        } else {
            this.setObsDescription(this.results, stringArray);
        }
        if (progressManager != null) {
            progressManager.incStep(2 * abstractDataMatrix.getK() * abstractDataMatrix.getN());
        }
        this.results.endCalculations();
        return this.results;
    }

    @Override
    public AbstractTransform<FastDecimal> cloneThis(Transformations transformations) {
        AddedValue addedValue = new AddedValue(transformations, this);
        addedValue.defaultYvalue = this.defaultYvalue;
        InnerColumnValue innerColumnValue = (InnerColumnValue)this.ic;
        InnerColumnValue innerColumnValue2 = (InnerColumnValue)addedValue.ic;
        innerColumnValue2.beginUpdate();
        for (int i = 0; i < addedValue.ic.getSize(); ++i) {
            innerColumnValue2.setDoubleLocal(i, innerColumnValue.getDoubleLocal(i), innerColumnValue.isMissingLocal(i));
        }
        innerColumnValue2.endUpdate();
        return addedValue;
    }

    @Override
    public AbstractInnerColumn<FastDecimal> createInnerColumn(String string, Transformations transformations) {
        return new InnerColumnValue(string, transformations, null, -1);
    }

    public void fillColumn(AbstractDataInfo abstractDataInfo, AbstractDataMatrix abstractDataMatrix, int n, int n2, int n3, int n4) {
        this.ic.beginUpdate();
        InnerColumnValue innerColumnValue = (InnerColumnValue)this.ic;
        for (int i = 0; i < this.ic.getSize(); ++i) {
            innerColumnValue.setDoubleLocal(i, 0.0, true);
        }
        this.ic.endUpdate();
    }

    @Override
    public byte getColumnType(int n) {
        if (this.defaultYvalue) {
            return 13;
        }
        return 12;
    }

    @Override
    public String getName() {
        if (this.ic != null) {
            return this.ic.toString();
        }
        return "Values";
    }

    @Override
    public byte getRowType(int n) {
        return 12;
    }

    @Override
    public String getShortName() {
        return this.getName();
    }

    @Override
    public AbstractTransform.Type getTransformationType() {
        return AbstractTransform.Type.localAdd;
    }

    @Override
    public byte getTreeType() {
        return 13;
    }

    @Override
    public void LoadData(RandomInputStream randomInputStream) throws IOException {
        DataTreeInterface dataTreeInterface;
        randomInputStream.beginDataBlock("Loading transformations into memory", false);
        int n = randomInputStream.ReadBlockInt();
        if (n > 0 && (dataTreeInterface = this.getTreeParent().getTreeParent()) instanceof Transformations) {
            Transformations transformations = (Transformations)dataTreeInterface;
            if (this.ic == null) {
                this.ic = new InnerColumnValue(null, transformations, null, -1);
            }
            this.ic.Load(randomInputStream, transformations.getSaveVersion());
        }
        this.loadDataLocal(randomInputStream);
        randomInputStream.endDataBlock();
    }

    @Override
    public void reverseTransformation(AbstractDataMatrix abstractDataMatrix, boolean bl) {
    }

    @Override
    public void SaveProperty(RandomOutputStream randomOutputStream) throws IOException {
        super.SaveProperty(randomOutputStream);
        randomOutputStream.writePropertyBoolean("yv", this.defaultYvalue);
    }

    public void set(Double d, Double d2) {
        InnerColumnValue innerColumnValue = (InnerColumnValue)this.ic;
        innerColumnValue.setDoubleLocal(d.intValue() - 1, d2, false);
    }

    public void setBySelection(double d) {
        InteractionArray interactionArray = this.getInteractionArray(this.isObservation() ? 1 : 2);
        if (interactionArray != null) {
            InnerColumnValue innerColumnValue = (InnerColumnValue)this.ic;
            innerColumnValue.beginUpdate();
            for (int i = 0; i < interactionArray.size() && i < this.ic.getSize(); ++i) {
                if (!interactionArray.get(i)) continue;
                innerColumnValue.setDoubleLocal(i, d, false);
            }
            this.dataInfo.triggerEvent(new DataInfoEvent(this.dataInfo, 9, this));
            innerColumnValue.endUpdate();
        }
    }

    @Override
    public boolean setCreated(Project_GUI project_GUI, AbstractDataInfo abstractDataInfo) {
        if (!super.setCreated(project_GUI, abstractDataInfo)) {
            return false;
        }
        if (this.panel != null) {
            this.panel.fillColumn(this.matrix, this);
            this.defaultYvalue = this.panel.isYValue();
            this.panel = null;
            this.matrix = null;
        }
        return true;
    }

    public void setDefaultYvalue(boolean bl) {
        this.defaultYvalue = bl;
        if (this.panel != null) {
            this.panel.setYValue(bl);
        }
    }

    @Override
    public void setExtraArgument(Properties properties) {
        if (properties != null && ScriptHelper.hasKey(properties, "yvalue")) {
            this.setDefaultYvalue(ScriptHelper.getPropertyBool(properties, "yvalue"));
        }
    }

    public void setSettingsPanel(AddedValueSettingsPanel addedValueSettingsPanel, AbstractDataMatrix abstractDataMatrix) {
        this.panel = addedValueSettingsPanel;
        this.matrix = abstractDataMatrix;
    }

    @Override
    protected boolean addToPopup(DataTreeInterface dataTreeInterface, CMenu cMenu) {
        CMenu cMenu2 = new CMenu("Set selected to...", false);
        cMenu.add(cMenu2);
        this.addSetSelectedMenuItems(cMenu2);
        super.addToPopup(dataTreeInterface, cMenu);
        return true;
    }

    @Override
    protected void initiateGUILocal() {
        this.mainPanel.setLayout(new BoxLayout(this.mainPanel, 1));
        JFlatButton jFlatButton = new JFlatButton(new ImageIcon(Main_GUI.class.getResource("gifother/left.gif")));
        jFlatButton.setPreferredSize(new Dimension(27, 21));
        jFlatButton.setToolTipText("Set Selected Rows to value");
        this.valueTextfield.setRoundDoubles(false);
        jFlatButton.addActionListener(actionEvent -> {
            this.valueTextfield.forceValidateInput();
            this.setValue(this.valueTextfield.getNumber(), false);
        });
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.mainPanel.add(jPanel);
        jPanel.add((Component)jFlatButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(6, 6, 0, 0), 0, 0));
        jPanel.add((Component)this.valueTextfield, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 2, new Insets(6, 6, 0, 6), 0, 0));
    }

    private double setNewValue(Component component, boolean bl) {
        String string = JOptionPane.showInputDialog(component, "Choose value (mv = missing):", "0");
        if (string != null) {
            if (bl) {
                this.dataInfo.triggerGlobalEvent(new DataInfoEvent(this.dataInfo, 9, this));
            }
            try {
                if (string.equalsIgnoreCase("mv")) {
                    return Double.NaN;
                }
                string = string.replace(',', '.');
                return Double.parseDouble(string);
            }
            catch (NumberFormatException numberFormatException) {
                JOptionPane.showConfirmDialog(this, "Not a valid number", "Invalid input", -1, 1);
            }
        }
        return -1.0;
    }

    private void setValue(double d, boolean bl) {
        InteractionArray interactionArray = this.getInteractionArray(this.isObs ? 1 : 2);
        if (interactionArray != null) {
            this.ic.beginUpdate();
            InnerColumnValue innerColumnValue = (InnerColumnValue)this.ic;
            for (int i = 0; i < interactionArray.size() && i < this.ic.getSize(); ++i) {
                if (!interactionArray.get(i)) continue;
                innerColumnValue.setDoubleLocal(i, d, bl);
            }
            this.ic.endUpdate();
            this.dataInfo.triggerGlobalEvent(new DataInfoEvent(this.dataInfo, 7, this));
        }
    }
}

