/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.datasetcontainer.transform.value;

import java.util.Properties;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.dataimport.FastDecimal;
import se.prediktera.map.datasetcontainer.DataTreeInterface;
import se.prediktera.map.datasetcontainer.classes.ClassTypes;
import se.prediktera.map.datasetcontainer.classes.InnerColumnClass;
import se.prediktera.map.datasetcontainer.datainfo.DataInfoEvent;
import se.prediktera.map.datasetcontainer.dataset.DataSet;
import se.prediktera.map.datasetcontainer.transform.value.AddedValue;
import se.prediktera.map.datasetcontainer.value.InnerColumnValue;
import se.prediktera.map.main.Project_GUI;
import se.prediktera.map.main.script.ScriptHelper;
import se.prediktera.map.model.analysis.AbstractAnalysisInfo;
import se.prediktera.map.plot.axisplot.windows.FloatWindow;
import se.prediktera.map.register.RegisterKeyManager;

public class AddedValueAnalysisInfo
extends AbstractAnalysisInfo {
    public void createDialog() {
    }

    @Override
    public Object performAnalysis(ProgressManager progressManager, Object[] objectArray, Properties properties) {
        InnerColumnClass innerColumnClass = (InnerColumnClass)objectArray[0];
        DataSet dataSet = innerColumnClass.getDataInfo().getDataSet();
        ClassTypes classTypes = innerColumnClass.getObject();
        double[] dArray = new double[classTypes.size()];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = i;
            if (properties == null || !ScriptHelper.hasKey(properties, "class" + (i + 1))) continue;
            dArray[i] = ScriptHelper.getPropertyDouble(properties, "class" + (i + 1));
        }
        AddedValue addedValue = (AddedValue)dataSet.createModification(progressManager, "obs", "new variable", properties);
        if (properties != null && ScriptHelper.hasKey(properties, "name")) {
            addedValue.setName(ScriptHelper.getProperty(properties, "name"));
        }
        InnerColumnValue innerColumnValue = (InnerColumnValue)addedValue.getInnerColumn();
        innerColumnValue.beginUpdate();
        FastDecimal fastDecimal = new FastDecimal();
        for (int i = 0; i < innerColumnClass.getSize(); ++i) {
            short s = innerColumnClass.getValueShort(i);
            fastDecimal.setValue(dArray[s]);
            innerColumnValue.setValueLocal(i, fastDecimal);
        }
        innerColumnValue.endUpdate();
        innerColumnValue.getDataInfo().triggerGlobalEvent(new DataInfoEvent(innerColumnValue.getDataInfo(), 7, addedValue));
        return addedValue;
    }

    @Override
    public void showAnalysisDialog(Project_GUI project_GUI, DataTreeInterface dataTreeInterface) {
    }

    @Override
    public boolean supportParam(Object[] objectArray) {
        if (RegisterKeyManager.isPredikteraDevelopmentLicense()) {
            return objectArray.length != 1 || !(objectArray[0] instanceof FloatWindow);
        }
        return false;
    }

    public String toString() {
        return "Added Value";
    }
}

