/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.datasetcontainer.transform.value;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;
import se.prediktera.map.common.JValidateNumberField;
import se.prediktera.map.common.swing.EvinceBorderFactory;
import se.prediktera.map.common.swing.JTextInputField;
import se.prediktera.map.common.wizard.WizardPageClass;
import se.prediktera.map.datasetcontainer.datainfo.AbstractDataInfo;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.datasetcontainer.transform.Transformations;
import se.prediktera.map.datasetcontainer.transform.value.AddedValue;

public class AddedValueSettingsPanel
extends WizardPageClass {
    private final JTextInputField name = new JTextInputField(this);
    private final JValidateNumberField valueTextfield = new JValidateNumberField(-2.147483647E9, 2.147483647E9, true);
    private final JRadioButton xRadioButton = new JRadioButton("X values");
    private final JRadioButton yRadioButton = new JRadioButton("Y values");
    private AbstractDataInfo dataInfo1 = null;

    public AddedValueSettingsPanel() {
        this((AbstractDataInfo)null);
    }

    public AddedValueSettingsPanel(AbstractDataInfo abstractDataInfo) {
        super(new BorderLayout());
        this.dataInfo1 = abstractDataInfo;
        if (abstractDataInfo != null) {
            this.jbinit();
        }
    }

    public void fillColumn(AbstractDataMatrix abstractDataMatrix, AddedValue addedValue) {
        this.valueTextfield.forceValidateInput();
        double d = this.valueTextfield.getNumber();
        addedValue.setBySelection(d);
    }

    @Override
    public String getName() {
        if (this.name != null) {
            return this.name.getText();
        }
        return "N/A";
    }

    public boolean isYValue() {
        return this.yRadioButton.isSelected();
    }

    @Override
    public void pageShown() {
        SwingUtilities.invokeLater(() -> {
            this.name.selectAll();
            this.name.requestFocus();
        });
    }

    public void setYValue(boolean bl) {
        if (bl) {
            this.yRadioButton.setSelected(true);
        } else {
            this.xRadioButton.setSelected(true);
        }
    }

    @Override
    protected void cleanUpChild() {
        this.dataInfo1 = null;
    }

    private String getIndexName(int n) {
        String string = "New Observation";
        if (this.dataInfo1.getDataType() == 0) {
            string = "New Variable";
        }
        if (n > 0) {
            return string + " (" + n + ")";
        }
        return string;
    }

    private String getUniqueClassName() {
        boolean bl;
        if (this.dataInfo1 == null) {
            return this.getIndexName(-1);
        }
        Transformations transformations = (Transformations)this.dataInfo1.getGroupColumnByType(10);
        int n = transformations.getColumnCount();
        int n2 = 0;
        block0: do {
            bl = false;
            for (int i = 0; i < n; ++i) {
                if (transformations.getColumnType(i) != 13 || !this.getIndexName(n2).equals(transformations.getColumnName(i))) continue;
                bl = true;
                ++n2;
                continue block0;
            }
        } while (bl);
        return this.getIndexName(n2);
    }

    private void jbinit() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        if (this.dataInfo1.getDataType() == 0) {
            jPanel.setBorder(EvinceBorderFactory.createEvinceBorder("New Variable Settings"));
        } else {
            jPanel.setBorder(EvinceBorderFactory.createEvinceBorder("New Observation Settings"));
        }
        this.add((Component)jPanel, "Center");
        this.name.setText(this.getUniqueClassName());
        jPanel.add((Component)new JLabel("Data Name:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(6, 6, 0, 6), 0, 0));
        jPanel.add((Component)this.name, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(6, 6, 0, 6), 0, 0));
        jPanel.add((Component)new JLabel("Data Value:"), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(6, 6, 6, 6), 0, 0));
        this.valueTextfield.setRoundDoubles(false);
        jPanel.add((Component)this.valueTextfield, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 18, 2, new Insets(6, 6, 6, 6), 0, 0));
        if (this.dataInfo1.getDataType() == 0) {
            jPanel.add((Component)new JLabel("Add new variable values as:"), new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(6, 6, 0, 6), 0, 0));
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(this.xRadioButton);
            buttonGroup.add(this.yRadioButton);
            this.yRadioButton.setSelected(true);
            jPanel.add((Component)this.xRadioButton, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 18, 0, new Insets(6, 6, 0, 6), 0, 0));
            jPanel.add((Component)this.yRadioButton, new GridBagConstraints(1, 4, 1, 1, 1.0, 1.0, 18, 0, new Insets(6, 6, 6, 6), 0, 0));
        } else {
            jPanel.add((Component)new JLabel(""), new GridBagConstraints(1, 2, 1, 1, 1.0, 1.0, 18, 0, new Insets(6, 6, 6, 6), 0, 0));
        }
    }
}

