/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.datasetcontainer.transform.wizard;

import java.awt.Dimension;
import java.awt.Image;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import se.prediktera.map.common.cleanup.CleanUpInterface;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.common.progress.ProgressManagerImpl;
import se.prediktera.map.common.wizard.AbstractWizard;
import se.prediktera.map.common.wizard.AbstractWizardInfo;
import se.prediktera.map.common.wizard.ComponentBaner;
import se.prediktera.map.common.wizard.SelectWizardPage;
import se.prediktera.map.common.wizard.WizardDialog;
import se.prediktera.map.common.wizard.WizardPageClass;
import se.prediktera.map.data.DescriptionInfo;
import se.prediktera.map.data.datasettable.AbstractSettings;
import se.prediktera.map.datasetcontainer.DataTreeInterface;
import se.prediktera.map.datasetcontainer.datainfo.AbstractDataInfo;
import se.prediktera.map.datasetcontainer.datainfo.DataInfoEvent;
import se.prediktera.map.datasetcontainer.dataset.DataSet;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.datasetcontainer.transform.AbstractTransform;
import se.prediktera.map.datasetcontainer.transform.AbstractTransformInfo;
import se.prediktera.map.datasetcontainer.transform.category.CategoryInfo;
import se.prediktera.map.datasetcontainer.transform.reduce.ReduceInfo;
import se.prediktera.map.datasetcontainer.transform.value.AbstractAddedValueInfo;
import se.prediktera.map.datasetcontainer.transform.value.AddedValue;
import se.prediktera.map.main.Main_GUI;
import se.prediktera.map.main.Project_GUI;
import se.prediktera.map.main.StatusBar;
import se.prediktera.map.main.extclass.AbstractInfo;
import se.prediktera.map.main.extclass.ExtClassLoader;
import se.prediktera.map.main.layer.AbstractLayer;
import se.prediktera.map.main.layer.LayerContainer;

public class TransformationWizard
extends AbstractWizard {
    protected SelectWizardPage page1;
    private final boolean variable;
    private AbstractDataInfo dataInfo1 = null;
    private AbstractDataInfo dataInfo2 = null;
    private DataSet dataSet;

    public static void addExternTransforms(boolean bl, List<AbstractWizardInfo> list, DataSet dataSet, DataTreeInterface dataTreeInterface) {
        boolean bl2 = dataSet == null ? false : dataSet.isProtected();
        List<AbstractInfo> list2 = ExtClassLoader.getAbstractInfoFromType(AbstractInfo.TRANSFORM_INFO, TransformationWizard.getTransformationComparator());
        for (AbstractInfo abstractInfo : list2) {
            AbstractTransformInfo abstractTransformInfo = (AbstractTransformInfo)abstractInfo;
            if (dataTreeInterface != null && !abstractTransformInfo.supportData(dataTreeInterface) || (!bl || !abstractTransformInfo.appliesToVariables(dataTreeInterface)) && (bl || !abstractTransformInfo.appliesToObservations(dataTreeInterface)) || bl2 && abstractTransformInfo.getType() != AbstractTransform.Type.globalAdd) continue;
            list.add(abstractTransformInfo);
        }
    }

    private static Comparator getTransformationComparator() {
        return new Comparator(){
            final String[] ORDER = new String[]{"Center", "UV Scale", "Pareto", "Interaction Term", "Logarithm", "Quad Term", "Function", "Spectral"};

            public int compare(Object object, Object object2) {
                if (object instanceof AbstractTransformInfo) {
                    AbstractTransformInfo abstractTransformInfo = (AbstractTransformInfo)object;
                    if (object2 instanceof AbstractTransformInfo) {
                        AbstractTransformInfo abstractTransformInfo2 = (AbstractTransformInfo)object2;
                        int n = 0;
                        if (abstractTransformInfo.getPath() != null) {
                            n = abstractTransformInfo.getPath().length();
                        }
                        int n2 = 0;
                        if (abstractTransformInfo2.getPath() != null) {
                            n2 = abstractTransformInfo2.getPath().length();
                        }
                        if (n != n2) {
                            return Float.compare(n, n2);
                        }
                        for (String string : this.ORDER) {
                            if (abstractTransformInfo.toString().compareTo(string) == 0) {
                                return 0;
                            }
                            if (abstractTransformInfo2.toString().compareTo(string) != 0) continue;
                            return 1;
                        }
                    }
                }
                return object.toString().compareTo(object2.toString());
            }
        };
    }

    public TransformationWizard(boolean bl, DataSet dataSet) {
        this.variable = bl;
        if (bl) {
            this.dataInfo1 = dataSet.getVarDataInfo();
            this.dataInfo2 = dataSet.getObsDataInfo();
        } else {
            this.dataInfo1 = dataSet.getObsDataInfo();
            this.dataInfo2 = dataSet.getVarDataInfo();
        }
        this.dataSet = dataSet;
        this.page1 = new SelectWizardPage(this, dataSet, false){

            @Override
            protected String getPageHeading() {
                return "Select Type:";
            }
        };
        this.page1.allowMultiSelection(true);
        this.addPage(this.page1, "Page1");
    }

    @Override
    public void addExtern(List<AbstractWizardInfo> list, DataTreeInterface dataTreeInterface) {
        TransformationWizard.addExternTransforms(this.variable, list, this.dataSet, dataTreeInterface);
        list.add(new DescriptionInfo());
    }

    @Override
    public boolean canFinish() {
        return true;
    }

    public void createLayers(final AbstractSettings abstractSettings, final AbstractDataMatrix abstractDataMatrix, final boolean bl, final AbstractDataInfo abstractDataInfo) {
        if (this.page1 != null) {
            ProgressManagerImpl progressManagerImpl = new ProgressManagerImpl(this){
                final /* synthetic */ TransformationWizard this$0;
                {
                    this.this$0 = transformationWizard;
                }

                @Override
                public Object doWork() {
                    Object object;
                    this.setInfoText("Creating modification");
                    ArrayList<AbstractTransform> arrayList = new ArrayList<AbstractTransform>();
                    Iterator<AbstractWizardInfo> iterator = this.this$0.page1.getAllWizardInfo().iterator();
                    Project_GUI project_GUI = this.this$0.dataSet.getCase().getDataTreeManager().getProject();
                    while (iterator.hasNext()) {
                        CleanUpInterface cleanUpInterface;
                        object = iterator.next();
                        if (object instanceof AbstractTransformInfo) {
                            try {
                                cleanUpInterface = (AbstractTransformInfo)object;
                                if (!cleanUpInterface.isCreated()) {
                                    cleanUpInterface.createWizard();
                                }
                                long l = System.currentTimeMillis();
                                AbstractTransform abstractTransform = cleanUpInterface.createTransform(abstractDataMatrix, bl, abstractDataInfo);
                                abstractTransform.setDuration(System.currentTimeMillis() - l);
                                if (abstractSettings == null) {
                                    abstractTransform.setCreated(project_GUI, abstractDataInfo);
                                    LayerContainer layerContainer = (LayerContainer)abstractDataInfo.getTransformationNode(abstractTransform.getTransformationType());
                                    abstractTransform.setLayerVisible(layerContainer.isLayerVisible());
                                    layerContainer.addTreeNode(abstractTransform);
                                    DataInfoEvent dataInfoEvent = new DataInfoEvent(abstractDataInfo, 0, abstractTransform, null, this);
                                    this.this$0.dataSet.triggetDataInfoEvent(dataInfoEvent);
                                } else {
                                    abstractSettings.addLayer(abstractTransform, (ProgressManager)this);
                                }
                                if (abstractTransform instanceof AddedValue) {
                                    // empty if block
                                }
                                arrayList.add(abstractTransform);
                            }
                            catch (Exception exception) {
                                ErrorHandler.logAndShowEvinceErrorDialogForException(exception);
                            }
                            continue;
                        }
                        if (!(object instanceof DescriptionInfo)) continue;
                        try {
                            cleanUpInterface = ((DescriptionInfo)object).createDescription(abstractDataMatrix, bl, abstractDataInfo);
                            if (abstractSettings != null) {
                                abstractSettings.addLayer((AbstractLayer)cleanUpInterface, (ProgressManager)this);
                            }
                            this.this$0.askIfShouldUpdate();
                        }
                        catch (Exception exception) {
                            ErrorHandler.logAndShowEvinceErrorDialogForException(exception);
                        }
                    }
                    object = arrayList.iterator();
                    while (object.hasNext()) {
                        ((AbstractTransform)object.next()).workDone(null);
                    }
                    Main_GUI.setStatusMessage(StatusBar.MessageType.INFORMATION, "Created modification(s)", 15);
                    return null;
                }
            };
            progressManagerImpl.run();
        }
    }

    @Override
    public int executeWizard() {
        return this.executeWizard(0);
    }

    public int executeWizard(int n) {
        this.setPreferredSize(new Dimension(500, 400));
        this.wizardWindow = new WizardDialog("New Modification Wizard", this, true, true, false);
        return this.wizardWindow.executeWizard(n);
    }

    @Override
    public boolean finished() {
        return this.canFinish();
    }

    @Override
    public Image getBanner() {
        if (this.banner == null) {
            this.banner = new ComponentBaner(150, 300, -1);
        }
        return this.banner;
    }

    @Override
    public String getDescription() {
        return "New Modification";
    }

    @Override
    public ImageIcon getIcon() {
        return null;
    }

    @Override
    public int getPaintType() {
        return 2;
    }

    @Override
    public boolean isMultipleSelection() {
        if (this.page1 != null) {
            return this.page1.getAllWizardInfo().size() > 1;
        }
        return false;
    }

    public void selectWizardType(String string) {
        this.page1.setCurWizardFromName(string);
    }

    @Override
    protected boolean canNext() {
        if (this.page1.getAllWizardInfo().size() > 1) {
            return false;
        }
        return super.canNext();
    }

    @Override
    protected void cleanUpChild() {
        super.cleanUpChild();
        if (this.page1 != null) {
            this.page1.cleanUp();
            this.page1 = null;
        }
        this.dataInfo1 = null;
        this.dataInfo2 = null;
        this.dataSet = null;
    }

    @Override
    protected String getHelpID() {
        return "evinceModifications";
    }

    @Override
    protected void pageChangedLocal(WizardPageClass wizardPageClass, int n) {
        if (this.page1 != null) {
            this.curWizard = this.page1.getWizardInfo();
        }
        if (n == 0) {
            Vector<JComponent> vector;
            this.removePagesKeepOne();
            if (this.curWizard != null && (vector = this.curWizard instanceof CategoryInfo ? ((CategoryInfo)this.curWizard).createWizard(this.dataSet, this.dataInfo1, this.dataInfo2) : (this.curWizard instanceof ReduceInfo ? ((ReduceInfo)this.curWizard).createWizard(this.dataSet, this.dataInfo1, this.dataInfo2) : (this.curWizard instanceof AbstractAddedValueInfo ? ((AbstractAddedValueInfo)this.curWizard).createWizard(this.dataInfo1) : this.curWizard.createWizard()))) != null) {
                for (int i = 0; i < vector.size(); ++i) {
                    this.addPage(vector.elementAt(i), "page");
                }
            }
        }
    }

    private void askIfShouldUpdate() {
        DataSet dataSet = this.dataSet;
        Thread thread = new Thread(() -> {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!dataSet.isProtected() && JOptionPane.showConfirmDialog(null, "New identifiers will not be available in models before changes are applied.\n\n Apply changes now?", "Apply changes?", 0) == 0) {
                dataSet.setChanged(null);
                if (dataSet.hasChanged()) {
                    dataSet.doUpdate(null);
                }
            }
        });
        thread.start();
    }
}

