/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.datasetcontainer.value;

import java.io.IOException;
import java.util.Arrays;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.dataimport.AbstractDataSource;
import se.prediktera.map.dataimport.FastDecimal;
import se.prediktera.map.datasetcontainer.datainfo.AbstractInnerColumn;
import se.prediktera.map.datasetcontainer.datainfo.DataGroupValues;
import se.prediktera.map.simpletableeditor.CellIdentifierModel;

public class InnerColumnValue
extends AbstractInnerColumn<FastDecimal> {
    private double[] array;
    private boolean[] missing;

    public InnerColumnValue(String string, DataGroupValues dataGroupValues, CellIdentifierModel cellIdentifierModel, int n) {
        super(string, dataGroupValues, cellIdentifierModel, n);
    }

    @Override
    public Class getGenericSuperClass() {
        return FastDecimal.class;
    }

    public double[] getArray() {
        return this.array;
    }

    public double getDoubleLocal(int n) {
        if (this.array == null) {
            return 0.0;
        }
        return this.array[n];
    }

    public boolean getValueBool(int n) {
        if (this.array == null) {
            return false;
        }
        return this.array[n] > 0.0;
    }

    @Override
    public FastDecimal getValueLocal(int n) {
        FastDecimal fastDecimal = new FastDecimal();
        if (this.array == null || this.missing[n]) {
            return fastDecimal.error();
        }
        return fastDecimal.setValue(this.array[n]);
    }

    public boolean isMissingLocal(int n) {
        if (this.array == null || this.missing == null) {
            return true;
        }
        return this.missing[n];
    }

    @Override
    public void LoadLocal(RandomInputStream randomInputStream, int n) throws IOException {
        int n2 = randomInputStream.ReadBlockInt();
        if (n2 > 0) {
            int n3;
            this.array = new double[n2];
            for (n3 = 0; n3 < n2; ++n3) {
                this.array[n3] = randomInputStream.ReadBlockDouble();
            }
            this.missing = new boolean[n2];
            for (n3 = 0; n3 < n2; ++n3) {
                this.missing[n3] = randomInputStream.ReadBlockBoolean();
            }
        } else {
            this.array = null;
            this.missing = null;
        }
    }

    @Override
    public void removeIndex(int[] nArray) {
        if (this.array != null) {
            double[] dArray = new double[this.array.length - nArray[nArray.length - 1]];
            boolean[] blArray = new boolean[this.array.length - nArray[nArray.length - 1]];
            for (int i = 0; i < nArray.length - 1; ++i) {
                if (nArray[i] < 0) continue;
                dArray[i - nArray[i]] = this.array[i];
                blArray[i - nArray[i]] = this.missing[i];
            }
            this.array = dArray;
            this.missing = blArray;
        }
    }

    @Override
    public void SaveLocal(RandomOutputStream randomOutputStream, int n) throws IOException {
        if (this.array == null) {
            randomOutputStream.WriteBlockInt(0);
        } else {
            int n2;
            int n3 = this.array.length;
            randomOutputStream.WriteBlockInt(n3);
            for (n2 = 0; n2 < n3; ++n2) {
                randomOutputStream.WriteBlockDouble(this.array[n2]);
            }
            for (n2 = 0; n2 < n3; ++n2) {
                randomOutputStream.WriteBlockBoolean(this.missing[n2]);
            }
        }
    }

    public void setArray(double[] dArray) {
        this.array = dArray;
    }

    public void setDoubleLocal(int n, double d, boolean bl) {
        if (this.array == null) {
            this.array = new double[this.getRowsLocal()];
            this.missing = new boolean[this.getRowsLocal()];
            Arrays.fill(this.missing, true);
        }
        this.array[n] = d;
        this.missing[n] = bl;
    }

    @Override
    public void setValueLocal(int n, FastDecimal fastDecimal) {
        if (this.array == null) {
            this.array = new double[this.getRowsLocal()];
            this.missing = new boolean[this.getRowsLocal()];
            Arrays.fill(this.missing, true);
        }
        this.array[n] = fastDecimal.getValue();
        this.missing[n] = fastDecimal.isMissing();
    }

    @Override
    protected void cleanUpChild() {
        super.cleanUpChild();
        this.array = null;
    }

    @Override
    protected AbstractInnerColumn<FastDecimal> createNew(String string, DataGroupValues dataGroupValues, AbstractDataSource abstractDataSource, int n) {
        return new InnerColumnValue(string, dataGroupValues, abstractDataSource, n);
    }

    @Override
    protected FastDecimal getDoubleLocal(int n, FastDecimal fastDecimal) {
        if (this.array == null) {
            return fastDecimal.error();
        }
        if (this.missing[n]) {
            return fastDecimal.error();
        }
        fastDecimal.setValue(this.array[n]);
        return fastDecimal;
    }

    @Override
    protected int getSizeLocal() {
        if (this.array == null) {
            return this.getRowsLocal();
        }
        return this.array.length;
    }

    @Override
    protected void insertLocal(int n, int n2) {
        if (this.array != null) {
            double[] dArray = new double[this.array.length + n2];
            System.arraycopy(this.array, 0, dArray, 0, n);
            System.arraycopy(this.array, n, dArray, n + n2, this.array.length - n);
            this.array = dArray;
            boolean[] blArray = new boolean[this.array.length + n2];
            System.arraycopy(this.missing, 0, blArray, 0, n);
            System.arraycopy(this.missing, n, blArray, n + n2, this.missing.length - n);
        }
    }

    @Override
    protected void setSizeLocal(int n) {
        if (this.array != null && this.array.length < n) {
            double[] dArray = new double[n];
            System.arraycopy(this.array, 0, dArray, 0, Math.min(n, this.array.length));
            this.array = dArray;
            boolean[] blArray = new boolean[n];
            System.arraycopy(this.missing, 0, blArray, 0, Math.min(n, this.missing.length));
            this.missing = blArray;
        }
    }
}

