/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.graphcollection;

import com.mxgraph.canvas.mxGraphics2DCanvas;
import com.mxgraph.layout.hierarchical.mxHierarchicalLayout;
import com.mxgraph.layout.mxCircleLayout;
import com.mxgraph.layout.mxCompactTreeLayout;
import com.mxgraph.layout.mxEdgeLabelLayout;
import com.mxgraph.layout.mxIGraphLayout;
import com.mxgraph.layout.mxOrganicLayout;
import com.mxgraph.layout.mxParallelEdgeLayout;
import com.mxgraph.layout.mxPartitionLayout;
import com.mxgraph.layout.mxStackLayout;
import com.mxgraph.model.mxCell;
import com.mxgraph.shape.mxIShape;
import com.mxgraph.swing.mxGraphComponent;
import com.mxgraph.swing.mxGraphOutline;
import com.mxgraph.util.mxConstants;
import com.mxgraph.util.mxRectangle;
import com.mxgraph.view.mxEdgeStyle;
import com.mxgraph.view.mxGraph;
import com.mxgraph.view.mxStylesheet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.Hashtable;
import java.util.Map;
import javax.swing.JSplitPane;
import se.prediktera.map.common.cleanup.CleanUpPanel;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.datasetcontainer.DataTreeInterface;
import se.prediktera.map.graphcollection.shape.mxClassShape;
import se.prediktera.map.graphcollection.shape.mxModelShape;
import se.prediktera.map.plot.axisplot.settings.Color.PerfectSpread;

public abstract class AbstractGraphManager
extends CleanUpPanel {
    public static final String SHAPE_CLASS = "class";
    public static final String SHAPE_MODEL = "model";
    protected mxGraph graph = new mxGraph();
    protected mxGraphComponent graphComponent;
    protected mxGraphOutline graphOutline;
    protected boolean ispreview;
    protected String layoutType = "horizontaltree";

    public AbstractGraphManager(boolean bl) {
        this.ispreview = bl;
        this.setLayout(new BorderLayout());
        this.createStyles();
        this.graphComponent = new mxGraphComponent(this.graph){

            protected mxGraphComponent.mxGraphControl createGraphControl() {
                return new mxGraphComponent.mxGraphControl(){

                    public String getToolTipText(MouseEvent mouseEvent) {
                        return AbstractGraphManager.this.getToolTipTextForCell(mouseEvent, (mxCell)AbstractGraphManager.this.graphComponent.getCellAt(mouseEvent.getX(), mouseEvent.getY()));
                    }
                };
            }
        };
        this.graphComponent.setToolTips(true);
        if (bl) {
            this.add((Component)this.graphComponent, "Center");
        } else {
            this.graphOutline = new mxGraphOutline(this.graphComponent);
            JSplitPane jSplitPane = new JSplitPane(1, (Component)this.graphOutline, (Component)this.graphComponent);
            jSplitPane.setOneTouchExpandable(true);
            jSplitPane.setDividerLocation(200);
            jSplitPane.setDividerSize(6);
            jSplitPane.setBorder(null);
            this.add((Component)jSplitPane, "Center");
        }
        this.graphComponent.getViewport().setOpaque(true);
        this.graphComponent.getViewport().setBackground(Color.WHITE);
        if (!bl) {
            this.graphComponent.setGridVisible(true);
        }
        this.graphComponent.setAntiAlias(true);
    }

    protected String getToolTipTextForCell(MouseEvent mouseEvent, mxCell mxCell2) {
        Object object;
        if (mxCell2 != null && (object = mxCell2.getValue()) instanceof DataTreeInterface) {
            DataTreeInterface dataTreeInterface = (DataTreeInterface)object;
            return dataTreeInterface.getInformation();
        }
        return super.getToolTipText(mouseEvent);
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.graphComponent.setEnabled(false);
    }

    public mxGraphComponent getGraphComponent() {
        return this.graphComponent;
    }

    public void setLayoutType(String string) {
        this.layoutType = string;
    }

    public abstract void updateGraph();

    protected mxIGraphLayout createLayout() {
        return this.createLayout(this.layoutType);
    }

    protected mxIGraphLayout createLayout(String string) {
        Object object = null;
        if (string != null) {
            mxGraph mxGraph2 = this.graphComponent.getGraph();
            if (string.equals("verticalhierarchical")) {
                object = new mxHierarchicalLayout(mxGraph2);
            } else if (string.equals("horizontalhierarchical")) {
                object = new mxHierarchicalLayout(mxGraph2, 7);
            } else if (string.equals("verticaltree")) {
                object = new mxCompactTreeLayout(mxGraph2, false);
            } else if (string.equals("horizontaltree")) {
                mxCompactTreeLayout mxCompactTreeLayout2 = new mxCompactTreeLayout(mxGraph2, true);
                mxCompactTreeLayout2.setLevelDistance(65);
                mxCompactTreeLayout2.setNodeDistance(25);
                object = mxCompactTreeLayout2;
            } else if (string.equals("paralleledges")) {
                object = new mxParallelEdgeLayout(mxGraph2);
            } else if (string.equals("placeedgelabels")) {
                object = new mxEdgeLabelLayout(mxGraph2);
            } else if (string.equals("organiclayout")) {
                object = new mxOrganicLayout(mxGraph2);
            }
            if (string.equals("verticalpartition")) {
                object = new mxPartitionLayout(mxGraph2, false){

                    public mxRectangle getContainerSize() {
                        return AbstractGraphManager.this.graphComponent.getLayoutAreaSize();
                    }
                };
            } else if (string.equals("horizontalpartition")) {
                object = new mxPartitionLayout(mxGraph2, true){

                    public mxRectangle getContainerSize() {
                        return AbstractGraphManager.this.graphComponent.getLayoutAreaSize();
                    }
                };
            } else if (string.equals("verticalstack")) {
                object = new mxStackLayout(mxGraph2, false){

                    public mxRectangle getContainerSize() {
                        return AbstractGraphManager.this.graphComponent.getLayoutAreaSize();
                    }
                };
            } else if (string.equals("horizontalstack")) {
                object = new mxStackLayout(mxGraph2, true, 10, 0, 0, 10){

                    public mxRectangle getContainerSize() {
                        return AbstractGraphManager.this.graphComponent.getLayoutAreaSize();
                    }
                };
            } else if (string.equals("circlelayout")) {
                object = new mxCircleLayout(mxGraph2);
            }
        }
        return object;
    }

    protected void createStyles() {
        mxGraphics2DCanvas.putShape((String)SHAPE_CLASS, (mxIShape)new mxClassShape());
        mxGraphics2DCanvas.putShape((String)SHAPE_MODEL, (mxIShape)new mxModelShape());
        mxStylesheet mxStylesheet2 = this.graph.getStylesheet();
        String[][] stringArrayArray = new String[][]{{"triangle", "#ed2024", "IMPORT"}, {"rectangle", "#ffff00", "DATASET"}, {"rectangle", "#3ad23a", "MODELS"}, {SHAPE_MODEL, "#3ad23a", SHAPE_MODEL.toUpperCase()}, {SHAPE_CLASS, "#ffea75", SHAPE_CLASS.toUpperCase()}, {"rectangle", "#eaff75", "ADDEDDATA"}};
        for (int i = 0; i < stringArrayArray.length; ++i) {
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            hashtable.put(mxConstants.STYLE_SHAPE, stringArrayArray[i][0]);
            hashtable.put(mxConstants.STYLE_FILLCOLOR, stringArrayArray[i][1]);
            hashtable.put(mxConstants.STYLE_STROKECOLOR, "#000000");
            hashtable.put(mxConstants.STYLE_FONTCOLOR, "#000000");
            hashtable.put(mxConstants.STYLE_WHITE_SPACE, "wrap");
            if (i == 0) {
                hashtable.put(mxConstants.STYLE_ALIGN, "left");
            } else if (i == 1) {
                hashtable.put(mxConstants.STYLE_ROUNDED, "1");
            } else if (i == 2) {
                hashtable.put(mxConstants.STYLE_STROKEWIDTH, "2");
            }
            try {
                Color color = PerfectSpread.getColorFromString(stringArrayArray[i][1]);
                hashtable.put(mxConstants.STYLE_GRADIENTCOLOR, PerfectSpread.getColorToString(PerfectSpread.blendWhite(color, 0.6, 0.0)));
            }
            catch (Exception exception) {
                ErrorHandler.logAndReportException(exception);
            }
            mxStylesheet2.putCellStyle(stringArrayArray[i][2], hashtable);
        }
        Map map = this.graph.getStylesheet().getDefaultEdgeStyle();
        map.put(mxConstants.STYLE_ENDARROW, mxConstants.NONE);
        map.put(mxConstants.STYLE_EDGE, mxEdgeStyle.ElbowConnector);
        map.put(mxConstants.STYLE_STARTARROW, "block");
        map.put(mxConstants.STYLE_LABEL_BACKGROUNDCOLOR, "#ffffff");
        map.put(mxConstants.STYLE_STROKECOLOR, "#000000");
        map.put(mxConstants.STYLE_FONTCOLOR, "#000000");
    }
}

