/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.graphcollection;

import com.mxgraph.canvas.mxGraphics2DCanvas;
import com.mxgraph.canvas.mxICanvas;
import com.mxgraph.canvas.mxSvgCanvas;
import com.mxgraph.io.mxCodec;
import com.mxgraph.swing.mxGraphComponent;
import com.mxgraph.util.mxCellRenderer;
import com.mxgraph.util.mxDomUtils;
import com.mxgraph.util.mxUtils;
import com.mxgraph.util.mxXmlUtils;
import com.mxgraph.view.mxGraph;
import java.awt.Color;
import java.awt.Component;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import javax.imageio.ImageIO;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import org.w3c.dom.Node;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.common.swing.filechooser.ExtensionFilter;
import se.prediktera.map.common.swing.filechooser.jopensaveDialog;
import se.prediktera.map.main.IniManager;

public class GraphHelper {
    public static void saveGraph(mxGraphComponent mxGraphComponent2, File file, String string, boolean bl, boolean bl2) throws IOException {
        mxGraph mxGraph2 = mxGraphComponent2.getGraph();
        String string2 = file.getAbsolutePath();
        if (string.equalsIgnoreCase("svg")) {
            mxSvgCanvas mxSvgCanvas2 = (mxSvgCanvas)mxCellRenderer.drawCells((mxGraph)mxGraph2, null, (double)1.0, null, (mxCellRenderer.CanvasFactory)new mxCellRenderer.CanvasFactory(){

                public mxICanvas createCanvas(int n, int n2) {
                    mxSvgCanvas mxSvgCanvas2 = new mxSvgCanvas(mxDomUtils.createSvgDocument((int)n, (int)n2));
                    mxSvgCanvas2.setEmbedded(true);
                    return mxSvgCanvas2;
                }
            });
            mxUtils.writeFile((String)mxXmlUtils.getXml((Node)mxSvgCanvas2.getDocument()), (String)string2);
        } else if (bl) {
            mxUtils.writeFile((String)mxXmlUtils.getXml((Node)mxCellRenderer.createVmlDocument((mxGraph)mxGraph2, null, (double)1.0, null, null).getDocumentElement()), (String)string2);
        } else if (string.equalsIgnoreCase("html")) {
            mxUtils.writeFile((String)mxXmlUtils.getXml((Node)mxCellRenderer.createHtmlDocument((mxGraph)mxGraph2, null, (double)1.0, null, null).getDocumentElement()), (String)string2);
        } else if (string.equalsIgnoreCase("mxe") || string.equalsIgnoreCase("xml")) {
            mxCodec mxCodec2 = new mxCodec();
            String string3 = mxXmlUtils.getXml((Node)mxCodec2.encode((Object)mxGraph2.getModel()));
            mxUtils.writeFile((String)string3, (String)string2);
        } else if (!string.equalsIgnoreCase("txt")) {
            BufferedImage bufferedImage;
            Color color = null;
            if (!string.equalsIgnoreCase("gif") && !string.equalsIgnoreCase("png") || !bl2) {
                color = mxGraphComponent2.getBackground();
            }
            if ((bufferedImage = mxCellRenderer.createBufferedImage((mxGraph)mxGraph2, null, (double)1.0, (Color)color, (boolean)mxGraphComponent2.isAntiAlias(), null, (mxGraphics2DCanvas)mxGraphComponent2.getCanvas())) != null) {
                ImageIO.write((RenderedImage)bufferedImage, string, new File(string2));
            } else {
                JOptionPane.showMessageDialog((Component)mxGraphComponent2, "No Image Data");
            }
        }
    }

    public static void showSaveDialog(mxGraphComponent mxGraphComponent2) {
        String string;
        FileFilter fileFilter = null;
        ExtensionFilter extensionFilter = new ExtensionFilter("html", "VML File (.html)");
        jopensaveDialog jopensaveDialog2 = new jopensaveDialog("Choose name for save", IniManager.getMainFrame());
        jopensaveDialog2.addChoosableFileFilter(new ExtensionFilter("txt", "Graph Drawing File (.txt)"));
        ExtensionFilter extensionFilter2 = new ExtensionFilter("svg", "SVG File (.svg)");
        jopensaveDialog2.addChoosableFileFilter(extensionFilter2);
        jopensaveDialog2.addChoosableFileFilter(extensionFilter);
        jopensaveDialog2.addChoosableFileFilter(new ExtensionFilter("html", "HTML File (.html)"));
        Object[] objectArray = ImageIO.getReaderFormatNames();
        HashSet<String> hashSet = new HashSet<String>();
        for (Object object : objectArray) {
            string = object.toString().toLowerCase();
            hashSet.add(string);
        }
        for (Object object : objectArray = hashSet.toArray()) {
            string = object.toString();
            jopensaveDialog2.addChoosableFileFilter(new ExtensionFilter(string, string.toUpperCase() + " File (." + string + ")"));
        }
        jopensaveDialog2.setFileFilter(extensionFilter2);
        if (jopensaveDialog2.saveshow()) {
            File file = jopensaveDialog2.getSelectedFile();
            fileFilter = jopensaveDialog2.getFileFilter();
            String string2 = jopensaveDialog.getFileExtension(file);
            try {
                int n = JOptionPane.showConfirmDialog((Component)mxGraphComponent2, "Transparent Background") != 0 ? 1 : 0;
                GraphHelper.saveGraph(mxGraphComponent2, file, string2, fileFilter == extensionFilter, n != 0);
            }
            catch (Throwable throwable) {
                ErrorHandler.logAndReportException(throwable);
                JOptionPane.showMessageDialog((Component)mxGraphComponent2, throwable.toString(), "Error", 0);
            }
        }
    }
}

