/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.graphcollection;

import com.mxgraph.layout.mxIGraphLayout;
import com.mxgraph.model.mxCell;
import com.mxgraph.swing.mxGraphComponent;
import com.mxgraph.view.mxGraph;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.common.swing.filechooser.jopensaveDialog;
import se.prediktera.map.datasetcontainer.AbstractDataNode;
import se.prediktera.map.datasetcontainer.Case;
import se.prediktera.map.datasetcontainer.DataTreeInterface;
import se.prediktera.map.datasetcontainer.dataset.DataSet;
import se.prediktera.map.datasetcontainer.matrix.ModelMatrix;
import se.prediktera.map.graphcollection.AbstractGraphManager;
import se.prediktera.map.graphcollection.GraphHelper;
import se.prediktera.map.graphcollection.GraphToolbar;
import se.prediktera.map.main.Project_GUI;
import se.prediktera.map.model.AbstractModel;
import se.prediktera.map.model.ModelManager;
import se.prediktera.map.model.output.OutputClass;
import se.prediktera.map.plot.axisplot.settings.Color.PerfectSpread;

public class GraphManager
extends AbstractGraphManager {
    public static final int SHOW_ALL = 0;
    public static final int SHOW_DATASET = 1;
    public static final int SHOW_MODEL = 2;
    public static final int SHOW_MODELS_WITH_CONNECTION_AND_OUTPUT = 3;
    private Project_GUI projectGUI;
    private int showType = 0;
    private final GraphToolbar graphToolbar = new GraphToolbar(this);

    public static void saveGraph(File file, List<AbstractModel> list, Properties properties) throws IOException {
        GraphManager graphManager = new GraphManager(true);
        graphManager.showType = 3;
        mxGraphComponent mxGraphComponent2 = graphManager.graphComponent;
        mxGraph mxGraph2 = graphManager.graph;
        Object object = mxGraph2.getDefaultParent();
        mxGraph2.getModel().beginUpdate();
        graphManager.createModelConnection(list, object);
        mxIGraphLayout mxIGraphLayout2 = graphManager.createLayout();
        Object object2 = mxGraph2.getDefaultParent();
        mxIGraphLayout2.execute(object2);
        mxGraph2.getModel().endUpdate();
        String string = jopensaveDialog.getFileExtension(file);
        GraphHelper.saveGraph(mxGraphComponent2, file, string, false, true);
    }

    public GraphManager(boolean bl) {
        super(bl);
        if (!bl) {
            this.graphComponent.getGraphControl().addMouseListener((MouseListener)new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent mouseEvent) {
                    if (mouseEvent.isPopupTrigger()) {
                        Object object;
                        mxCell mxCell2 = (mxCell)GraphManager.this.graphComponent.getCellAt(mouseEvent.getX(), mouseEvent.getY());
                        if (mxCell2 != null && (object = mxCell2.getValue()) instanceof DataTreeInterface) {
                            DataTreeInterface dataTreeInterface = (DataTreeInterface)object;
                            object = SwingUtilities.convertPoint(mouseEvent.getComponent(), mouseEvent.getPoint(), (Component)GraphManager.this.graphComponent);
                            GraphManager.this.createPopupMenu((Point)object, dataTreeInterface);
                        }
                        mouseEvent.consume();
                    }
                }
            });
            this.graphComponent.getGraphControl().addMouseMotionListener((MouseMotionListener)new MouseMotionAdapter(){

                @Override
                public void mouseMoved(MouseEvent mouseEvent) {
                    mxCell mxCell2 = (mxCell)GraphManager.this.graphComponent.getCellAt(mouseEvent.getX(), mouseEvent.getY());
                    if (mxCell2 != null) {
                        GraphManager.this.setCursor(Cursor.getPredefinedCursor(12));
                    } else {
                        GraphManager.this.setCursor(Cursor.getDefaultCursor());
                    }
                }
            });
        }
        this.updateGraph();
    }

    public GraphManager(Project_GUI project_GUI, boolean bl) {
        this(bl);
        this.projectGUI = project_GUI;
    }

    public JToolBar getToolbar() {
        return this.graphToolbar;
    }

    public boolean isVisibleGUI() {
        if (this.projectGUI != null) {
            return this.projectGUI.getGraph_GUI().isVisibleGUI();
        }
        return false;
    }

    public void LoadProperties(RandomInputStream randomInputStream, MapProperty mapProperty) {
        if (mapProperty != null) {
            this.showType = mapProperty.getPropertyInt("showtype", this.showType);
            this.layoutType = mapProperty.getPropertyStringUTF("layoutType", this.layoutType);
            this.updateGraph();
        }
    }

    public void PurgeSignal() {
    }

    public void saveGraph() {
        GraphHelper.showSaveDialog(this.graphComponent);
    }

    public void SaveProperties(RandomOutputStream randomOutputStream) throws IOException {
        randomOutputStream.writePropertyInt("showtype", this.showType);
        randomOutputStream.writePropertyStringUTF("layoutType", this.layoutType);
    }

    public void setCreated() {
        this.graphToolbar.setCreated();
    }

    @Override
    public void setLayoutType(String string) {
        this.layoutType = string;
        this.updateGraph();
        this.projectGUI.setProjectChanged();
    }

    public void setLineStyle(String string) {
        this.updateGraph();
        this.projectGUI.setProjectChanged();
    }

    public void setType(int n) {
        this.showType = n;
        this.updateGraph();
        if (this.projectGUI != null) {
            this.projectGUI.setProjectChanged();
        }
    }

    @Override
    public void updateGraph() {
        if (this.projectGUI != null) {
            AbstractDataNode abstractDataNode = this.projectGUI.getRootNode();
            this.updateGraph(abstractDataNode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateGraph(DataTreeInterface dataTreeInterface) {
        if (this.graph != null) {
            Object object = this.graph.getDefaultParent();
            this.graph.selectAll();
            this.graph.removeCells();
            this.graph.getModel().beginUpdate();
            try {
                switch (this.showType) {
                    case 0: {
                        this.createTreeConnection(dataTreeInterface, object, null);
                        break;
                    }
                    case 1: {
                        this.createTreeConnection(dataTreeInterface, object, null);
                        break;
                    }
                    case 2: 
                    case 3: {
                        this.createModelConnection(dataTreeInterface, object);
                    }
                }
                mxIGraphLayout mxIGraphLayout2 = this.createLayout();
                Object object2 = this.graph.getDefaultParent();
                mxIGraphLayout2.execute(object2);
                if (this.ispreview) {
                    this.graphComponent.zoomTo(0.5, true);
                }
            }
            finally {
                this.graph.getModel().endUpdate();
                if (this.graphOutline != null) {
                    this.graphOutline.destroyTripleBuffer();
                }
            }
        }
    }

    @Override
    protected void cleanUpChild() {
        this.projectGUI = null;
        this.graph = null;
        this.graphComponent = null;
    }

    private boolean connectedToClass(List<AbstractModel> list, AbstractModel abstractModel, String string) {
        for (AbstractModel abstractModel2 : list) {
            if (!abstractModel.equals(abstractModel2.getReplaceModel()) || string != null && !string.equals(abstractModel2.getReplaceClassName())) continue;
            return true;
        }
        return false;
    }

    private void createModelConnection(DataTreeInterface dataTreeInterface, Object object) {
        ArrayList<AbstractModel> arrayList = new ArrayList<AbstractModel>();
        ModelManager.collectModels(dataTreeInterface, arrayList, true, false);
        this.createModelConnection(arrayList, object);
    }

    private void createModelConnection(List<AbstractModel> list, Object object) {
        Object object2;
        Object object3;
        HashMap hashMap = new HashMap();
        Object object4 = null;
        if (this.showType != 3) {
            object4 = this.graph.insertVertex(object, null, (Object)"Models", 20.0, 20.0, 60.0, 60.0, "MODELS");
        }
        for (AbstractModel abstractModel : list) {
            object3 = this.getModelStyleName(abstractModel);
            object2 = this.graph.insertVertex(object, null, (Object)abstractModel, 20.0, 20.0, 65.0, 65.0, (String)object3);
            hashMap.put(abstractModel, object2);
        }
        for (AbstractModel abstractModel : list) {
            Object v;
            object3 = abstractModel.getOutput();
            object2 = hashMap.get(abstractModel);
            AbstractModel abstractModel2 = abstractModel.getReplaceModel();
            if (abstractModel2 != null) {
                v = hashMap.get(abstractModel2);
                this.graph.insertEdge(object, null, (Object)abstractModel.getReplaceClassName(), v, object2);
            } else if (abstractModel.getTreeParent() instanceof AbstractModel) {
                abstractModel2 = (AbstractModel)abstractModel.getTreeParent();
                Object v2 = hashMap.get(abstractModel2);
                this.graph.insertEdge(object, null, (Object)"", v2, object2);
            } else if (object4 != null) {
                this.graph.insertEdge(object, null, (Object)"", object4, object2);
            }
            if (this.showType != 3) continue;
            if (abstractModel.hasChildWithName("c")) {
                String string;
                boolean bl = abstractModel.getModelName().equals("PLS-DA");
                ModelMatrix modelMatrix = (ModelMatrix)abstractModel.getMatrixByName("c");
                if (modelMatrix == null) continue;
                for (int i = 0; i < modelMatrix.getK(); ++i) {
                    string = modelMatrix.getColumnDescription(i, 0);
                    if (bl) {
                        int n = string.indexOf(":");
                        if (n >= 0) {
                            string = string.substring(n + 1).trim();
                        }
                        if (this.connectedToClass(list, abstractModel, string)) continue;
                    }
                    Object v3 = hashMap.get(abstractModel);
                    if (bl) {
                        Color color = ((OutputClass)object3).getColor(i);
                        if (color == null) {
                            color = Color.white;
                        }
                        String string2 = PerfectSpread.getColorToString(color);
                        object2 = this.graph.insertVertex(object, null, (Object)string, 20.0, 20.0, 140.0, 22.0, "CLASS;classcolor=" + string2);
                        this.graph.insertEdge(object, null, (Object)"", v3, object2);
                        continue;
                    }
                    object2 = this.graph.insertVertex(object, null, (Object)string, 20.0, 20.0, 140.0, 22.0, "ADDEDDATA");
                    this.graph.insertEdge(object, null, (Object)"", v3, object2);
                }
                if (!abstractModel.isUseDcrit()) continue;
                Object v4 = hashMap.get(abstractModel);
                string = PerfectSpread.getColorToString(new Color(((OutputClass)object3).getColordmodx()));
                object2 = this.graph.insertVertex(object, null, (Object)("DmodX - " + ((OutputClass)object3).getNamedmodx()), 20.0, 20.0, 140.0, 22.0, "CLASS;classcolor=" + string);
                this.graph.insertEdge(object, null, (Object)"", v4, object2);
                continue;
            }
            v = hashMap.get(abstractModel);
            boolean bl = abstractModel.isUseDcrit();
            if (bl) {
                if (!this.connectedToClass(list, abstractModel, "In Model")) {
                    object2 = this.graph.insertVertex(object, null, (Object)"DmodX - In Model", 20.0, 20.0, 140.0, 22.0, "CLASS;classcolor=green");
                    this.graph.insertEdge(object, null, (Object)"", v, object2);
                }
                String string = PerfectSpread.getColorToString(new Color(((OutputClass)object3).getColordmodx()));
                object2 = this.graph.insertVertex(object, null, (Object)("DmodX - " + ((OutputClass)object3).getNamedmodx()), 20.0, 20.0, 140.0, 22.0, "CLASS;classcolor=" + string);
                this.graph.insertEdge(object, null, (Object)"", v, object2);
                continue;
            }
            object2 = this.graph.insertVertex(object, null, (Object)"Tpred", 20.0, 20.0, 140.0, 22.0, "ADDEDDATA");
            this.graph.insertEdge(object, null, (Object)"", v, object2);
            object2 = this.graph.insertVertex(object, null, (Object)"DmodX", 20.0, 20.0, 140.0, 22.0, "ADDEDDATA");
            this.graph.insertEdge(object, null, (Object)"", v, object2);
        }
    }

    private void createPopupMenu(Point point, DataTreeInterface dataTreeInterface) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        if (dataTreeInterface instanceof DataSet) {
            ((DataSet)dataTreeInterface).addToPopupMenu(this.projectGUI, jPopupMenu);
        } else if (dataTreeInterface instanceof AbstractModel) {
            ((AbstractModel)dataTreeInterface).addToPopupMenu(this.projectGUI, jPopupMenu);
        }
        dataTreeInterface.addToPopup(this.projectGUI, dataTreeInterface, point, jPopupMenu, false);
        jPopupMenu.show((Component)this.graphComponent, point.x, point.y);
    }

    private void createTreeConnection(DataTreeInterface dataTreeInterface, Object object, Object object2) {
        if (dataTreeInterface != null) {
            for (int i = 0; i < dataTreeInterface.getTreeNodeCount(); ++i) {
                Object object3;
                DataTreeInterface dataTreeInterface2 = dataTreeInterface.getTreeNodeAt(i);
                if (!dataTreeInterface2.isVisibleInTree()) continue;
                String string = null;
                if (dataTreeInterface2 instanceof Case) {
                    string = "IMPORT";
                } else if (dataTreeInterface2 instanceof DataSet) {
                    string = "DATASET";
                } else if (dataTreeInterface2 instanceof AbstractModel) {
                    object3 = (AbstractModel)dataTreeInterface2;
                    if (this.showType == 0) {
                        string = this.getModelStyleName((AbstractModel)object3);
                    }
                }
                object3 = object2;
                if (string != null) {
                    Object object4 = this.graph.insertVertex(object, null, (Object)dataTreeInterface2, 20.0, 20.0, 60.0, 60.0, string);
                    if (object2 != null) {
                        this.graph.insertEdge(object, null, (Object)"", object2, object4);
                    }
                    object3 = object4;
                }
                this.createTreeConnection(dataTreeInterface2, object, object3);
            }
        }
    }

    private String getModelStyleName(AbstractModel abstractModel) {
        if (abstractModel.isModelContainer()) {
            return "MODELS";
        }
        return "MODEL";
    }
}

