/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.graphcollection;

import java.awt.Component;
import java.awt.Dimension;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import se.prediktera.map.common.cleanup.CleanUpToolBar;
import se.prediktera.map.common.swing.flat.JFlatButton;
import se.prediktera.map.common.swing.flat.JFlatToggleButton;
import se.prediktera.map.common.swing.flat.JFlatToggleButtonComboBox;
import se.prediktera.map.graphcollection.GraphManager;
import se.prediktera.map.main.GlobalMessageInterface;
import se.prediktera.map.main.Main_GUI;
import se.prediktera.map.main.script.EvinceScriptCommands;

public class GraphToolbar
extends CleanUpToolBar
implements GlobalMessageInterface {
    private final JComboBox typeComboBox = new JComboBox();
    private final JFlatButton saveButton = new JFlatButton();
    private final JFlatToggleButtonComboBox toggleButtonLayoutComboBox = new JFlatToggleButtonComboBox();
    String[] layoutStyle = new String[]{"Vertical Hierarchical", "Horizontal Hierarchical", "Vertical Tree", "Horizontal Tree"};
    private final JFlatToggleButtonComboBox toggleButtonLineStyleComboBox = new JFlatToggleButtonComboBox();
    private final JFlatToggleButton straightLineStyleButton = new JFlatToggleButton();
    private final JFlatToggleButton horizontalLineStyleButton = new JFlatToggleButton();
    private final JFlatToggleButton verticalLineStyleButton = new JFlatToggleButton();
    private GraphManager graphManager;

    public GraphToolbar(GraphManager graphManager) {
        this.graphManager = graphManager;
        this.typeComboBox.setPreferredSize(new Dimension(180, 20));
        this.typeComboBox.setMinimumSize(new Dimension(180, 20));
        this.typeComboBox.setMaximumSize(new Dimension(180, 20));
        this.typeComboBox.addItem("All");
        this.typeComboBox.addItem("DataSet");
        this.typeComboBox.addItem("Model connection");
        this.typeComboBox.addItem("Model connection with output");
        this.typeComboBox.addItemListener(itemEvent -> this.graphManager.setType(this.typeComboBox.getSelectedIndex()));
        this.saveButton.setToolTipText("Save graph");
        this.saveButton.setIcon(new ImageIcon(Main_GUI.class.getResource("icons/common/saveFile.png")));
        this.saveButton.addActionListener(actionEvent -> this.graphManager.saveGraph());
        this.toggleButtonLayoutComboBox.setButtonGroup(new ButtonGroup());
        for (String string : this.layoutStyle) {
            JFlatToggleButton jFlatToggleButton = new JFlatToggleButton();
            jFlatToggleButton.setToolTipText(string);
            jFlatToggleButton.setIcon(new ImageIcon(GraphToolbar.class.getResource("images/tree.gif")));
            String string2 = EvinceScriptCommands.removeSpace(string).toLowerCase();
            jFlatToggleButton.addItemListener(itemEvent -> this.graphManager.setLayoutType(string2));
            this.toggleButtonLayoutComboBox.addButton(jFlatToggleButton);
        }
        this.straightLineStyleButton.setToolTipText("Straight line");
        this.straightLineStyleButton.setIcon(new ImageIcon(GraphToolbar.class.getResource("images/straight.gif")));
        this.straightLineStyleButton.addItemListener(itemEvent -> this.graphManager.setLineStyle("straight"));
        this.horizontalLineStyleButton.setToolTipText("Horizontal line");
        this.horizontalLineStyleButton.setIcon(new ImageIcon(GraphToolbar.class.getResource("images/connect.gif")));
        this.horizontalLineStyleButton.addItemListener(itemEvent -> this.graphManager.setLineStyle("horizontal"));
        this.verticalLineStyleButton.setToolTipText("Verical line");
        this.verticalLineStyleButton.setIcon(new ImageIcon(GraphToolbar.class.getResource("images/vertical.gif")));
        this.verticalLineStyleButton.addItemListener(itemEvent -> this.graphManager.setLineStyle("vertical"));
        this.toggleButtonLineStyleComboBox.setButtonGroup(new ButtonGroup());
        this.toggleButtonLineStyleComboBox.addButton(this.straightLineStyleButton);
        this.toggleButtonLineStyleComboBox.addButton(this.horizontalLineStyleButton);
        this.toggleButtonLineStyleComboBox.addButton(this.verticalLineStyleButton);
        this.setBorder(null);
        this.setFloatable(false);
        this.add((Component)new JLabel("Show:"), null);
        this.add((Component)this.typeComboBox, null);
        this.addSeparator();
        this.add((Component)this.saveButton, null);
    }

    public void setCreated() {
        this.typeComboBox.setSelectedIndex(3);
    }

    @Override
    protected void cleanUpChild() {
        this.graphManager = null;
    }
}

