/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.history;

import java.awt.Point;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.List;
import javax.swing.JPopupMenu;
import javax.swing.UIManager;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;
import se.prediktera.map.common.CMenuItem;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.datasetcontainer.DataTreeInterface;
import se.prediktera.map.datasetcontainer.DataTreeMemoryClass;
import se.prediktera.map.history.HistoryInterface;
import se.prediktera.map.history.HistoryManager;
import se.prediktera.map.main.IniManager;
import se.prediktera.map.main.Project_GUI;

public abstract class AbstractHistoryNode
extends DataTreeMemoryClass
implements UndoableEdit,
HistoryInterface {
    protected static final String UndoName = "Undo";
    protected static final String RedoName = "Redo";
    protected long duration;
    private boolean hasBeenDone;
    private boolean alive;
    private final long timestamp;
    private final String username;
    private String script;

    public AbstractHistoryNode(RandomInputStream randomInputStream, MapProperty mapProperty) throws IOException {
        super(randomInputStream, mapProperty);
        this.hasBeenDone = mapProperty.getPropertyBoolean("hbd");
        this.alive = mapProperty.getPropertyBoolean("alive");
        this.duration = mapProperty.getPropertyLong("dur");
        this.timestamp = mapProperty.getPropertyLong("ts");
        this.username = mapProperty.getPropertyStringUTF("un");
        this.script = mapProperty.getPropertyStringUTF("sc");
    }

    public AbstractHistoryNode(String string) {
        super(string);
        this.hasBeenDone = true;
        this.alive = true;
        this.timestamp = System.currentTimeMillis();
        this.username = IniManager.getUsername();
    }

    @Override
    public boolean addEdit(UndoableEdit undoableEdit) {
        return false;
    }

    @Override
    public boolean addToPopup(Project_GUI project_GUI, DataTreeInterface dataTreeInterface, Point point, JPopupMenu jPopupMenu, boolean bl) {
        CMenuItem cMenuItem = new CMenuItem((this.hasBeenDone ? UndoName : RedoName) + " to this action", true){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AbstractHistoryNode.this.setHistoryNode();
            }
        };
        jPopupMenu.add(cMenuItem);
        return true;
    }

    @Override
    public boolean canRedo() {
        return this.alive && !this.hasBeenDone;
    }

    @Override
    public boolean canUndo() {
        return this.alive && this.hasBeenDone;
    }

    @Override
    public void die() {
        this.alive = false;
    }

    @Override
    public String getDescription() {
        return this.name;
    }

    @Override
    public long getDuration() {
        return this.duration;
    }

    @Override
    public List getHistory() {
        return null;
    }

    @Override
    public String getPresentationName() {
        return "";
    }

    @Override
    public String getRedoPresentationName() {
        Object object = this.getPresentationName();
        object = !"".equals(object) ? UIManager.getString("AbstractUndoableEdit.redoText") + " " + (String)object : UIManager.getString("AbstractUndoableEdit.redoText");
        return object;
    }

    @Override
    public String getScript() {
        return this.script;
    }

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public String getToolTipText() {
        return this.toString();
    }

    @Override
    public String getUndoPresentationName() {
        Object object = this.getPresentationName();
        object = !"".equals(object) ? UIManager.getString("AbstractUndoableEdit.undoText") + " " + (String)object : UIManager.getString("AbstractUndoableEdit.undoText");
        return object;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    public boolean hasBeenDone() {
        return this.hasBeenDone;
    }

    @Override
    public boolean isSignificant() {
        return true;
    }

    @Override
    public void redo() throws CannotRedoException {
        if (!this.canRedo()) {
            throw new CannotRedoException();
        }
        this.hasBeenDone = true;
    }

    @Override
    public boolean replaceEdit(UndoableEdit undoableEdit) {
        return false;
    }

    @Override
    public void SavePropertyLocal(RandomOutputStream randomOutputStream) throws IOException {
        randomOutputStream.writePropertyBoolean("hbd", this.hasBeenDone);
        randomOutputStream.writePropertyBoolean("alive", this.alive);
        randomOutputStream.writePropertyLong("dur", this.duration);
        randomOutputStream.writePropertyLong("ts", this.timestamp);
        randomOutputStream.writePropertyStringUTF("un", this.username);
        randomOutputStream.writePropertyStringUTF("sc", this.script);
    }

    public void setHistoryNode() {
        HistoryManager historyManager = (HistoryManager)this.getTreeParent();
        if (historyManager != null) {
            historyManager.setHistoryNode(this);
        }
    }

    @Override
    public String toString() {
        DataTreeInterface dataTreeInterface;
        HistoryManager historyManager = (HistoryManager)this.getTreeParent();
        if (historyManager != null && (dataTreeInterface = historyManager.getTreeParent()) != null) {
            return dataTreeInterface.toString();
        }
        return "";
    }

    @Override
    public void undo() throws CannotUndoException {
        if (!this.canUndo()) {
            throw new CannotUndoException();
        }
        this.hasBeenDone = false;
    }
}

