/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.history;

import java.awt.Point;
import java.io.IOException;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JPopupMenu;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;
import javax.swing.undo.UndoableEditSupport;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.datasetcontainer.DataTreeInterface;
import se.prediktera.map.datasetcontainer.DataTreeManager;
import se.prediktera.map.datasetcontainer.event.DataTreeListener;
import se.prediktera.map.history.AbstractHistoryNode;
import se.prediktera.map.main.Project_GUI;

public class HistoryManager
extends UndoManager
implements DataTreeInterface {
    protected UndoableEditSupport undoSupport;
    private Integer historyID;
    private DataTreeInterface nodeParent;
    private DataTreeManager dataTreeManager;
    private int saveIndex = -1;
    private boolean hascleanup = false;

    public HistoryManager() {
        this.init();
    }

    public HistoryManager(RandomInputStream randomInputStream, MapProperty mapProperty) throws IOException {
        this.historyID = randomInputStream.getDataTreeManager().addUniqueID(randomInputStream.getCT().id, this);
        this.init();
    }

    @Override
    public void addDataTreeChangeListener(DataTreeListener dataTreeListener) {
    }

    @Override
    public void addShortcut(DataTreeInterface dataTreeInterface) {
        this.addTreeNode(dataTreeInterface);
    }

    @Override
    public boolean addToPopup(Project_GUI project_GUI, DataTreeInterface dataTreeInterface, Point point, JPopupMenu jPopupMenu, boolean bl) {
        return false;
    }

    @Override
    public void addTreeNode(DataTreeInterface dataTreeInterface) {
        this.postEdit((AbstractHistoryNode)dataTreeInterface);
    }

    @Override
    public boolean cleanUp() {
        if (this.hascleanup) {
            return true;
        }
        this.hascleanup = true;
        if (this.dataTreeManager != null && this.historyID != null) {
            this.dataTreeManager.removeUniqueID(this.historyID);
            this.dataTreeManager.updateHistory();
        }
        while (!this.edits.isEmpty()) {
            DataTreeInterface dataTreeInterface = this.getTreeNodeAt(0);
            if ((this.dataTreeManager == null || this.dataTreeManager.hasDataMask(dataTreeInterface)) && !dataTreeInterface.cleanUp()) continue;
            this.edits.removeElementAt(0);
        }
        return false;
    }

    @Override
    public boolean containsTreeNode(DataTreeInterface dataTreeInterface) {
        return false;
    }

    @Override
    public DataTreeManager getDataTreeManager() {
        return this.dataTreeManager;
    }

    public List getEdits() {
        return this.edits;
    }

    @Override
    public ImageIcon getIcon(byte by) {
        return null;
    }

    @Override
    public Integer getID() {
        return this.historyID;
    }

    @Override
    public String getInformation() {
        return "";
    }

    @Override
    public byte getNodeType() {
        return 12;
    }

    @Override
    public int getSaveIndex() {
        return this.saveIndex;
    }

    @Override
    public String getToolTipText() {
        return this.toString();
    }

    @Override
    public DataTreeInterface getTreeNodeAt(int n) {
        return (DataTreeInterface)this.edits.elementAt(n);
    }

    @Override
    public int getTreeNodeCount() {
        return this.edits.size();
    }

    @Override
    public DataTreeInterface getTreeParent() {
        return this.nodeParent;
    }

    @Override
    public byte getTreeType() {
        return 0;
    }

    @Override
    public void insertTreeNode(DataTreeInterface dataTreeInterface) {
        this.edits.insertElementAt((UndoableEdit)((Object)dataTreeInterface), 0);
    }

    @Override
    public boolean isCleaned() {
        return this.hascleanup;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public boolean isNode() {
        return true;
    }

    @Override
    public boolean isVisibleInTree() {
        return false;
    }

    public void postEdit(AbstractHistoryNode abstractHistoryNode) {
        abstractHistoryNode.setTreeParent(this);
        this.undoSupport.postEdit(abstractHistoryNode);
        if (this.dataTreeManager != null) {
            this.dataTreeManager.updateHistory();
        }
    }

    @Override
    public void removeDataTreeChangeListener(DataTreeListener dataTreeListener) {
    }

    @Override
    public boolean removeTreeNode(DataTreeInterface dataTreeInterface) {
        if (this.edits != null) {
            return this.edits.removeElement(dataTreeInterface);
        }
        return false;
    }

    @Override
    public void SaveProperty(RandomOutputStream randomOutputStream, int n) throws IOException {
        this.saveIndex = n;
    }

    @Override
    public void setDataTreeManager(DataTreeManager dataTreeManager, boolean bl) {
        if (bl || this.dataTreeManager != null && this.dataTreeManager != dataTreeManager) {
            this.historyID = null;
        }
        this.dataTreeManager = dataTreeManager;
        if (this.historyID == null && this.dataTreeManager != null) {
            this.historyID = this.dataTreeManager.addUniqueID(null, this);
        }
        int n = this.getTreeNodeCount();
        for (int i = 0; i < n; ++i) {
            this.getTreeNodeAt(i).setDataTreeManager(dataTreeManager, bl);
        }
    }

    public void setHistoryNode(AbstractHistoryNode abstractHistoryNode) {
        if (abstractHistoryNode.hasBeenDone()) {
            this.undoTo(abstractHistoryNode);
        } else {
            this.redoTo(abstractHistoryNode);
        }
    }

    @Override
    public void setTreeParent(DataTreeInterface dataTreeInterface) {
        this.nodeParent = dataTreeInterface;
        if (dataTreeInterface != null && dataTreeInterface.getDataTreeManager() != null) {
            this.dataTreeManager = dataTreeInterface.getDataTreeManager();
            if (this.historyID == null) {
                this.historyID = this.dataTreeManager.addUniqueID(null, this);
                this.dataTreeManager.updateHistory();
            }
            for (int i = 0; i < this.getTreeNodeCount(); ++i) {
                this.getTreeNodeAt(i).setTreeParent(this);
            }
        }
    }

    @Override
    public void swapNodes(int n, int n2) {
    }

    private void init() {
        this.undoSupport = new UndoableEditSupport();
        this.undoSupport.addUndoableEditListener(undoableEditEvent -> {
            UndoableEdit undoableEdit = undoableEditEvent.getEdit();
            this.addEdit(undoableEdit);
        });
    }
}

