/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.history;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumnModel;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.common.swing.filechooser.jopensaveDialog;
import se.prediktera.map.common.swing.treetable.AbstractTreeTableModel;
import se.prediktera.map.common.swing.treetable.JTreeTable;
import se.prediktera.map.common.swing.treetable.TreeTableModel;
import se.prediktera.map.datasetcontainer.DataContainer;
import se.prediktera.map.datasetcontainer.DataTreeInterface;
import se.prediktera.map.datasetcontainer.ShortcutInterface;
import se.prediktera.map.history.AbstractHistoryNode;
import se.prediktera.map.history.HistoryInterface;
import se.prediktera.map.history.HistoryToolbar;
import se.prediktera.map.main.DataMonitor;
import se.prediktera.map.main.History_GUI;
import se.prediktera.map.main.IniManager;
import se.prediktera.map.main.script.ScriptFile;
import se.prediktera.map.main.script.ScriptManager;

public class HistoryScrollPane
extends JScrollPane {
    private final History_GUI history_GUI;
    private final JTreeTable historyTreeTable;
    private final HistoryTreeTableModel tableModel;
    private final HistoryToolbar historyToolbar = new HistoryToolbar(this);
    private boolean ishierarch = false;
    private boolean autoscroll = true;
    private final ArrayList<Object> historyList = new ArrayList();
    private final int[] columnwidth = new int[]{3, 8, 2, 1, 2};

    public HistoryScrollPane(History_GUI history_GUI) {
        this.history_GUI = history_GUI;
        this.setHorizontalScrollBarPolicy(31);
        this.tableModel = new HistoryTreeTableModel(new String[]{"Timestamp", "Name", "Action", "Time", "Username"});
        this.historyTreeTable = new JTreeTable(this.tableModel);
        this.historyTreeTable.setDefaultRenderer(String.class, new CustomTableCellRenderer());
        this.historyTreeTable.getSelectionModel().addListSelectionListener(listSelectionEvent -> {
            Object object = this.historyTreeTable.getValueAt(listSelectionEvent.getFirstIndex(), 1);
            if (object instanceof AbstractHistoryNode) {
                this.historyToolbar.setCurrentNode((AbstractHistoryNode)object);
            } else {
                this.historyToolbar.setCurrentNode(null);
            }
        });
        this.historyTreeTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (!mouseEvent.isConsumed()) {
                    Object object;
                    int n = HistoryScrollPane.this.historyTreeTable.rowAtPoint(mouseEvent.getPoint());
                    int n2 = HistoryScrollPane.this.historyTreeTable.columnAtPoint(mouseEvent.getPoint());
                    if (n2 != 1 && SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() > 1) {
                        if (HistoryScrollPane.this.historyTreeTable.getTree().isExpanded(n)) {
                            HistoryScrollPane.this.historyTreeTable.getTree().collapseRow(n);
                        } else {
                            HistoryScrollPane.this.historyTreeTable.getTree().expandRow(n);
                        }
                        HistoryScrollPane.this.updateTable();
                    } else if (SwingUtilities.isRightMouseButton(mouseEvent) && (object = HistoryScrollPane.this.historyTreeTable.getValueAt(n, 1)) instanceof DataTreeInterface) {
                        DataMonitor.showPopup(HistoryScrollPane.this.historyTreeTable, HistoryScrollPane.this.history_GUI.getProject_GUI(), (DataTreeInterface)object, mouseEvent.getPoint());
                    }
                    mouseEvent.consume();
                }
            }
        });
        TableColumnModel tableColumnModel = this.historyTreeTable.getColumnModel();
        for (int i = 0; i < tableColumnModel.getColumnCount(); ++i) {
            tableColumnModel.getColumn(i).setPreferredWidth(this.columnwidth[i] * 100);
        }
        this.setViewportView(this.historyTreeTable);
        this.getViewport().setBackground(this.historyTreeTable.getBackground());
    }

    public void exportScript() {
        try {
            Object object;
            jopensaveDialog jopensaveDialog2 = new jopensaveDialog("Choose name for template", IniManager.getMainFrame());
            jopensaveDialog2.addExtension("txt", "Evince Template File (*.txt)");
            File file = IniManager.getScriptDir();
            if (file != null) {
                object = new File(file.getAbsolutePath() + IniManager.getFileSeparator() + this.history_GUI.getProject_GUI().getProjectName());
                jopensaveDialog2.setCurrentDirectory(file);
                jopensaveDialog2.setSelectedFile((File)object);
            }
            if (jopensaveDialog2.saveshow()) {
                object = this.generateScript();
                ScriptFile scriptFile = new ScriptFile();
                scriptFile.setScriptInfo("Evince Template File");
                scriptFile.setType("import");
                scriptFile.setScript((String)object);
                ScriptManager.saveScriptFile(scriptFile, jopensaveDialog2.getSelectedFile(), false);
            }
        }
        catch (IOException iOException) {
            ErrorHandler.logAndReportException(iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String generateScript() {
        StringBuilder stringBuilder = new StringBuilder();
        ArrayList<Object> arrayList = this.historyList;
        synchronized (arrayList) {
            for (HistoryInterface historyInterface : this.historyList) {
                String string = historyInterface.getScript();
                if (string == null) continue;
                stringBuilder.append(string);
            }
        }
        return stringBuilder.toString();
    }

    public JToolBar getToolbar() {
        return this.historyToolbar;
    }

    public boolean isAutoscroll() {
        return this.autoscroll;
    }

    public boolean isHierarch() {
        return this.ishierarch;
    }

    public boolean isVisibleGUI() {
        if (this.history_GUI != null) {
            return this.history_GUI.isVisibleGUI();
        }
        return false;
    }

    public void LoadProperties(RandomInputStream randomInputStream) throws IOException {
        MapProperty mapProperty = randomInputStream.readProperties("HistoryScrollPane");
        if (mapProperty != null) {
            this.ishierarch = mapProperty.getPropertyBoolean("ishierarch");
            this.autoscroll = mapProperty.getPropertyBoolean("as", true);
            this.historyToolbar.setButtonState();
            this.updateHistory();
        }
    }

    public void SaveProperties(RandomOutputStream randomOutputStream) throws IOException {
        randomOutputStream.beginProperty("HistoryScrollPane");
        randomOutputStream.writePropertyBoolean("ishierarch", this.ishierarch);
        randomOutputStream.writePropertyBoolean("as", this.autoscroll);
        randomOutputStream.endProperty();
    }

    public void setAutoscroll(boolean bl) {
        this.autoscroll = bl;
        this.tableModel.autoScroll();
    }

    public void setHierarch(boolean bl) {
        this.ishierarch = bl;
        this.tableModel.buildList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateHistory() {
        ArrayList<Object> arrayList = this.historyList;
        synchronized (arrayList) {
            this.tableModel.buildList();
        }
    }

    public void updateTable() {
        this.historyTreeTable.updateUI();
    }

    class HistoryTreeTableModel
    extends AbstractTreeTableModel
    implements TreeTableModel {
        private final String[] cNames;
        private final SimpleDateFormat format;
        private final Date date;

        public HistoryTreeTableModel(String[] stringArray) {
            super(HistoryScrollPane.this.historyList);
            this.format = new SimpleDateFormat("yyyy-MM-dd, HH:mm");
            this.date = new Date();
            this.cNames = stringArray;
            this.buildList();
        }

        public void autoScroll() {
            int n = HistoryScrollPane.this.historyTreeTable.getRowCount();
            if (HistoryScrollPane.this.autoscroll && n > 0) {
                HistoryScrollPane.this.historyTreeTable.scrollRectToVisible(HistoryScrollPane.this.historyTreeTable.getCellRect(n - 1, 0, true));
            }
        }

        @Override
        public Object getChild(Object object, int n) {
            if (object instanceof HistoryInterface) {
                List list = ((HistoryInterface)object).getHistory();
                if (0 <= n && n < list.size()) {
                    return list.get(n);
                }
            } else if (0 <= n && n < HistoryScrollPane.this.historyList.size()) {
                return HistoryScrollPane.this.historyList.get(n);
            }
            return null;
        }

        @Override
        public int getChildCount(Object object) {
            if (object instanceof HistoryInterface) {
                List list = ((HistoryInterface)object).getHistory();
                if (HistoryScrollPane.this.ishierarch && list != null) {
                    return ((HistoryInterface)object).getHistory().size();
                }
                return 0;
            }
            return HistoryScrollPane.this.historyList.size();
        }

        @Override
        public Class getColumnClass(int n) {
            return switch (n) {
                case 1 -> TreeTableModel.class;
                default -> String.class;
            };
        }

        @Override
        public int getColumnCount() {
            return this.cNames.length;
        }

        @Override
        public String getColumnName(int n) {
            return this.cNames[n];
        }

        @Override
        public Object getRoot() {
            return HistoryScrollPane.this.historyList;
        }

        public JToolBar getToolbar() {
            return HistoryScrollPane.this.historyToolbar;
        }

        @Override
        public Object getValueAt(JTree jTree, Object object, int n, int n2) {
            if (object instanceof HistoryInterface) {
                HistoryInterface historyInterface = (HistoryInterface)object;
                switch (n2) {
                    case 0: {
                        this.date.setTime(historyInterface.getTimestamp());
                        return this.format.format(this.date);
                    }
                    case 1: {
                        return historyInterface;
                    }
                    case 2: {
                        return historyInterface.getDescription();
                    }
                    case 3: {
                        return this.formatTime(historyInterface.getDuration());
                    }
                    case 4: {
                        return historyInterface.getUsername();
                    }
                }
            }
            return "No value";
        }

        private synchronized void buildList() {
            HistoryScrollPane.this.historyList.clear();
            this.buildList(HistoryScrollPane.this.history_GUI.getRootNode());
            Collections.sort(HistoryScrollPane.this.historyList, (object, object2) -> {
                HistoryInterface historyInterface = (HistoryInterface)object;
                HistoryInterface historyInterface2 = (HistoryInterface)object2;
                return Double.compare(historyInterface.getTimestamp(), historyInterface2.getTimestamp());
            });
            if (HistoryScrollPane.this.historyTreeTable != null) {
                HistoryScrollPane.this.updateTable();
                this.autoScroll();
            }
        }

        private boolean buildList(DataTreeInterface dataTreeInterface) {
            if (dataTreeInterface != null && !dataTreeInterface.isCleaned()) {
                Object object;
                Object object2;
                if (!dataTreeInterface.isVisibleInTree()) {
                    if (dataTreeInterface instanceof DataContainer) {
                        object2 = (DataContainer)dataTreeInterface;
                        if (((DataContainer)object2).getTreeType() != 5 && ((DataContainer)object2).getTreeType() == 4) {
                            // empty if block
                        }
                    } else {
                        return false;
                    }
                }
                if (dataTreeInterface instanceof ShortcutInterface && ((ShortcutInterface)((Object)dataTreeInterface)).isShortcut()) {
                    return false;
                }
                if (dataTreeInterface instanceof HistoryInterface) {
                    object2 = (HistoryInterface)((Object)dataTreeInterface);
                    object = object2.getHistory();
                    HistoryScrollPane.this.historyList.add(object2);
                    if (object != null && !HistoryScrollPane.this.ishierarch) {
                        HistoryScrollPane.this.historyList.addAll((Collection<Object>)object);
                    }
                }
                for (int i = 0; i < dataTreeInterface.getTreeNodeCount(); ++i) {
                    object = dataTreeInterface.getTreeNodeAt(i);
                    this.buildList((DataTreeInterface)object);
                }
                return true;
            }
            return false;
        }

        private String formatTime(long l) {
            if (l < 100L) {
                return l + " msek";
            }
            if (l < 60000L) {
                return (double)((int)((double)l / 100.0)) / 10.0 + " sec";
            }
            if (l < 3600000L) {
                return (double)((int)((double)l / 6000.0)) / 10.0 + " min";
            }
            return (double)((int)((double)l / 360000.0)) / 10.0 + " hour";
        }
    }

    public class CustomTableCellRenderer
    extends DefaultTableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            Object object2 = HistoryScrollPane.this.historyTreeTable.getValueAt(n, 1);
            if (object2 instanceof AbstractHistoryNode && !((AbstractHistoryNode)object2).hasBeenDone()) {
                component.setForeground(Color.lightGray);
            } else if (!bl) {
                component.setForeground(Color.black);
            }
            return component;
        }
    }
}

