/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.history;

import java.awt.Color;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import se.prediktera.map.common.cleanup.CleanUpToolBar;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.common.swing.flat.JFlatButton;
import se.prediktera.map.common.swing.flat.JFlatToggleButton;
import se.prediktera.map.common.swing.flat.TextIcon;
import se.prediktera.map.history.AbstractHistoryNode;
import se.prediktera.map.history.HistoryScrollPane;
import se.prediktera.map.main.IniManager;
import se.prediktera.map.main.Main_GUI;
import se.prediktera.map.main.script.gui.ScriptEditorPanel;

public class HistoryToolbar
extends CleanUpToolBar {
    private HistoryScrollPane historyScrollPane;
    private final JFlatToggleButton buttonHierarch = new JFlatToggleButton();
    private final JFlatToggleButton autoScroll = new JFlatToggleButton();
    private final JFlatButton undoButton = new JFlatButton();
    private final JFlatButton redoButton = new JFlatButton();
    private final JFlatButton exportButton = new JFlatButton();
    private final JFlatButton viewButton = new JFlatButton();
    private AbstractHistoryNode node;

    public HistoryToolbar(HistoryScrollPane historyScrollPane) {
        this.historyScrollPane = historyScrollPane;
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            ErrorHandler.logAndReportException(exception);
        }
    }

    public void setButtonState() {
        this.buttonHierarch.setSelected(this.historyScrollPane.isHierarch());
        this.autoScroll.setSelected(this.historyScrollPane.isAutoscroll());
    }

    public void setCurrentNode(AbstractHistoryNode abstractHistoryNode) {
        this.node = abstractHistoryNode;
        this.undoButton.setEnabled(abstractHistoryNode != null && abstractHistoryNode.canUndo());
        this.redoButton.setEnabled(abstractHistoryNode != null && abstractHistoryNode.canRedo());
    }

    @Override
    protected void cleanUpChild() {
        this.historyScrollPane = null;
    }

    private void jbInit() throws Exception {
        this.buttonHierarch.setToolTipText("Show/Hide Hierarchical Order");
        this.buttonHierarch.setIcon(new TextIcon("H", Color.black));
        this.buttonHierarch.addActionListener(actionEvent -> this.historyScrollPane.setHierarch(this.buttonHierarch.isSelected()));
        this.autoScroll.setToolTipText("AutoScroll to Bottom");
        this.autoScroll.setIcon(new TextIcon("A", Color.black));
        this.autoScroll.setSelected(true);
        this.autoScroll.addActionListener(actionEvent -> this.historyScrollPane.setAutoscroll(this.autoScroll.isSelected()));
        this.undoButton.setToolTipText("Undo to this action");
        this.undoButton.setIcon(new ImageIcon(Main_GUI.class.getResource("gif/undo.png")));
        this.undoButton.setSelected(true);
        this.undoButton.addActionListener(actionEvent -> {
            this.node.setHistoryNode();
            this.setCurrentNode(this.node);
            this.historyScrollPane.updateTable();
        });
        this.undoButton.setEnabled(false);
        this.redoButton.setToolTipText("Redo to this action");
        this.redoButton.setIcon(new ImageIcon(Main_GUI.class.getResource("gif/redo.png")));
        this.redoButton.setSelected(true);
        this.redoButton.addActionListener(this.undoButton.getActionListeners()[0]);
        this.redoButton.setEnabled(false);
        this.exportButton.setToolTipText("Save as Template");
        this.exportButton.setIcon(new ImageIcon(Main_GUI.class.getResource("icons/common/saveFile.png")));
        this.exportButton.setSelected(true);
        this.exportButton.addActionListener(actionEvent -> this.historyScrollPane.exportScript());
        this.viewButton.setToolTipText("View Template");
        this.viewButton.setIcon(new TextIcon("V", Color.black));
        this.viewButton.setSelected(true);
        this.viewButton.addActionListener(actionEvent -> {
            ScriptEditorPanel scriptEditorPanel = new ScriptEditorPanel(false);
            scriptEditorPanel.setScript(this.historyScrollPane.generateScript(), null);
            JDialog jDialog = new JDialog(IniManager.getMainFrame());
            jDialog.setTitle("Template");
            jDialog.getContentPane().add(scriptEditorPanel);
            jDialog.setSize(600, 500);
            jDialog.setLocationRelativeTo(IniManager.getMainFrame());
            jDialog.setVisible(true);
        });
        this.setBorder(null);
        this.setFloatable(false);
        this.add(this.buttonHierarch);
        this.add(this.autoScroll);
        this.addSeparator();
        this.add(this.undoButton);
        this.add(this.redoButton);
        this.addSeparator();
        this.add(this.exportButton);
        this.add(this.viewButton);
    }
}

