/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.main;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import se.prediktera.map.common.CMenu;
import se.prediktera.map.common.swing.flat.JFlatButton;
import se.prediktera.map.common.swing.flat.JFlatButtonComboBox;
import se.prediktera.map.common.swing.flat.JFlatToggleButton;
import se.prediktera.map.datasetcontainer.DataTreeInterface;
import se.prediktera.map.main.AbstractGUI;
import se.prediktera.map.main.AbstractSettingsToolbar;
import se.prediktera.map.main.Evince;
import se.prediktera.map.main.Project_GUI;

public abstract class AbstractMainGUI
extends AbstractGUI {
    protected CMenu menu;
    protected NorthPanel northTitle = new NorthPanel();
    protected JPanel framePanel;
    protected JPanel centerPanel = new JPanel(new BorderLayout());
    private final JToolBar settingstoolbar = new JToolBar(1);
    private boolean hastoolbar = false;

    public AbstractMainGUI(Project_GUI project_GUI, String string, CMenu cMenu) {
        super(project_GUI, string);
        this.setLayout(new BorderLayout());
        this.add((Component)this.northTitle, "North");
        this.add((Component)this.centerPanel, "Center");
        this.setPreferredSize(new Dimension(100, 100));
        this.menu = cMenu;
    }

    public AbstractMainGUI(String string) {
        super(string);
    }

    @Override
    public void closing() {
    }

    public abstract void DataTreeSelected(DataTreeInterface var1);

    public abstract JComponent getSettingsPanel();

    public void showToolbar(boolean bl) {
        this.northTitle.showToolbar(bl);
    }

    @Override
    protected void cleanUpChild() {
        super.cleanUpChild();
        if (this.centerPanel != null) {
            this.centerPanel.removeAll();
            this.centerPanel = null;
        }
        if (this.framePanel != null) {
            this.framePanel.removeAll();
            this.framePanel = null;
        }
        if (this.northTitle != null) {
            this.northTitle.removeAll();
            this.northTitle = null;
        }
        this.menu = null;
    }

    protected void setSettingsToolbar(AbstractSettingsToolbar abstractSettingsToolbar) {
        this.settingstoolbar.removeAll();
        if (abstractSettingsToolbar == null) {
            if (this.hastoolbar) {
                this.centerPanel.remove(this.settingstoolbar);
                this.hastoolbar = false;
            }
        } else {
            for (int i = 0; i < abstractSettingsToolbar.size(); ++i) {
                if (i != 0) {
                    this.settingstoolbar.addSeparator();
                }
                this.settingstoolbar.add((Component)abstractSettingsToolbar.elementAt(i));
            }
            if (!this.hastoolbar) {
                this.centerPanel.add((Component)this.settingstoolbar, "West");
                this.hastoolbar = true;
            }
            this.settingstoolbar.setPreferredSize(new Dimension(abstractSettingsToolbar.getPreferedWidth(), 0));
            this.settingstoolbar.repaint();
        }
    }

    protected void setWindowMenu(JMenu jMenu, JToolBar jToolBar) {
        for (int i = 0; i < jToolBar.getComponentCount(); ++i) {
            Component component = jToolBar.getComponentAtIndex(i);
            if (component instanceof JFlatToggleButton) {
                jMenu.add(((JFlatToggleButton)component).createMenuItem(null));
                continue;
            }
            if (component instanceof JFlatButtonComboBox) {
                jMenu.add(((JFlatButtonComboBox)component).createMenuItem(null));
                continue;
            }
            if (component instanceof JFlatButton) {
                jMenu.add(((JFlatButton)component).createMenuItem(null));
                continue;
            }
            if (component instanceof JSeparator) {
                jMenu.addSeparator();
                continue;
            }
            if (!(component instanceof JToolBar)) continue;
            this.setWindowMenu(jMenu, (JToolBar)component);
        }
    }

    protected class NorthPanel
    extends JPanel {
        private final JLabel label;
        private final JPanel toolbarPanel;
        private JPanel titlePanel;

        public NorthPanel() {
            super(new BorderLayout());
            this.label = new JLabel();
            this.toolbarPanel = new JPanel(new GridBagLayout());
            this.titlePanel = new JPanel(new BorderLayout());
            this.addTitlePanel(this.titlePanel);
            this.add((Component)this.toolbarPanel, "North");
            this.toolbarPanel.setBackground(Color.white);
            this.titlePanel.add((Component)this.label, "West");
            this.titlePanel.setBackground(Color.white);
        }

        public void addComponent(JComponent jComponent, GridBagConstraints gridBagConstraints) {
            this.toolbarPanel.add((Component)jComponent, gridBagConstraints);
        }

        public void addComponent(JComponent jComponent, int n, float f) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints(n, 0, 1, 1, f, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0);
            this.toolbarPanel.add((Component)jComponent, gridBagConstraints);
        }

        public void addTitlePanel(JPanel jPanel) {
            if (this.titlePanel != null) {
                this.remove(this.titlePanel);
            }
            if (jPanel != null) {
                int n = 20;
                if (Evince.touchscreen || Evince.isHidpi()) {
                    n *= 2;
                }
                this.titlePanel = jPanel;
                this.titlePanel.setPreferredSize(new Dimension(0, n));
                this.add((Component)this.titlePanel, "Center");
            }
        }

        public void addToolbar(JToolBar jToolBar) {
            this.addToolbar(jToolBar, 0);
        }

        public void addToolbar(JToolBar jToolBar, int n) {
            float f = 0.0f;
            if (n > 0) {
                f = 1.0f;
            }
            GridBagConstraints gridBagConstraints = new GridBagConstraints(n, 0, 1, 1, f, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0);
            this.toolbarPanel.add((Component)jToolBar, gridBagConstraints);
        }

        public void addToolbar(JToolBar jToolBar, int n, float f) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints(n, 0, 1, 1, f, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0);
            this.toolbarPanel.add((Component)jToolBar, gridBagConstraints);
        }

        public void addToolbar(JToolBar jToolBar, Object object) {
            this.toolbarPanel.add((Component)jToolBar, object);
        }

        public void createFramePanel() {
            this.createFramePanel(this.toolbarPanel);
        }

        public void createFramePanel(JPanel jPanel) {
            AbstractMainGUI.this.framePanel = new JPanel(new BorderLayout());
            jPanel.add((Component)AbstractMainGUI.this.framePanel, "East");
        }

        public String getText() {
            return this.label.getText();
        }

        public JPanel getTitlePanel() {
            return this.titlePanel;
        }

        public void setIcon(Icon icon) {
            this.label.setIcon(icon);
        }

        public void setText(String string) {
            this.label.setText(string);
        }

        public void showToolbar(boolean bl) {
            this.toolbarPanel.setVisible(bl);
        }
    }
}

