/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.main;

import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import se.prediktera.map.components.tree.AbstractComponentNode;
import se.prediktera.map.datasetcontainer.AbstractDataNode;
import se.prediktera.map.datasetcontainer.Case;
import se.prediktera.map.datasetcontainer.DataContainer;
import se.prediktera.map.datasetcontainer.DataTreeInterface;
import se.prediktera.map.datasetcontainer.DataTreeShortcut;
import se.prediktera.map.datasetcontainer.ShortcutInterface;
import se.prediktera.map.datasetcontainer.event.DataTreeListener;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.main.DataBrowser;
import se.prediktera.map.model.AbstractModel;

public class BrowserElement
extends AbstractComponentNode {
    private DataTreeListener listener;

    private static int getSupportedChilds(DataBrowser dataBrowser, DataTreeInterface dataTreeInterface) {
        int n = dataTreeInterface.getTreeNodeCount();
        int n2 = 0;
        for (int i = 0; dataTreeInterface != null && i < n; ++i) {
            DataTreeInterface dataTreeInterface2 = dataTreeInterface.getTreeNodeAt(i);
            if (!dataBrowser.supportInterface(dataTreeInterface2) || !BrowserElement.isVisibleInTree(dataTreeInterface2)) continue;
            ++n2;
        }
        return n2;
    }

    private static boolean isVisibleInTree(DataTreeInterface dataTreeInterface) {
        return dataTreeInterface.isVisibleInTree();
    }

    public BrowserElement(DataTreeInterface dataTreeInterface) {
        super(dataTreeInterface);
        if (dataTreeInterface instanceof DataContainer) {
            this.setPainttype(((DataContainer)dataTreeInterface).getPainttype());
        }
        if (dataTreeInterface instanceof AbstractModel && ((AbstractModel)dataTreeInterface).isModelContainer()) {
            this.setPainttype(3);
        }
    }

    public BrowserElement(DataTreeInterface dataTreeInterface, DataTreeListener dataTreeListener) {
        this(dataTreeInterface);
        this.listener = dataTreeListener;
        dataTreeInterface.addDataTreeChangeListener(dataTreeListener);
    }

    public void change(DataBrowser dataBrowser, TreePath treePath, boolean bl, boolean bl2) {
        if (treePath == null) {
            treePath = new TreePath(dataBrowser.getTreePath(this));
        }
        if (bl2) {
            for (int i = 0; i < this.getChildCount(); ++i) {
                BrowserElement browserElement = (BrowserElement)this.getChildAt(i);
                browserElement.change(dataBrowser, treePath.pathByAddingChild(browserElement), bl, bl2);
            }
        }
        if (bl) {
            dataBrowser.expandPath(treePath);
        } else {
            dataBrowser.collapsePath(treePath);
        }
    }

    public DataTreeInterface getDataTreeInterface() {
        return (DataTreeInterface)this.userObject;
    }

    public DataTreeListener getDataTreeListener() {
        return this.listener;
    }

    @Override
    public String getToolTipText() {
        AbstractModel abstractModel;
        DataTreeInterface dataTreeInterface = this.getDataTreeInterface();
        if (dataTreeInterface instanceof AbstractModel && (abstractModel = (AbstractModel)dataTreeInterface).getDatasetchanged()) {
            return "<html><body>" + String.valueOf(dataTreeInterface) + "<br><I>DataSet changes has not been applied to the model<br>Press \"Apply Changes\" to update the model</I></body></html>";
        }
        return super.getToolTipText();
    }

    public final boolean hasDataTreeInterface(DataTreeInterface dataTreeInterface) {
        DataTreeInterface dataTreeInterface2 = this.getDataTreeInterface();
        if (dataTreeInterface2 instanceof DataTreeShortcut) {
            dataTreeInterface2 = ((DataTreeShortcut)dataTreeInterface2).getShortcut();
        }
        return dataTreeInterface.equals(dataTreeInterface2);
    }

    public void Purge(DataBrowser dataBrowser) {
        if (this.isRoot()) {
            for (int i = this.getChildCount() - 1; i >= 0; --i) {
                ((BrowserElement)this.getChildAt(i)).Purge(dataBrowser);
            }
        } else {
            this.PurgeRecursize(dataBrowser);
            if (this.getParent() != null) {
                DefaultTreeModel defaultTreeModel = (DefaultTreeModel)dataBrowser.getModel();
                defaultTreeModel.removeNodeFromParent(this);
            }
        }
    }

    @Override
    public String toString() {
        DataTreeInterface dataTreeInterface = this.getDataTreeInterface();
        if (dataTreeInterface != null) {
            AbstractModel abstractModel;
            if (dataTreeInterface instanceof AbstractDataMatrix && ((AbstractDataMatrix)dataTreeInterface).isOrigMatrix()) {
                return "Original Data (" + String.valueOf(dataTreeInterface) + ")";
            }
            if (dataTreeInterface instanceof AbstractModel && (abstractModel = (AbstractModel)dataTreeInterface).getDatasetchanged()) {
                return "* " + String.valueOf(dataTreeInterface);
            }
            return dataTreeInterface.toString();
        }
        return super.toString();
    }

    public final BrowserElement update(DataBrowser dataBrowser, DataTreeInterface dataTreeInterface, boolean bl, boolean bl2) {
        DataTreeInterface dataTreeInterface2 = this.getDataTreeInterface();
        BrowserElement browserElement = null;
        if (dataBrowser.supportInterface(dataTreeInterface2) && BrowserElement.isVisibleInTree(dataTreeInterface2)) {
            if (!bl && dataTreeInterface2 instanceof ShortcutInterface) {
                bl = ((ShortcutInterface)((Object)dataTreeInterface2)).isShortcut();
            }
            if (dataTreeInterface2.getTreeNodeCount() > 0) {
                this.checkChild(dataBrowser, dataTreeInterface2, bl, bl2);
            }
            if (dataBrowser.isSelectable(dataTreeInterface2)) {
                browserElement = this;
            }
            for (int i = this.getChildCount() - 1; i >= 0; --i) {
                DataTreeInterface dataTreeInterface3;
                BrowserElement browserElement2 = (BrowserElement)this.getChildAt(i);
                BrowserElement browserElement3 = browserElement2.update(dataBrowser, dataTreeInterface, bl, false);
                if (browserElement3 == null || (dataTreeInterface3 = browserElement3.getDataTreeInterface()) == null || !dataTreeInterface3.equals(dataTreeInterface)) continue;
                browserElement = browserElement3;
            }
        } else {
            this.Purge(dataBrowser);
        }
        return browserElement;
    }

    private void checkChild(DataBrowser dataBrowser, DataTreeInterface dataTreeInterface, boolean bl, boolean bl2) {
        int n = dataTreeInterface.getTreeNodeCount();
        boolean bl3 = this.userObject instanceof Case;
        for (int i = 0; dataTreeInterface != null && i < n; ++i) {
            DataTreeInterface dataTreeInterface2 = dataTreeInterface.getTreeNodeAt(i);
            if (this.hasChild(dataTreeInterface2) || !dataBrowser.supportInterface(dataTreeInterface2) || !BrowserElement.isVisibleInTree(dataTreeInterface2)) continue;
            if (dataBrowser.visibleContainer(dataTreeInterface2)) {
                int n2;
                byte by = dataBrowser.getFilter();
                if (bl2 && by != -1 && dataTreeInterface2 instanceof AbstractDataNode && ((AbstractDataNode)dataTreeInterface2).getType() != by) continue;
                DefaultTreeModel defaultTreeModel = (DefaultTreeModel)dataBrowser.getModel();
                if (bl) {
                    dataTreeInterface2 = new DataTreeShortcut(dataTreeInterface2);
                }
                if (bl3 && dataTreeInterface2 instanceof AbstractDataMatrix) {
                    n2 = 0;
                } else if (dataTreeInterface2.getTreeParent() instanceof AbstractModel && ((AbstractModel)dataTreeInterface2.getTreeParent()).isModelContainer() && !(dataTreeInterface2 instanceof AbstractModel)) {
                    n2 = 0;
                } else if (dataTreeInterface2 instanceof AbstractDataNode) {
                    n2 = this.getCatalogueCount(bl3);
                    if (((AbstractDataNode)dataTreeInterface2).getType() == -1 && !dataTreeInterface2.toString().equals("Explained variances") && BrowserElement.getSupportedChilds(dataBrowser, dataTreeInterface2) == 0) {
                        continue;
                    }
                } else {
                    n2 = this.getChildCount();
                }
                defaultTreeModel.insertNodeInto(new BrowserElement(dataTreeInterface2, this.listener), this, n2);
                continue;
            }
            this.checkChild(dataBrowser, dataTreeInterface2, bl, bl2);
        }
    }

    private int getCatalogueCount(boolean bl) {
        int n = 0;
        int n2 = this.getChildCount();
        for (int i = 0; i < n2; ++i) {
            BrowserElement browserElement = (BrowserElement)this.getChildAt(i);
            DataTreeInterface dataTreeInterface = (DataTreeInterface)browserElement.getUserObject();
            if (!(dataTreeInterface instanceof AbstractDataNode) && (!bl || !(dataTreeInterface instanceof AbstractDataMatrix))) continue;
            ++n;
        }
        return n;
    }

    private boolean hasChild(DataTreeInterface dataTreeInterface) {
        if (!dataTreeInterface.isCleaned()) {
            int n = this.getChildCount();
            for (int i = 0; i < n; ++i) {
                BrowserElement browserElement = (BrowserElement)this.getChildAt(i);
                if (!browserElement.hasDataTreeInterface(dataTreeInterface)) continue;
                return true;
            }
        }
        return false;
    }

    private void PurgeRecursize(DataBrowser dataBrowser) {
        int n = this.getChildCount();
        for (int i = 0; i < n; ++i) {
            BrowserElement browserElement = (BrowserElement)this.getChildAt(i);
            browserElement.PurgeRecursize(dataBrowser);
        }
        DataTreeInterface dataTreeInterface = this.getDataTreeInterface();
        if (dataTreeInterface != null && this.listener != null) {
            dataTreeInterface.removeDataTreeChangeListener(this.listener);
        }
        if (dataTreeInterface instanceof DataTreeShortcut && dataTreeInterface.isCleaned()) {
            dataTreeInterface.cleanUp();
        }
        this.setUserObject(null);
        this.listener = null;
    }
}

