/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.main;

import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import se.prediktera.map.common.ErrorDialog;
import se.prediktera.map.main.IniManager;
import se.prediktera.map.main.Plot_GUI;
import se.prediktera.map.plot.axisplot.settings.Color.PlotContinuousColor;

public class ColorScalesHelper {
    private static final String[] SCALE_NAMES = new String[]{"Cool", "Gray", "Hot", "HSV", "Jet", "Spring", "Summer", "Winter"};
    private static final Color[] SCALE_SELECTIONCOLOR = new Color[]{Color.BLACK, Color.YELLOW, Color.GREEN, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.YELLOW};
    private static final int[][] SCALE_VALUES = new int[][]{{-16711681, -16777216, -16580608, -65536, -16777085, -65281, -16744346, -16776961}, {-16646401, -16711423, -16449536, -64000, -16777081, -65026, -16678810, -16776705}, {-16581121, -16645630, -16252928, -62464, -16777077, -64771, -16613274, -16776450}, {-16515841, -16579837, -16056320, -60928, -16777073, -64516, -16547482, -16776194}, {-16450561, -16514044, -15925248, -59392, -16777069, -64261, -16481946, -16775939}, {-16385281, -16448251, -15728640, -57856, -16777065, -64006, -16416154, -16775683}, {-16320001, -16382458, -15532032, -56320, -16777061, -63751, -16350618, -16775428}, {-16254721, -16316665, -15400960, -54784, -16777057, -63496, -16284826, -16775173}, {-16189441, -16250872, -15204352, -53248, -16777053, -63241, -16219034, -16774917}, {-16124161, -16185079, -15007744, -51712, -16777049, -62986, -16153498, -16774662}, {-16058881, -16119286, -14876672, -50176, -16777045, -62731, -16087706, -16774406}, {-15993601, -16053493, -14680064, -48640, -16777041, -62476, -16022170, -16774151}, {-15928321, -15987700, -14483456, -47104, -16777037, -62221, -15956378, -16773895}, {-15863041, -15921907, -14352384, -45568, -16777033, -61966, -15890842, -16773639}, {-15797761, -15856114, -14155776, -44032, -16777029, -61711, -15825306, -16773384}, {-15732481, -15790321, -13959168, -42496, -16777025, -61456, -15759514, -16773128}, {-15667201, -15724528, -13828096, -40960, -16777021, -61201, -15693978, -16772873}, {-15601921, -15658735, -13631488, -39424, -16777017, -60946, -15628186, -16772617}, {-15536641, -15592942, -13500416, -37888, -16777013, -60691, -15562650, -16772362}, {-15471361, -15527149, -13303808, -36352, -16777009, -60436, -15496858, -16772106}, {-15406081, -15461356, -13107200, -34816, -16777005, -60181, -15431066, -16771851}, {-15340801, -15395563, -12976128, -33280, -16777001, -59926, -15365530, -16771596}, {-15275521, -15329770, -12779520, -32000, -16776997, -59671, -15299738, -16771340}, {-15210241, -15263977, -12582912, -30464, -16776993, -59416, -15234202, -16771085}, {-15144961, -15198184, -12451840, -28928, -16776989, -59161, -15168410, -16770829}, {-15079681, -15132391, -12255232, -27392, -16776985, -58906, -15102874, -16770574}, {-15014401, -15066598, -12058624, -25856, -16776981, -58651, -15037338, -16770318}, {-14949121, -15000805, -11927552, -24320, -16776977, -58396, -14971546, -16770062}, {-14883841, -14935012, -11730944, -22784, -16776973, -58141, -14906010, -16769807}, {-14818561, -14869219, -11534336, -21248, -16776969, -57886, -14840218, -16769551}, {-14753281, -14803426, -11403264, -19712, -16776965, -57631, -14774682, -16769296}, {-14688001, -14737633, -11206656, -18176, -16776961, -57376, -14708890, -16769040}, {-14622721, -14671840, -11010048, -16640, -16775937, -57121, -14643098, -16768785}, {-14557441, -14606047, -10878976, -15104, -16774913, -56866, -14577562, -16768530}, {-14492161, -14540254, -10682368, -13568, -16773889, -56611, -14511770, -16768274}, {-14426881, -14474461, -10485760, -12032, -16772865, -56356, -14446234, -16768019}, {-14361601, -14408668, -10354688, -10496, -16771841, -56101, -14380442, -16767763}, {-14296321, -14342875, -10158080, -8960, -16770817, -55846, -14314906, -16767508}, {-14231041, -14277082, -9961472, -7424, -16769793, -55591, -14249114, -16767252}, {-14165761, -14211289, -9830400, -5888, -16768769, -55336, -14183578, -16766996}, {-14100481, -14145496, -9633792, -4352, -16767745, -55081, -14118042, -16766741}, {-14035201, -14079703, -9437184, -2816, -16766721, -54826, -14052250, -16766485}, {-13969921, -14013910, -9306112, -1280, -16765697, -54571, -13986714, -16766230}, {-13904641, -13948117, -9109504, -131328, -16764673, -54316, -13920922, -16765974}, {-13839361, -13882324, -8912896, -524544, -16763649, -54061, -13855386, -16765719}, {-13774081, -13816531, -8781824, -917760, -16762625, -53806, -13789594, -16765464}, {-13708801, -13750738, -8585216, -1310976, -16761601, -53551, -13723802, -16765208}, {-13643521, -13684945, -8388608, -1704192, -16760577, -53296, -13658266, -16764953}, {-13578241, -13619152, -8257536, -2097408, -16759553, -53041, -13592474, -16764697}, {-13512961, -13553359, -8060928, -2490624, -16758529, -52786, -13526938, -16764442}, {-13447681, -13487566, -7929856, -2883840, -16757505, -52531, -13461146, -16764186}, {-13382401, -13421773, -7733248, -3277056, -16756481, -52276, -13395610, -16763930}, {-13317121, -13355980, -7536640, -3670272, -16755457, -52021, -13330074, -16763675}, {-13251841, -13290187, -7405568, -4063488, -16754433, -51766, -13264282, -16763419}, {-13186561, -13224394, -7208960, -4456704, -16753409, -51511, -13198746, -16763164}, {-13121281, -13158601, -7012352, -4849920, -16752385, -51256, -13132954, -16762908}, {-13056001, -13092808, -6881280, -5243136, -16751361, -51001, -13067418, -16762653}, {-12990721, -13027015, -6684672, -5636352, -16750337, -50746, -13001626, -16762397}, {-12925441, -12961222, -6488064, -6029568, -16749313, -50491, -12935834, -16762142}, {-12860161, -12895429, -6356992, -6422784, -16748289, -50236, -12870298, -16761887}, {-12794881, -12829636, -6160384, -6816000, -16747265, -49981, -12804506, -16761631}, {-12729601, -12763843, -5963776, -7209216, -16746241, -49726, -12738970, -16761376}, {-12664321, -12698050, -5832704, -7602432, -16745217, -49471, -12673178, -16761120}, {-12599041, -12632257, -5636096, -7995648, -16744193, -49216, -12607642, -16760865}, {-12533761, -12566464, -5439488, -8323328, -16743425, -48961, -12542106, -16760609}, {-12468481, -12500671, -5308416, -8716544, -16742401, -48706, -12476314, -16760353}, {-12403201, -12434878, -5111808, -9109760, -16741377, -48451, -12410778, -16760098}, {-12337921, -12369085, -4915200, -9502976, -16740353, -48196, -12344986, -16759842}, {-12272641, -12303292, -4784128, -9896192, -16739329, -47941, -12279450, -16759587}, {-12207361, -12237499, -4587520, -10289408, -16738305, -47686, -12213658, -16759331}, {-12142081, -12171706, -4390912, -10682624, -16737281, -47431, -12148122, -16759076}, {-12076801, -12105913, -4259840, -11075840, -16736257, -47176, -12082330, -16758821}, {-12011521, -12040120, -4063232, -11469056, -16735233, -46921, -12016538, -16758565}, {-11946241, -11974327, -3866624, -11862272, -16734209, -46666, -11951002, -16758310}, {-11880961, -11908534, -3735552, -12255488, -16733185, -46411, -11885210, -16758054}, {-11815681, -11842741, -3538944, -12648704, -16732161, -46156, -11819674, -16757799}, {-11750401, -11776948, -3342336, -13041920, -16731137, -45901, -11753882, -16757543}, {-11685121, -11711155, -3211264, -13435136, -16730113, -45646, -11688346, -16757287}, {-11619841, -11645362, -3014656, -13828352, -16729089, -45391, -11622810, -16757032}, {-11554561, -11579569, -2883584, -14221568, -16728065, -45136, -11557018, -16756776}, {-11489281, -11513776, -2686976, -14614784, -16727041, -44881, -11491482, -16756521}, {-11424001, -11447983, -2490368, -15008000, -16726017, -44626, -11425690, -16756265}, {-11358721, -11382190, -2359296, -15401216, -16724993, -44371, -11360154, -16756010}, {-11293441, -11316397, -2162688, -15794432, -16723969, -44116, -11294362, -16755755}, {-11228161, -11250604, -1966080, -16187648, -16722945, -43861, -11228570, -16755499}, {-11162881, -11184811, -1835008, -16580864, -16721921, -43606, -11163034, -16755244}, {-11097601, -11119018, -1638400, -16711932, -16720897, -43351, -11097242, -16754988}, {-11032321, -11053225, -1441792, -16711926, -16719873, -43096, -11031706, -16754733}, {-10967041, -10987432, -1310720, -16711920, -16718849, -42841, -10965914, -16754477}, {-10901761, -10921639, -1114112, -16711914, -16717825, -42586, -10900378, -16754222}, {-10836481, -10855846, -917504, -16711908, -16716801, -42331, -10834842, -16753966}, {-10771201, -10790053, -786432, -16711902, -16715777, -42076, -10769050, -16753710}, {-10705921, -10724260, -589824, -16711896, -16714753, -41821, -10703514, -16753455}, {-10640641, -10658467, -393216, -16711890, -16713729, -41566, -10637722, -16753199}, {-10575361, -10592674, -262144, -16711884, -16712705, -41311, -10572186, -16752944}, {-10510081, -10526881, -65536, -16711878, -16711681, -41056, -10506394, -16752688}, {-10444801, -10461088, -64768, -16711872, -16449537, -40801, -10440602, -16752433}, {-10379521, -10395295, -64256, -16711866, -16187397, -40546, -10375066, -16752178}, {-10314241, -10329502, -63488, -16711860, -15925257, -40291, -10309274, -16751922}, {-10248961, -10263709, -62720, -16711854, -15663117, -40036, -10243738, -16751667}, {-10183681, -10197916, -62208, -16711848, -15400977, -39781, -10177946, -16751411}, {-10118401, -10132123, -61440, -16711842, -15138837, -39526, -10112410, -16751156}, {-10053121, -10066330, -60672, -16711836, -14876697, -39271, -10046618, -16750900}, {-9987841, -10000537, -60160, -16711830, -14614557, -39016, -9981082, -16750644}, {-9922561, -9934744, -59392, -16711824, -14352417, -38761, -9915546, -16750389}, {-9857281, -9868951, -58624, -16711818, -14090277, -38506, -9849754, -16750133}, {-9792001, -9803158, -58112, -16711812, -13828137, -38251, -9784218, -16749878}, {-9726721, -9737365, -57344, -16711807, -13565997, -37996, -9718426, -16749622}, {-9661441, -9671572, -56576, -16711801, -13303857, -37741, -9652890, -16749367}, {-9596161, -9605779, -56064, -16711795, -13041717, -37486, -9587098, -16749112}, {-9530881, -9539986, -55296, -16711789, -12779577, -37231, -9521306, -16748856}, {-9465601, -9474193, -54528, -16711783, -12517437, -36976, -9455770, -16748601}, {-9400321, -9408400, -54016, -16711777, -12255297, -36721, -9389978, -16748345}, {-9335041, -9342607, -53248, -16711771, -11993157, -36466, -9324442, -16748090}, {-9269761, -9276814, -52736, -16711765, -11731017, -36211, -9258650, -16747834}, {-9204481, -9211021, -51968, -16711759, -11468877, -35956, -9193114, -16747578}, {-9139201, -9145228, -51200, -16711753, -11206737, -35701, -9127578, -16747323}, {-9073921, -9079435, -50688, -16711747, -10944597, -35446, -9061786, -16747067}, {-9008641, -9013642, -49920, -16711741, -10682457, -35191, -8996250, -16746812}, {-8943361, -8947849, -49152, -16711735, -10420317, -34936, -8930458, -16746556}, {-8878081, -8882056, -48640, -16711729, -10158177, -34681, -8864922, -16746301}, {-8812801, -8816263, -47872, -16711723, -9896037, -34426, -8799130, -16746045}, {-8747521, -8750470, -47104, -16711717, -9633897, -34171, -8733338, -16745790}, {-8682241, -8684677, -46592, -16711711, -9371757, -33916, -8667802, -16745535}, {-8616961, -8618884, -45824, -16711705, -9109617, -33661, -8602010, -16745279}, {-8551681, -8553091, -45056, -16711699, -8847477, -33406, -8536474, -16745024}, {-8486401, -8487298, -44544, -16711693, -8585337, -33151, -8470682, -16744768}, {-8421121, -8421505, -43776, -16711687, -8323197, -32896, -8405146, -16744513}, {-8355841, -8355712, -43008, -16711681, -8126592, -32641, -8339610, -16744257}, {-8290561, -8289919, -42496, -16713217, -7864452, -32386, -8273818, -16744001}, {-8225281, -8224126, -41728, -16714753, -7602312, -32131, -8208282, -16743746}, {-8160001, -8158333, -40960, -16716289, -7340172, -31876, -8142490, -16743490}, {-8094721, -8092540, -40448, -16717825, -7078032, -31621, -8076954, -16743235}, {-8029441, -8026747, -39680, -16719361, -6815892, -31366, -8011162, -16742979}, {-7964161, -7960954, -38912, -16720897, -6553752, -31111, -7945370, -16742724}, {-7898881, -7895161, -38400, -16722433, -6291612, -30856, -7879834, -16742469}, {-7833601, -7829368, -37632, -16723969, -6029472, -30601, -7814042, -16742213}, {-7768321, -7763575, -36864, -16725505, -5767332, -30346, -7748506, -16741958}, {-7703041, -7697782, -36352, -16727041, -5505192, -30091, -7682714, -16741702}, {-7637761, -7631989, -35584, -16728577, -5243052, -29836, -7617178, -16741447}, {-7572481, -7566196, -34816, -16730113, -4980912, -29581, -7551386, -16741191}, {-7507201, -7500403, -34304, -16731649, -4718772, -29326, -7485850, -16740935}, {-7441921, -7434610, -33536, -16733185, -4456632, -29071, -7420314, -16740680}, {-7376641, -7368817, Short.MIN_VALUE, -16734721, -4194492, -28816, -7354522, -16740424}, {-7311361, -7303024, -32256, -16736257, -3932352, -28561, -7288986, -16740169}, {-7246081, -7237231, -31488, -16737793, -3670212, -28306, -7223194, -16739913}, {-7180801, -7171438, -30976, -16739329, -3408072, -28051, -7157658, -16739658}, {-7115521, -7105645, -30208, -16740865, -3145932, -27796, -7091866, -16739403}, {-7050241, -7039852, -29440, -16742401, -2883792, -27541, -7026074, -16739147}, {-6984961, -6974059, -28928, -16743937, -2621652, -27286, -6960538, -16738892}, {-6919681, -6908266, -28160, -16745217, -2359512, -27031, -6894746, -16738636}, {-6854401, -6842473, -27392, -16746753, -2097372, -26776, -6829210, -16738381}, {-6789121, -6776680, -26880, -16748289, -1835232, -26521, -6763418, -16738125}, {-6723841, -6710887, -26112, -16749825, -1573092, -26266, -6697882, -16737869}, {-6658561, -6645094, -25344, -16751361, -1310952, -26011, -6632346, -16737614}, {-6593281, -6579301, -24832, -16752897, -1048812, -25756, -6566554, -16737358}, {-6528001, -6513508, -24064, -16754433, -786672, -25501, -6501018, -16737103}, {-6462721, -6447715, -23296, -16755969, -524532, -25246, -6435226, -16736847}, {-6397441, -6381922, -22784, -16757505, -262392, -24991, -6369690, -16736592}, {-6332161, -6316129, -22016, -16759041, -252, -24736, -6303898, -16736336}, {-6266881, -6250336, -21248, -16760577, -256, -24481, -6238106, -16736081}, {-6201601, -6184543, -20736, -16762113, -1280, -24226, -6172570, -16735826}, {-6136321, -6118750, -19968, -16763649, -2304, -23971, -6106778, -16735570}, {-6071041, -6052957, -19200, -16765185, -3328, -23716, -6041242, -16735315}, {-6005761, -5987164, -18688, -16766721, -4352, -23461, -5975450, -16735059}, {-5940481, -5921371, -17920, -16768257, -5376, -23206, -5909914, -16734804}, {-5875201, -5855578, -17152, -16769793, -6400, -22951, -5844378, -16734548}, {-5809921, -5789785, -16640, -16771329, -7424, -22696, -5778586, -16734292}, {-5744641, -5723992, -15872, -16772865, -8448, -22441, -5713050, -16734037}, {-5679361, -5658199, -15104, -16774401, -9472, -22186, -5647258, -16733781}, {-5614081, -5592406, -14592, -16775937, -10496, -21931, -5581722, -16733526}, {-5548801, -5526613, -13824, -16645889, -11520, -21676, -5515930, -16733270}, {-5483521, -5460820, -13056, -16252673, -12544, -21421, -5450394, -16733015}, {-5418241, -5395027, -12544, -15859457, -13568, -21166, -5384602, -16732760}, {-5352961, -5329234, -11776, -15466241, -14592, -20911, -5318810, -16732504}, {-5287681, -5263441, -11264, -15073025, -15616, -20656, -5253274, -16732249}, {-5222401, -5197648, -10496, -14679809, -16640, -20401, -5187482, -16731993}, {-5157121, -5131855, -9728, -14286593, -17664, -20146, -5121946, -16731738}, {-5091841, -5066062, -9216, -13893377, -18688, -19891, -5056154, -16731482}, {-5026561, -5000269, -8448, -13500161, -19712, -19636, -4990618, -16731226}, {-4961281, -4934476, -7680, -13106945, -20736, -19381, -4925082, -16730971}, {-4896001, -4868683, -7168, -12713729, -21760, -19126, -4859290, -16730715}, {-4830721, -4802890, -6400, -12320513, -22784, -18871, -4793754, -16730460}, {-4765441, -4737097, -5632, -11927297, -23808, -18616, -4727962, -16730204}, {-4700161, -4671304, -5120, -11534081, -24832, -18361, -4662426, -16729949}, {-4634881, -4605511, -4352, -11140865, -25856, -18106, -4596634, -16729694}, {-4569601, -4539718, -3584, -10747649, -26880, -17851, -4530842, -16729438}, {-4504321, -4473925, -3072, -10354433, -27904, -17596, -4465306, -16729183}, {-4439041, -4408132, -2304, -9961217, -28928, -17341, -4399514, -16728927}, {-4373761, -4342339, -1536, -9568001, -29952, -17086, -4333978, -16728672}, {-4308481, -4276546, -1024, -9174785, -30976, -16831, -4268186, -16728416}, {-4243201, -4210753, -256, -8781569, -32000, -16576, -4202650, -16728161}, {-4177921, -4144960, -252, -8388353, Short.MIN_VALUE, -16321, -4137114, -16727905}, {-4112641, -4079167, -248, -8060673, -33792, -16066, -4071322, -16727649}, {-4047361, -4013374, -244, -7667457, -34816, -15811, -4005786, -16727394}, {-3982081, -3947581, -240, -7274241, -35840, -15556, -3939994, -16727138}, {-3916801, -3881788, -236, -6881025, -36864, -15301, -3874458, -16726883}, {-3851521, -3815995, -232, -6487809, -37888, -15046, -3808666, -16726627}, {-3786241, -3750202, -228, -6094593, -38912, -14791, -3742874, -16726372}, {-3720961, -3684409, -224, -5701377, -39936, -14536, -3677338, -16726117}, {-3655681, -3618616, -220, -5308161, -40960, -14281, -3611546, -16725861}, {-3590401, -3552823, -216, -4914945, -41984, -14026, -3546010, -16725606}, {-3525121, -3487030, -212, -4521729, -43008, -13771, -3480218, -16725350}, {-3459841, -3421237, -208, -4128513, -44032, -13516, -3414682, -16725095}, {-3394561, -3355444, -204, -3735297, -45056, -13261, -3348890, -16724839}, {-3329281, -3289651, -200, -3342081, -46080, -13006, -3283354, -16724583}, {-3264001, -3223858, -196, -2948865, -47104, -12751, -3217818, -16724328}, {-3198721, -3158065, -192, -2555649, -48128, -12496, -3152026, -16724072}, {-3133441, -3092272, -188, -2162433, -49152, -12241, -3086490, -16723817}, {-3068161, -3026479, -184, -1769217, -50176, -11986, -3020698, -16723561}, {-3002881, -2960686, -180, -1376001, -51200, -11731, -2955162, -16723306}, {-2937601, -2894893, -176, -982785, -52224, -11476, -2889370, -16723051}, {-2872321, -2829100, -172, -589569, -53248, -11221, -2823578, -16722795}, {-2807041, -2763307, -168, -196353, -54272, -10966, -2758042, -16722540}, {-2741761, -2697514, -164, -65285, -55296, -10711, -2692250, -16722284}, {-2676481, -2631721, -160, -65291, -56320, -10456, -2626714, -16722029}, {-2611201, -2565928, -156, -65297, -57344, -10201, -2560922, -16721773}, {-2545921, -2500135, -152, -65303, -58368, -9946, -2495386, -16721517}, {-2480641, -2434342, -148, -65309, -59392, -9691, -2429850, -16721262}, {-2415361, -2368549, -144, -65315, -60416, -9436, -2364058, -16721006}, {-2350081, -2302756, -140, -65321, -61440, -9181, -2298522, -16720751}, {-2284801, -2236963, -136, -65327, -62464, -8926, -2232730, -16720495}, {-2219521, -2171170, -132, -65333, -63488, -8671, -2167194, -16720240}, {-2154241, -2105377, -128, -65339, -64512, -8416, -2101402, -16719984}, {-2088961, -2039584, -125, -65345, -65536, -8161, -2035610, -16719729}, {-2023681, -1973791, -121, -65351, -327680, -7906, -1970074, -16719474}, {-1958401, -1907998, -117, -65357, -589824, -7651, -1904282, -16719218}, {-1893121, -1842205, -113, -65363, -851968, -7396, -1838746, -16718963}, {-1827841, -1776412, -109, -65369, -1114112, -7141, -1772954, -16718707}, {-1762561, -1710619, -105, -65375, -1376256, -6886, -1707418, -16718452}, {-1697281, -1644826, -101, -65381, -1638400, -6631, -1641882, -16718196}, {-1632001, -1579033, -97, -65387, -1900544, -6376, -1576090, -16717940}, {-1566721, -1513240, -93, -65393, -2162688, -6121, -1510554, -16717685}, {-1501441, -1447447, -89, -65399, -2424832, -5866, -1444762, -16717429}, {-1436161, -1381654, -85, -65405, -2686976, -5611, -1379226, -16717174}, {-1370881, -1315861, -81, -65410, -2949120, -5356, -1313434, -16716918}, {-1305601, -1250068, -77, -65416, -3211264, -5101, -1247642, -16716663}, {-1240321, -1184275, -73, -65422, -3473408, -4846, -1182106, -16716408}, {-1175041, -1118482, -69, -65428, -3735552, -4591, -1116314, -16716152}, {-1109761, -1052689, -65, -65434, -3997696, -4336, -1050778, -16715897}, {-1044481, -986896, -61, -65440, -4259840, -4081, -984986, -16715641}, {-979201, -921103, -57, -65446, -4521984, -3826, -919450, -16715386}, {-913921, -855310, -53, -65452, -4784128, -3571, -853658, -16715130}, {-848641, -789517, -49, -65458, -5046272, -3316, -788122, -16714874}, {-783361, -723724, -45, -65464, -5308416, -3061, -722586, -16714619}, {-718081, -657931, -41, -65470, -5570560, -2806, -656794, -16714363}, {-652801, -592138, -37, -65476, -5832704, -2551, -591258, -16714108}, {-587521, -526345, -33, -65482, -6094848, -2296, -525466, -16713852}, {-522241, -460552, -29, -65488, -6356992, -2041, -459930, -16713597}, {-456961, -394759, -25, -65494, -6619136, -1786, -394138, -16713342}, {-391681, -328966, -21, -65500, -6881280, -1531, -328346, -16713086}, {-326401, -263173, -17, -65506, -7143424, -1276, -262810, -16712831}, {-261121, -197380, -13, -65512, -7405568, -1021, -197018, -16712575}, {-195841, -131587, -9, -65518, -7667712, -766, -131482, -16712320}, {-130561, -65794, -5, -65524, -7929856, -511, -65690, -16712064}, {-65281, -1, -1, -65530, -8192000, -256, -154, -16711808}};
    private static ColorScalesHelper instance;
    private final List<PlotContinuousColor> colorScales = new ArrayList<PlotContinuousColor>();
    private final int[] rgbIndex = new int[3];

    public static void main(String[] stringArray) {
        for (int[] nArray : SCALE_VALUES) {
            Color color = new Color(nArray[4]);
            System.out.println(color.getRed() + ", " + color.getGreen() + ", " + color.getBlue());
        }
    }

    public static ColorScalesHelper getInstance() {
        if (instance == null) {
            instance = new ColorScalesHelper();
        }
        return instance;
    }

    private ColorScalesHelper() {
        this.addColorScales(ColorScalesHelper.getInternColorscales());
        this.addColorScales(ColorScalesHelper.getRGBscales());
        this.addColorScales(ColorScalesHelper.parseColorScales(new File(IniManager.getStartDirSlash(), "colorScales.txt")));
        this.addColorScales(ColorScalesHelper.parseColorScales(IniManager.getEvinceSettingsFile("colorScales.txt")));
        this.rgbIndex[0] = this.colorScales.indexOf(this.getColorScale("red"));
        this.rgbIndex[1] = this.colorScales.indexOf(this.getColorScale("green"));
        this.rgbIndex[2] = this.colorScales.indexOf(this.getColorScale("blue"));
    }

    private void addColorScales(List<PlotContinuousColor> list) {
        for (PlotContinuousColor plotContinuousColor : list) {
            if (ColorScalesHelper.hasColorScale(this.colorScales, plotContinuousColor)) continue;
            this.colorScales.add(plotContinuousColor);
        }
    }

    private static boolean hasColorScale(List<PlotContinuousColor> list, PlotContinuousColor plotContinuousColor) {
        for (PlotContinuousColor plotContinuousColor2 : list) {
            if (!plotContinuousColor2.getName().equalsIgnoreCase(plotContinuousColor.getName())) continue;
            return true;
        }
        return false;
    }

    public List<PlotContinuousColor> getColorScales() {
        return this.colorScales;
    }

    public PlotContinuousColor getColorScale(String string) {
        for (PlotContinuousColor plotContinuousColor : this.colorScales) {
            if (!plotContinuousColor.getName().equalsIgnoreCase(string)) continue;
            return plotContinuousColor;
        }
        return this.colorScales.get(0);
    }

    public int getRgbIndex(int n) {
        return this.rgbIndex[n];
    }

    private static List<PlotContinuousColor> parseColorScales(File file) {
        ArrayList<PlotContinuousColor> arrayList = new ArrayList<PlotContinuousColor>();
        if (file.exists()) {
            try (RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");){
                String string;
                int n = 0;
                while ((string = randomAccessFile.readLine()) != null) {
                    int n2 = 0;
                    StringTokenizer stringTokenizer = new StringTokenizer(string);
                    while (stringTokenizer.hasMoreTokens()) {
                        if (n == 0) {
                            arrayList.add(new PlotContinuousColor(stringTokenizer.nextToken()));
                            continue;
                        }
                        PlotContinuousColor plotContinuousColor = (PlotContinuousColor)arrayList.get(n2++);
                        float f = Float.parseFloat(stringTokenizer.nextToken());
                        float f2 = Float.parseFloat(stringTokenizer.nextToken());
                        float f3 = Float.parseFloat(stringTokenizer.nextToken());
                        plotContinuousColor.addColor(new Color(f, f2, f3));
                    }
                    ++n;
                }
                randomAccessFile.close();
            }
            catch (IOException | NumberFormatException exception) {
                ErrorDialog.showErrorDialog(exception);
            }
        }
        return arrayList;
    }

    public static void printColorScales(List<PlotContinuousColor> list) {
        for (PlotContinuousColor plotContinuousColor : list) {
            System.out.print("\"" + plotContinuousColor.getName() + "\",");
        }
        System.out.println("");
        for (int i = 0; i < 256; ++i) {
            System.out.print("new [] {");
            for (int j = 0; j < list.size(); ++j) {
                int n;
                PlotContinuousColor plotContinuousColor = list.get(j);
                if (j > 0) {
                    System.out.print(",");
                }
                if ((n = plotContinuousColor.getNrColors()) < 256) {
                    double d = (double)n / 256.0;
                    System.out.print(plotContinuousColor.getColor((int)((double)i * d)).getRGB());
                    continue;
                }
                System.out.print(plotContinuousColor.getColor(i).getRGB());
            }
            System.out.println("},");
        }
    }

    private static List<PlotContinuousColor> getInternColorscales() {
        ArrayList<PlotContinuousColor> arrayList = new ArrayList<PlotContinuousColor>();
        for (int i = 0; i < SCALE_NAMES.length; ++i) {
            PlotContinuousColor plotContinuousColor = new PlotContinuousColor(SCALE_NAMES[i]);
            for (int[] nArray : SCALE_VALUES) {
                plotContinuousColor.addColor(new Color(nArray[i]));
            }
            plotContinuousColor.setSelectionColor(SCALE_SELECTIONCOLOR[i]);
            arrayList.add(plotContinuousColor);
        }
        return arrayList;
    }

    private static List<PlotContinuousColor> getRGBscales() {
        ArrayList<PlotContinuousColor> arrayList = new ArrayList<PlotContinuousColor>();
        Color[] colorArray = new Color[]{Color.YELLOW, Color.RED, Color.YELLOW};
        for (int i = 0; i < 3; ++i) {
            PlotContinuousColor plotContinuousColor = new PlotContinuousColor(Plot_GUI.RGB_NAMES[i]);
            for (int j = 0; j < 256; ++j) {
                plotContinuousColor.addColor(new Color(i == 0 ? j : 0, i == 1 ? j : 0, i == 2 ? j : 0));
            }
            plotContinuousColor.setSelectionColor(colorArray[i]);
            arrayList.add(plotContinuousColor);
        }
        PlotContinuousColor plotContinuousColor = new PlotContinuousColor("Traffic light");
        plotContinuousColor.addColor(Color.green);
        plotContinuousColor.addColor(Color.yellow);
        plotContinuousColor.addColor(Color.red);
        plotContinuousColor.setSelectionColor(Color.green);
        arrayList.add(plotContinuousColor);
        return arrayList;
    }
}

