/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.main;

import java.awt.Component;
import java.awt.Rectangle;
import java.awt.datatransfer.Transferable;
import javax.help.CSH;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import se.prediktera.map.components.tree.AbstractComponentNode;
import se.prediktera.map.components.tree.AbstractComponentTree;
import se.prediktera.map.data.AbstractTable;
import se.prediktera.map.datasetcontainer.AbstractDataNode;
import se.prediktera.map.datasetcontainer.Case;
import se.prediktera.map.datasetcontainer.DataContainer;
import se.prediktera.map.datasetcontainer.DataTreeClass;
import se.prediktera.map.datasetcontainer.DataTreeInterface;
import se.prediktera.map.datasetcontainer.DataTreeShortcut;
import se.prediktera.map.datasetcontainer.ShortcutInterface;
import se.prediktera.map.datasetcontainer.TransferNode;
import se.prediktera.map.datasetcontainer.database.DataBaseControl;
import se.prediktera.map.datasetcontainer.database.DataBaseManager;
import se.prediktera.map.datasetcontainer.database.DataBaseNode;
import se.prediktera.map.datasetcontainer.dataset.DataSet;
import se.prediktera.map.datasetcontainer.event.DataTreeEvent;
import se.prediktera.map.datasetcontainer.event.DataTreeListener;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.main.BrowserElement;
import se.prediktera.map.model.AbstractModel;
import se.prediktera.map.model.AbstractModelContainerWindow;
import se.prediktera.map.model.AbstractPrediction;
import se.prediktera.map.plot.axisplot.AbstractAxisPlot;

public class DataBrowser
extends AbstractComponentTree {
    private BrowserElement troot;
    private DefaultTreeModel model;
    private DataTreeInterface root;
    private DataTreeInterface currentNode;
    private DataTreeInterface interactionObject = null;
    private byte filter = (byte)-1;
    private int tagfilter = 16;
    private PropertyListener propertyListener = new PropertyListener();
    private Class classfilter;
    private boolean isCreated = false;
    private boolean filterCase = false;
    private boolean autoScrollToSelection = false;

    public DataBrowser(DataTreeInterface dataTreeInterface, boolean bl) {
        this(dataTreeInterface, null, bl);
    }

    public DataBrowser(DataTreeInterface dataTreeInterface, DataTreeInterface dataTreeInterface2, boolean bl) {
        super(null, bl);
        this.root = dataTreeInterface;
        this.currentNode = dataTreeInterface2;
        if (dataTreeInterface != null) {
            this.troot = new BrowserElement(dataTreeInterface, this.propertyListener);
            this.model = new DefaultTreeModel(this.troot);
            this.setModel(this.model);
            this.setRootVisible(false);
            this.getSelectionModel().setSelectionMode(1);
            this.setShowsRootHandles(true);
            ToolTipManager.sharedInstance().registerComponent(this);
        }
        CSH.setHelpIDString((Component)this, (String)"evinceDatatree");
    }

    public void changeTree(boolean bl, boolean bl2) {
        if (this.troot != null) {
            this.troot.change(this, null, bl, bl2);
        }
    }

    public void collapseTree() {
        for (int i = this.getRowCount() - 1; i >= 0; --i) {
            this.collapseRow(i);
        }
    }

    public DataTreeInterface getCurrentNode() {
        return this.currentNode;
    }

    public DefaultMutableTreeNode getDefaultMutableTreeNode(DefaultMutableTreeNode defaultMutableTreeNode, DataTreeInterface dataTreeInterface) {
        if (defaultMutableTreeNode == null || dataTreeInterface == null) {
            return null;
        }
        Object object = defaultMutableTreeNode.getUserObject();
        if (object != null && object.equals(dataTreeInterface)) {
            return defaultMutableTreeNode;
        }
        int n = defaultMutableTreeNode.getChildCount();
        for (int i = 0; i < n; ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode2;
            DefaultMutableTreeNode defaultMutableTreeNode3;
            if (i >= defaultMutableTreeNode.getChildCount() || (defaultMutableTreeNode3 = this.getDefaultMutableTreeNode(defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i), dataTreeInterface)) == null) continue;
            return defaultMutableTreeNode3;
        }
        return null;
    }

    public byte getFilter() {
        return this.filter;
    }

    public TreeNode[] getTreePath(BrowserElement browserElement) {
        return this.model.getPathToRoot(browserElement);
    }

    public byte isMarked(BrowserElement browserElement) {
        if (this.interactionObject != null && this.isElementMarked(browserElement)) {
            return 2;
        }
        for (int i = 0; i < browserElement.getChildCount(); ++i) {
            BrowserElement browserElement2 = (BrowserElement)browserElement.getChildAt(i);
            byte by = this.isMarked(browserElement2);
            if (by <= 0) continue;
            return 1;
        }
        return 0;
    }

    public boolean isSelectable(DataTreeInterface dataTreeInterface) {
        return this.supportData(dataTreeInterface);
    }

    public void ReloadDataTree() {
        this.ReloadDataTree(this.currentNode);
    }

    public void ReloadDataTree(DataTreeInterface dataTreeInterface) {
        if (this.isCreated) {
            this.troot.Purge(this);
            int n = this.root.getTreeNodeCount();
            for (int i = 0; i < n; ++i) {
                DataTreeInterface cleanUpInterface = this.root.getTreeNodeAt(i);
                if (cleanUpInterface == null || !cleanUpInterface.isVisibleInTree() || !this.supportInterface(cleanUpInterface)) continue;
                this.setStartNodes(cleanUpInterface);
            }
            for (DataBaseManager dataBaseManager : DataBaseControl.getDataBaseVector()) {
                DataBaseNode dataBaseNode = dataBaseManager.getRootNode();
                if (!this.supportInterface(dataBaseNode) || !dataBaseNode.isVisibleInTree()) continue;
                this.setStartNodes(dataBaseNode);
            }
            this.model.reload(this.troot);
            this.UpdateDataTree(dataTreeInterface);
        }
    }

    @Override
    public void scrollPathToVisible(TreePath treePath) {
        if (treePath != null) {
            this.makeVisible(treePath);
            Rectangle rectangle = this.getPathBounds(treePath);
            if (rectangle != null) {
                rectangle.x = 0;
                this.scrollRectToVisible(rectangle);
                if (this.accessibleContext != null) {
                    ((JTree.AccessibleJTree)this.accessibleContext).fireVisibleDataPropertyChange();
                }
            }
        }
    }

    public void scrollSelectedToCurrentWindow(BrowserElement browserElement) {
        if (this.isElementMarked(browserElement)) {
            TreePath treePath = new TreePath(browserElement.getPath());
            this.scrollPathToVisible(treePath);
        }
        for (int i = 0; i < browserElement.getChildCount(); ++i) {
            BrowserElement browserElement2 = (BrowserElement)browserElement.getChildAt(i);
            this.scrollSelectedToCurrentWindow(browserElement2);
        }
    }

    public void scrollSelectedToVisible() {
        if (this.selectedNode != null) {
            TreePath treePath = new TreePath(this.selectedNode.getPath());
            this.setSelectionPath(treePath);
            this.scrollPathToVisible(treePath);
        }
    }

    public synchronized void SelectDataTree(DataTreeInterface dataTreeInterface) {
        this.UpdateDataTree(dataTreeInterface);
        if (this.selectedNode != null) {
            this.scrollPathToVisible(new TreePath(this.selectedNode.getPath()));
        }
    }

    public void setAutoScrollToSelection(boolean bl) {
        this.autoScrollToSelection = bl;
        if (bl) {
            this.scrollSelectedToCurrentWindow(this.troot);
        }
    }

    public void setClassFilter(Class clazz) {
        this.classfilter = clazz;
        this.ReloadDataTree();
    }

    public void setCreated() {
        if (!this.isCreated) {
            this.isCreated = true;
            this.ReloadDataTree();
        }
    }

    public void setCurrentNode(DataTreeInterface dataTreeInterface) {
        this.currentNode = dataTreeInterface;
    }

    public void setFilter(byte by) {
        this.filter = by;
        this.ReloadDataTree();
    }

    public void setFilterCase(boolean bl) {
        this.filterCase = bl;
        this.ReloadDataTree();
    }

    public void setInteractionObject(DataTreeInterface dataTreeInterface) {
        this.interactionObject = dataTreeInterface;
        if (this.interactionObject != null && this.autoScrollToSelection) {
            this.scrollSelectedToCurrentWindow(this.troot);
        }
        this.repaint();
    }

    public boolean setStartNodes(DataTreeInterface dataTreeInterface) {
        if ((-1 == this.filter || dataTreeInterface instanceof AbstractDataNode && ((AbstractDataNode)dataTreeInterface).getType() == this.filter) && dataTreeInterface.isVisibleInTree() && this.supportInterface(dataTreeInterface)) {
            this.troot.add(new BrowserElement(dataTreeInterface, this.propertyListener));
            return true;
        }
        for (int i = 0; i < dataTreeInterface.getTreeNodeCount(); ++i) {
            DataTreeInterface dataTreeInterface2 = dataTreeInterface.getTreeNodeAt(i);
            if (!dataTreeInterface2.isVisibleInTree() || dataTreeInterface2 instanceof ShortcutInterface && ((ShortcutInterface)((Object)dataTreeInterface2)).isShortcut()) continue;
            this.setStartNodes(dataTreeInterface2);
        }
        return false;
    }

    public void setTagFilter(int n) {
        this.tagfilter = n;
        this.ReloadDataTree();
    }

    public boolean supportData(DataTreeInterface dataTreeInterface) {
        return true;
    }

    public boolean supportFilter(DataTreeInterface dataTreeInterface) {
        DataTreeClass dataTreeClass;
        if (dataTreeInterface == null || dataTreeInterface.isCleaned()) {
            return false;
        }
        if (this.classfilter != null && this.classfilter.isInstance(dataTreeInterface)) {
            return true;
        }
        if ((this.tagfilter & 0x10) == 0 && dataTreeInterface instanceof AbstractDataMatrix && (((AbstractDataMatrix)(dataTreeClass = (AbstractDataMatrix)dataTreeInterface)).getMatrixTag() & this.tagfilter) == 0) {
            return false;
        }
        if (dataTreeInterface instanceof AbstractDataNode) {
            dataTreeClass = (AbstractDataNode)dataTreeInterface;
            byte by = ((AbstractDataNode)dataTreeClass).getType();
            if (this.filterCase && (by == 5 || by == 4)) {
                return false;
            }
        }
        return true;
    }

    public boolean supportInterface(DataTreeInterface dataTreeInterface) {
        if (this.supportFilter(dataTreeInterface)) {
            if (dataTreeInterface.isLeaf()) {
                return this.supportData(dataTreeInterface);
            }
            return true;
        }
        return false;
    }

    public synchronized void UpdateDataTree(DataTreeInterface dataTreeInterface) {
        if (this.root == null) {
            return;
        }
        if (dataTreeInterface != null) {
            this.currentNode = dataTreeInterface;
        }
        if (this.isCreated) {
            BrowserElement browserElement = this.troot.update(this, this.currentNode, false, true);
            if (browserElement == null) {
                this.selectedNode = null;
                this.currentNode = null;
            } else if (browserElement != this.selectedNode) {
                this.selectedNode = browserElement;
                this.scrollSelectedToVisible();
            }
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        super.valueChanged(treeSelectionEvent);
        this.currentNode = this.selectedNode == null ? null : ((BrowserElement)this.selectedNode).getDataTreeInterface();
    }

    public boolean visibleContainer(DataTreeInterface dataTreeInterface) {
        if (dataTreeInterface instanceof AbstractDataNode) {
            return ((AbstractDataNode)dataTreeInterface).getType() != 0;
        }
        return true;
    }

    @Override
    protected void cleanUpChild() {
        super.cleanUpChild();
        if (this.troot != null) {
            this.troot.Purge(this);
            this.troot = null;
        }
        this.model = null;
        this.root = null;
        this.currentNode = null;
        this.propertyListener = null;
    }

    @Override
    protected Transferable createTransferable(AbstractComponentNode abstractComponentNode) {
        Object object = abstractComponentNode.getUserObject();
        if (object instanceof DataTreeInterface) {
            DataTreeInterface dataTreeInterface = (DataTreeInterface)object;
            if (dataTreeInterface instanceof DataTreeShortcut) {
                dataTreeInterface = ((DataTreeShortcut)dataTreeInterface).getShortcut();
            }
            if (dataTreeInterface.getID() == null) {
                return null;
            }
            return new TransferNode(dataTreeInterface.getID());
        }
        return null;
    }

    private boolean isElementMarked(BrowserElement browserElement) {
        if (this.interactionObject != null) {
            DataTreeInterface dataTreeInterface = browserElement.getDataTreeInterface();
            if (dataTreeInterface instanceof DataTreeShortcut) {
                dataTreeInterface = ((DataTreeShortcut)dataTreeInterface).getShortcut();
            }
            DataTreeInterface dataTreeInterface2 = this.interactionObject;
            if (this.interactionObject instanceof DataTreeShortcut) {
                dataTreeInterface2 = ((DataTreeShortcut)this.interactionObject).getShortcut();
            }
            if (dataTreeInterface2 instanceof AbstractAxisPlot && ((AbstractAxisPlot)dataTreeInterface2).hasObject(dataTreeInterface) || dataTreeInterface2 instanceof AbstractTable && ((AbstractTable)dataTreeInterface2).getDataTreeInterface() == dataTreeInterface) {
                return true;
            }
            if (dataTreeInterface2 instanceof AbstractModelContainerWindow && ((AbstractModelContainerWindow)dataTreeInterface2).isSelected(dataTreeInterface)) {
                return true;
            }
            if (dataTreeInterface2 instanceof Case && ((Case)dataTreeInterface2).isExternal()) {
                AbstractModel abstractModel;
                DataContainer dataContainer;
                if (dataTreeInterface instanceof AbstractPrediction) {
                    return dataTreeInterface2.equals(((AbstractPrediction)dataTreeInterface).getCase());
                }
                if (dataTreeInterface instanceof AbstractModel && (dataContainer = (abstractModel = (AbstractModel)dataTreeInterface).getExternalPredictions()) != null) {
                    for (int i = 0; i < dataContainer.getTreeNodeCount(); ++i) {
                        if (!(dataContainer.getTreeNodeAt(i) instanceof AbstractPrediction) || !dataTreeInterface2.equals(((AbstractPrediction)dataContainer.getTreeNodeAt(i)).getCase())) continue;
                        return true;
                    }
                }
            } else if (dataTreeInterface2 instanceof AbstractPrediction && (dataTreeInterface instanceof Case || dataTreeInterface instanceof DataSet || dataTreeInterface instanceof AbstractModel)) {
                return dataTreeInterface.equals(((AbstractPrediction)dataTreeInterface2).getCase()) || dataTreeInterface.equals(((AbstractPrediction)dataTreeInterface2).getDataSet()) || dataTreeInterface.equals(((AbstractPrediction)dataTreeInterface2).getModel());
            }
        }
        return false;
    }

    private class PropertyListener
    implements DataTreeListener {
        private PropertyListener() {
        }

        @Override
        public void eventFinished(DataTreeEvent dataTreeEvent) {
        }

        @Override
        public void nodeReplaced(DataTreeEvent dataTreeEvent) {
            DefaultMutableTreeNode defaultMutableTreeNode = this.getNode(dataTreeEvent);
            if (defaultMutableTreeNode != null) {
                defaultMutableTreeNode.setUserObject(dataTreeEvent.getReplaceDataTreeInterface());
            }
        }

        @Override
        public void propertyChanged(DataTreeEvent dataTreeEvent) {
            DefaultMutableTreeNode defaultMutableTreeNode = this.getNode(dataTreeEvent);
            if (defaultMutableTreeNode != null) {
                DataBrowser.this.model.nodeChanged(defaultMutableTreeNode);
            }
        }

        private DefaultMutableTreeNode getNode(DataTreeEvent dataTreeEvent) {
            DataTreeInterface dataTreeInterface = dataTreeEvent.getDataTreeInterface();
            if (dataTreeInterface != null) {
                if (dataTreeInterface.equals(DataBrowser.this.currentNode)) {
                    DataBrowser.this.currentNode = dataTreeEvent.getReplaceDataTreeInterface();
                }
                return DataBrowser.this.getDefaultMutableTreeNode(DataBrowser.this.troot, dataTreeInterface);
            }
            return null;
        }
    }
}

