/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.main;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import javax.help.CSH;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.common.cleanup.CleanUpPanel;
import se.prediktera.map.common.cleanup.CleanUpPopupMenu;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.common.swing.ComponentBorderedPanel;
import se.prediktera.map.common.swing.PinCheckBox;
import se.prediktera.map.common.swing.flat.JFlatButton;
import se.prediktera.map.common.swing.flat.JFlatToggleButton;
import se.prediktera.map.components.tree.AbstractComponentNode;
import se.prediktera.map.data.datasettable.DataSetTable;
import se.prediktera.map.dataimport.AbstractDataSource;
import se.prediktera.map.datasetcontainer.DataTreeInterface;
import se.prediktera.map.datasetcontainer.DataTreeManager;
import se.prediktera.map.datasetcontainer.DataTreeShortcut;
import se.prediktera.map.datasetcontainer.OriginalData;
import se.prediktera.map.datasetcontainer.database.EditableTreeInterface;
import se.prediktera.map.datasetcontainer.dataset.DataSet;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.main.BrowserElement;
import se.prediktera.map.main.DataBrowser;
import se.prediktera.map.main.Data_GUI;
import se.prediktera.map.main.Main_GUI;
import se.prediktera.map.main.Model_GUI;
import se.prediktera.map.main.Plot_GUI;
import se.prediktera.map.main.Project_GUI;
import se.prediktera.map.main.window.AbstractWindow;
import se.prediktera.map.model.AbstractModel;
import se.prediktera.map.model.AbstractModelContainerWindow;
import se.prediktera.map.model.AbstractPrediction;
import se.prediktera.map.statistic.AbstractStatistic;

public class DataMonitor
extends CleanUpPanel {
    public static final String[] filterNames = new String[]{"All", "DataSet", "Models"};
    private Project_GUI project;
    private final JComboBox comboBoxFilter = new JComboBox();
    private final JFlatToggleButton syncronizeButton = new JFlatToggleButton(20, 20, false);
    private final JFlatButton collapseButton = new JFlatButton(20, 20, false);
    private DataBrowser dataBrowser;
    private final JLabel nodeTitle = new JLabel();
    private final JLabel nodeInfo = new JLabel();
    private boolean created = false;
    private DataTreeInterface interactionObject = null;
    private final PinCheckBox quickInfoLocked = new PinCheckBox("Quick Information");
    private DataTreeInterface currentInfo = null;
    private final JPanel topPanel = new JPanel(new GridBagLayout());
    private JPanel bottomPanel = null;

    public static void showPopup(Component component, Project_GUI project_GUI, DataTreeInterface dataTreeInterface, Point point) {
        CleanUpPopupMenu cleanUpPopupMenu = DataMonitor.createPopupMenu(project_GUI, dataTreeInterface, point);
        if (cleanUpPopupMenu.getComponentCount() > 0) {
            cleanUpPopupMenu.show(component, point.x, point.y);
        }
    }

    private static CleanUpPopupMenu createPopupMenu(Project_GUI project_GUI, DataTreeInterface dataTreeInterface, Point point) {
        CleanUpPopupMenu cleanUpPopupMenu = new CleanUpPopupMenu("popupmenu");
        if (dataTreeInterface instanceof DataTreeShortcut) {
            dataTreeInterface = ((DataTreeShortcut)dataTreeInterface).getShortcut();
        }
        if (dataTreeInterface instanceof OriginalData) {
            ((OriginalData)dataTreeInterface).addToPopupMenu(project_GUI, cleanUpPopupMenu);
        } else if (dataTreeInterface instanceof AbstractDataMatrix) {
            ((AbstractDataMatrix)dataTreeInterface).addToPopupMenu(project_GUI, cleanUpPopupMenu);
        } else if (dataTreeInterface instanceof EditableTreeInterface) {
            ((EditableTreeInterface)((Object)dataTreeInterface)).addToPopupMenu(project_GUI, cleanUpPopupMenu);
        } else if (dataTreeInterface instanceof DataSet) {
            ((DataSet)dataTreeInterface).addToPopupMenu(project_GUI, cleanUpPopupMenu);
        } else if (dataTreeInterface instanceof AbstractModel) {
            ((AbstractModel)dataTreeInterface).addToPopupMenu(project_GUI, cleanUpPopupMenu);
        } else if (dataTreeInterface instanceof AbstractPrediction) {
            ((AbstractPrediction)dataTreeInterface).addToPopupMenu(project_GUI, cleanUpPopupMenu);
        } else if (dataTreeInterface instanceof AbstractStatistic) {
            ((AbstractStatistic)dataTreeInterface).addToPopupMenu(project_GUI, cleanUpPopupMenu);
        } else if (dataTreeInterface instanceof AbstractDataSource) {
            ((AbstractDataSource)dataTreeInterface).addToPopupMenu(project_GUI, cleanUpPopupMenu);
        }
        dataTreeInterface.addToPopup(project_GUI, dataTreeInterface, point, cleanUpPopupMenu, false);
        return cleanUpPopupMenu;
    }

    public DataMonitor(Project_GUI project_GUI, RandomInputStream randomInputStream) {
        super("DataMonitor", new BorderLayout());
        CSH.setHelpIDString((Component)this, (String)"evinceQuickinfo");
        this.project = project_GUI;
        DataTreeInterface dataTreeInterface = null;
        if (randomInputStream != null) {
            try {
                MapProperty mapProperty = randomInputStream.readProperties("DataMonitor");
                if (mapProperty != null) {
                    dataTreeInterface = mapProperty.resolveNodeFromName(randomInputStream, "cNode");
                    this.currentInfo = mapProperty.resolveNodeFromName(randomInputStream, "cInfo");
                    if (this.currentInfo == null) {
                        this.currentInfo = dataTreeInterface;
                    }
                    if (mapProperty.hasProperty("qiLocked")) {
                        this.quickInfoLocked.setSelected(mapProperty.getLVBoolean());
                    }
                }
            }
            catch (IOException iOException) {
                ErrorHandler.logAndShowEvinceErrorDialogForException(iOException);
            }
        }
        this.dataBrowser = new DataBrowser(project_GUI.getRootNode(), dataTreeInterface, true);
        this.dataBrowser.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                int n = DataMonitor.this.dataBrowser.getRowForLocation(mouseEvent.getX(), mouseEvent.getY());
                if (n == -1 || mouseEvent.getClickCount() == 2) {
                    // empty if block
                }
            }
        });
        this.dataBrowser.setShowsRootHandles(true);
        this.dataBrowser.putClientProperty("JTree.lineStyle", "Angled");
        this.quickInfoLocked.setToolTipText("Lock on current node");
        this.addKeyActionFromPopupMenu(project_GUI, KeyStroke.getKeyStroke(127, 0), "Delete");
        this.addKeyActionFromPopupMenu(project_GUI, KeyStroke.getKeyStroke(113, 0), "Rename");
        this.jbInit();
    }

    public void addBottomPanel(JPanel jPanel) {
        if (this.bottomPanel == null) {
            this.bottomPanel = new JPanel();
            this.add((Component)this.bottomPanel, "South");
        }
        this.bottomPanel.add(jPanel);
    }

    public void apply(String string, DataTreeInterface dataTreeInterface) throws Exception {
        BrowserElement browserElement = null;
        if (dataTreeInterface != null) {
            this.SelectDataTree(dataTreeInterface);
            AbstractComponentNode abstractComponentNode = this.dataBrowser.getSelectedNode();
            if (abstractComponentNode instanceof BrowserElement) {
                browserElement = (BrowserElement)abstractComponentNode;
            }
        }
        if (!string.equalsIgnoreCase("select") && (string.equalsIgnoreCase("expand") || string.equalsIgnoreCase("collapse"))) {
            boolean bl = string.equalsIgnoreCase("expand");
            if (browserElement != null) {
                browserElement.change(this.dataBrowser, null, bl, false);
            } else {
                this.dataBrowser.changeTree(bl, false);
            }
        }
    }

    public DataTreeInterface getSelectedTreeNode() {
        return this.dataBrowser.getCurrentNode();
    }

    public void PurgeSignal() {
        this.UpdateDataTree(null);
    }

    public void registerKeyAction(KeyStroke keyStroke, Action action) {
        InputMap inputMap = this.getInputMap(2);
        String string = "Input_" + inputMap.size();
        inputMap.put(keyStroke, string);
        ActionMap actionMap = this.getActionMap();
        actionMap.put(string, action);
    }

    public void ReloadDataTree(DataTreeInterface dataTreeInterface) {
        if (this.created) {
            this.dataBrowser.ReloadDataTree(dataTreeInterface);
        }
    }

    public void Save(RandomOutputStream randomOutputStream) throws IOException {
        randomOutputStream.beginProperty("DataMonitor");
        randomOutputStream.writePropertyNode("cNode", this.dataBrowser.getCurrentNode());
        randomOutputStream.writePropertyNode("cInfo", this.currentInfo);
        randomOutputStream.writePropertyBoolean("qiLocked", this.quickInfoLocked.isSelected());
        randomOutputStream.endProperty();
    }

    public void SelectDataTree(DataTreeInterface dataTreeInterface) {
        if (this.created) {
            this.dataBrowser.SelectDataTree(dataTreeInterface);
        }
    }

    public void setCreated() {
        this.created = true;
        this.dataBrowser.setCreated();
    }

    public void setFilter(int n) {
        this.comboBoxFilter.setSelectedIndex(n);
    }

    public void setInteractionObject(DataTreeInterface dataTreeInterface) {
        this.interactionObject = dataTreeInterface;
        if (this.dataBrowser != null) {
            this.dataBrowser.setInteractionObject(dataTreeInterface);
        }
    }

    public void UpdateDataTree(DataTreeInterface dataTreeInterface) {
        if (this.created) {
            this.dataBrowser.UpdateDataTree(dataTreeInterface);
            this.setNodeInfo(this.dataBrowser.getCurrentNode());
        }
    }

    @Override
    protected void cleanUpChild() {
        this.project = null;
        this.created = false;
        if (this.dataBrowser != null) {
            this.dataBrowser.cleanUp();
            this.dataBrowser = null;
        }
        this.interactionObject = null;
    }

    private void addKeyActionFromPopupMenu(final Project_GUI project_GUI, KeyStroke keyStroke, final String string) {
        AbstractAction abstractAction = new AbstractAction(this){
            final /* synthetic */ DataMonitor this$0;
            {
                this.this$0 = dataMonitor;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BrowserElement browserElement;
                DataTreeInterface dataTreeInterface;
                CleanUpPopupMenu cleanUpPopupMenu;
                AbstractComponentNode abstractComponentNode = this.this$0.dataBrowser.getSelectedNode();
                if (abstractComponentNode instanceof BrowserElement && (cleanUpPopupMenu = DataMonitor.createPopupMenu(project_GUI, dataTreeInterface = (browserElement = (BrowserElement)abstractComponentNode).getDataTreeInterface(), null)) != null) {
                    for (int i = 0; i < cleanUpPopupMenu.getComponentCount(); ++i) {
                        JMenuItem jMenuItem;
                        Component component = cleanUpPopupMenu.getComponent(i);
                        if (!(component instanceof JMenuItem) || !(jMenuItem = (JMenuItem)component).isEnabled() || !jMenuItem.getText().equals(string)) continue;
                        jMenuItem.doClick();
                        break;
                    }
                    cleanUpPopupMenu.cleanUp();
                }
            }
        };
        this.registerKeyAction(keyStroke, abstractAction);
    }

    private void jbInit() {
        this.comboBoxFilter.setPreferredSize(new Dimension(120, 20));
        this.comboBoxFilter.addItemListener(new ComboBoxListener());
        this.syncronizeButton.setIcon(new ImageIcon(Main_GUI.class.getResource("gif/syncronize.png")));
        this.syncronizeButton.setToolTipText("Automatically expand selection");
        this.syncronizeButton.addActionListener(actionEvent -> this.dataBrowser.setAutoScrollToSelection(this.syncronizeButton.isSelected()));
        this.collapseButton.setIcon(new ImageIcon(Main_GUI.class.getResource("gif/collapse.gif")));
        this.collapseButton.setToolTipText("Collapse tree");
        this.collapseButton.addActionListener(actionEvent -> this.dataBrowser.collapseTree());
        this.dataBrowser.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                DataMonitor.this.nodeSelected();
            }
        });
        this.dataBrowser.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                this.showPopupMenu(mouseEvent);
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                DataMonitor.this.nodeSelected();
                this.showPopupMenu(mouseEvent);
            }

            private void showPopupMenu(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    Point point = mouseEvent.getPoint();
                    TreePath treePath = DataMonitor.this.dataBrowser.getClosestPathForLocation(point.x, point.y);
                    DataMonitor.this.dataBrowser.setSelectionPath(treePath);
                    DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
                    if (defaultMutableTreeNode != null) {
                        DataMonitor.showPopup(DataMonitor.this.dataBrowser, DataMonitor.this.project, (DataTreeInterface)defaultMutableTreeNode.getUserObject(), point);
                    }
                }
            }
        });
        this.dataBrowser.setFont(new Font("Dialog", 0, 10));
        JPanel jPanel = new JPanel(new BorderLayout());
        this.nodeTitle.setFont(new Font("Dialog", 1, 11));
        this.nodeInfo.setFont(new Font("Dialog", 0, 10));
        JScrollPane jScrollPane = new JScrollPane();
        jPanel.add((Component)this.topPanel, "North");
        jPanel.add((Component)jScrollPane, "Center");
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setBackground(Color.WHITE);
        jPanel2.setBorder(BorderFactory.createEmptyBorder(2, 0, 0, 0));
        jPanel2.add((Component)this.dataBrowser, "Center");
        jScrollPane.setViewportView(jPanel2);
        this.topPanel.add((Component)new JLabel("Show:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 2, 0, 0), 0, 0));
        this.topPanel.add((Component)this.comboBoxFilter, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 2, 0, 0), 0, 0));
        this.topPanel.add((Component)this.collapseButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 2, 0, 0), 0, 0));
        this.topPanel.add((Component)this.syncronizeButton, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 2, 0, 2), 0, 0));
        ComponentBorderedPanel componentBorderedPanel = new ComponentBorderedPanel((LayoutManager)new GridBagLayout(), this.quickInfoLocked);
        componentBorderedPanel.setBackground(Color.white);
        this.nodeTitle.setOpaque(true);
        this.nodeTitle.setBackground(Color.white);
        this.nodeInfo.setOpaque(true);
        this.nodeInfo.setBackground(Color.white);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(6, 6, 0, 6);
        gridBagConstraints.anchor = 18;
        componentBorderedPanel.add((JComponent)this.nodeTitle, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        componentBorderedPanel.add((JComponent)this.nodeInfo, (Object)gridBagConstraints);
        JScrollPane jScrollPane2 = new JScrollPane();
        jScrollPane2.setBackground(Color.white);
        jScrollPane2.setPreferredSize(new Dimension(0, 150));
        jScrollPane2.setViewportView(componentBorderedPanel);
        for (String string : filterNames) {
            this.comboBoxFilter.addItem(string);
        }
        JSplitPane jSplitPane = new JSplitPane(0);
        jSplitPane.setDividerSize(2);
        jSplitPane.add(jPanel);
        jSplitPane.add(jScrollPane2);
        jSplitPane.setResizeWeight(0.75);
        this.add((Component)jSplitPane, "Center");
    }

    private void nodeSelected() {
        AbstractComponentNode abstractComponentNode = this.dataBrowser.getSelectedNode();
        if (abstractComponentNode instanceof BrowserElement) {
            this.setInteractionObject(((BrowserElement)abstractComponentNode).getDataTreeInterface());
        } else {
            this.setInteractionObject(null);
        }
        this.nodeSelected(abstractComponentNode);
    }

    private void nodeSelected(DefaultMutableTreeNode defaultMutableTreeNode) {
        Plot_GUI plot_GUI;
        if (defaultMutableTreeNode == null) {
            return;
        }
        Object object = defaultMutableTreeNode.getUserObject();
        if (object instanceof DataTreeInterface) {
            this.setNodeInfo((DataTreeInterface)object);
        } else {
            this.setNodeInfo(null);
        }
        Model_GUI model_GUI = this.project == null ? null : this.project.getModel_GUI();
        Data_GUI data_GUI = this.project == null ? null : this.project.getData_GUI();
        Plot_GUI plot_GUI2 = plot_GUI = this.project == null ? null : this.project.getPlot_GUI();
        if (model_GUI == null || data_GUI == null) {
            return;
        }
        model_GUI.selectModel(null);
        if (object instanceof DataTreeInterface) {
            DataTreeInterface dataTreeInterface = (DataTreeInterface)object;
            data_GUI.showOnlyRelatedTo(dataTreeInterface);
            plot_GUI.showOnlyRelatedTo(dataTreeInterface);
            AbstractWindow abstractWindow = data_GUI.getCurrentWindow();
            if (abstractWindow instanceof DataSetTable && abstractWindow.getAbstractInit() != null) {
                DataTreeInterface dataTreeInterface2 = abstractWindow.getAbstractInit().getDataTreeInterface();
                DataSet dataSet = (DataSet)DataTreeManager.getAncestorNull(dataTreeInterface2, DataSet.class);
                DataSet dataSet2 = (DataSet)DataTreeManager.getAncestorNull(dataTreeInterface, DataSet.class);
                if (dataSet != null && dataSet2 != null && !dataSet.equals(dataSet2) && data_GUI.selectWindow(dataSet2)) {
                    this.dataBrowser.setCurrentNode(dataSet2);
                    this.setNodeInfo(dataTreeInterface);
                }
            }
            if (dataTreeInterface instanceof AbstractModel) {
                model_GUI.selectModel((AbstractModel)dataTreeInterface);
            }
        }
    }

    private void setNodeInfo(DataTreeInterface dataTreeInterface) {
        if (this.interactionObject != null) {
            if (this.interactionObject.isCleaned()) {
                this.setInteractionObject(null);
            } else if (!this.dataBrowser.hasFocus() && !(this.interactionObject instanceof AbstractModelContainerWindow)) {
                dataTreeInterface = this.interactionObject;
            }
        }
        if (this.quickInfoLocked.isSelected()) {
            dataTreeInterface = this.currentInfo;
        } else {
            this.currentInfo = dataTreeInterface;
        }
        if (dataTreeInterface == null) {
            this.nodeTitle.setText("");
            this.nodeTitle.setIcon(null);
            this.nodeInfo.setText("");
        } else if (dataTreeInterface.isCleaned()) {
            this.nodeTitle.setText("PURGED!");
            this.nodeInfo.setText("Should not occur, please contact support@prediktera.se");
        } else {
            if (!this.nodeTitle.getText().equals(dataTreeInterface.toString())) {
                this.nodeTitle.setText(dataTreeInterface.toString());
            }
            this.nodeTitle.setIcon(dataTreeInterface.getIcon((byte)0));
            String string = dataTreeInterface.getInformation();
            String string2 = this.nodeInfo.getText();
            if (string2 != null && !string2.equals(string)) {
                this.nodeInfo.setText(string);
            }
        }
    }

    class ComboBoxListener
    implements ItemListener {
        ComboBoxListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() == 1) {
                switch (DataMonitor.this.comboBoxFilter.getSelectedIndex()) {
                    case 0: {
                        DataMonitor.this.dataBrowser.setFilter((byte)-1);
                        break;
                    }
                    case 1: {
                        DataMonitor.this.dataBrowser.setFilter((byte)9);
                        break;
                    }
                    case 2: {
                        DataMonitor.this.dataBrowser.setFilter((byte)10);
                        break;
                    }
                    case 3: {
                        DataMonitor.this.dataBrowser.setFilter((byte)4);
                        break;
                    }
                    case 4: {
                        DataMonitor.this.dataBrowser.setFilter((byte)5);
                    }
                }
            }
        }
    }
}

