/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.main;

import java.awt.Color;
import java.awt.Component;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.Vector;
import javax.help.CSH;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.border.Border;
import se.prediktera.map.common.CMenu;
import se.prediktera.map.common.CMenuItem;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.cleanup.CleanUpPanel;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.common.swing.flat.JFlatButton;
import se.prediktera.map.common.wizard.AbstractWizardInfo;
import se.prediktera.map.common.wizard.WizardInfoInterface;
import se.prediktera.map.components.paint.AbstractPaint;
import se.prediktera.map.data.AbstractTable;
import se.prediktera.map.data.datasettable.DataSetTable;
import se.prediktera.map.data.quicktable.QuickTableInfo;
import se.prediktera.map.data.sparsetable.SparseTableInfo;
import se.prediktera.map.data.tablegenerator.TableGeneratorWizard;
import se.prediktera.map.datasetcontainer.Case;
import se.prediktera.map.datasetcontainer.DataContainer;
import se.prediktera.map.datasetcontainer.DataTreeInterface;
import se.prediktera.map.datasetcontainer.DataTreeManager;
import se.prediktera.map.datasetcontainer.dataset.DataSet;
import se.prediktera.map.datasetcontainer.matrix.SparseMatrix;
import se.prediktera.map.main.AbstractGUI;
import se.prediktera.map.main.Project_GUI;
import se.prediktera.map.main.window.AbstractWindow;
import se.prediktera.map.main.window.AbstractWindowInfo;
import se.prediktera.map.main.window.AbstractWindowWizard;
import se.prediktera.map.main.window.AbstractWindow_GUI;

public class Data_GUI
extends AbstractWindow_GUI {
    private final Border normalBorder = BorderFactory.createEmptyBorder(1, 1, 1, 1);
    private final Border dragBorder = BorderFactory.createLineBorder(Color.green);

    public Data_GUI(Project_GUI project_GUI, CMenu cMenu) {
        super(project_GUI, "Data_GUI", cMenu);
        this.jbInit();
        this.setAutoMode((byte)2);
    }

    public Data_GUI(RandomInputStream randomInputStream, Project_GUI project_GUI, ProgressManager progressManager, CMenu cMenu) throws IOException {
        super(randomInputStream, project_GUI, progressManager, cMenu, "Data_GUI");
        this.jbInit();
    }

    @Override
    public DataContainer createWindowContainer() {
        return new DataContainer("Tables", 4);
    }

    @Override
    public AbstractWindow createWindowFromWizard(DataTreeInterface dataTreeInterface, WizardInfoInterface wizardInfoInterface) {
        CleanUpPanel cleanUpPanel;
        if (dataTreeInterface instanceof DataSet) {
            cleanUpPanel = this.getTableForDataSet((DataSet)dataTreeInterface);
            if (cleanUpPanel != null) {
                ((AbstractGUI)cleanUpPanel).getAssociatedFrame().selectFrameAndAssociatedButtons();
                return null;
            }
        } else if (dataTreeInterface instanceof Case) {
            dataTreeInterface = ((Case)dataTreeInterface).getOriginalMatrix();
        }
        cleanUpPanel = new TableGeneratorWizard(this, dataTreeInterface);
        AbstractWindow abstractWindow = null;
        if ((wizardInfoInterface != null || ((TableGeneratorWizard)cleanUpPanel).executeWizard() == 1) && (abstractWindow = ((AbstractWindowWizard)cleanUpPanel).createWindow(this, (AbstractWindowInfo)wizardInfoInterface)) != null) {
            this.addWindow(abstractWindow, false);
            this.project_GUI.updateDataTree(null);
        }
        cleanUpPanel.cleanUp();
        return abstractWindow;
    }

    @Override
    public void dataDropped(DataTreeInterface dataTreeInterface, int n) {
        if (dataTreeInterface instanceof AbstractTable) {
            AbstractTable abstractTable = (AbstractTable)dataTreeInterface;
            DataTreeManager.LoadIntoMemory(this.getProject_GUI(), abstractTable, true);
            this.addWindow(abstractTable, true);
        } else {
            QuickTableInfo quickTableInfo = null;
            if (n != 2) {
                quickTableInfo = new QuickTableInfo();
            }
            this.createWindowFromWizard(dataTreeInterface, quickTableInfo);
        }
        this.getDesktop().setBorder(this.normalBorder);
    }

    @Override
    public void DataTreeSelected(DataTreeInterface dataTreeInterface) {
    }

    @Override
    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        this.getDesktop().setBorder(this.dragBorder);
    }

    @Override
    public void dragExit(DropTargetEvent dropTargetEvent) {
        this.getDesktop().setBorder(this.normalBorder);
    }

    @Override
    public String getAreaName() {
        return "Table area";
    }

    @Override
    public String getGUI_Name() {
        return "Data";
    }

    public DataSetTable getTableForDataSet(DataSet dataSet) {
        DataContainer dataContainer = this.getWindowContainer();
        int n = dataContainer.getTreeNodeCount();
        for (int i = 0; i < n; ++i) {
            DataSetTable dataSetTable;
            DataTreeInterface dataTreeInterface = dataContainer.getTreeNodeAt(i);
            if (!(dataTreeInterface instanceof DataSetTable) || (dataSetTable = (DataSetTable)dataTreeInterface).getDataSet() != dataSet) continue;
            return dataSetTable;
        }
        return null;
    }

    public CMenu getTableMenu(DataTreeInterface dataTreeInterface) {
        CMenu cMenu = new CMenu("New Table", false);
        cMenu.setIcon(AbstractTable.tableIcon);
        Vector<AbstractWizardInfo> vector = new Vector<AbstractWizardInfo>();
        TableGeneratorWizard.addExternTables(vector, dataTreeInterface);
        if (vector.isEmpty()) {
            JMenuItem jMenuItem = new JMenuItem("Matrix Contains No Data");
            jMenuItem.setEnabled(false);
            cMenu.add(jMenuItem);
            return cMenu;
        }
        if (vector.size() > 1) {
            CMenuItem cMenuItem = new CMenuItem(dataTreeInterface, "Wizard"){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    CMenuItem cMenuItem = (CMenuItem)actionEvent.getSource();
                    DataTreeInterface dataTreeInterface = (DataTreeInterface)cMenuItem.getObject();
                    Data_GUI.this.createWindowFromWizard(dataTreeInterface, null);
                }
            };
            cMenu.add(cMenuItem);
            cMenu.addSeparator();
        }
        for (int i = 0; i < vector.size(); ++i) {
            CMenuItem cMenuItem = new CMenuItem(vector.elementAt(i), dataTreeInterface){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    CMenuItem cMenuItem = (CMenuItem)actionEvent.getSource();
                    WizardInfoInterface wizardInfoInterface = (WizardInfoInterface)cMenuItem.getObject();
                    DataTreeInterface dataTreeInterface = (DataTreeInterface)cMenuItem.getObject2();
                    Data_GUI.this.createWindowFromWizard(dataTreeInterface, wizardInfoInterface);
                }
            };
            cMenu.add(cMenuItem);
        }
        return cMenu;
    }

    @Override
    public String getTitle(AbstractWindow abstractWindow) {
        if (abstractWindow == null) {
            return "Table - [No Table]";
        }
        return "Table - [" + abstractWindow.getGUI_Name() + "]";
    }

    @Override
    public ImageIcon getWindowIcon() {
        return AbstractTable.tableIcon;
    }

    @Override
    public void guiSelected() {
        AbstractWindow abstractWindow = this.getCurrentWindow();
        if (abstractWindow instanceof AbstractTable) {
            this.project_GUI.setSelectedWindow(abstractWindow);
        } else {
            this.project_GUI.setSelectedWindow(null);
        }
    }

    public void newSparseMatrix(String string) {
        SparseMatrix sparseMatrix = new SparseMatrix(string);
        SparseTableInfo sparseTableInfo = new SparseTableInfo();
        this.addWindow(sparseTableInfo.createWindow((AbstractWindow_GUI)this, sparseTableInfo.getInit(sparseMatrix)), false);
    }

    public boolean selectWindow(DataSet dataSet) {
        DataSetTable dataSetTable = this.getTableForDataSet(dataSet);
        this.selectWindow(dataSetTable);
        return dataSetTable != null;
    }

    @Override
    public boolean supportVersion(long l) {
        return true;
    }

    private void jbInit() {
        this.getDesktop().setBorder(this.normalBorder);
        CSH.setHelpIDString((Component)this, (String)"evinceTable");
        this.project_GUI.setData_GUI(this);
        JFlatButton jFlatButton = new JFlatButton();
        jFlatButton.setToolTipText("Start Table Wizard");
        jFlatButton.setIcon(AbstractPaint.createIcon(9));
        jFlatButton.addActionListener(actionEvent -> this.createWindowFromWizard(null, null));
        this.menu.add(jFlatButton.createMenuItem(null));
        this.northTitle.setText("Table - [No Table]");
        this.windowToolbar.add(jFlatButton);
    }
}

