/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.main;

import java.awt.Color;
import java.awt.Toolkit;
import java.awt.Window;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.apache.commons.lang3.SystemUtils;
import se.prediktera.map.InitClass;
import se.prediktera.map.common.AbstractRandomStream;
import se.prediktera.map.common.MacHelper;
import se.prediktera.map.common.cleanup.CleanUpClass;
import se.prediktera.map.common.connection.Url;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.common.error.Logg;
import se.prediktera.map.common.progress.SwingWorker;
import se.prediktera.map.common.update.UpdateHelper;
import se.prediktera.map.common.update.UpdatePanel;
import se.prediktera.map.datasetcontainer.database.DataBaseControl;
import se.prediktera.map.main.ExceptionGroup;
import se.prediktera.map.main.IniManager;
import se.prediktera.map.main.JavaErrorPanel;
import se.prediktera.map.main.Main_GUI;
import se.prediktera.map.main.StartUpFrame;
import se.prediktera.map.main.extclass.ExtClassLoader;
import se.prediktera.map.main.script.ScriptFile;
import se.prediktera.map.main.script.ScriptManager;
import se.prediktera.map.main.script.gui.ScriptFilePanel;
import se.prediktera.map.plot.axisplot.settings.Color.PerfectSpread;
import se.prediktera.map.register.RegInfo;
import se.prediktera.map.register.RegisterKeyManager;
import se.prediktera.map.register.wizard.RegisterWizard;

public class Evince {
    public static final int mapVersionNr = 8;
    private static UpdateHelper.DownloadFile updateDownloadFile;
    private static JDialog updateDialog;
    private static JFrame frame;
    private static StartUpFrame startUpFrame;
    public static boolean touchscreen;
    private static int dpiThreshold;

    public static void checkForUpdates() {
        UpdateHelper.getDownloadFile(UpdateHelper.Product.Evince, new UpdateHelper.UpdateCheckCallback(){

            @Override
            public void update(UpdateHelper.DownloadFile downloadFile) {
                if (InitClass.getEvinceVersion().newer(downloadFile.getVersion())) {
                    updateDownloadFile = downloadFile;
                    Main_GUI.getStatusBar().setUpdateInfo("Update: Available!");
                    SwingUtilities.invokeLater(Evince::showUpdateInformation);
                } else {
                    Main_GUI.getStatusBar().setUpdateInfo(null);
                }
            }

            @Override
            public void updateFailed(Exception exception) {
                if (exception != null) {
                    Main_GUI.getStatusBar().setUpdateInfo("Update: Failed");
                }
            }
        });
    }

    public static boolean updateDialogVisible() {
        return updateDialog != null;
    }

    public static void showUpdateInformation() {
        final Main_GUI main_GUI = Main_GUI.get();
        if (updateDownloadFile != null) {
            updateDialog = new JDialog(frame, "Update available", true);
            updateDialog.getContentPane().add(new UpdatePanel(updateDownloadFile, new UpdatePanel.UpdateCallback(){

                @Override
                public void downloadComplete(File file) {
                    updateDialog.dispose();
                    switch (updateDownloadFile.getPlatform()) {
                        case Linux: 
                        case LinuxArm: 
                        case Unknown: {
                            JOptionPane.showConfirmDialog(main_GUI, "Please close down Evince and install the downloaded file localed in the Download folder", "Download complete", -1, 3, null);
                            break;
                        }
                        case MacOSX: {
                            JOptionPane.showConfirmDialog(main_GUI, UpdateHelper.getMacOSXText(UpdateHelper.Product.Evince), "Download complete", -1, 3, null);
                            break;
                        }
                        case Windows: {
                            int n = JOptionPane.showConfirmDialog(main_GUI, UpdateHelper.getRestartText(updateDownloadFile.getProduct()), "Download complete", 2, 3, null);
                            if (n != 0 || !main_GUI.getProjectsContainer().close()) break;
                            SwingUtilities.invokeLater(() -> {
                                IniManager.SaveIni();
                                UpdateHelper.runExe(file);
                                System.exit(0);
                            });
                        }
                    }
                }

                @Override
                public void cancel() {
                    updateDialog.dispose();
                    updateDialog = null;
                }
            }, Color.black));
            updateDialog.pack();
            updateDialog.setLocationRelativeTo(null);
            updateDialog.setVisible(true);
        } else {
            JOptionPane.showConfirmDialog(main_GUI, "No update is available", "Evince Update", -1, 1, null);
        }
    }

    public static void checkForWebstart(String string) {
        Thread thread = new Thread(() -> {
            try {
                Url url = new Url(IniManager.getWebSite("update/updatewebstart.asp"), true, true);
                DataOutputStream dataOutputStream = new DataOutputStream(url.getOutputStream());
                dataOutputStream.writeBytes("comment=" + string);
                dataOutputStream.flush();
                dataOutputStream.close();
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(url.getInputStream()));
                bufferedReader.readLine();
                bufferedReader.close();
            }
            catch (Exception exception) {
                ErrorHandler.logAndReportException(exception);
            }
        });
        thread.start();
        try {
            thread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static Main_GUI getMainGui() {
        if (frame instanceof Main_GUI) {
            return (Main_GUI)frame;
        }
        return null;
    }

    public static void initExtended() {
        ExtClassLoader.findExtendedLibrariesByClassDir();
        DataBaseControl.LoadDataBases();
        PerfectSpread.Setup();
        ExtClassLoader.Init();
    }

    public static void initForBreeze(boolean bl, UpdateHelper.Product product, UpdateHelper.UpdateVersion updateVersion) {
        Evince.setLookAndFeel();
        if (!Evince.checkLicense(product, updateVersion)) {
            try {
                while (true) {
                    Thread.sleep(100L);
                }
            }
            catch (InterruptedException interruptedException) {
                throw new RuntimeException(interruptedException);
            }
        }
        Evince.initExtended();
        frame = new Main_GUI(product, bl);
        Evince.setFrameIcons(frame);
    }

    public static void initNoShow() {
        Evince.initNoShow(true, UpdateHelper.Product.Evince);
    }

    public static void initNoShow(boolean bl) {
        Evince.initNoShow(bl, UpdateHelper.Product.Evince);
    }

    public static void initNoShow(boolean bl, UpdateHelper.Product product) {
        if (frame != null) {
            if (frame instanceof Main_GUI) {
                ((Main_GUI)frame).setTerminateOnExit(bl);
            }
            return;
        }
        Evince.setLookAndFeel();
        if (!Evince.checkLicense(product, InitClass.getEvinceVersion())) {
            try {
                while (true) {
                    Thread.sleep(100L);
                }
            }
            catch (InterruptedException interruptedException) {
                throw new RuntimeException(interruptedException);
            }
        }
        Evince.initExtended();
        frame = new Main_GUI(product, bl);
        Main_GUI main_GUI = frame;
        Evince.setFrameIcons(frame);
        if (product == UpdateHelper.Product.Evince) {
            main_GUI.initHelp();
        }
    }

    public static boolean isHidpi() {
        return Toolkit.getDefaultToolkit().getScreenResolution() > dpiThreshold;
    }

    public static void main(String[] stringArray) {
        String string = IniManager.getJavaVersion();
        String[] stringArray2 = string.split("[.]");
        if (stringArray2.length >= 2 && Integer.parseInt(stringArray2[0]) < 1 && Integer.parseInt(stringArray2[1]) < 8) {
            Evince.setLookAndFeel();
            JOptionPane.showConfirmDialog(null, new JavaErrorPanel(string, "1.8"), "Your Java version is too old", -1, 0, null);
            System.exit(3);
        } else {
            Object object;
            String string2;
            int n;
            int n2 = 0;
            String string3 = null;
            boolean bl = false;
            ArrayList<String> arrayList = new ArrayList<String>();
            String string4 = null;
            String string5 = null;
            String string6 = null;
            boolean bl2 = false;
            boolean bl3 = false;
            String string7 = null;
            if (stringArray != null) {
                for (n = 0; n < stringArray.length; ++n) {
                    string2 = stringArray[n];
                    Logg.info("Argument " + (n + 1) + " = " + string2, new Object[0]);
                    object = string2.toLowerCase();
                    if (((String)object).equals("-debug")) {
                        n2 = 1;
                        continue;
                    }
                    if (((String)object).equals("-nolookandfeel")) {
                        bl = true;
                        continue;
                    }
                    if (((String)object).startsWith("-file=")) {
                        arrayList.add(string2.substring(6));
                        continue;
                    }
                    if (((String)object).startsWith("-files=")) {
                        arrayList.addAll(Arrays.asList(string2.substring(7).split(";")));
                        continue;
                    }
                    if (((String)object).startsWith("-template=")) {
                        string4 = string2.substring(10);
                        continue;
                    }
                    if (((String)object).startsWith("-templatefile=")) {
                        string5 = string2.substring(14);
                        continue;
                    }
                    if (((String)object).startsWith("-importtemplate=")) {
                        string7 = string2.substring(16);
                        continue;
                    }
                    if (((String)object).startsWith("-variables=")) {
                        string6 = string2.substring(11);
                        continue;
                    }
                    if (((String)object).startsWith("-scripteditor")) {
                        bl2 = true;
                        continue;
                    }
                    if (((String)object).startsWith("-release")) {
                        RegisterKeyManager.umbiolicense = false;
                        continue;
                    }
                    if (((String)object).startsWith("-offline")) {
                        bl3 = true;
                        continue;
                    }
                    if (((String)object).startsWith("-touchscreen")) {
                        touchscreen = true;
                        continue;
                    }
                    if (((String)object).startsWith("-")) continue;
                    if (((String)object).endsWith(".map") || ((String)object).endsWith(".mdl")) {
                        string3 = string2;
                        continue;
                    }
                    arrayList.add(string2);
                }
            }
            if (!bl) {
                Evince.setLookAndFeel();
            }
            if (bl2) {
                try {
                    Evince.initNoShow(false);
                    ScriptFilePanel.showAsFrame(true);
                }
                catch (Exception exception) {
                    ErrorHandler.logAndReportException(exception);
                }
                return;
            }
            if (Evince.tryRunScript(string4, string5, string6, bl3, n2 != 0)) {
                try {
                    while (true) {
                        Thread.sleep(500L);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            n = n2;
            string2 = string3;
            object = Evince.createImportTemplate(string7);
            try {
                Thread thread2 = new Thread((ThreadGroup)new ExceptionGroup(), () -> Evince.lambda$main$0(n != 0, string2, arrayList, (ScriptFile)object));
                thread2.setUncaughtExceptionHandler((thread, throwable) -> {
                    ErrorHandler.logAndReportException("Evince cannot start", throwable);
                    System.err.println(String.valueOf(thread) + " throws exception: " + throwable.getMessage());
                    throwable.printStackTrace();
                    JOptionPane.showConfirmDialog(null, "Evince could not start\n\nError message: " + throwable.getMessage() + "\n\nPlease uninstall and reinstall Evince and try again.\nIf the problem persists please contact support@prediktera.se\n", "Evince cannot start", -1, 0, null);
                    System.exit(0);
                });
                thread2.start();
                thread2.join();
            }
            catch (Exception exception) {
                ErrorHandler.logAndShowEvinceErrorDialogForException(exception);
            }
        }
    }

    private static ScriptFile createImportTemplate(String string) {
        if (string != null) {
            try {
                if (string.endsWith(";\"")) {
                    string = string.substring(0, string.length() - 1);
                }
                ScriptFile scriptFile = new ScriptFile("Custom", "Custom import script", "");
                scriptFile.setAddDefaultImportScript(false);
                scriptFile.setScript(string);
                return scriptFile;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
        return null;
    }

    public static synchronized void setFrameIcons(Window window) {
        UpdateHelper.Product.Evince.setFrameIcons(window);
    }

    public static void setLookAndFeel() {
        try {
            Locale.setDefault(Locale.ENGLISH);
            if (UpdateHelper.getPlatform().equals((Object)UpdateHelper.Platform.Linux)) {
                UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
            } else {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
        }
        catch (Exception exception) {
            ErrorHandler.logAndReportException(exception);
        }
    }

    public static void showGUI(boolean bl, final String string, final List<String> list, final ScriptFile scriptFile) {
        if (Evince.checkLicense(UpdateHelper.Product.Evince, InitClass.getEvinceVersion())) {
            Object object;
            if (!bl) {
                startUpFrame = new StartUpFrame();
                Evince.setFrameIcons(startUpFrame);
                startUpFrame.setVisible(true);
            }
            if ((frame = Main_GUI.get()) == null) {
                Logg.info("Loading libraries", new Object[0]);
                Evince.initExtended();
            }
            if (frame == null) {
                Logg.info("Setup:", new Object[0]);
                Logg.info(" - Frame", new Object[0]);
                frame = new Main_GUI(UpdateHelper.Product.Evince, true);
                object = frame;
                Logg.info(" - Distrution manager", new Object[0]);
                Logg.info(" - Help", new Object[0]);
                ((Main_GUI)object).initHelp();
            }
            Logg.info("Check for updates", new Object[0]);
            if (SystemUtils.IS_OS_MAC) {
                MacHelper.setup(frame, "Evince", new ImageIcon(Evince.class.getResource("/images/icons/Evince_256_Mac.png")));
            }
            Evince.setFrameIcons(frame);
            if (IniManager.hasAutoupdate()) {
                Main_GUI.getStatusBar().setUpdateInfo("Update: Automatic");
                Evince.checkForUpdates();
            } else {
                Main_GUI.getStatusBar().setUpdateInfo("Update: Manual");
                Evince.checkForWebstart("MEVINCE");
            }
            Logg.info("Starting Evince", new Object[0]);
            frame.validate();
            frame.setLocationRelativeTo(null);
            frame.setState(1);
            object = new SwingWorker(){

                @Override
                public Object construct() {
                    try {
                        if (startUpFrame != null) {
                            Thread.sleep(4000L);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    return null;
                }

                @Override
                public void finished() {
                    if (startUpFrame != null) {
                        startUpFrame.dispose();
                    }
                    Logg.debug("Starting Evince using jre: " + IniManager.getJavaRunPath(), new Object[0]);
                    ((Main_GUI)frame).showNow(string, list, scriptFile);
                }
            };
            ((SwingWorker)object).start();
        }
    }

    private static void checkForInstalledLicense() {
        File file;
        File file2 = new File(IniManager.getStartDir());
        if (file2.isDirectory() && (file = new File(file2, "license.key")).exists()) {
            try {
                File file3 = IniManager.getEvinceSettingsFile("license.key");
                int n = 0;
                if (file3.exists()) {
                    n = JOptionPane.showConfirmDialog(null, "Do you want to replace the current license with the installed license?", "Replace current license", 1, 3, null);
                } else {
                    JOptionPane.showConfirmDialog(null, "Thank you for choosing Evince\nA trial license has been installed, press Ok to continue", "Trial license installed", -1, 1, null);
                }
                if (n == 0) {
                    file3.delete();
                    AbstractRandomStream.CopyFile(file, file3);
                }
                if (n == 0 || n == 1) {
                    file.delete();
                }
            }
            catch (IOException iOException) {
                ErrorHandler.logAndShowEvinceErrorDialogForException(iOException);
            }
        }
    }

    private static boolean checkLicense(UpdateHelper.Product product, UpdateHelper.UpdateVersion updateVersion) {
        UpdateHelper.Product.setRunningProduct(product);
        IniManager.LoadIni(product);
        JComponent.setDefaultLocale(Locale.ENGLISH);
        boolean bl = Boolean.parseBoolean("jnlp.demo");
        boolean bl2 = false;
        if (!bl) {
            Evince.checkForInstalledLicense();
            RegisterKeyManager registerKeyManager = new RegisterKeyManager(product);
            bl2 = registerKeyManager.parseRegAndVerifyInfoFile();
            if (updateVersion != null && UpdateHelper.logUserAndUpdateLicense(UpdateHelper.getPlatform(), product, updateVersion)) {
                bl2 = registerKeyManager.parseRegAndVerifyInfoFile();
            }
            RegInfo regInfo = RegisterKeyManager.getRegInfo();
            RegisterWizard registerWizard = new RegisterWizard(regInfo, product);
            if (!bl2 || regInfo == null) {
                bl2 = false;
                registerWizard.executeWizardFrame(product);
            } else if (regInfo.hasLicenseExpired()) {
                bl2 = false;
                JOptionPane.showConfirmDialog(null, "Please contact sales@prediktera.se if you want to renew your license", "Your license has expired", -1, 1, null);
                registerWizard.executeWizardFrame(product);
            } else if (regInfo.isTrialLicense() && regInfo.hasAllLibrariesExpired(false) && IniManager.showWindow((byte)1)) {
                bl2 = true;
                int n = JOptionPane.showConfirmDialog(null, "Please contact sales@prediktera.se if you want to buy a full license or renew your trial license.\nPress Yes if you want to start the License Wizard.\nPress No if you want to continue with your Free license(s)", "Your trial license has expired!", 1, 3, null);
                if (n == 1) {
                    IniManager.setWindow((byte)1, false);
                } else if (n == 0) {
                    bl2 = false;
                    registerWizard.executeWizardFrame(product);
                }
            } else if (regInfo.isLicenseTooOld()) {
                bl2 = false;
                int n = JOptionPane.showConfirmDialog(null, "The license is not valid for this version but still works for the older versions.\nPlease contact license@prediktera.se if you want to renew your license.\nDo you want to start the License Wizard?", "Your license is too old", 0, 3, null);
                if (n == 0) {
                    registerWizard.executeWizardFrame(product);
                }
            } else if (!regInfo.matchIp()) {
                JOptionPane.showConfirmDialog(null, "Your IP address is not within the range of the IP specified in your license\nIf your IP is within range, Please check that your computer is connected to Internet and try again", "IP not in range", -1, 2, null);
                bl2 = false;
                registerWizard.executeWizardFrame(product);
            } else if (!regInfo.matchSerial()) {
                JOptionPane.showConfirmDialog(null, "The license does not contain this device's identification code", "Invalid device id", -1, 2, null);
                bl2 = false;
                registerWizard.executeWizardFrame(product);
            } else if (!regInfo.matchVersionDates()) {
                JOptionPane.showConfirmDialog(null, "The computer time has been altered. Please check that you have set a correct computer time.\nContact license@prediktera.se if you have problem with your license", "Altered time settings", -1, 2, null);
                bl2 = false;
                registerWizard.executeWizardFrame(product);
            } else if (!regInfo.hasLicense(product)) {
                JOptionPane.showConfirmDialog(null, String.valueOf((Object)product) + " is not included in your license\nPlease contact license@prediktera.se", "License information", -1, 1, null);
                bl2 = false;
                registerWizard.executeWizardFrame(product);
            } else if (regInfo.getDaysUntilExpire(product) < 15 && !regInfo.isFeatureActive(RegInfo.LicenseFeature.Record)) {
                if (regInfo.getDaysUntilExpire(product) < 0) {
                    JOptionPane.showConfirmDialog(null, "Your " + String.valueOf((Object)product) + " license has expired\nPlease contact license@prediktera.se", "License information", -1, 1, null);
                    bl2 = false;
                    registerWizard.executeWizardFrame(product);
                } else if (UpdateHelper.Product.isRunningProductEvince()) {
                    JOptionPane.showConfirmDialog(null, "Your license will expire in " + regInfo.getDaysUntilExpire(product) + " day(s)", "License information", -1, 1, null);
                }
            }
        } else {
            RegisterKeyManager.setDemoLicense();
            bl2 = true;
        }
        return bl2;
    }

    private static void clearTempFiles() {
        File[] fileArray;
        File file = IniManager.getTempDir();
        if (file != null && file.exists() && (fileArray = file.listFiles()).length > 0) {
            Date date = new Date(System.currentTimeMillis() - 604800000L);
            for (File file2 : fileArray) {
                Date date2 = new Date(file2.lastModified());
                if (!date2.before(date)) continue;
                Logg.info("The file " + String.valueOf(file2) + " was last modified over seven days ago is being removed", new Object[0]);
                file2.delete();
            }
        }
    }

    private static boolean tryRunScript(String string, String string2, String string3, boolean bl, boolean bl2) {
        CleanUpClass cleanUpClass;
        String string4 = string;
        if (string4 == null) {
            string4 = System.getProperty("jnlp.script");
        }
        if (string4 == null && string2 != null) {
            try {
                cleanUpClass = new ScriptFile(new File(string2));
                string4 = ((ScriptFile)cleanUpClass).getScript();
            }
            catch (Exception exception) {
                JOptionPane.showConfirmDialog(null, "Error loading template:\n" + string2 + "\nMessage: " + exception.getMessage(), "Error", -1, 0);
                ErrorHandler.logAndReportException(exception);
                System.exit(-1);
            }
        }
        if (string4 != null && string4.length() > 0) {
            try {
                cleanUpClass = new ScriptManager(true);
                if (!bl) {
                    Main_GUI.getStatusBar().setUpdateInfo("Update: N/A");
                    Evince.checkForWebstart("ROUTINE");
                }
                if (string3 != null) {
                    String[] stringArray;
                    for (String string5 : stringArray = string3.split(";")) {
                        String string6 = "N/A";
                        try {
                            String[] stringArray2 = string5.split("=");
                            string6 = stringArray2[0];
                            String string7 = stringArray2[1];
                            try {
                                double d = string7.equalsIgnoreCase("true") ? 1.0 : (string7.equalsIgnoreCase("false") ? 0.0 : Double.parseDouble(string7));
                                ((ScriptManager)cleanUpClass).addVariable(d, string6);
                            }
                            catch (Exception exception) {
                                ((ScriptManager)cleanUpClass).addVariable(string7, string6);
                            }
                        }
                        catch (Exception exception) {
                            ErrorHandler.logAndReportException("Cannot add variable: " + string6, exception);
                        }
                    }
                }
                ((ScriptManager)cleanUpClass).evaluteScript(string4);
                return true;
            }
            catch (Exception exception) {
                ErrorHandler.logAndReportException(exception);
            }
        }
        return false;
    }

    private Evince() {
    }

    public static boolean isHotellingT2Feature() {
        return false;
    }

    public static boolean isVipFeature() {
        return false;
    }

    private static /* synthetic */ void lambda$main$0(boolean bl, String string, List list, ScriptFile scriptFile) {
        ErrorHandler.setProductType(ErrorHandler.ProductType.EVINCE);
        ErrorHandler.registerUncaughtExceptionHandlingForAllThreadsAndEventQueue();
        Evince.showGUI(bl, string, list, scriptFile);
    }

    static {
        touchscreen = false;
        dpiThreshold = 200;
        Evince.clearTempFiles();
    }
}

