/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.main;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import se.prediktera.map.common.cleanup.CleanUpDialog;
import se.prediktera.map.main.IniManager;
import se.prediktera.map.main.Main_GUI;
import se.prediktera.map.main.ProxyDialog;
import se.prediktera.map.main.script.ScriptManager;

public class EvinceOptions
extends CleanUpDialog {
    public static final int MODAL_OK = 0;
    public static final int MODAL_ABORT = 1;
    private int modalResult;
    private final JCheckBox checkAutoUpdate = new JCheckBox("Check for new updates every time Evince starts");
    private final JCheckBox check3DAccelerated = new JCheckBox("Use 3D Acceleration");

    public EvinceOptions() {
        super(Main_GUI.get(), "Evince Options", true);
        this.jbInit();
        this.pack();
        this.setLocationRelativeTo(Main_GUI.get());
    }

    public void showModal() {
        this.modalResult = 1;
        super.setVisible(true);
        if (this.modalResult == 0) {
            if (this.checkAutoUpdate.isSelected()) {
                IniManager.setProxySettings((byte)6, "TRUE");
                Main_GUI.getStatusBar().setUpdateInfo("Update: Automatic");
            } else {
                IniManager.setProxySettings((byte)6, "FALSE");
                Main_GUI.getStatusBar().setUpdateInfo("Update: Manual");
            }
        }
    }

    @Override
    protected void cleanUpChild() {
    }

    private void jbInit() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setMinimumSize(new Dimension(548, 383));
        this.setResizable(false);
        JTabbedPane jTabbedPane = new JTabbedPane();
        jPanel.add((Component)jTabbedPane, "Center");
        JButton jButton = new JButton("Help");
        jButton.setMinimumSize(new Dimension(75, 27));
        jButton.setMnemonic('H');
        JButton jButton2 = new JButton("OK");
        jButton2.setMinimumSize(new Dimension(75, 27));
        jButton2.setMnemonic('O');
        jButton2.addActionListener(actionEvent -> {
            this.modalResult = 0;
            this.dispose();
        });
        JButton jButton3 = new JButton("Default");
        jButton3.setMinimumSize(new Dimension(75, 27));
        jButton3.setMnemonic('D');
        ActionListener actionListener = actionEvent -> this.checkAutoUpdate.setSelected(IniManager.hasAutoupdate());
        actionListener.actionPerformed(null);
        jButton3.addActionListener(actionListener);
        JButton jButton4 = new JButton("Cancel");
        jButton4.setMinimumSize(new Dimension(75, 27));
        jButton4.setMnemonic('C');
        jButton4.addActionListener(actionEvent -> {
            this.modalResult = 1;
            this.dispose();
        });
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel.add((Component)jPanel2, "South");
        JPanel jPanel3 = new JPanel();
        jPanel2.add((Component)jPanel3, "East");
        jPanel3.add((Component)jButton2, null);
        jPanel3.add((Component)jButton3, null);
        jPanel3.add((Component)jButton4, null);
        jButton2.requestFocus();
        this.getContentPane().add((Component)jPanel, "Center");
        JPanel jPanel4 = new JPanel(new GridBagLayout());
        jTabbedPane.add((Component)jPanel4, "Auto Update");
        JButton jButton5 = new JButton("Proxy");
        jButton5.addActionListener(actionEvent -> ProxyDialog.RunProxySettings());
        jPanel4.add((Component)this.checkAutoUpdate, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 17, 0, new Insets(12, 12, 0, 12), 0, 0));
        jPanel4.add((Component)new JLabel("Setup Proxy settings"), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 12, 0, new Insets(6, 18, 12, 0), 0, 0));
        jPanel4.add((Component)jButton5, new GridBagConstraints(1, 1, 1, 1, 0.0, 1.0, 18, 0, new Insets(6, 6, 12, 12), 0, 0));
        JPanel jPanel5 = new JPanel(new GridBagLayout());
        jTabbedPane.add((Component)jPanel5, "3D Settings");
        this.check3DAccelerated.setSelected(IniManager.is3dAccelerated());
        this.check3DAccelerated.addActionListener(actionEvent -> IniManager.set3dAccelerated(!IniManager.is3dAccelerated()));
        jPanel5.add((Component)this.check3DAccelerated, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 17, 0, new Insets(12, 12, 0, 12), 0, 0));
        JPanel jPanel6 = new JPanel(new GridBagLayout());
        jTabbedPane.add((Component)jPanel6, "Template directory");
        JTextField jTextField = new JTextField(30);
        JButton jButton6 = new JButton("Add");
        jButton6.addActionListener(actionEvent -> {
            try {
                IniManager.setWorkDir((byte)8, new File(jTextField.getText()));
                ScriptManager.clearScriptFileCache();
            }
            catch (Exception exception) {
                JOptionPane.showConfirmDialog(this, exception.getMessage(), "Error", -1, 0);
            }
        });
        jPanel6.add((Component)jTextField, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(12, 12, 0, 12), 0, 0));
        jPanel6.add((Component)jButton6, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(12, 12, 0, 12), 0, 0));
    }
}

