/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.main;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.Vector;
import javax.help.CSH;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import se.prediktera.map.common.CMenu;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.common.swing.scrollabledesktop.BaseInternalFrame;
import se.prediktera.map.datasetcontainer.DataTreeInterface;
import se.prediktera.map.graphcollection.GraphManager;
import se.prediktera.map.main.AbstractMainGUI;
import se.prediktera.map.main.Main_GUI;
import se.prediktera.map.main.ProjectProperties;
import se.prediktera.map.main.Project_GUI;

public class Graph_GUI
extends AbstractMainGUI {
    private final JPanel settingsPanel = new JPanel(new BorderLayout());
    private GraphManager baseGraphManager;
    private ProjectProperties projectProperties;
    private final JScrollPane treeScrollPane = new JScrollPane();

    public Graph_GUI(Project_GUI project_GUI, CMenu cMenu) {
        super(project_GUI, "Graph Gui", cMenu);
        project_GUI.setGraph_GUI(this);
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            ErrorHandler.logAndShowEvinceErrorDialogForException(exception);
        }
        CSH.setHelpIDString((Component)this, (String)"evinceGraphLayout");
    }

    public Graph_GUI(RandomInputStream randomInputStream, Project_GUI project_GUI, CMenu cMenu) throws IOException {
        this(project_GUI, cMenu);
        MapProperty mapProperty = randomInputStream.readProperties("Graph_GUI");
        this.baseGraphManager.LoadProperties(randomInputStream, mapProperty);
    }

    public JPopupMenu createPopupMenu(Point point, Object object, boolean bl) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add(new AbstractAction("Project Properties"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Graph_GUI.this.projectProperties.showModal();
            }
        });
        jPopupMenu.add(new AbstractAction("Build model tree"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Graph_GUI.this.updateGraph();
            }
        });
        return jPopupMenu;
    }

    @Override
    public void DataTreeSelected(DataTreeInterface dataTreeInterface) {
    }

    @Override
    public String getGUI_Name() {
        return "Graph";
    }

    public ProjectProperties getProjectProperties() {
        return this.projectProperties;
    }

    @Override
    public JComponent getSettingsPanel() {
        return this.settingsPanel;
    }

    public void getToolbars(Vector<JToolBar> vector) {
        vector.add(this.baseGraphManager.getToolbar());
    }

    public void PurgeSignal() {
        this.baseGraphManager.PurgeSignal();
    }

    @Override
    public void Save(RandomOutputStream randomOutputStream) throws IOException {
        randomOutputStream.beginProperty("Graph_GUI");
        this.baseGraphManager.SaveProperties(randomOutputStream);
        randomOutputStream.endProperty();
    }

    @Override
    public void selectedFrameUpdated(BaseInternalFrame baseInternalFrame) {
    }

    public void setCreated() {
        this.baseGraphManager.setCreated();
    }

    public void updateGraph() {
        this.baseGraphManager.updateGraph();
    }

    @Override
    protected void cleanUpChild() {
        super.cleanUpChild();
        if (this.projectProperties != null) {
            this.projectProperties.cleanUp();
            this.projectProperties = null;
        }
        if (this.baseGraphManager != null) {
            this.baseGraphManager.cleanUp();
            this.baseGraphManager = null;
        }
        this.baseGraphManager = null;
    }

    private void jbInit() throws Exception {
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 13, 0, new Insets(0, 6, 0, 12), 0, 0);
        JLabel jLabel = new JLabel(new ImageIcon(Main_GUI.class.getResource("gif/graph_layout_button.png")));
        this.northTitle.addComponent(jLabel, gridBagConstraints);
        this.northTitle.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                    JPopupMenu jPopupMenu = Graph_GUI.this.createPopupMenu(null, null, false);
                    jPopupMenu.show(Graph_GUI.this, mouseEvent.getX(), mouseEvent.getY());
                }
            }
        });
        this.projectProperties = new ProjectProperties(this.project_GUI);
        this.baseGraphManager = new GraphManager(this.project_GUI, false);
        this.project_GUI.getDataTreeManager().setGraphManager(this.baseGraphManager);
        JToolBar jToolBar = this.baseGraphManager.getToolbar();
        this.northTitle.addToolbar(jToolBar, 1);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setMinimumSize(new Dimension(0, 100));
        jPanel.setPreferredSize(new Dimension(0, 100));
        this.centerPanel.add((Component)this.baseGraphManager, "Center");
        this.settingsPanel.add((Component)this.treeScrollPane, "Center");
        JScrollPane jScrollPane = new JScrollPane();
        jPanel.add((Component)jScrollPane, "Center");
        this.setWindowMenu(this.menu, jToolBar);
    }
}

