/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.main;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.FileSystemException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.security.CodeSource;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import java.util.stream.Stream;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;
import javax.swing.JOptionPane;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.SystemUtils;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.common.cleanup.CleanUpDialog;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.common.error.Logg;
import se.prediktera.map.common.update.UpdateHelper;
import se.prediktera.map.datasetcontainer.DataTreeInterface;
import se.prediktera.map.main.Main_GUI;
import se.prediktera.map.main.StatusBar;

public final class IniManager {
    public static final byte EXIT_ERROR = 1;
    public static final byte EXIT_MEMORY = 2;
    public static final byte EXIT_LICENSE = 3;
    public static final byte EVINCEDIRECTORY = 0;
    public static final byte DATADIRECTORY = 1;
    public static final byte PICTUREDIRECTORY = 2;
    public static final byte TEMPLATENAME = 3;
    public static final byte WORKFLOWDIRECTORY = 4;
    public static final byte MODELDIRECTORY = 5;
    public static final byte IMAGEDIRECTORY = 6;
    public static final byte FOLDERDIRECTORY = 7;
    public static final byte ALTSCRIPTDIR = 8;
    public static final byte PLAYDATADIR = 9;
    public static final byte OUTPUTFOLDERDIRECTORY = 10;
    public static final byte BREEZEWORKSPACEDIRECTORY = 11;
    public static final String[] dirnames = new String[]{"EVINCE", "DATA", "PICTURE", "TEMPLATE", "WORKFLOW", "MODEL", "IMAGE", "FOLDER", "ALTSCRIPTDIR", "PLAYDATA", "OUTPUTFOLDER", "ROOTPATH"};
    public static final byte HINTS = 0;
    public static final byte LICENSERENEW = 1;
    public static final byte DATASETCHECK = 2;
    public static final byte ZEROTOEXCLUDE = 3;
    public static final String[] windowsnames = new String[]{"HINTS", "LICENSERENEW", "DATASETCHECK", "ZEROTOEXCLUDE"};
    public static final byte PROXYENABLE = 0;
    public static final byte PROXYHOST = 1;
    public static final byte PROXYPORT = 2;
    public static final byte PROXYUSER = 3;
    public static final byte PROXYPASSWORD = 4;
    public static final byte PROXYAUTHENTICATION = 5;
    public static final byte PROXYAUTOUPDATE = 6;
    public static final String[] proxynames = new String[]{"ENABLE", "HOST", "PORT", "USER", "PASSWORD", "AUTHENTICATION", "DOAUTOUPDATE"};
    public static final byte DEDICATED = 0;
    public static final byte AUTOCONNECT = 1;
    public static final String[] clusternames = new String[]{"DEDICATED", "AUTOCONNECT"};
    public static final String[] plotnames = new String[0];
    public static final String[] datanames = new String[0];
    private static List<File> recentProject = new Vector<File>(11);
    private static HashMap<Byte, Object> workingDir = new HashMap();
    private static HashMap<Byte, Boolean> windowsShow = new HashMap();
    private static HashMap<Byte, String> proxySettings = new HashMap();
    private static HashMap<Byte, String> clusterSettings = new HashMap();
    private static HashMap plotSettings = new HashMap();
    private static HashMap dataSettings = new HashMap();
    private static HashMap<String, String> scriptSettings = new HashMap();
    private static HashMap<String, String> userSettings = new HashMap();
    private static HashMap<String, String> importSettings = new HashMap();
    private static List<String> recentDatabase = new Vector<String>(11);
    private static List<File> recentWorkspace = new Vector<File>(11);
    private static File evinceini;

    public static String Abs(String string) {
        if (IniManager.isWindowsOS()) {
            return "\"" + string + "\"";
        }
        return string;
    }

    public static void clearSettings() {
        recentProject.clear();
        recentWorkspace.clear();
        workingDir.clear();
        recentWorkspace.clear();
    }

    public static void drawImageString(Graphics graphics, String string, Color color, double d) {
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n = fontMetrics.stringWidth(string);
        int n2 = fontMetrics.getHeight();
        int n3 = (int)((double)n * d);
        int n4 = (int)((double)n2 * d);
        if (n3 > 0 && n4 > 0) {
            BufferedImage bufferedImage = new BufferedImage(n3, n4, 2);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            Font font = graphics.getFont();
            graphics2D.setFont(new Font(font.getFontName(), font.getStyle(), (int)((double)font.getSize() * d)));
            graphics2D.setColor(color);
            graphics2D.drawString(string, 0, (int)((double)fontMetrics.getAscent() * d));
            graphics2D.dispose();
            graphics.drawImage(bufferedImage, 0, 0, null);
        }
    }

    public static File getDataDir() {
        return IniManager.getOrCreateDir(IniManager.Slash(IniManager.getPredikteraPath()) + "Data");
    }

    public static File getEdbDir() throws IOException {
        return IniManager.getOrCreateDir(IniManager.Slash(IniManager.getPredikteraPath()) + "Edb");
    }

    public static File getEvinceSettingsFile(String string) {
        return IniManager.getEvinceSettingsFile(string, UpdateHelper.Product.Evince);
    }

    public static File getEvinceSettingsFile(String string, UpdateHelper.Product product) {
        File file = IniManager.getOrCreatePredikteraDir(product);
        return new File(IniManager.Slash(file.getAbsolutePath()) + string);
    }

    public static String getFileSeparator() {
        return FileSystems.getDefault().getSeparator();
    }

    public static String getFineSize(long l) {
        if (l < 1024L) {
            return l + " bytes";
        }
        if (l < 0x100000L) {
            return (int)(l / 1024L) + " KB";
        }
        if (l < 0x40000000L) {
            return (int)(l / 1024L / 1024L) + " MB";
        }
        return String.format("%.1f GB", Float.valueOf((float)l / 1.0737418E9f));
    }

    public static String getIdFile() {
        return IniManager.Slash(IniManager.getPredikteraPath()) + "license.id";
    }

    public static Boolean getImportSettings(String string, boolean bl) {
        Boolean bl2 = IniManager.getImportSettings(string);
        if (bl2 != null) {
            return bl2;
        }
        return bl;
    }

    public static String[][] getInspectorShift() {
        return new String[][]{{"Prototyp", "0"}, {"SN410037", "3"}, {"SN410038", "9"}, {"SN410041", "0"}, {"SN410042", "3"}};
    }

    public static String getJavaHome() {
        return System.getProperty("java.home");
    }

    public static String getJavaRunPath() {
        return IniManager.Abs(IniManager.Slash(IniManager.getJavaHome()) + IniManager.Slash("bin") + "java");
    }

    public static String getJavaVersion() {
        return System.getProperty("java.version");
    }

    public static String getJavaWindowRunPath() {
        return IniManager.Abs(IniManager.Slash(IniManager.getJavaHome()) + IniManager.Slash("bin") + "javaw");
    }

    public static Frame getMainFrame() {
        if (Main_GUI.get() == null) {
            if (Frame.getFrames().length == 0) {
                return null;
            }
            return Frame.getFrames()[0];
        }
        return Main_GUI.get();
    }

    @Deprecated
    public static Main_GUI getMainGUI() {
        return Main_GUI.get();
    }

    public static int getModelDataType() {
        return 4;
    }

    public static File getOrCreatePredikteraDir(UpdateHelper.Product product) {
        try {
            IniManager.migrateSettingsDirectory(product);
        }
        catch (IOException iOException) {
            Logg.error("Error during settings folder migration", iOException);
        }
        return IniManager.getOrCreateDir(IniManager.getPredikteraPath());
    }

    private static void migrateSettingsDirectory(UpdateHelper.Product product) throws IOException {
        Object object;
        boolean bl;
        File file2 = new File(IniManager.getEvincePathOld());
        File file3 = new File(IniManager.getPredikteraPath(), ".moved");
        if (file3.exists() && (bl = new HashSet(object = Stream.of(UpdateHelper.Product.Breeze, UpdateHelper.Product.Evince).filter(product2 -> product2 != product).map(UpdateHelper.Product::toString).toList()).containsAll(Files.readAllLines(file3.toPath()))) && file2.exists()) {
            FileUtils.deleteQuietly((File)file2);
            Logg.info("Removed old config dir", new Object[0]);
        }
        object = new File(IniManager.getPredikteraPath());
        if (file2.exists() && !file3.exists()) {
            File file4;
            Logg.info("Migrating old directory: " + file2.getAbsolutePath() + " to " + IniManager.getPredikteraPath(), new Object[0]);
            IniManager.copyDirectory(file2, (File)object);
            if (!FileUtils.deleteQuietly((File)file2)) {
                Logg.warn("Could not remove old Evince settings directory", new Object[0]);
            }
            File file5 = new File((File)object, "Breeze");
            File file6 = new File((File)object, "BreezeRuntime.log");
            if (file6.exists() && !new File(file5, file6.getName()).exists()) {
                FileUtils.moveToDirectory((File)file6, (File)file5, (boolean)true);
            }
            FileUtils.deleteQuietly((File)file6);
            File file7 = new File((File)object, "evince.key");
            File file8 = new File((File)object, "license.key");
            if (file7.exists() && !file8.exists()) {
                Files.copy(file7.toPath(), file8.toPath(), new CopyOption[0]);
            }
            File file9 = new File((File)object, "evince.id");
            File file10 = new File((File)object, "license.id");
            if (file9.exists() && !file10.exists()) {
                Files.copy(file9.toPath(), file10.toPath(), new CopyOption[0]);
            }
            if ((file4 = new File((File)object, "archives")).exists()) {
                File file11 = new File((File)object, "Evince");
                if (!Files.isDirectory(file11.toPath(), new LinkOption[0])) {
                    Files.createDirectory(file11.toPath(), new FileAttribute[0]);
                }
                if (!Files.isDirectory(file5.toPath(), new LinkOption[0])) {
                    Files.createDirectory(file5.toPath(), new FileAttribute[0]);
                }
                FileUtils.copyDirectory((File)file4, (File)new File(file11, "archives"), file -> !file.getName().startsWith("BreezeRuntime"));
                FileUtils.copyDirectory((File)file4, (File)new File(file5, "archives"));
                IniManager.moveLogFileToArchive(file11);
                IniManager.moveLogFileToArchive(file5);
                FileUtils.deleteQuietly((File)file4);
            }
            Files.writeString(file3.toPath(), (CharSequence)product.toString(), new OpenOption[0]);
        } else if (!file2.exists() && file3.exists()) {
            FileUtils.deleteQuietly((File)file3);
            Logg.debug("Removed moved indicator", new Object[0]);
        }
        IniManager.createYamlFileIfNotExists((File)object);
    }

    private static void createYamlFileIfNotExists(File file) throws IOException {
        File file2 = new File(file, "evince.ini");
        File file3 = new File(file.getAbsolutePath(), "Breeze");
        File file4 = new File(file3, "Settings.yaml");
        if (file2.exists() && !file4.exists()) {
            Logg.info("Creating new Breeze settings file: " + String.valueOf(file4), new Object[0]);
            String string = IniManager.getRootPath(file2);
            file3.mkdirs();
            Files.writeString(file4.toPath(), (CharSequence)("rootFolder: " + string), StandardCharsets.UTF_8, StandardOpenOption.CREATE_NEW);
        }
    }

    private static String getRootPath(File file) throws IOException {
        boolean bl = false;
        for (String string : Files.readAllLines(file.toPath(), StandardCharsets.ISO_8859_1)) {
            if (string.equals("ROOTPATH")) {
                bl = true;
                continue;
            }
            if (!bl) continue;
            return string;
        }
        return "";
    }

    public static void copyDirectory(File file, File file2) throws IOException {
        if (file.isDirectory()) {
            file2.mkdirs();
            for (String string : file.list()) {
                IniManager.copyDirectory(new File(file, string), new File(file2, string));
            }
        } else {
            try {
                Files.copy(file.toPath(), file2.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (FileSystemException fileSystemException) {
            }
            catch (IOException iOException) {
                Logg.warn("Failed copy file", iOException);
            }
        }
    }

    private static void moveLogFileToArchive(File file) throws IOException {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd");
        String string = simpleDateFormat.format(new Date());
        File file2 = new File(file, "archives");
        File file3 = new File(file2, "error." + string + ".log");
        File file4 = new File(IniManager.getEvincePathOld(), "error.log");
        if (file4.exists()) {
            FileUtils.touch((File)file3);
            Files.write(file3.toPath(), Files.readAllBytes(file4.toPath()), StandardOpenOption.APPEND);
        }
        File file5 = new File(file2, "debug." + string + ".log");
        File file6 = new File(IniManager.getEvincePathOld(), "debug.log");
        if (file6.exists()) {
            FileUtils.touch((File)file5);
            Files.write(file5.toPath(), Files.readAllBytes(file6.toPath()), StandardOpenOption.APPEND);
        }
    }

    public static String getPathSeparator() {
        return File.pathSeparator;
    }

    public static int getPredictionDataType() {
        return 4;
    }

    public static String getProxyHost() {
        String string = proxySettings.get((byte)1);
        if (!IniManager.hasProxy() || string == null) {
            return IniManager.getWebSite();
        }
        return string;
    }

    public static String getProxyPassword() {
        String string = proxySettings.get((byte)4);
        if (string == null) {
            return "";
        }
        return string;
    }

    public static String getProxyPort() {
        String string = proxySettings.get((byte)2);
        if (!IniManager.hasProxy() || string == null) {
            return "8080";
        }
        return string;
    }

    public static String getProxyUser() {
        String string = proxySettings.get((byte)3);
        if (string == null) {
            return "";
        }
        return string;
    }

    public static List<String> getRecentDatabase() {
        return recentDatabase;
    }

    public static List<File> getRecentProject() {
        return recentProject;
    }

    public static List<File> getRecentWorkspace() {
        return recentWorkspace;
    }

    public static File getSamplesDir() throws IOException {
        return IniManager.getOrCreateDir(IniManager.getStartDirSlash() + "Samples");
    }

    public static File getScriptDir() throws IOException {
        return IniManager.getOrCreateDir(IniManager.Slash(IniManager.getPredikteraPath()) + "Script");
    }

    public static String getScriptName(String string, String string2, int n) {
        return IniManager.getScriptName(null, string, string2, n);
    }

    public static String getScriptName(String string, String string2, String string3, int n) {
        for (int i = n; i >= 0; --i) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("SCRIPT_");
            if (string != null) {
                stringBuilder.append(string);
                stringBuilder.append("_");
            }
            stringBuilder.append(string2);
            if (string3 != null && string3.length() > 0) {
                stringBuilder.append("_");
                stringBuilder.append(string3);
            }
            stringBuilder.append("_DEFAULT_");
            stringBuilder.append(i);
            String string4 = IniManager.getScriptSettings(stringBuilder.toString());
            if (string4 == null) continue;
            return string4;
        }
        return null;
    }

    public static String getScriptSettings(String string) {
        String string2 = scriptSettings.get(string);
        if (string2 != null) {
            return string2.toString();
        }
        return null;
    }

    public static String getWebSite() {
        return "https://www.prediktera.com/";
    }

    public static String getWebSite(String string) {
        return "https://www.prediktera.com/" + string;
    }

    public static String getUserPage(String string) {
        return "https://license.prediktera.se/" + string;
    }

    public static String getCNAME(String string) throws NamingException {
        Properties properties = new Properties();
        properties.put("java.naming.factory.initial", "com.sun.jndi.dns.DnsContextFactory");
        InitialDirContext initialDirContext = new InitialDirContext(properties);
        Attributes attributes = initialDirContext.getAttributes(string, new String[]{"CNAME"});
        Attribute attribute = attributes.get("CNAME");
        String string2 = attribute.get().toString();
        if (string2.length() > 2 && string2.endsWith(".")) {
            return string2.substring(0, string2.length() - 1);
        }
        return string2;
    }

    public static String getStartDir() {
        Class<IniManager> clazz;
        CodeSource codeSource;
        URL uRL;
        String string = System.getProperty("user.dir");
        File file = new File(IniManager.Slash(string) + "Evince.jar");
        if (!file.exists() && (file = new File((uRL = (codeSource = (clazz = IniManager.class).getProtectionDomain().getCodeSource()).getLocation()).getPath())).exists()) {
            string = file.getParentFile().getPath();
        }
        return string;
    }

    public static String getStartDirSlash() {
        return IniManager.Slash(IniManager.getStartDir());
    }

    public static StatusBar getStatusBar() {
        return Main_GUI.getStatusBar();
    }

    public static File getTempDir() {
        return IniManager.getOrCreateDir(IniManager.Slash(System.getProperty("java.io.tmpdir")) + "Evince");
    }

    public static String getUserHome() {
        return System.getProperty("user.home");
    }

    public static String getUsername() {
        return System.getProperty("user.name");
    }

    public static String getUserSettings(String string) {
        String string2 = userSettings.get(string);
        if (string2 != null) {
            return string2.toString();
        }
        return null;
    }

    public static File getWorkDir(byte by) {
        File file = (File)workingDir.get(by);
        if (by == 1 && file == null) {
            try {
                return IniManager.getSamplesDir();
            }
            catch (IOException iOException) {
                return null;
            }
        }
        return file;
    }

    public static byte getWorkDirType(String string) {
        for (byte by = 0; by < dirnames.length; by = (byte)(by + 1)) {
            if (!dirnames[by].equalsIgnoreCase(string)) continue;
            return by;
        }
        return -1;
    }

    public static File getWorkflowDir() {
        return IniManager.getOrCreateDir(IniManager.Slash(IniManager.getPredikteraPath()) + "Workflow");
    }

    public static String getWorkPath(byte by) {
        Object object = workingDir.get(by);
        if (object != null) {
            return String.valueOf(object);
        }
        return null;
    }

    public static boolean hasAuthentication() {
        return "TRUE".equals(proxySettings.get((byte)5));
    }

    public static boolean hasAutoupdate() {
        return !"FALSE".equals(proxySettings.get((byte)6));
    }

    public static boolean hasProxy() {
        return "TRUE".equals(proxySettings.get((byte)0));
    }

    public static boolean is3dAccelerated() {
        String string = (String)plotSettings.get("3dAccelerated");
        if (string != null) {
            return string.equals("TRUE");
        }
        return true;
    }

    public static boolean is64bit() {
        String string = System.getProperty("os.arch");
        return string.contains("64");
    }

    public static boolean isAutoConnected() {
        return "TRUE".equals(clusterSettings.get((byte)1));
    }

    public static boolean isDedicated() {
        return "TRUE".equals(clusterSettings.get((byte)0));
    }

    public static boolean isMacOS() {
        String string = System.getProperty("os.name");
        return string.toLowerCase().startsWith("mac");
    }

    public static boolean isWindowsOS() {
        String string = System.getProperty("os.name");
        return string.toLowerCase().startsWith("wind");
    }

    public static void LoadIniIfNeeded() {
        if (evinceini == null) {
            IniManager.LoadIni(UpdateHelper.Product.Breeze);
        }
    }

    public static void LoadIni(UpdateHelper.Product product) {
        try {
            IniManager.LoadIni(IniManager.getEvinceSettingsFile("evince.ini", product));
        }
        catch (IOException iOException) {
            ErrorHandler.logAndShowEvinceErrorDialogForException(iOException);
        }
    }

    public static void LoadIni(File file) throws IOException {
        String string;
        IniManager.clearSettings();
        file.createNewFile();
        evinceini = file;
        RandomInputStream randomInputStream = new RandomInputStream(null, evinceini, null);
        while ((string = randomInputStream.readLine()) != null) {
            if (string.equals("[RECENT]")) {
                IniManager.loadRecent(randomInputStream, recentProject);
                continue;
            }
            if (string.equals("[WORKDIR]")) {
                IniManager.loadWorkdir(randomInputStream);
                continue;
            }
            if (string.equals("[WINDOWS]")) {
                IniManager.loadWindows(randomInputStream);
                continue;
            }
            if (string.equals("[PROXY]")) {
                IniManager.loadProxy(randomInputStream);
                continue;
            }
            if (string.equals("[PLOT]")) {
                IniManager.loadPlot(randomInputStream);
                continue;
            }
            if (string.equals("[DATA]")) {
                IniManager.loadData(randomInputStream);
                continue;
            }
            if (string.equals("[SCRIPT]")) {
                IniManager.loadSettings(randomInputStream, scriptSettings);
                continue;
            }
            if (string.equals("[IMPORT]")) {
                IniManager.loadImport(randomInputStream);
                continue;
            }
            if (string.equals("[RECENTDATABASE]")) {
                IniManager.loadRecentDatabase(randomInputStream);
                continue;
            }
            if (string.equals("[USER]")) {
                IniManager.loadSettings(randomInputStream, userSettings);
                continue;
            }
            if (!string.equals("[RECENTWORKSPACE]")) continue;
            IniManager.loadRecent(randomInputStream, recentWorkspace);
        }
        randomInputStream.close();
        if (recentDatabase.size() > 10) {
            recentDatabase = recentDatabase.subList(0, 10);
        }
    }

    public static void reloadAllDataTrees(DataTreeInterface dataTreeInterface) {
        Main_GUI.reloadAllDataTrees(dataTreeInterface);
    }

    public static void SaveIni() {
        try {
            if (evinceini == null) {
                evinceini = IniManager.getEvinceSettingsFile("evince.ini");
            }
            File file = File.createTempFile("evince", "ini", evinceini.getParentFile());
            file.delete();
            RandomOutputStream randomOutputStream = new RandomOutputStream(file, true, null);
            IniManager.savePathVector(randomOutputStream, "[RECENT]", recentProject);
            IniManager.saveHashMap(randomOutputStream, "[WORKDIR]", workingDir, dirnames, null);
            IniManager.saveHashMap(randomOutputStream, "[WINDOWS]", windowsShow, windowsnames, null);
            IniManager.saveHashMap(randomOutputStream, "[PROXY]", proxySettings, proxynames, null);
            IniManager.saveHashMap(randomOutputStream, "[PLOT]", plotSettings, plotnames, null);
            IniManager.saveHashMap(randomOutputStream, "[DATA]", dataSettings, datanames, null);
            IniManager.saveHashMap(randomOutputStream, "[SCRIPT]", scriptSettings, IniManager.createNames(scriptSettings), null);
            IniManager.saveHashMap(randomOutputStream, "[IMPORT]", importSettings, IniManager.createNames(importSettings), null);
            IniManager.saveVector(randomOutputStream, "[RECENTDATABASE]", recentDatabase);
            IniManager.saveHashMap(randomOutputStream, "[USER]", userSettings, IniManager.createNames(userSettings), null);
            IniManager.savePathVector(randomOutputStream, "[RECENTWORKSPACE]", recentWorkspace);
            randomOutputStream.close();
            if (!evinceini.exists() || evinceini.delete()) {
                file.renameTo(evinceini);
            }
        }
        catch (IOException iOException) {
            JOptionPane.showConfirmDialog(IniManager.getMainFrame(), "Cannot save evince.ini\nPlease check if the file is used by another program", "Cannot save properties", -1, 0, null);
        }
    }

    public static void set3dAccelerated(boolean bl) {
        plotSettings.put("3dAccelerated", bl ? "TRUE" : "FALSE");
    }

    public static void setClusterSettings(byte by, String string) {
        clusterSettings.put(by, string);
        IniManager.SaveIni();
    }

    public static void setHelpWindow(CleanUpDialog cleanUpDialog) {
        Main_GUI.setHelpWindow(cleanUpDialog);
    }

    public static void setImportSettings(String string, boolean bl) {
        importSettings.put(string, String.valueOf(bl));
        IniManager.SaveIni();
    }

    public static void setProxySettings(byte by, String string) {
        proxySettings.put(by, string);
        IniManager.SaveIni();
    }

    public static void setScriptSettings(String string, String string2) {
        scriptSettings.put(string, string2);
        IniManager.SaveIni();
    }

    public static void setUserSettings(String string, String string2) {
        if (string2 == null || string2.equals("")) {
            userSettings.remove(string);
        } else {
            userSettings.put(string, string2);
        }
        IniManager.SaveIni();
    }

    public static void setWindow(byte by, boolean bl) {
        windowsShow.put(by, bl);
        IniManager.SaveIni();
    }

    public static void setWorkDir(byte by, File file) {
        workingDir.put(by, file);
        IniManager.SaveIni();
    }

    public static void setWorkPath(byte by, String string) {
        workingDir.put(by, string);
        IniManager.SaveIni();
    }

    public static boolean showWindow(byte by) {
        return IniManager.showWindow(by, true);
    }

    public static boolean showWindow(byte by, boolean bl) {
        Boolean bl2 = windowsShow.get(by);
        if (bl2 == null) {
            return bl;
        }
        return bl2;
    }

    public static String Slash(String string) {
        return string + IniManager.getFileSeparator();
    }

    private static String[] createNames(HashMap hashMap) {
        String[] stringArray = new String[hashMap.size()];
        int n = 0;
        Iterator iterator = hashMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry;
            Map.Entry entry2 = entry = iterator.next();
            stringArray[n++] = entry2.getKey().toString();
        }
        return stringArray;
    }

    public static String getPredikteraPath() {
        return IniManager.Slash(IniManager.getUserHome()) + ".Prediktera";
    }

    private static String getEvincePathOld() {
        return IniManager.Slash(IniManager.getUserHome()) + ".Evince";
    }

    private static String getFilepath(File file) {
        try {
            return file.getCanonicalPath();
        }
        catch (IOException iOException) {
            return file.getAbsolutePath();
        }
    }

    private static Boolean getImportSettings(String string) {
        String string2 = importSettings.get(string);
        if (string2 != null) {
            return Boolean.parseBoolean(string2.toString());
        }
        return null;
    }

    private static File getOrCreateDir(String string) {
        File file = new File(string);
        if (file.exists() || file.mkdir()) {
            return file;
        }
        Logg.error("Could not find or create " + file.getAbsolutePath(), new Object[0]);
        return null;
    }

    public static File getOrCreateDir(String string, boolean bl) {
        Path path = Path.of(string, new String[0]);
        try {
            Files.createDirectories(path, new FileAttribute[0]);
            if (SystemUtils.IS_OS_WINDOWS && bl) {
                Files.setAttribute(path, "dos:hidden", true, new LinkOption[0]);
            }
            return path.toFile();
        }
        catch (IOException iOException) {
            Logg.error("Could not create or set attributes on " + String.valueOf(path.toAbsolutePath()), iOException);
            return null;
        }
    }

    private static void loadData(RandomInputStream randomInputStream) throws IOException {
        String string;
        while ((string = randomInputStream.readLine()) != null && !string.equals("[END]")) {
            randomInputStream.readLine();
        }
    }

    private static void loadImport(RandomInputStream randomInputStream) throws IOException {
        String string;
        while ((string = randomInputStream.readLine()) != null && !string.equals("[END]")) {
            String string2 = randomInputStream.readLine();
            if (string2 == null) continue;
            importSettings.put(string, string2);
        }
    }

    private static void loadPlot(RandomInputStream randomInputStream) throws IOException {
        String string;
        while ((string = randomInputStream.readLine()) != null && !string.equals("[END]")) {
            String string2 = randomInputStream.readLine();
            plotSettings.put(string, string2);
        }
    }

    private static void loadProxy(RandomInputStream randomInputStream) throws IOException {
        String string;
        while ((string = randomInputStream.readLine()) != null && !string.equals("[END]")) {
            String string2 = randomInputStream.readLine();
            if (string2 == null) continue;
            if (string.equalsIgnoreCase(proxynames[0])) {
                proxySettings.put((byte)0, string2);
                continue;
            }
            if (string.equalsIgnoreCase(proxynames[1])) {
                proxySettings.put((byte)1, string2);
                continue;
            }
            if (string.equalsIgnoreCase(proxynames[2])) {
                proxySettings.put((byte)2, string2);
                continue;
            }
            if (string.equalsIgnoreCase(proxynames[5])) {
                proxySettings.put((byte)5, string2);
                continue;
            }
            if (string.equalsIgnoreCase(proxynames[3])) {
                proxySettings.put((byte)3, string2);
                continue;
            }
            if (string.equalsIgnoreCase(proxynames[4])) {
                proxySettings.put((byte)4, string2);
                continue;
            }
            if (!string.equalsIgnoreCase(proxynames[6])) continue;
            proxySettings.put((byte)6, string2);
        }
    }

    private static void loadRecent(RandomInputStream randomInputStream, List<File> list) throws IOException {
        String string;
        while ((string = randomInputStream.readLine()) != null && !string.equals("[END]")) {
            File file = new File(string);
            if (!file.exists()) continue;
            list.add(file);
        }
    }

    private static void loadRecentDatabase(RandomInputStream randomInputStream) throws IOException {
        String string;
        while ((string = randomInputStream.readLine()) != null && !string.equals("[END]")) {
            recentDatabase.add(string);
        }
    }

    private static void loadSettings(RandomInputStream randomInputStream, HashMap<String, String> hashMap) throws IOException {
        String string;
        while ((string = randomInputStream.readLine()) != null && !string.equals("[END]")) {
            String string2 = randomInputStream.readLine();
            if (string2 == null) continue;
            hashMap.put(string, string2);
        }
    }

    private static void loadWindows(RandomInputStream randomInputStream) throws IOException {
        String string;
        block2: while ((string = randomInputStream.readLine()) != null && !string.equals("[END]")) {
            Boolean bl;
            String string2 = randomInputStream.readLine();
            if (string2 == null) continue;
            try {
                bl = Boolean.valueOf(string2);
            }
            catch (Exception exception) {
                bl = Boolean.TRUE;
            }
            for (byte by = 0; by < windowsnames.length; by = (byte)(by + 1)) {
                if (!string.equalsIgnoreCase(windowsnames[by])) continue;
                windowsShow.put(by, bl);
                continue block2;
            }
        }
    }

    private static void loadWorkdir(RandomInputStream randomInputStream) throws IOException {
        String string;
        block0: while ((string = randomInputStream.readLine()) != null && !string.equals("[END]")) {
            File file;
            String string2 = randomInputStream.readLine();
            if (string2 == null || !(file = new File(string2)).exists()) continue;
            for (byte by = 0; by < dirnames.length; by = (byte)(by + 1)) {
                if (!string.equalsIgnoreCase(dirnames[by])) continue;
                workingDir.put(by, file);
                continue block0;
            }
        }
    }

    private static void saveHashMap(RandomOutputStream randomOutputStream, String string, HashMap hashMap, String[] stringArray, String string2) throws IOException {
        randomOutputStream.writeLine(string);
        for (Map.Entry entry : hashMap.entrySet()) {
            Comparable<Byte> comparable;
            Map.Entry entry2 = entry;
            Object object = entry2.getKey();
            if (object instanceof Byte) {
                comparable = (Byte)object;
                randomOutputStream.writeLine(stringArray[comparable]);
            } else {
                randomOutputStream.writeLine(entry2.getKey().toString());
            }
            object = entry2.getValue();
            if (object instanceof File) {
                comparable = (File)object;
                randomOutputStream.write(IniManager.getFilepath((File)comparable));
            }
            if (entry2.getValue() instanceof Boolean) {
                randomOutputStream.write(entry2.getValue().toString());
            }
            if (entry2.getValue() instanceof String) {
                randomOutputStream.write((String)entry2.getValue());
            }
            randomOutputStream.newLine();
        }
        randomOutputStream.writeLine("[END]");
    }

    private static void savePathVector(RandomOutputStream randomOutputStream, String string, List list) throws IOException {
        randomOutputStream.writeLine(string);
        for (Object e : list) {
            randomOutputStream.writeLine(IniManager.getFilepath((File)e));
        }
        randomOutputStream.writeLine("[END]");
    }

    private static void saveVector(RandomOutputStream randomOutputStream, String string, List list) throws IOException {
        randomOutputStream.writeLine(string);
        for (Object e : list) {
            randomOutputStream.writeLine(String.valueOf(e));
        }
        randomOutputStream.writeLine("[END]");
    }
}

