/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.main;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.help.CSH;
import javax.help.DefaultHelpBroker;
import javax.help.HelpBroker;
import javax.help.HelpSet;
import javax.help.HelpSetException;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.MenuElement;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import se.prediktera.map.InitClass;
import se.prediktera.map.common.CMenu;
import se.prediktera.map.common.CMenuItem;
import se.prediktera.map.common.CRadioButtonMenuItem;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.ReportDialog;
import se.prediktera.map.common.cleanup.CleanUpDialog;
import se.prediktera.map.common.cleanup.CleanUpInterface;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.common.error.Logg;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.common.progress.ProgressManagerImpl;
import se.prediktera.map.common.resource.ImageResource;
import se.prediktera.map.common.swing.filechooser.jopensaveDialog;
import se.prediktera.map.common.update.UpdateHelper;
import se.prediktera.map.dataimport.ImportHelper;
import se.prediktera.map.datasetcontainer.Case;
import se.prediktera.map.datasetcontainer.DataContainer;
import se.prediktera.map.datasetcontainer.DataTreeInterface;
import se.prediktera.map.datasetcontainer.database.DataBaseControl;
import se.prediktera.map.datasetcontainer.datainfo.AbstractDataInfo;
import se.prediktera.map.datasetcontainer.datainfo.DataGroupValues;
import se.prediktera.map.datasetcontainer.datainfo.InnerColumnString;
import se.prediktera.map.datasetcontainer.dataset.DataSet;
import se.prediktera.map.main.Evince;
import se.prediktera.map.main.EvinceOptions;
import se.prediktera.map.main.IniManager;
import se.prediktera.map.main.Main_GUI_AboutDialog;
import se.prediktera.map.main.MenuBarMediator;
import se.prediktera.map.main.Project_GUI;
import se.prediktera.map.main.ProjectsContainer;
import se.prediktera.map.main.StatusBar;
import se.prediktera.map.main.hints.HintDialog;
import se.prediktera.map.main.layer.AbstractLayer;
import se.prediktera.map.main.layer.AbstractLayerPanel;
import se.prediktera.map.main.newproject.NewProjectWizard;
import se.prediktera.map.main.newproject.ProjectPreviewPanel;
import se.prediktera.map.main.script.EvinceScriptCommands;
import se.prediktera.map.main.script.FileDataClass;
import se.prediktera.map.main.script.LoadHelper;
import se.prediktera.map.main.script.ScriptFile;
import se.prediktera.map.main.script.ScriptManager;
import se.prediktera.map.main.script.download.ScriptDownloadWizard;
import se.prediktera.map.main.script.gui.ScriptFilePanel;
import se.prediktera.map.model.ModelManager;
import se.prediktera.map.plot.axisplot.AbstractAxisLayer;
import se.prediktera.map.plot.axisplot.settings.Color.ColorAdvanceFrame;
import se.prediktera.map.plot.axisplot.settings.ComboBoxColor;
import se.prediktera.map.plot.layout.AbstractPlotLayout;
import se.prediktera.map.register.RegInfo;
import se.prediktera.map.register.RegisterKeyManager;
import se.prediktera.map.register.wizard.RegisterWizard;

public class Main_GUI
extends JFrame {
    public static final int UPDATETREE = 0;
    private static String MAINTITLE = "Prediktera Evince";
    private static Main_GUI main;
    private String titleposttext = "";
    private long lasttimestamp;
    private final MenuBarMediator menuBarMediator = new MenuBarMediator();
    private final CMenu jMenuFile = new CMenu(false);
    private final CMenu jMenuTools = new CMenu("Tools", false);
    private final CMenuItem jMenuFileSave = new CMenuItem("Save", 83);
    private final CMenuItem jMenuFileSaveAs = new CMenuItem("Save As...", 65);
    private final CMenu jMenuFileApplyTemplate = new CMenu("Apply Template", true);
    private final CMenuItem jMenuFileImportTemplates = new CMenuItem("Import Template(s)", true);
    private final CMenuItem jMenuDownloadTemplates = new CMenuItem("Download Template(s)", true);
    private final CMenuItem jMenuFileClose = new CMenuItem("Close Project", 87);
    private final CMenuItem jMenuFileCloseAll = new CMenuItem("Close All Projects", true);
    private final CMenu jMenuWindows = new CMenu(false);
    private final CMenuItem jMenuHelpTopics = new CMenuItem("Help Topics", 84);
    private final StatusBar statusBar = new StatusBar();
    private final ProjectsContainer projectsContainer = new ProjectsContainer();
    private UpdateThread updateThread;
    private HelpSet rootHelpSet;
    private DefaultHelpBroker helpBroker;
    private ActionListener helpListener;
    private final boolean isfree = false;
    private boolean terminateOnExit = true;
    private boolean closeProjectsOnExit = true;
    private boolean closeWithHide = false;
    private final boolean iscalculating = false;
    private final int menusize = 16;

    public static Main_GUI get() {
        return main;
    }

    public static StatusBar getStatusBar() {
        if (main != null) {
            return Main_GUI.main.statusBar;
        }
        return null;
    }

    public static void reloadAllDataTrees(DataTreeInterface dataTreeInterface) {
        if (main != null) {
            main.reloadAllDataTreesInternal(dataTreeInterface);
        }
    }

    public static void resetStatusMessage() {
        if (main != null) {
            Main_GUI.main.statusBar.resetStatusMessage();
        }
    }

    public static void setHelpWindow(CleanUpDialog cleanUpDialog) {
        if (main != null) {
            main.setHelpWindowIntern(cleanUpDialog);
        }
    }

    public static void setStatusMessage(StatusBar.MessageType messageType, String string, int n) {
        if (main != null) {
            try {
                Main_GUI.main.statusBar.setStatusMessage(messageType, string, n);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static void showHelp(ActionEvent actionEvent) {
        if (main == null) {
            try {
                URL uRL = Paths.get("Help/Evince.hs", new String[0]).toUri().toURL();
                HelpSet helpSet = new HelpSet(null, uRL);
                HelpBroker helpBroker = helpSet.createHelpBroker();
                CSH.DisplayHelpFromSource displayHelpFromSource = new CSH.DisplayHelpFromSource(helpBroker);
                displayHelpFromSource.actionPerformed(actionEvent);
            }
            catch (MalformedURLException | HelpSetException throwable) {
                ErrorHandler.logAndReportException("Evince cannot create help system", throwable);
            }
        } else {
            Main_GUI.main.helpListener.actionPerformed(actionEvent);
        }
    }

    private static void showAdvertDialog() {
        try {
            HintDialog hintDialog = new HintDialog("Prediktera Evince<br>World leading solution for chemical image analysis", (ImageResource)EvinceScriptCommands.getConstant("logo"));
            hintDialog.executeWizard();
        }
        catch (Exception exception) {
            ErrorHandler.logAndReportException(exception);
        }
    }

    private static void showHintDialog(boolean bl) {
        if (bl) {
            HintDialog hintDialog = new HintDialog(false);
            hintDialog.executeWizard();
            IniManager.setWindow((byte)0, hintDialog.showNextTime());
        }
    }

    public Main_GUI() {
        assert (main == null) : "Main_GUI already created!?!";
        main = this;
        this.jbInit();
    }

    public Main_GUI(boolean bl) {
        this(UpdateHelper.Product.Evince, bl);
    }

    public Main_GUI(UpdateHelper.Product product, boolean bl) {
        this.terminateOnExit = bl;
        if (main == null) {
            main = this;
            if (product.equals((Object)UpdateHelper.Product.Evince)) {
                Logg.trace("Setting Main_GUI.main to {}", this);
                this.updateTitlePostText();
                this.jbInit();
            }
        }
    }

    public void addFileToRecent(Project_GUI project_GUI) {
        this.projectsContainer.addFileToRecent(project_GUI.getProjectFile());
    }

    public void addProjectToDesktop(Project_GUI project_GUI, boolean bl) {
        this.projectsContainer.addProject(project_GUI, bl);
    }

    public void cleanUp() {
        if (this.updateThread != null) {
            this.updateThread.interrupt();
            this.updateThread = null;
        }
    }

    public void closeWithoutAsk() {
        if (!this.closeWithHide) {
            this.projectsContainer.close(false);
        }
    }

    public Project_GUI getCurrentProject() {
        return this.projectsContainer.getCurrentProject();
    }

    public static Project_GUI getOrCreateScriptProject() {
        Project_GUI project_GUI = Main_GUI.get().getCurrentProject();
        if (project_GUI == null) {
            return ScriptManager.setupScriptProject();
        }
        return project_GUI;
    }

    public void initHelp() {
        try {
            Path path = Paths.get("Help/Evince.hs", new String[0]);
            if (!path.toFile().exists()) {
                throw new FileNotFoundException();
            }
            URL uRL = path.toUri().toURL();
            this.rootHelpSet = new HelpSet(null, uRL);
            this.helpBroker = (DefaultHelpBroker)this.rootHelpSet.createHelpBroker();
            this.helpBroker.enableHelpKey((Component)this.getRootPane(), "Default", this.rootHelpSet);
            this.helpListener = new CSH.DisplayHelpFromSource((HelpBroker)this.helpBroker);
            this.jMenuHelpTopics.addActionListener(this.helpListener);
        }
        catch (MalformedURLException | HelpSetException throwable) {
            ErrorHandler.logAndReportException("Evince cannot create help system", throwable);
        }
        catch (FileNotFoundException fileNotFoundException) {
            Logg.warn("Help file not found", new Object[0]);
        }
    }

    public boolean isDemoLicense() {
        return RegisterKeyManager.getRegInfo().isDemoLicense();
    }

    public Project_GUI loadProject(ProgressManager progressManager, File file, boolean bl) throws Exception {
        progressManager.setInfoText("Opening project file " + file.getName());
        if (bl) {
            progressManager.setMaximumAndReset(1);
            progressManager.incStep();
        }
        RandomInputStream randomInputStream = new RandomInputStream(file, progressManager);
        Project_GUI project_GUI = new Project_GUI(progressManager, randomInputStream, bl);
        progressManager.setInfoText("Creating window");
        this.addProjectToDesktop(project_GUI, bl);
        randomInputStream.close();
        return project_GUI;
    }

    public void newProject(ActionEvent actionEvent, boolean bl) {
        if (actionEvent == null || actionEvent.getWhen() > this.lasttimestamp) {
            NewProjectWizard newProjectWizard = new NewProjectWizard(bl);
            Project_GUI project_GUI = null;
            if (this.isDemoLicense()) {
                project_GUI = newProjectWizard.createProject(this.projectsContainer);
            } else if (newProjectWizard.executeWizard() == 1) {
                project_GUI = newProjectWizard.createProject(this.projectsContainer);
                if (actionEvent != null) {
                    this.lasttimestamp = actionEvent.getWhen();
                }
            }
            if (project_GUI != null) {
                this.addProjectToDesktop(project_GUI, false);
            }
            newProjectWizard.cleanUp();
        }
    }

    public void openProject(ActionEvent actionEvent, boolean bl) {
        if (actionEvent == null || actionEvent.getWhen() != this.lasttimestamp) {
            jopensaveDialog jopensaveDialog2 = new jopensaveDialog("Select project to open" + (bl ? " (template)" : ""), this);
            File file = IniManager.getWorkDir((byte)0);
            if (file != null) {
                jopensaveDialog2.setCurrentDirectory(file);
            }
            jopensaveDialog2.addExtension("map", "Evince File (*.map)");
            jopensaveDialog2.addExtension("mdl", "Evince Model File (*.mdl)");
            jopensaveDialog2.addAllSupported();
            jopensaveDialog2.setCurrentDirectory(IniManager.getWorkDir((byte)0));
            jopensaveDialog2.setPreview(new ProjectPreviewPanel(), true);
            if (jopensaveDialog2.openshow()) {
                File file2 = jopensaveDialog2.getSelectedFile();
                String string = jopensaveDialog.getFileExtension(file2);
                try {
                    RandomInputStream randomInputStream = new RandomInputStream(file2, null);
                    randomInputStream.readFileFramework(false);
                    randomInputStream.close();
                    if (string.equals("map") || randomInputStream.getStartIndex((byte)9) > 0L) {
                        this.openProject(file2, bl);
                    } else if (string.equals("mdl")) {
                        this.openModel(file2);
                    }
                    if (!bl) {
                        IniManager.setWorkDir((byte)0, jopensaveDialog2.getCurrentDirectory());
                    }
                }
                catch (IOException iOException) {
                    ErrorHandler.logAndReportException(iOException);
                }
            }
            if (actionEvent != null) {
                this.lasttimestamp = actionEvent.getWhen();
            }
        }
    }

    public void openProject(final File file, final boolean bl) {
        for (int i = 0; i < this.projectsContainer.getNumberOfProject(); ++i) {
            Project_GUI project_GUI = this.projectsContainer.getProjectAt(i);
            File file2 = project_GUI.getProjectFile();
            if (file2 == null || !file2.equals(file)) continue;
            this.projectsContainer.setCurrentProject(project_GUI);
            return;
        }
        ProgressManagerImpl progressManagerImpl = new ProgressManagerImpl(this){
            final /* synthetic */ Main_GUI this$0;
            {
                this.this$0 = main_GUI;
            }

            @Override
            public Object doWork() {
                Project_GUI project_GUI = null;
                try {
                    project_GUI = this.this$0.loadProject(this, file, bl);
                    this.Finish();
                }
                catch (Project_GUI.AbortException abortException) {
                    this.Finish();
                    this.this$0.removeProjectFromDesktop(project_GUI);
                }
                catch (Exception exception) {
                    this.Finish();
                    ErrorHandler.logAndShowEvinceErrorDialogForException(exception);
                }
                return null;
            }
        };
        progressManagerImpl.invokeLater();
    }

    public void openProjectLink(AbstractDataInfo abstractDataInfo, int n, int n2) {
        String string;
        File file;
        boolean bl;
        String string2;
        int n3;
        InnerColumnString innerColumnString;
        DataGroupValues dataGroupValues;
        DataSet dataSet;
        if (abstractDataInfo != null && (dataSet = abstractDataInfo.getDataSet()) != null && !dataSet.isExternal() && (n & 1) == 1 && (dataGroupValues = abstractDataInfo.getGroupColumnByType(13)) != null && (innerColumnString = (InnerColumnString)dataGroupValues.getPrimaryColumn()) != null && (n3 = JOptionPane.showConfirmDialog(this, "This point is connected to an external " + (string2 = (bl = LoadHelper.isProjectFile(file = new File(string = innerColumnString.getValueLocal(n2)))) ? "project" : "file") + " (" + jopensaveDialog.getFileName(file) + ").\nDo you want to open this " + string2 + "?", "Open external " + string2, 0, 1)) == 0) {
            Main_GUI main_GUI = Main_GUI.get();
            if (bl) {
                main_GUI.openProject(file, false);
            } else {
                Project_GUI project_GUI = Project_GUI.createNewProject(false);
                if (project_GUI != null) {
                    Case case_ = project_GUI.getPrimaryCase();
                    ImportHelper.importData(project_GUI, case_, null, List.of(file), true);
                    this.addProjectToDesktop(project_GUI, false);
                }
            }
        }
    }

    public void rebuildToolsMenu(final Project_GUI project_GUI) {
        this.jMenuTools.removeAll();
        CRadioButtonMenuItem cRadioButtonMenuItem = new CRadioButtonMenuItem("Toggle Toolbar", true);
        if (project_GUI != null) {
            cRadioButtonMenuItem.setSelected(project_GUI.isToolbarVisible());
        } else {
            cRadioButtonMenuItem.setEnabled(false);
        }
        cRadioButtonMenuItem.addItemListener(itemEvent -> project_GUI.showToolbars(cRadioButtonMenuItem.isSelected()));
        this.jMenuTools.add(cRadioButtonMenuItem);
        CMenu cMenu = new CMenu("Layout", true);
        if (project_GUI != null) {
            project_GUI.addLayoutItems(cMenu);
        }
        this.jMenuTools.add(cMenu);
        CMenuItem cMenuItem = new CMenuItem(this, "Free Memory", 70){
            final /* synthetic */ Main_GUI this$0;
            {
                this.this$0 = main_GUI;
                super(string, n);
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                project_GUI.freeMemory();
            }
        };
        this.jMenuTools.add(cMenuItem);
        CMenuItem cMenuItem2 = new CMenuItem("Refresh Templates", true){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ScriptManager.clearScriptFileCache();
            }
        };
        this.jMenuTools.add(cMenuItem2);
        this.jMenuTools.addSeparator();
        CMenuItem cMenuItem3 = new CMenuItem("Open Script Editor", 80){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ScriptFilePanel.showAsFrame(false);
            }
        };
        this.jMenuTools.add(cMenuItem3);
        CMenuItem cMenuItem4 = new CMenuItem(this, "Project Properties", 80){
            final /* synthetic */ Main_GUI this$0;
            {
                this.this$0 = main_GUI;
                super(string, n);
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                project_GUI.getProperties().showModal();
            }
        };
        this.jMenuTools.add(cMenuItem4);
        this.jMenuTools.add(new CMenuItem("Options", 79){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                new EvinceOptions().showModal();
            }
        });
        if (project_GUI == null) {
            cMenu.setEnabled(false);
            cMenuItem.setEnabled(false);
            cMenuItem4.setEnabled(false);
        }
    }

    public void removeProjectFromDesktop(Project_GUI project_GUI) {
        if (project_GUI != null) {
            this.projectsContainer.removeProject(project_GUI, false);
        }
    }

    public void removeProjectNoClose(Project_GUI project_GUI) {
        this.projectsContainer.removeProjectNoClose(project_GUI);
    }

    public void saveSelectedFrame(boolean bl, boolean bl2) {
        Project_GUI project_GUI = this.projectsContainer.getCurrentProject();
        if (project_GUI != null) {
            this.projectsContainer.saveProject(project_GUI, bl, bl2);
            this.updateTitle(project_GUI);
        }
    }

    public ProjectsContainer getProjectsContainer() {
        return this.projectsContainer;
    }

    public void selectCurrentProject(Project_GUI project_GUI) {
        JMenuBar jMenuBar = project_GUI == null ? null : project_GUI.getProjectMenuBar();
        this.menuBarMediator.set(jMenuBar, 1);
        this.jMenuWindows.removeAllRemoveAble();
        JMenu jMenu = this.projectsContainer.getProjectMenu(!this.isDemoLicense());
        this.jMenuWindows.add(jMenu);
        MenuElement[] menuElementArray = jMenu.getSubElements();
        this.jMenuWindows.setVisible(menuElementArray.length > 0 && menuElementArray[0].getSubElements().length > 1);
        this.updateTitle(project_GUI);
        this.rebuildToolsMenu(project_GUI);
    }

    public void setCloseProjectsOnExit(boolean bl) {
        this.closeProjectsOnExit = bl;
    }

    public void setCloseWithHide(boolean bl) {
        this.closeWithHide = bl;
    }

    public void setCurrentProject(Project_GUI project_GUI) {
        this.projectsContainer.setCurrentProject(project_GUI);
    }

    public void setTerminateOnExit(boolean bl) {
        this.terminateOnExit = bl;
    }

    @Override
    public void setVisible(boolean bl) {
        if (bl && this.updateThread == null) {
            this.updateThread = new UpdateThread();
            this.updateThread.start();
        }
        super.setVisible(bl);
    }

    public void showAboutDialog() {
        Main_GUI_AboutDialog main_GUI_AboutDialog = new Main_GUI_AboutDialog(this);
        main_GUI_AboutDialog.setVisible(true);
        this.updateTitlePostText();
        this.updateTitle(this.projectsContainer.getCurrentProject());
    }

    public void showNow(String string, List<String> list, ScriptFile scriptFile) {
        this.setExtendedState(6);
        this.setVisible(true);
        Main_GUI.showHintDialog(false);
        File file = null;
        ArrayList<File> arrayList = new ArrayList<File>();
        if (string != null) {
            file = new File(string);
        }
        if (list != null && !list.isEmpty()) {
            for (String object : list) {
                File file2 = new File(object);
                if (!file2.exists()) {
                    JOptionPane.showConfirmDialog(this, "No such filename: " + file2.getAbsolutePath(), "Warning", -1, 2, null);
                    return;
                }
                arrayList.add(file2);
            }
        }
        if (file != null && file.exists()) {
            this.openProject(file, false);
            IniManager.setWorkDir((byte)0, file.getParentFile());
        } else if (arrayList != null && !arrayList.isEmpty()) {
            Case case_;
            Project_GUI project_GUI = Project_GUI.createNewProject(false);
            if (project_GUI != null && ImportHelper.importData(project_GUI, case_ = project_GUI.getPrimaryCase(), null, arrayList, scriptFile, true)) {
                this.addProjectToDesktop(project_GUI, false);
            }
            IniManager.setWorkDir((byte)1, ((File)arrayList.get(0)).getParentFile());
        } else if (!Evince.updateDialogVisible()) {
            this.newProject(null, false);
        }
    }

    public void thisWindowClosing() {
        if (this.closeWithHide) {
            this.setVisible(false);
        } else if (!this.closeProjectsOnExit || this.projectsContainer.close()) {
            SwingUtilities.invokeLater(() -> {
                IniManager.SaveIni();
                if (this.terminateOnExit) {
                    DataBaseControl.SaveDataBases();
                    this.cleanUp();
                    System.exit(0);
                } else {
                    this.setVisible(false);
                }
            });
        }
    }

    public void UpdateProjectTrees() {
        for (int i = 0; i < this.projectsContainer.getNumberOfProject(); ++i) {
            this.projectsContainer.getProjectAt(i).updateDataTree(null);
        }
    }

    public void updateTitle(Project_GUI project_GUI) {
        if (UpdateHelper.Product.isRunningProductEvince()) {
            if (project_GUI == null) {
                this.setTitle(MAINTITLE + this.titleposttext);
            } else {
                this.setTitle(MAINTITLE + " - " + project_GUI.getGUI_Name() + this.titleposttext);
            }
            boolean bl = project_GUI != null && !this.isDemoLicense();
            this.jMenuFileClose.setEnabled(bl);
            this.jMenuFileCloseAll.setEnabled(bl);
            this.jMenuFileSave.setEnabled(bl && project_GUI.hasProjectChanged());
            this.jMenuFileSaveAs.setEnabled(bl);
        }
    }

    @Override
    protected void processWindowEvent(WindowEvent windowEvent) {
        if (windowEvent.getID() == 201) {
            this.thisWindowClosing();
        } else {
            super.processWindowEvent(windowEvent);
        }
    }

    void updateRecentFiles() {
        Object object;
        for (int i = 0; i < this.jMenuFile.getItemCount(); ++i) {
            if (!(this.jMenuFile.getItem(i) instanceof CMenuItem) || !((object = ((CMenuItem)this.jMenuFile.getItem(i)).getObject()) instanceof File)) continue;
            while (object instanceof File) {
                this.jMenuFile.remove(i);
                CMenuItem cMenuItem = (CMenuItem)this.jMenuFile.getItem(i);
                if (cMenuItem == null) {
                    object = null;
                    continue;
                }
                object = cMenuItem.getObject();
            }
        }
        ActionListener actionListener = actionEvent -> {
            CMenuItem cMenuItem = (CMenuItem)actionEvent.getSource();
            this.openProject((File)cMenuItem.getObject(), false);
        };
        object = this.projectsContainer.getRecentVector();
        if (object.size() > 0 && this.jMenuFile.getItemCount() < (RegisterKeyManager.isPredikteraLicense() ? 17 : 16)) {
            this.jMenuFile.insertSeparator(this.jMenuFile.getItemCount() - 2);
        }
        int n = this.jMenuFile.getItemCount();
        boolean bl = !this.isDemoLicense();
        int n2 = object.size() - Math.min(object.size(), 10);
        try {
            for (int i = object.size() - n2 - 1; i >= 0; --i) {
                File file = (File)object.get(i);
                if (file == null) continue;
                CMenuItem cMenuItem = new CMenuItem((Object)file, file.getName());
                cMenuItem.setToolTipText(file.getPath());
                cMenuItem.setEnabled(bl);
                cMenuItem.setEmptyIcon();
                cMenuItem.addActionListener(actionListener);
                this.jMenuFile.insert(cMenuItem, n - 2);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private JMenu createFileMenu() {
        this.jMenuFile.setText("File");
        this.jMenuFile.setMnemonic('F');
        CMenuItem cMenuItem = new CMenuItem("New Project", 78);
        cMenuItem.setEnabled(!this.isDemoLicense());
        CMenuItem cMenuItem2 = new CMenuItem("Open Project", 79);
        cMenuItem2.setEnabled(!this.isDemoLicense());
        CMenuItem cMenuItem3 = new CMenuItem("Exit", 120);
        CMenu cMenu = new CMenu("Template", true);
        cMenu.setVisible(false);
        CMenuItem cMenuItem4 = new CMenuItem("Save As Template", 84);
        cMenuItem4.setEnabled(!this.isDemoLicense());
        CMenuItem cMenuItem5 = new CMenuItem("Open as Template", 84);
        cMenuItem5.setEnabled(!this.isDemoLicense());
        cMenuItem.setIcon(new ImageIcon(Main_GUI.class.getResource("gif/new.gif")));
        cMenuItem.addActionListener(actionEvent -> this.newProject(actionEvent, true));
        cMenuItem.setAccelerator(Main_GUI.getCtrlStroke(78));
        cMenuItem2.setIcon(new ImageIcon(Main_GUI.class.getResource("icons/common/openFile.png")));
        cMenuItem2.addActionListener(actionEvent -> this.openProject(actionEvent, false));
        cMenuItem2.setAccelerator(Main_GUI.getCtrlStroke(79));
        cMenuItem5.addActionListener(actionEvent -> this.openProject(actionEvent, true));
        this.jMenuFileSave.setEnabled(false);
        this.jMenuFileSave.setIcon(new ImageIcon(Main_GUI.class.getResource("icons/common/saveFile.png")));
        this.jMenuFileSave.addActionListener(actionEvent -> this.saveSelectedFrame(false, false));
        this.jMenuFileSave.setAccelerator(Main_GUI.getCtrlStroke(83));
        this.jMenuFileSaveAs.setEnabled(false);
        this.jMenuFileSaveAs.addActionListener(actionEvent -> this.saveSelectedFrame(true, false));
        cMenuItem4.addActionListener(actionEvent -> this.saveSelectedFrame(true, true));
        ScriptManager.addScriptToMenu(this.jMenuFileApplyTemplate, null, null, "custom", "");
        this.jMenuFileImportTemplates.addActionListener(actionEvent -> {
            jopensaveDialog jopensaveDialog2 = new jopensaveDialog("Select Template file(s)", this);
            jopensaveDialog2.addExtension(new String[]{"xml", "txt"}, "Evince Template file");
            jopensaveDialog2.setMultiSelectionEnabled(true);
            jopensaveDialog2.setApproveButtonText("Import");
            if (jopensaveDialog2.openshow()) {
                File[] fileArray = jopensaveDialog2.getSelectedFiles();
                try {
                    File file = IniManager.getScriptDir();
                    for (File file2 : fileArray) {
                        FileDataClass.copyFile(file2, file.getAbsolutePath());
                    }
                    ScriptManager.clearScriptFileCache();
                    JOptionPane.showConfirmDialog(this, "Template file(s) successfully imported", "Import", -1, 1);
                }
                catch (Exception exception) {
                    ErrorHandler.logAndReportException(exception);
                }
            }
        });
        this.jMenuDownloadTemplates.addActionListener(actionEvent -> {
            ScriptDownloadWizard scriptDownloadWizard = new ScriptDownloadWizard();
            if (scriptDownloadWizard.executeWizard() == 1) {
                scriptDownloadWizard.download();
                ScriptManager.clearScriptFileCache();
                JOptionPane.showConfirmDialog(this, "Template file(s) successfully downloaded", "Download", -1, 1);
            }
        });
        this.jMenuFileClose.setEnabled(false);
        this.jMenuFileClose.addActionListener(actionEvent -> {
            this.projectsContainer.removeProject(this.projectsContainer.getCurrentProject());
            if (this.projectsContainer.isEmpty()) {
                this.newProject(null, false);
            }
        });
        this.jMenuFileClose.setAccelerator(Main_GUI.getCtrlStroke(87));
        this.jMenuFileCloseAll.setEnabled(false);
        this.jMenuFileCloseAll.addActionListener(actionEvent -> {
            this.projectsContainer.removeAllProjects();
            if (this.projectsContainer.isEmpty()) {
                this.newProject(null, false);
            }
        });
        this.jMenuFileCloseAll.setAccelerator(KeyStroke.getKeyStroke(87, Main_GUI.getCntrKey() | 1));
        cMenuItem3.addActionListener(actionEvent -> this.thisWindowClosing());
        this.jMenuWindows.setText("Windows");
        this.jMenuWindows.setMnemonic('W');
        this.statusBar.setBorder(BorderFactory.createLoweredBevelBorder());
        this.statusBar.setMinimumSize(new Dimension(10, 20));
        this.statusBar.setPreferredSize(new Dimension(10, 20));
        this.jMenuFile.add(cMenuItem);
        this.jMenuFile.add(cMenuItem2);
        this.jMenuFile.addSeparator();
        this.jMenuFile.add(this.jMenuFileClose);
        this.jMenuFile.add(this.jMenuFileCloseAll);
        this.jMenuFile.addSeparator();
        this.jMenuFile.add(this.jMenuFileSave);
        this.jMenuFile.add(this.jMenuFileSaveAs);
        this.jMenuFile.addSeparator();
        this.jMenuFile.add(this.jMenuFileApplyTemplate);
        this.jMenuFile.add(this.jMenuFileImportTemplates);
        this.jMenuFile.add(this.jMenuDownloadTemplates);
        this.jMenuFile.add(cMenu);
        cMenu.add(cMenuItem5);
        cMenu.add(cMenuItem4);
        this.jMenuFile.addSeparator();
        this.jMenuFile.add(cMenuItem3);
        return this.jMenuFile;
    }

    private JMenuBar createHelpMenu() {
        CMenu cMenu = new CMenu(false);
        cMenu.setText("Help");
        cMenu.setMnemonic('H');
        CMenuItem cMenuItem = new CMenuItem("Check for Updates", 85);
        CMenuItem cMenuItem2 = new CMenuItem("Edit License", 69);
        CMenuItem cMenuItem3 = new CMenuItem("About", 65);
        CMenuItem cMenuItem4 = new CMenuItem("Send Comments/Error Report", 67);
        this.jMenuHelpTopics.setAccelerator(KeyStroke.getKeyStroke("F1"));
        cMenuItem3.addActionListener(actionEvent -> this.showAboutDialog());
        cMenuItem2.setEnabled(true);
        cMenuItem2.addActionListener(actionEvent -> new RegisterWizard(RegisterKeyManager.getRegInfo()).executeWizard());
        cMenuItem.setEnabled(true);
        cMenuItem.addActionListener(actionEvent -> Evince.showUpdateInformation());
        cMenuItem2.setEnabled(true);
        cMenuItem4.addActionListener(actionEvent -> new ReportDialog(this).setVisible(true));
        cMenu.add(this.jMenuHelpTopics);
        cMenu.addSeparator();
        cMenu.add(cMenuItem);
        cMenu.add(cMenuItem2);
        cMenu.add(cMenuItem4);
        cMenu.addSeparator();
        cMenu.add(cMenuItem3);
        JMenuBar jMenuBar = new JMenuBar();
        jMenuBar.add(this.jMenuWindows);
        jMenuBar.add(cMenu);
        this.jMenuWindows.setVisible(false);
        return jMenuBar;
    }

    private void jbInit() {
        MAINTITLE = MAINTITLE + " " + InitClass.getEvinceVersion().format(false);
        System.setProperty("apple.laf.useScreenMenuBar", "true");
        ToolTipManager.sharedInstance().setDismissDelay(60000);
        this.rebuildToolsMenu(null);
        this.setDefaultCloseOperation(3);
        this.setSize(new Dimension(800, 600));
        this.setTitle(MAINTITLE + this.titleposttext);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                Main_GUI.this.thisWindowClosing();
            }
        });
        JMenuBar jMenuBar = new JMenuBar();
        jMenuBar.add(this.createFileMenu());
        jMenuBar.add(this.jMenuTools);
        this.jMenuTools.setMnemonic('T');
        JMenuBar jMenuBar2 = new JMenuBar();
        this.menuBarMediator.set(jMenuBar, 0);
        this.menuBarMediator.set(jMenuBar2, 2);
        this.menuBarMediator.set(this.createHelpMenu(), 3);
        this.setJMenuBar(this.menuBarMediator);
        JPanel jPanel = new JPanel(new BorderLayout());
        this.getContentPane().add((Component)jPanel, "Center");
        jPanel.add((Component)this.projectsContainer, "Center");
        jPanel.add((Component)this.statusBar, "South");
        this.updateRecentFiles();
    }

    private void openModel(final File file) {
        ProgressManagerImpl progressManagerImpl = new ProgressManagerImpl(this){
            final /* synthetic */ Main_GUI this$0;
            {
                this.this$0 = main_GUI;
            }

            @Override
            public Object doWork() {
                try {
                    this.setInfoText("Opening model file " + file.getName());
                    Project_GUI project_GUI = Project_GUI.createNewProject(false);
                    Iterator<Case> iterator = project_GUI.getCases();
                    while (iterator.hasNext()) {
                        Case case_ = iterator.next();
                        case_.cleanUp();
                    }
                    ModelManager.loadModelIntoProject(this, project_GUI, file);
                    this.setInfoText("Creating window");
                    this.this$0.addProjectToDesktop(project_GUI, false);
                    this.Finish();
                }
                catch (Exception exception) {
                    this.Finish();
                    ErrorHandler.logAndShowEvinceErrorDialogForException(exception);
                }
                return null;
            }
        };
        progressManagerImpl.invokeLater();
    }

    private void reloadAllDataTreesInternal(DataTreeInterface dataTreeInterface) {
        this.projectsContainer.reloadAllDataTrees(dataTreeInterface);
    }

    private void setHelpWindowIntern(CleanUpDialog cleanUpDialog) {
        if (this.helpBroker == null) {
            return;
        }
        if (cleanUpDialog == null) {
            this.helpBroker.setActivationWindow((Window)this);
        } else {
            this.helpBroker.enableHelpKey((Component)cleanUpDialog.getRootPane(), "Default", this.rootHelpSet);
            this.helpBroker.setActivationWindow((Window)cleanUpDialog);
        }
    }

    private void updateTitlePostText() {
        RegInfo regInfo = RegisterKeyManager.getRegInfo();
        if (regInfo.isTrialLicense()) {
            this.titleposttext = regInfo.getDaysLeftEvince() > 0 ? " [Trial " + regInfo.getDaysLeftEvince() + " days left]" : " [Trial expired]";
        } else if (regInfo.isDemoLicense()) {
            this.titleposttext = " [Demo]";
        } else if (regInfo.isProfessional()) {
            this.titleposttext = " [Professional]";
        } else if (regInfo.isArchived) {
            if (regInfo.getDaysLeftEvince() > 0 && regInfo.getDaysLeftEvince() < 11) {
                this.titleposttext = " [License revoked - will expire in " + regInfo.getDaysLeftEvince() + " days]";
            } else if (regInfo.getDaysLeftEvince() == 0) {
                this.titleposttext = " [License revoked as of today]";
            }
        }
    }

    public static KeyStroke getCtrlStroke(int n) {
        return KeyStroke.getKeyStroke(n, Main_GUI.getCntrKey());
    }

    public static int getCntrKey() {
        return Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx();
    }

    public static void updateColorScales(String string, boolean bl) {
        Main_GUI main_GUI = Main_GUI.get();
        Properties properties = new Properties();
        properties.put("colorscheme", string);
        properties.put("reverse", String.valueOf(bl));
        ProjectsContainer projectsContainer = main_GUI.getProjectsContainer();
        for (int i = 0; i < projectsContainer.getNumberOfProject(); ++i) {
            Project_GUI project_GUI = projectsContainer.getProjectAt(i);
            project_GUI.getProperties().setProperty("colorScale", string);
            DataContainer dataContainer = project_GUI.getPlot_GUI().getWindowContainer();
            for (int j = 0; j < dataContainer.getTreeNodeCount(); ++j) {
                AbstractPlotLayout abstractPlotLayout;
                JPanel jPanel;
                CleanUpInterface cleanUpInterface = dataContainer.getTreeNodeAt(j);
                if (!(cleanUpInterface instanceof AbstractPlotLayout) || !((jPanel = (abstractPlotLayout = (AbstractPlotLayout)cleanUpInterface).getSettingsPanel()) instanceof AbstractLayerPanel)) continue;
                cleanUpInterface = (AbstractLayerPanel)jPanel;
                for (int k = 0; k < ((AbstractLayerPanel)cleanUpInterface).getLayerCount(); ++k) {
                    AbstractLayer abstractLayer = ((AbstractLayerPanel)cleanUpInterface).getLayerAtRow(k);
                    if (!(abstractLayer instanceof AbstractAxisLayer)) continue;
                    AbstractAxisLayer abstractAxisLayer = (AbstractAxisLayer)abstractLayer;
                    ComboBoxColor comboBoxColor = (ComboBoxColor)abstractAxisLayer.getComboBox((byte)3);
                    ColorAdvanceFrame colorAdvanceFrame = (ColorAdvanceFrame)comboBoxColor.getAdvanceSettings();
                    colorAdvanceFrame.setProperties(properties);
                }
            }
        }
    }

    class UpdateThread
    extends Thread {
        UpdateThread() {
        }

        @Override
        public void run() {
            Runnable runnable = () -> {
                Main_GUI.this.projectsContainer.updateNow();
                Main_GUI.this.statusBar.updateMemInfo();
            };
            try {
                int n = 0;
                while (true) {
                    try {
                        SwingUtilities.invokeAndWait(runnable);
                    }
                    catch (InterruptedException | InvocationTargetException exception) {
                        // empty catch block
                    }
                    UpdateThread.sleep(1000L);
                    if (++n <= 3600) continue;
                    Main_GUI.this.projectsContainer.touchSwapFiles();
                    n = 0;
                }
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }
    }
}

