/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.main;

import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.apache.commons.lang3.SystemUtils;
import se.prediktera.map.InitClass;
import se.prediktera.map.common.cleanup.CleanUpDialog;
import se.prediktera.map.main.Evince;
import se.prediktera.map.register.RegInfo;
import se.prediktera.map.register.RegisterKeyManager;
import se.prediktera.map.register.wizard.RegisterWizard;

public class Main_GUI_AboutDialog
extends CleanUpDialog {
    public static final String COPYRIGHT = "Copyright \u00a9 2002-2025 Prediktera AB. All Rights Reserved";
    private JLabel aboutText;

    public static void main(String[] stringArray) {
        try {
            for (UIManager.LookAndFeelInfo lookAndFeelInfo : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(lookAndFeelInfo.getName())) continue;
                UIManager.setLookAndFeel(lookAndFeelInfo.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException exception) {
            Logger.getLogger(Main_GUI_AboutDialog.class.getName()).log(Level.SEVERE, null, exception);
        }
        EventQueue.invokeLater(() -> {
            Main_GUI_AboutDialog main_GUI_AboutDialog = new Main_GUI_AboutDialog(new JFrame());
            main_GUI_AboutDialog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent windowEvent) {
                    System.exit(0);
                }
            });
            main_GUI_AboutDialog.setVisible(true);
        });
    }

    public Main_GUI_AboutDialog(Frame frame) {
        super(frame, "About", true);
        this.initComponents();
        this.getContentPane().setBackground(Color.white);
        this.updateRegInfo();
        this.pack();
        this.setLocationRelativeTo(frame);
    }

    @Override
    protected void cleanUpChild() {
    }

    private void closeButtonActionPerformed(ActionEvent actionEvent) {
        this.dispose();
    }

    private void initComponents() {
        JLabel jLabel = new JLabel();
        this.aboutText = new JLabel();
        JPanel jPanel = new JPanel();
        JButton jButton = new JButton();
        JButton jButton2 = new JButton();
        this.setDefaultCloseOperation(2);
        this.setBackground(new Color(255, 255, 255));
        this.getContentPane().setLayout(new GridBagLayout());
        jLabel.setIcon(new ImageIcon(Evince.class.getResource("logo/prediktera_breeze_small.png")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(12, 48, 0, 48);
        this.getContentPane().add((Component)jLabel, gridBagConstraints);
        this.aboutText.setText("About text");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(12, 48, 12, 48);
        this.getContentPane().add((Component)this.aboutText, gridBagConstraints);
        jPanel.setOpaque(false);
        jPanel.setLayout(new GridBagLayout());
        jButton.setMnemonic('E');
        jButton.setText("Edit License");
        jButton.addActionListener(this::licenseButtonActionPerformed);
        jPanel.add((Component)jButton, new GridBagConstraints());
        jButton2.setMnemonic('C');
        jButton2.setText("Close");
        jButton2.addActionListener(this::closeButtonActionPerformed);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(12, 12, 12, 12);
        jPanel.add((Component)jButton2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        this.getContentPane().add((Component)jPanel, gridBagConstraints);
        this.pack();
    }

    private void licenseButtonActionPerformed(ActionEvent actionEvent) {
        new RegisterWizard(RegisterKeyManager.getRegInfo()).executeWizard();
        this.updateRegInfo();
    }

    private void updateRegInfo() {
        RegInfo regInfo = RegisterKeyManager.getRegInfo();
        StringBuilder stringBuilder = new StringBuilder("<html><body><h2>Evince ");
        stringBuilder.append(InitClass.GetVersionString());
        if (regInfo.isTrialLicense()) {
            stringBuilder.append(" [Trial License]");
        } else if (regInfo.isProfessional()) {
            stringBuilder.append(" [Professional]");
        }
        stringBuilder.append("</h2>");
        stringBuilder.append("Build#").append(InitClass.getBuild());
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("MMMM dd, yyyy");
        Optional<Date> optional = Optional.ofNullable(InitClass.getTimestamp());
        Instant instant = optional.map(Date::toInstant).orElse(Instant.now());
        LocalDateTime localDateTime = LocalDateTime.ofInstant(instant, ZoneId.systemDefault());
        stringBuilder.append(", built on ").append(dateTimeFormatter.format(localDateTime));
        stringBuilder.append("<br/><br/>");
        stringBuilder.append("Java Runtime version: ").append(SystemUtils.JAVA_RUNTIME_VERSION);
        stringBuilder.append("<br/>");
        stringBuilder.append("VM: ").append(SystemUtils.JAVA_VM_NAME).append(" by ").append(SystemUtils.JAVA_VM_VENDOR);
        stringBuilder.append("<br/>");
        stringBuilder.append("Architecture: ").append(SystemUtils.OS_ARCH);
        stringBuilder.append("<br/><br/>");
        stringBuilder.append(COPYRIGHT);
        stringBuilder.append("<br/>");
        if (regInfo.isTrialLicense()) {
            int n = regInfo.getDaysLeftEvince();
            stringBuilder.append("<i>[Trial ").append(n).append(" day");
            if (n > 1) {
                stringBuilder.append("s");
            }
            stringBuilder.append(" left]</i>");
        }
        stringBuilder.append("<br/>");
        stringBuilder.append("Licenced to:<br/>");
        if (regInfo.company != null) {
            stringBuilder.append(regInfo.company).append("<br/>");
        }
        if (regInfo.email != null) {
            stringBuilder.append(regInfo.email).append("<br/>");
        }
        stringBuilder.append("</body></html>");
        this.aboutText.setText(stringBuilder.toString());
    }
}

