/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.main;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import se.prediktera.map.common.CMenu;
import se.prediktera.map.common.CMenuItem;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.common.cleanup.CleanUpInterface;
import se.prediktera.map.common.cleanup.CleanUpPanel;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.common.progress.ProgressManagerImpl;
import se.prediktera.map.common.swing.flat.JFlatButton;
import se.prediktera.map.common.wizard.AbstractWizardInfo;
import se.prediktera.map.common.wizard.WizardInfoInterface;
import se.prediktera.map.components.paint.AbstractPaint;
import se.prediktera.map.datasetcontainer.Case;
import se.prediktera.map.datasetcontainer.DataContainer;
import se.prediktera.map.datasetcontainer.DataTreeInterface;
import se.prediktera.map.datasetcontainer.dataset.DataSet;
import se.prediktera.map.main.IniManager;
import se.prediktera.map.main.Project_GUI;
import se.prediktera.map.main.extclass.AbstractInfo;
import se.prediktera.map.main.extclass.ExtClassLoader;
import se.prediktera.map.main.window.AbstractWindow;
import se.prediktera.map.main.window.AbstractWindow_GUI;
import se.prediktera.map.model.AbstractModel;
import se.prediktera.map.model.AbstractModelContainerWindow;
import se.prediktera.map.model.modelgenerator.AbstractModelInfo;
import se.prediktera.map.model.modelgenerator.ModelGeneratorWizard;

public class Model_GUI
extends AbstractWindow_GUI {
    public Model_GUI(Project_GUI project_GUI, CMenu cMenu) {
        super(project_GUI, "Model_GUI", cMenu);
        project_GUI.setModel_GUI(this);
        JFlatButton jFlatButton = new JFlatButton();
        jFlatButton.setToolTipText("Start Model Wizard");
        jFlatButton.setIcon(AbstractPaint.createIcon(3));
        jFlatButton.addActionListener(actionEvent -> this.createWindowFromWizard(null, (WizardInfoInterface)null, false));
        this.northTitle.setText("Model - [No Model]");
        this.windowToolbar.add(jFlatButton);
        this.setAutoMode((byte)2);
    }

    public Model_GUI(RandomInputStream randomInputStream, Project_GUI project_GUI, ProgressManager progressManager, CMenu cMenu) throws IOException {
        this(project_GUI, cMenu);
    }

    public void addToPopupMenu(JMenu jMenu, DataSet dataSet) {
        for (int i = 0; i < this.windowContainer.size(); ++i) {
            AbstractModelContainerWindow abstractModelContainerWindow = (AbstractModelContainerWindow)this.windowContainer.getTreeNodeAt(i);
            abstractModelContainerWindow.addToPopupMenu(jMenu, dataSet);
        }
    }

    public void createModelWindows(Case case_) {
        List<AbstractInfo> list = ExtClassLoader.getAbstractInfoFromType(AbstractInfo.MODEL_INFO);
        for (AbstractModelInfo abstractModelInfo : list) {
            AbstractModelContainerWindow abstractModelContainerWindow;
            String string = abstractModelInfo.getType();
            if (!string.equals("pca") && !string.equals("pls")) continue;
            String string2 = string.toUpperCase() + "-Models";
            DataContainer dataContainer = (DataContainer)case_.getNodeByName(string2);
            if (dataContainer == null) {
                dataContainer = new DataContainer(string2, 1);
                dataContainer.setVisibleInTree(false);
                case_.addTreeNode(dataContainer);
            }
            if ((abstractModelContainerWindow = (AbstractModelContainerWindow)this.getWindowByName(string2)) != null) {
                abstractModelContainerWindow.setInformationContainer(dataContainer, null);
                continue;
            }
            abstractModelContainerWindow = abstractModelInfo.createModelContainerWindow(case_, dataContainer);
            this.addWindow((AbstractWindow)abstractModelContainerWindow, false, true);
        }
        if (this.windowContainer.size() > 0) {
            this.selectWindow((AbstractModelContainerWindow)this.windowContainer.getTreeNodeAt(0));
        }
    }

    @Override
    public DataContainer createWindowContainer() {
        return new DataContainer("Models", 4);
    }

    public AbstractWindow createWindowFromWizard(DataTreeInterface dataTreeInterface, AbstractModel abstractModel) {
        return this.createWindowFromWizard(dataTreeInterface, abstractModel, false);
    }

    public AbstractWindow createWindowFromWizard(DataTreeInterface dataTreeInterface, final AbstractModel abstractModel, boolean bl) {
        AbstractWindow abstractWindow = null;
        AbstractModelInfo abstractModelInfo = (AbstractModelInfo)abstractModel.getInfo();
        if (abstractModelInfo != null) {
            abstractModelInfo.setBaseModel(abstractModel);
        }
        ModelGeneratorWizard modelGeneratorWizard = new ModelGeneratorWizard(this, this.windowContainer, dataTreeInterface, abstractModelInfo);
        if ((bl || modelGeneratorWizard.executeWizard() == 1) && modelGeneratorWizard.checkModel(bl)) {
            ProgressManagerImpl progressManagerImpl = new ProgressManagerImpl(this, new Object[]{modelGeneratorWizard}){
                final /* synthetic */ Model_GUI this$0;
                {
                    this.this$0 = model_GUI;
                    super(objectArray);
                }

                @Override
                public Object doWork() {
                    Project_GUI project_GUI = this.this$0.project_GUI;
                    AbstractWindow abstractWindow = null;
                    try {
                        ModelGeneratorWizard modelGeneratorWizard = (ModelGeneratorWizard)this.arguments[0];
                        abstractWindow = modelGeneratorWizard.createModel(this, abstractModel);
                        if (!this.this$0.hasWindow(abstractWindow)) {
                            this.this$0.addWindow(abstractWindow, false);
                            project_GUI.updateDataTree(null);
                        }
                        project_GUI.setProjectChanged();
                    }
                    catch (Exception exception) {
                        ErrorHandler.logAndShowEvinceErrorDialogForException(exception);
                    }
                    return abstractWindow;
                }
            };
            progressManagerImpl.invokeNow();
            abstractWindow = (AbstractWindow)progressManagerImpl.getResult();
        }
        modelGeneratorWizard.cleanUp();
        return abstractWindow;
    }

    @Override
    public AbstractWindow createWindowFromWizard(DataTreeInterface dataTreeInterface, WizardInfoInterface wizardInfoInterface) {
        return this.createWindowFromWizard(dataTreeInterface, wizardInfoInterface, false);
    }

    public AbstractWindow createWindowFromWizard(DataTreeInterface dataTreeInterface, WizardInfoInterface wizardInfoInterface, boolean bl) {
        CleanUpInterface cleanUpInterface;
        AbstractWindow abstractWindow = null;
        if (wizardInfoInterface != null && this.getModelByType((DataSet)(cleanUpInterface = (DataSet)dataTreeInterface), wizardInfoInterface.toString()) != null) {
            int n = JOptionPane.showConfirmDialog(IniManager.getMainFrame(), "A model of this type already exists. Press OK to clone dataset and create new model", "Model already exists", 2);
            if (n == 2) {
                return null;
            }
            dataTreeInterface = ((DataSet)cleanUpInterface).cloneAndShowDataSet(ProgressManager.createEmpty(), this.project_GUI);
            if (dataTreeInterface == null) {
                return null;
            }
        }
        cleanUpInterface = new ModelGeneratorWizard(this, this.windowContainer, dataTreeInterface, (AbstractModelInfo)wizardInfoInterface);
        if ((bl || ((ModelGeneratorWizard)cleanUpInterface).executeWizard() == 1) && ((ModelGeneratorWizard)cleanUpInterface).checkModel(bl)) {
            ProgressManagerImpl progressManagerImpl = new ProgressManagerImpl(new Object[]{cleanUpInterface}){

                @Override
                public Object doWork() {
                    Project_GUI project_GUI = Model_GUI.this.project_GUI;
                    AbstractWindow abstractWindow = null;
                    try {
                        ModelGeneratorWizard modelGeneratorWizard = (ModelGeneratorWizard)this.arguments[0];
                        abstractWindow = modelGeneratorWizard.createModel(this);
                        if (abstractWindow instanceof AbstractModelContainerWindow) {
                            ((AbstractModelContainerWindow)abstractWindow).selectLastModel();
                        }
                        if (abstractWindow != null && !Model_GUI.this.hasWindow(abstractWindow)) {
                            Model_GUI.this.addWindow(abstractWindow, false);
                            project_GUI.updateDataTree(null);
                        }
                        project_GUI.setProjectChanged();
                    }
                    catch (Exception exception) {
                        ErrorHandler.logAndShowEvinceErrorDialogForException(exception);
                    }
                    return abstractWindow;
                }
            };
            progressManagerImpl.invokeNow();
            abstractWindow = (AbstractWindow)progressManagerImpl.getResult();
        }
        ((CleanUpPanel)cleanUpInterface).cleanUp();
        return abstractWindow;
    }

    private AbstractModel getModelByType(DataSet dataSet, String string) {
        String string2 = string.substring(0, 3).toLowerCase();
        for (int i = 0; i < dataSet.getTreeNodeCount(); ++i) {
            AbstractModel abstractModel;
            Object object = dataSet.getTreeNodeAt(i);
            if (!(object instanceof AbstractModel) || !((String)(object = (abstractModel = (AbstractModel)object).getModelName().substring(0, 3).toLowerCase())).startsWith(string2)) continue;
            return abstractModel;
        }
        return null;
    }

    @Override
    public Object[] createWindowList() {
        Object[] objectArray = super.createWindowList();
        ArrayList<AbstractModel> arrayList = new ArrayList<AbstractModel>();
        for (Object object : objectArray) {
            AbstractModelContainerWindow abstractModelContainerWindow = (AbstractModelContainerWindow)object;
            DataContainer dataContainer = abstractModelContainerWindow.getDataContainer();
            for (int i = 0; i < dataContainer.getTreeNodeCount(); ++i) {
                DataTreeInterface dataTreeInterface = dataContainer.getTreeNodeAt(i);
                if (!(dataTreeInterface instanceof AbstractModel)) continue;
                arrayList.add((AbstractModel)dataTreeInterface);
            }
        }
        return arrayList.toArray();
    }

    @Override
    public void dataDropped(DataTreeInterface dataTreeInterface, int n) {
        AbstractModelContainerWindow abstractModelContainerWindow = (AbstractModelContainerWindow)this.getCurrentWindow();
        if (dataTreeInterface instanceof DataSet && abstractModelContainerWindow != null) {
            this.createWindowFromWizard(dataTreeInterface, abstractModelContainerWindow.createModelInfo());
        }
    }

    @Override
    public void DataTreeSelected(DataTreeInterface dataTreeInterface) {
    }

    @Override
    public String getAreaName() {
        return "Model area";
    }

    public AbstractModelContainerWindow getContainerWindow(AbstractModel abstractModel) {
        if (abstractModel == null) {
            return null;
        }
        AbstractModel abstractModel2 = abstractModel.getRootModel();
        for (int i = 0; i < this.windowContainer.size(); ++i) {
            AbstractModelContainerWindow abstractModelContainerWindow = (AbstractModelContainerWindow)this.windowContainer.getTreeNodeAt(i);
            DataContainer dataContainer = abstractModelContainerWindow.getDataContainer();
            if (!dataContainer.contains(abstractModel2)) continue;
            return abstractModelContainerWindow;
        }
        return null;
    }

    @Override
    public String getGUI_Name() {
        return "Model";
    }

    public CMenu getModelMenu(DataTreeInterface dataTreeInterface) {
        CMenu cMenu = new CMenu("New Model", false);
        cMenu.setIcon(AbstractModel.modelIcon);
        Vector<AbstractWizardInfo> vector = new Vector<AbstractWizardInfo>();
        ModelGeneratorWizard.addExternModels(this, vector, dataTreeInterface, false);
        if (vector.isEmpty()) {
            JMenuItem jMenuItem = new JMenuItem("Matrix Contains No Data");
            jMenuItem.setEnabled(false);
            cMenu.add(jMenuItem);
            return cMenu;
        }
        if (vector.size() > 1) {
            CMenuItem cMenuItem = new CMenuItem(dataTreeInterface);
            cMenuItem.setText("Wizard");
            cMenuItem.addActionListener(actionEvent -> {
                CMenuItem cMenuItem = (CMenuItem)actionEvent.getSource();
                DataTreeInterface dataTreeInterface = (DataTreeInterface)cMenuItem.getObject();
                this.createWindowFromWizard(dataTreeInterface, (WizardInfoInterface)null);
            });
            cMenu.add(cMenuItem);
            cMenu.addSeparator();
        }
        for (int i = 0; i < vector.size(); ++i) {
            AbstractModelInfo abstractModelInfo = (AbstractModelInfo)vector.elementAt(i);
            CMenuItem cMenuItem = new CMenuItem((Object)abstractModelInfo, dataTreeInterface);
            cMenuItem.addActionListener(actionEvent -> {
                CMenuItem cMenuItem = (CMenuItem)actionEvent.getSource();
                AbstractModelInfo abstractModelInfo = (AbstractModelInfo)cMenuItem.getObject();
                DataTreeInterface dataTreeInterface = (DataTreeInterface)cMenuItem.getObject2();
                this.createWindowFromWizard(dataTreeInterface, abstractModelInfo);
            });
            cMenuItem.setEnabled(abstractModelInfo.supportData(dataTreeInterface));
            cMenu.add(cMenuItem);
        }
        return cMenu;
    }

    public AbstractModelContainerWindow getModelWindow(AbstractModelInfo abstractModelInfo) {
        for (int i = 0; i < this.windowContainer.size(); ++i) {
            AbstractModelContainerWindow abstractModelContainerWindow = (AbstractModelContainerWindow)this.windowContainer.getTreeNodeAt(i);
            if (!abstractModelContainerWindow.supportInfo(abstractModelInfo)) continue;
            return abstractModelContainerWindow;
        }
        return null;
    }

    @Override
    public String getTitle(AbstractWindow abstractWindow) {
        if (abstractWindow == null) {
            return "Model - [No Model]";
        }
        return "Model - [" + abstractWindow.getGUI_Name() + "]";
    }

    @Override
    public ImageIcon getWindowIcon() {
        return AbstractModel.modelViewIcon;
    }

    @Override
    public void guiSelected() {
        AbstractWindow abstractWindow = this.getCurrentWindow();
        if (abstractWindow instanceof AbstractModelContainerWindow) {
            this.project_GUI.setSelectedWindow(abstractWindow);
        } else {
            this.project_GUI.setSelectedWindow(null);
        }
    }

    public void PurgeSignal() {
        this.PostGlobalMessage((byte)0, (byte)0);
    }

    @Override
    public void Save(RandomOutputStream randomOutputStream) throws IOException {
    }

    public void selectModel(AbstractModel abstractModel) {
        for (int i = 0; i < this.windowContainer.size(); ++i) {
            AbstractModelContainerWindow abstractModelContainerWindow = (AbstractModelContainerWindow)this.windowContainer.getTreeNodeAt(i);
            DataContainer dataContainer = abstractModelContainerWindow.getDataContainer();
            if (abstractModel == null) {
                abstractModelContainerWindow.selectInformation(null);
                continue;
            }
            if (!dataContainer.contains(abstractModel)) continue;
            this.selectWindow(abstractModelContainerWindow);
            abstractModelContainerWindow.selectInformation(abstractModel);
        }
    }

    @Override
    public void setWindowProperties(JPanel jPanel, boolean bl) {
    }

    public boolean supportModel(AbstractModelInfo abstractModelInfo) {
        return this.getModelWindow(abstractModelInfo) != null;
    }

    @Override
    public boolean supportVersion(long l) {
        return true;
    }
}

