/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.main;

import java.awt.Color;
import java.awt.Component;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.help.CSH;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.border.Border;
import se.prediktera.map.InitClass;
import se.prediktera.map.common.CMenu;
import se.prediktera.map.common.CMenuItem;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.common.cleanup.CleanUpPanel;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.common.swing.flat.JFlatButton;
import se.prediktera.map.common.wizard.AbstractWizardInfo;
import se.prediktera.map.common.wizard.WizardInfoInterface;
import se.prediktera.map.components.paint.AbstractPaint;
import se.prediktera.map.datasetcontainer.Case;
import se.prediktera.map.datasetcontainer.DataContainer;
import se.prediktera.map.datasetcontainer.DataTreeInterface;
import se.prediktera.map.datasetcontainer.DataTreeManager;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.main.ColorScalesHelper;
import se.prediktera.map.main.Main_GUI;
import se.prediktera.map.main.Project_GUI;
import se.prediktera.map.main.script.EvinceScriptCommands;
import se.prediktera.map.main.script.ScriptManager;
import se.prediktera.map.main.window.AbstractWindow;
import se.prediktera.map.main.window.AbstractWindowInfo;
import se.prediktera.map.main.window.AbstractWindow_GUI;
import se.prediktera.map.plot.AbstractPlot;
import se.prediktera.map.plot.PlotInit;
import se.prediktera.map.plot.axisplot.AbstractAxisPlotInfo;
import se.prediktera.map.plot.axisplot.settings.Color.PlotContinuousColor;
import se.prediktera.map.plot.layout.AbstractPlotLayout;
import se.prediktera.map.plot.plotgenerator.PlotGeneratorWizard;

public class Plot_GUI
extends AbstractWindow_GUI {
    public static final String[] RGB_NAMES = new String[]{"Red", "Green", "Blue", "Alpha"};
    private static ColorScalesHelper csh = ColorScalesHelper.getInstance();
    private final Border normalBorder = BorderFactory.createEmptyBorder(1, 1, 1, 1);
    private final Border dragBorder = BorderFactory.createLineBorder(Color.green);

    public static List<PlotContinuousColor> getColorScales() {
        return csh.getColorScales();
    }

    public static ColorScalesHelper getCsh() {
        return csh;
    }

    public Plot_GUI(Project_GUI project_GUI, CMenu cMenu) {
        super(project_GUI, "Plot_GUI", cMenu);
        this.jbInit();
    }

    public Plot_GUI(RandomInputStream randomInputStream, Project_GUI project_GUI, ProgressManager progressManager, CMenu cMenu) throws IOException {
        super(randomInputStream, project_GUI, progressManager, cMenu, "Plot_GUI");
        this.jbInit();
    }

    @Override
    public DataContainer createWindowContainer() {
        return new DataContainer("Plots", 5);
    }

    @Override
    public AbstractWindow createWindowFromWizard(DataTreeInterface dataTreeInterface, WizardInfoInterface wizardInfoInterface) {
        if (dataTreeInterface instanceof Case) {
            dataTreeInterface = ((Case)dataTreeInterface).getOriginalMatrix();
        }
        PlotGeneratorWizard plotGeneratorWizard = new PlotGeneratorWizard(this, dataTreeInterface);
        AbstractWindow abstractWindow = null;
        if ((wizardInfoInterface != null || plotGeneratorWizard.executeWizard() == 1) && (abstractWindow = plotGeneratorWizard.createWindow(this, (AbstractWindowInfo)wizardInfoInterface)) != null) {
            this.addWindow(abstractWindow, false);
        }
        plotGeneratorWizard.cleanUp();
        return abstractWindow;
    }

    @Override
    public void dataDropped(DataTreeInterface dataTreeInterface, int n) {
        CleanUpPanel cleanUpPanel;
        if (dataTreeInterface instanceof AbstractPlot) {
            cleanUpPanel = (AbstractPlot)dataTreeInterface;
            DataTreeManager.LoadIntoMemory(this.getProject_GUI(), (DataTreeInterface)((Object)cleanUpPanel), true);
            this.addWindow((AbstractWindow)cleanUpPanel, true);
        } else {
            AbstractWizardInfo abstractWizardInfo = null;
            if (n != 2) {
                String string = ScriptManager.getLastScriptName(this.getProject_GUI(), dataTreeInterface, "PLOT");
                ArrayList<AbstractWizardInfo> arrayList = new ArrayList<AbstractWizardInfo>();
                PlotGeneratorWizard.addExternPlots(arrayList, dataTreeInterface, "PlotArea");
                for (AbstractWizardInfo abstractWizardInfo2 : arrayList) {
                    String string2 = EvinceScriptCommands.removeSpace(abstractWizardInfo2.toString());
                    if (abstractWizardInfo != null && !string2.equals(string)) continue;
                    abstractWizardInfo = abstractWizardInfo2;
                }
            }
            this.createWindowFromWizard(dataTreeInterface, abstractWizardInfo);
        }
        cleanUpPanel = this.getDesktop();
        if (cleanUpPanel != null) {
            cleanUpPanel.setBorder(this.normalBorder);
        }
    }

    @Override
    public void DataTreeSelected(DataTreeInterface dataTreeInterface) {
    }

    @Override
    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        this.getDesktop().setBorder(this.dragBorder);
    }

    @Override
    public void dragExit(DropTargetEvent dropTargetEvent) {
        this.getDesktop().setBorder(this.normalBorder);
    }

    @Override
    public String getAreaName() {
        return "Plot area";
    }

    @Override
    public String getGUI_Name() {
        return "Plot";
    }

    public CMenu getPlotMenu(DataTreeInterface dataTreeInterface) {
        ActionListener actionListener;
        CMenu cMenu = new CMenu("New Plot", false);
        cMenu.setIcon(AbstractPlot.plotIcon);
        ArrayList<AbstractWizardInfo> arrayList = new ArrayList<AbstractWizardInfo>();
        PlotGeneratorWizard.addExternPlots(arrayList, dataTreeInterface, "PlotArea");
        if (arrayList.isEmpty()) {
            JMenuItem jMenuItem = new JMenuItem("Matrix Contains No Data");
            jMenuItem.setEnabled(false);
            cMenu.add(jMenuItem);
            return cMenu;
        }
        if (arrayList.size() > 1) {
            actionListener = new CMenuItem(dataTreeInterface);
            ((AbstractButton)((Object)actionListener)).setText("Wizard");
            ((AbstractButton)((Object)actionListener)).addActionListener(actionEvent -> {
                CMenuItem cMenuItem = (CMenuItem)actionEvent.getSource();
                DataTreeInterface dataTreeInterface = (DataTreeInterface)cMenuItem.getObject();
                this.createWindowFromWizard(dataTreeInterface, null);
            });
            cMenu.add((JMenuItem)((Object)actionListener));
        }
        cMenu.addSeparator();
        actionListener = actionEvent -> {
            AbstractAxisPlotInfo abstractAxisPlotInfo;
            CMenuItem cMenuItem = (CMenuItem)actionEvent.getSource();
            WizardInfoInterface wizardInfoInterface = (WizardInfoInterface)cMenuItem.getObject();
            DataTreeInterface dataTreeInterface = (DataTreeInterface)cMenuItem.getObject2();
            if (wizardInfoInterface instanceof AbstractAxisPlotInfo && (abstractAxisPlotInfo = (AbstractAxisPlotInfo)wizardInfoInterface).doFold() && abstractAxisPlotInfo.getInit(dataTreeInterface) instanceof PlotInit && dataTreeInterface instanceof AbstractDataMatrix && ((AbstractDataMatrix)dataTreeInterface).isFoldable()) {
                ((PlotInit)abstractAxisPlotInfo.getInit((DataTreeInterface)dataTreeInterface)).dofold = true;
            }
            this.createWindowFromWizard(dataTreeInterface, wizardInfoInterface);
        };
        for (AbstractWizardInfo abstractWizardInfo : arrayList) {
            CMenuItem cMenuItem = new CMenuItem((Object)abstractWizardInfo, dataTreeInterface);
            cMenuItem.addActionListener(actionListener);
            cMenu.add(cMenuItem);
        }
        return cMenu;
    }

    @Override
    public String getTitle(AbstractWindow abstractWindow) {
        if (abstractWindow == null) {
            return "Plot - [No Plot]";
        }
        return "Plot - [" + abstractWindow.getGUI_Name() + "]";
    }

    @Override
    public ImageIcon getWindowIcon() {
        return AbstractPlot.plotIcon;
    }

    @Override
    public void guiSelected() {
        if (this.project_GUI != null) {
            AbstractWindow abstractWindow = this.getCurrentWindow();
            if (abstractWindow instanceof AbstractPlotLayout) {
                this.project_GUI.setSelectedWindow(((AbstractPlotLayout)abstractWindow).getMainWindow());
            } else {
                this.project_GUI.setSelectedWindow(null);
            }
        }
    }

    @Override
    public boolean hasChanged() {
        return false;
    }

    @Override
    protected void loadLocal(MapProperty mapProperty) throws IOException {
    }

    @Override
    protected void saveLocal(RandomOutputStream randomOutputStream) throws IOException {
    }

    @Override
    protected boolean supportVersion(long l) {
        if ((long)InitClass.OldestPlotVersion.intValue() > l) {
            JOptionPane.showConfirmDialog(Main_GUI.get(), "This version of Evince does not support the opening of plots in older formats", "Plots not supported", -1, 1, null);
            return false;
        }
        return true;
    }

    private void jbInit() {
        this.getDesktop().setBorder(this.normalBorder);
        CSH.setHelpIDString((Component)this, (String)"evincePlot");
        if (this.project_GUI != null) {
            this.project_GUI.setPlot_GUI(this);
        }
        JFlatButton jFlatButton = new JFlatButton();
        jFlatButton.setToolTipText("Start Plot Wizard");
        jFlatButton.setIcon(AbstractPaint.createIcon(6));
        jFlatButton.addActionListener(actionEvent -> this.createWindowFromWizard(null, null));
        if (this.menu != null) {
            this.menu.add(jFlatButton.createMenuItem(null));
        }
        this.northTitle.setText("Plot - [No Plot]");
        this.windowToolbar.add(jFlatButton);
    }
}

