/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.main;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.Properties;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.common.cleanup.CleanUpPanel;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.main.AbstractGUI;
import se.prediktera.map.main.Evince;
import se.prediktera.map.main.ProjectPane;
import se.prediktera.map.main.ProjectToolbar;
import se.prediktera.map.main.Project_GUI;
import se.prediktera.map.main.script.ScriptHelper;
import se.prediktera.map.register.RegisterKeyManager;

public class ProjectLayout
extends CleanUpPanel {
    public static final byte TREE = 0;
    public static final byte GRAPH = 1;
    public static final byte DATA = 2;
    public static final byte PLOT = 3;
    public static final byte SETTINGS = 4;
    public static final byte HISTORY = 5;
    public static final byte MODEL = 6;
    public static final byte TREEPOS = 1;
    public static final byte GRAPHPOS = 2;
    public static final byte DATAPOS = 4;
    public static final byte PLOTPOS = 8;
    public static final byte SETTINGSPOS = 16;
    public static final byte HISTORYPOS = 32;
    public static final byte MODELPOS = 64;
    public static final String[] LAYOUT = new String[]{"datatree", "grapharea", "tablearea", "plotarea", "settings", "historyarea", "modelarea"};
    public static final byte DATAPLOT = 12;
    public static final byte GRAPHDATAPLOT = 14;
    public static final byte PANELS = 17;
    public static final byte DEFAULT = 29;
    private static final byte WEST = 0;
    private static final byte EAST = 1;
    private static final byte GDP = 2;
    private static final byte DP = 3;
    private static final byte HGDP = 4;
    private static final byte MHGDP = 5;
    private static final byte RESIZE_SUBPANELS = 0;
    private static final byte HIDE_SUBPANELS = 1;
    private static final double[] RESIZE_WEIGHT = new double[]{0.0, 1.0, 0.0, 0.5, 1.0, 0.0};
    private static final String[] SPLITPANE_NAMES = new String[]{"WEST", "EAST", "GDP", "DP", "HGDP", "MHGDP"};
    private static final int minsize = 10;
    private final ProjectSplitPane[] projectSplitPane = new ProjectSplitPane[6];
    private ProjectSplitPane rootSplitPane;
    private final ProjectPane[] projectPane = new ProjectPane[7];
    private byte projectTypes;
    private ProjectToolbar projectToolbar;
    private boolean isload = false;
    private Project_GUI project_GUI = null;

    public static void createTestFrame(MapProperty mapProperty) {
        ProjectLayout projectLayout = null;
        if (mapProperty == null) {
            projectLayout = new ProjectLayout(null);
        } else {
            try {
                projectLayout = new ProjectLayout(null, mapProperty);
            }
            catch (IOException iOException) {
                ErrorHandler.logAndReportException(iOException);
            }
        }
        JButton jButton = new JButton("Save and Open");
        ActionListenerTest actionListenerTest = new ActionListenerTest(projectLayout);
        jButton.addActionListener(actionListenerTest);
        JFrame jFrame = new JFrame();
        JPanel jPanel = new JPanel();
        jPanel.setBackground(Color.black);
        jPanel.setPreferredSize(new Dimension(200, 200));
        JPanel jPanel2 = new JPanel();
        jPanel2.setBackground(Color.yellow);
        jPanel2.setPreferredSize(new Dimension(100, 200));
        JPanel jPanel3 = new JPanel();
        jPanel3.setBackground(Color.white);
        jPanel3.setPreferredSize(new Dimension(200, 100));
        JPanel jPanel4 = new JPanel();
        jPanel4.setBackground(Color.blue);
        jPanel4.setPreferredSize(new Dimension(100, 100));
        JPanel jPanel5 = new JPanel();
        jPanel5.setBackground(Color.red);
        jPanel5.setPreferredSize(new Dimension(100, 100));
        JPanel jPanel6 = new JPanel();
        jPanel6.setBackground(Color.gray);
        jPanel6.setPreferredSize(new Dimension(200, 100));
        JPanel jPanel7 = new JPanel();
        jPanel7.setBackground(Color.cyan);
        jPanel7.setPreferredSize(new Dimension(200, 100));
        projectLayout.setProjectPane(jPanel, (byte)0);
        projectLayout.setProjectPane(jPanel2, (byte)4);
        projectLayout.setProjectPane(jPanel3, (byte)1);
        projectLayout.setProjectPane(jPanel4, (byte)2);
        projectLayout.setProjectPane(jPanel5, (byte)3);
        projectLayout.setProjectPane(jPanel6, (byte)5);
        projectLayout.setProjectPane(jPanel7, (byte)6);
        projectLayout.updateProjectTypes((byte)12);
        JPanel jPanel8 = (JPanel)jFrame.getContentPane();
        jPanel8.add((Component)projectLayout, "Center");
        jPanel8.add((Component)projectLayout.getToolbar(), "North");
        JPanel jPanel9 = new JPanel();
        jPanel9.add(jButton);
        jPanel9.add(actionListenerTest.getButton());
        jPanel8.add((Component)jPanel9, "South");
        jFrame.pack();
        jFrame.setLocationRelativeTo(null);
        jFrame.setVisible(true);
    }

    public static boolean isTypeDifferent(byte by, byte by2, byte by3) {
        return ProjectLayout.isTypeSelected(by, by3) == ProjectLayout.isTypeSelected(by2, by3);
    }

    public static boolean isTypeSelected(byte by, byte by2) {
        return (by & by2) == by2;
    }

    public static void main(String[] stringArray) {
        ProjectLayout.createTestFrame(null);
    }

    public static byte setTypeSelected(byte by, byte by2, boolean bl) {
        if (ProjectLayout.isTypeSelected(by, by2)) {
            by = (byte)(by - by2);
        }
        if (bl) {
            return (byte)(by | by2);
        }
        return by;
    }

    public ProjectLayout(Project_GUI project_GUI) {
        this.project_GUI = project_GUI;
        try {
            this.jbInit();
            this.updateProjectTypes((byte)29);
        }
        catch (Exception exception) {
            ErrorHandler.logAndReportException(exception);
        }
    }

    public ProjectLayout(Project_GUI project_GUI, MapProperty mapProperty) throws IOException {
        this.project_GUI = project_GUI;
        try {
            if (mapProperty.hasProperty("pT")) {
                this.projectTypes = mapProperty.getLVByte();
                this.jbInit();
                this.isload = true;
                for (int i = 0; i < this.projectSplitPane.length; ++i) {
                    mapProperty.setPrefix(String.valueOf(i));
                    this.projectSplitPane[i].LoadProperty(mapProperty);
                }
                mapProperty.setPrefix("");
                this.isload = false;
                if (!RegisterKeyManager.isPredikteraDevelopmentLicense() && (this.projectTypes & 0x20) != 0) {
                    this.projectTypes = (byte)(this.projectTypes - 32);
                    this.projectSplitPane[4].setDividerSize(0);
                    this.projectSplitPane[4].setLastDividerLocation(Integer.MAX_VALUE);
                    this.projectSplitPane[4].setDividerLocation(Integer.MAX_VALUE);
                }
            } else {
                this.jbInit();
                this.updateProjectTypes((byte)29);
            }
        }
        catch (Exception exception) {
            ErrorHandler.logAndReportException(exception);
        }
    }

    public ProjectPane getProjectPane(byte by) {
        return this.projectPane[by];
    }

    public byte getProjectTypes() {
        return this.projectTypes;
    }

    public ProjectToolbar getToolbar() {
        return this.projectToolbar;
    }

    public boolean isVisibleGUI(AbstractGUI abstractGUI) {
        for (ProjectPane projectPane : this.projectPane) {
            if (!abstractGUI.equals(projectPane.getCenterPanel())) continue;
            return projectPane.isTypeSelected(this.projectTypes);
        }
        return false;
    }

    public void printState() {
        System.out.println("STATE");
        for (ProjectSplitPane projectSplitPane : this.projectSplitPane) {
            projectSplitPane.printState();
        }
    }

    public void SaveProperty(RandomOutputStream randomOutputStream) throws IOException {
        randomOutputStream.writePropertyByte("pT", this.projectTypes);
        for (int i = 0; i < this.projectSplitPane.length; ++i) {
            randomOutputStream.setPrefix(String.valueOf(i));
            this.projectSplitPane[i].SaveProperty(randomOutputStream);
        }
        randomOutputStream.setPrefix("");
    }

    public void setProjectPane(JPanel jPanel, byte by) {
        this.projectPane[by].setCenterPanel(jPanel);
    }

    public void setProperties(Properties properties) throws Exception {
        if (ScriptHelper.hasKey(properties, "data_plot")) {
            int n = ScriptHelper.getPropertyInt(properties, "data_plot");
            this.projectSplitPane[3].setResizeWeight((double)n * 0.01);
            this.projectSplitPane[3].setDividerLocation((double)n * 0.01);
        } else if (ScriptHelper.hasKey(properties, "model")) {
            int n = ScriptHelper.getPropertyInt(properties, "model");
            this.projectSplitPane[5].setResizeWeight((double)n * 0.01);
            this.projectSplitPane[5].setDividerLocation((double)n * 0.01);
        }
    }

    public void updateLayout() {
        if (this.projectToolbar != null) {
            this.projectToolbar.updateLayout();
        }
    }

    public void updateProjectTypes(byte by) {
        if (this.projectTypes != by) {
            this.projectTypes = this.projectPane[1].setTypeSelected(this.projectTypes, ProjectLayout.isTypeSelected(by, (byte)2));
            this.projectTypes = this.projectPane[2].setTypeSelected(this.projectTypes, ProjectLayout.isTypeSelected(by, (byte)4));
            this.projectTypes = this.projectPane[3].setTypeSelected(this.projectTypes, ProjectLayout.isTypeSelected(by, (byte)8));
            this.projectTypes = this.projectPane[5].setTypeSelected(this.projectTypes, ProjectLayout.isTypeSelected(by, (byte)32));
            this.projectTypes = this.projectPane[6].setTypeSelected(this.projectTypes, ProjectLayout.isTypeSelected(by, (byte)64));
            this.projectTypes = this.projectPane[0].setTypeSelected(this.projectTypes, ProjectLayout.isTypeSelected(by, (byte)1));
            this.projectTypes = this.projectPane[4].setTypeSelected(this.projectTypes, ProjectLayout.isTypeSelected(by, (byte)16));
            this.rootSplitPane.updatePanels((byte)0);
            if (this.project_GUI != null) {
                this.project_GUI.setProjectChanged();
            }
        }
    }

    public void updateUnhideablePanels(int n) {
        if ((n & 1) == 0) {
            SwingUtilities.invokeLater(() -> {
                this.projectSplitPane[0].setDividerLocation(0);
                if ((n & 0x10) == 0) {
                    SwingUtilities.invokeLater(() -> this.projectSplitPane[1].setDividerLocation(Integer.MAX_VALUE));
                }
            });
        } else if ((n & 0x10) == 0) {
            SwingUtilities.invokeLater(() -> this.projectSplitPane[1].setDividerLocation(Integer.MAX_VALUE));
        }
    }

    @Override
    protected void cleanUpChild() {
        this.projectToolbar = null;
    }

    private void jbInit() throws Exception {
        byte by;
        for (by = 0; by < this.projectSplitPane.length; ++by) {
            this.projectSplitPane[by] = new ProjectSplitPane(RESIZE_WEIGHT[by]);
            this.projectSplitPane[by].setName(SPLITPANE_NAMES[by]);
        }
        this.projectToolbar = new ProjectToolbar(this, this.projectTypes);
        for (by = 0; by < (byte)this.projectPane.length; by = (byte)(by + 1)) {
            this.projectPane[by] = new ProjectPane(by);
        }
        this.setLayout(new BorderLayout());
        this.projectSplitPane[0].setUnhideable();
        this.projectSplitPane[1].setUnhideable();
        this.projectSplitPane[1].setResizeWeight(1.0);
        this.projectSplitPane[5].setOrientation(0);
        this.projectSplitPane[4].setOrientation(0);
        this.projectSplitPane[4].setResizeWeight(1.0);
        this.projectSplitPane[2].setOrientation(0);
        this.projectSplitPane[3].setResizeWeight(0.5);
        this.add((Component)this.projectSplitPane[0], "Center");
        this.projectSplitPane[0].add((Component)this.projectPane[0], "left");
        this.projectSplitPane[0].add((Component)this.projectSplitPane[1], "right");
        this.projectSplitPane[1].add((Component)this.projectSplitPane[5], "left");
        this.projectSplitPane[1].add((Component)this.projectPane[4], "right");
        this.projectSplitPane[5].add((Component)this.projectPane[6], "top");
        this.projectSplitPane[5].add((Component)this.projectSplitPane[4], "bottom");
        this.projectSplitPane[4].add((Component)this.projectSplitPane[2], "top");
        this.projectSplitPane[4].add((Component)this.projectPane[5], "bottom");
        this.projectSplitPane[2].add((Component)this.projectPane[1], "top");
        this.projectSplitPane[2].add((Component)this.projectSplitPane[3], "bottom");
        this.projectSplitPane[3].add((Component)this.projectPane[2], "left");
        this.projectSplitPane[3].add((Component)this.projectPane[3], "right");
        for (ProjectSplitPane projectSplitPane : this.projectSplitPane) {
            projectSplitPane.setBorder(null);
        }
        this.rootSplitPane = this.projectSplitPane[0];
    }

    static class ActionListenerTest
    implements ActionListener {
        private final ProjectLayout projectLayout;

        public ActionListenerTest(ProjectLayout projectLayout) {
            this.projectLayout = projectLayout;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                File file = new File("test.map");
                RandomOutputStream randomOutputStream = new RandomOutputStream(file, false, null);
                randomOutputStream.writeHeader(8);
                randomOutputStream.writeIndexTable();
                randomOutputStream.setStartIndex((byte)8, randomOutputStream.getFilePointer());
                randomOutputStream.beginProperty("Project_GUI");
                this.projectLayout.SaveProperty(randomOutputStream);
                randomOutputStream.endProperty();
                randomOutputStream.setEndIndex((byte)8, randomOutputStream.getFilePointer());
                randomOutputStream.setDatabaseID(5);
                randomOutputStream.writeIndexTable();
                randomOutputStream.close();
                RandomInputStream randomInputStream = new RandomInputStream(file, null);
                randomInputStream.readFileFramework(true);
                MapProperty mapProperty = randomInputStream.readProperties("Project_GUI");
                ProjectLayout.createTestFrame(mapProperty);
                randomInputStream.close();
            }
            catch (IOException iOException) {
                ErrorHandler.logAndReportException(iOException);
            }
        }

        public JButton getButton() {
            JButton jButton = new JButton("Print State");
            jButton.addActionListener(actionEvent -> this.projectLayout.printState());
            return jButton;
        }
    }

    private class ProjectSplitPane
    extends JSplitPane {
        private final int dividersize;
        private final double defaultResizeWeight;
        private boolean ishidable = true;

        public ProjectSplitPane(double d) {
            this.defaultResizeWeight = d;
            if (Evince.touchscreen) {
                this.setDividerSize(15);
            }
            this.dividersize = this.getDividerSize();
            BasicSplitPaneDivider basicSplitPaneDivider = ((BasicSplitPaneUI)this.getUI()).getDivider();
            basicSplitPaneDivider.setBackground(Color.white);
        }

        public void LoadProperty(MapProperty mapProperty) throws IOException {
            this.setDividerSize(mapProperty.getPropertyInt("ds"));
            if (mapProperty.getPropertyBoolean("right")) {
                int n;
                if (mapProperty.hasProperty("dl")) {
                    n = mapProperty.getLVInt();
                    if (n > 0) {
                        this.setDividerLocation(this.getWidth() - n);
                    } else {
                        this.setDividerLocation(Integer.MAX_VALUE);
                    }
                }
                if (mapProperty.hasProperty("ll")) {
                    n = mapProperty.getLVInt();
                    if (n > 0) {
                        this.setLastDividerLocation(this.getWidth() - n);
                    } else {
                        this.setLastDividerLocation(Integer.MAX_VALUE);
                    }
                }
            } else {
                this.setDividerLocation(mapProperty.getPropertyInt("dl", this.getResizeWeight() > 0.0 ? Integer.MAX_VALUE : 0));
                this.setLastDividerLocation(mapProperty.getPropertyInt("ll", -1));
            }
        }

        public void printState() {
            System.out.println("DividerSize: " + this.getDividerSize());
            System.out.println("DividerLocation: " + this.getDividerLocation());
            System.out.println("LastDividerLocation: " + this.getLastDividerLocation());
        }

        public void SaveProperty(RandomOutputStream randomOutputStream) throws IOException {
            randomOutputStream.writePropertyInt("ds", this.getDividerSize());
            if (Double.compare(this.getResizeWeight(), 1.0) == 0) {
                randomOutputStream.writePropertyBoolean("right", true);
                randomOutputStream.writePropertyInt("dl", this.getWidth() - this.getDividerLocation());
                randomOutputStream.writePropertyInt("ll", this.getWidth() - this.getLastDividerLocation());
            } else {
                randomOutputStream.writePropertyBoolean("right", false);
                randomOutputStream.writePropertyInt("dl", this.getDividerLocation());
                randomOutputStream.writePropertyInt("ll", this.getLastDividerLocation());
            }
        }

        @Override
        public void setDividerLocation(int n) {
            int n2 = this.getDividerLocation();
            if (n2 != n && !ProjectLayout.this.isload) {
                boolean bl = n2 > -1;
                int n3 = this.getLeftMinValue();
                int n4 = this.getRightMinValue();
                int n5 = this.getMaxValue();
                if (n > 10 && n < n3) {
                    super.setDividerLocation(n3);
                } else if (n < 10) {
                    if (this.ishidable) {
                        this.setDividerSize(0);
                        this.updatePanels(this.leftComponent, (byte)1);
                        this.setResizeWeight(0.0);
                    }
                    super.setDividerLocation(0);
                } else if (n5 - n > 10 && n5 - n < n4) {
                    super.setDividerLocation(n5 - n4);
                } else if (n5 - n < 10) {
                    if (n2 == Integer.MAX_VALUE) {
                        bl = false;
                    }
                    if (this.ishidable) {
                        this.setDividerSize(0);
                        this.updatePanels(this.rightComponent, (byte)1);
                        this.setResizeWeight(1.0);
                    }
                    super.setDividerLocation(Integer.MAX_VALUE);
                } else {
                    super.setDividerLocation(n);
                }
                ProjectLayout.this.projectToolbar.updateProjectTypes(ProjectLayout.this.projectTypes);
                if (ProjectLayout.this.project_GUI != null && bl) {
                    ProjectLayout.this.project_GUI.setProjectChanged();
                }
                SwingUtilities.invokeLater(() -> {
                    if (this.getRightComponent() != null) {
                        this.getRightComponent().repaint();
                    }
                });
            } else if (ProjectLayout.this.isload) {
                super.setDividerLocation(n);
            }
        }

        public void setUnhideable() {
            this.ishidable = false;
        }

        public boolean updatePanels(byte by) {
            boolean bl = this.isComponentVisible(true);
            boolean bl2 = this.updatePanels(this.leftComponent, by);
            boolean bl3 = this.isComponentVisible(false);
            boolean bl4 = this.updatePanels(this.rightComponent, by);
            if (by == 0 && (bl2 || bl4)) {
                int n = this.getLastDividerLocation();
                if (bl2 && bl4 && (!bl || !bl3)) {
                    if (n < 0) {
                        if (!bl) {
                            n = this.getLeftMinValue();
                        }
                        if (!bl3) {
                            n = this.getMaxValue() - this.getRightMinValue();
                        }
                    }
                    this.setDividerLocation(n);
                    this.setDividerSize(this.dividersize);
                    this.setResizeWeight(this.defaultResizeWeight);
                } else if (!bl2 && bl) {
                    if (this.getDividerLocation() != 0) {
                        this.setDividerLocation(0);
                        if (this.ishidable) {
                            this.setDividerSize(0);
                        }
                        this.setResizeWeight(0.0);
                    }
                    if (this.getLastDividerLocation() == Integer.MAX_VALUE && this.normalLocal(n)) {
                        this.setLastDividerLocation(n);
                    }
                } else if (!bl4 && bl3) {
                    this.setDividerLocation(Integer.MAX_VALUE);
                    if (this.ishidable) {
                        this.setDividerSize(0);
                    }
                    this.setResizeWeight(1.0);
                    if (this.getLastDividerLocation() == 0 && this.normalLocal(n)) {
                        this.setLastDividerLocation(n);
                    }
                }
            }
            return bl2 || bl4;
        }

        private int getLeftMinValue() {
            return this.isHorizontal() ? this.leftComponent.getPreferredSize().width : this.leftComponent.getPreferredSize().height;
        }

        private int getMaxValue() {
            return (this.isHorizontal() ? this.getWidth() : this.getHeight()) - this.getDividerSize();
        }

        private int getRightMinValue() {
            return this.isHorizontal() ? this.rightComponent.getPreferredSize().width : this.rightComponent.getPreferredSize().height;
        }

        private boolean isComponentVisible(boolean bl) {
            if (this.getDividerSize() == 0) {
                if (bl) {
                    return this.getDividerLocation() > 0;
                }
                return this.getDividerLocation() < this.getWidth();
            }
            return true;
        }

        private boolean isHorizontal() {
            return this.getOrientation() == 1;
        }

        private boolean normalLocal(int n) {
            return n > 0 && n < Integer.MAX_VALUE;
        }

        private boolean updatePanels(Component component, byte by) {
            if (component instanceof ProjectSplitPane) {
                return ((ProjectSplitPane)component).updatePanels(by);
            }
            if (component instanceof ProjectPane) {
                byte by2 = ((ProjectPane)component).getTypePos();
                if (by == 1) {
                    ProjectLayout.this.projectTypes = ProjectLayout.setTypeSelected(ProjectLayout.this.projectTypes, by2, false);
                }
                return ProjectLayout.isTypeSelected(ProjectLayout.this.projectTypes, by2);
            }
            return false;
        }
    }
}

