/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.main;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JComponent;
import se.prediktera.map.common.cleanup.CleanUpPanel;
import se.prediktera.map.main.ProjectLayout;

public class ProjectPane
extends CleanUpPanel {
    private final byte type;
    private final Dimension minimumSize = new Dimension(0, 0);
    private JComponent northComponent = null;
    private JComponent centerComponent = null;
    private JComponent westComponent = null;
    private JComponent southComponent = null;

    public ProjectPane(byte by) {
        super(new BorderLayout());
        this.type = by;
    }

    public JComponent getCenterPanel() {
        return this.centerComponent;
    }

    @Override
    public Dimension getMinimumSize() {
        return this.minimumSize;
    }

    public JComponent getNorthPanel() {
        return this.northComponent;
    }

    public byte getType() {
        return this.type;
    }

    public byte getTypePos() {
        return (byte)Math.pow(2.0, this.type);
    }

    public boolean isTypeSelected(byte by) {
        return ProjectLayout.isTypeSelected(by, this.getTypePos());
    }

    public void setCenterPanel(JComponent jComponent) {
        this.changeComponent(this.centerComponent, jComponent, "Center");
        this.centerComponent = jComponent;
    }

    public void setNorthPanel(JComponent jComponent) {
        this.changeComponent(this.northComponent, jComponent, "North");
        this.northComponent = jComponent;
    }

    public void setSouthPanel(JComponent jComponent) {
        this.changeComponent(this.southComponent, jComponent, "South");
        this.southComponent = jComponent;
    }

    public byte setTypeSelected(byte by, boolean bl) {
        if (bl != this.isTypeSelected(by)) {
            by = ProjectLayout.setTypeSelected(by, this.getTypePos(), bl);
        }
        return by;
    }

    public void setWestPanel(JComponent jComponent) {
        this.changeComponent(this.westComponent, jComponent, "West");
        this.westComponent = jComponent;
    }

    @Override
    protected void cleanUpChild() {
        this.northComponent = null;
        this.centerComponent = null;
        this.westComponent = null;
    }

    private void changeComponent(JComponent jComponent, JComponent jComponent2, String string) {
        if (jComponent != null) {
            this.remove(jComponent);
        }
        if (jComponent2 != null) {
            this.add((Component)jComponent2, string);
        }
        this.validate();
        this.doLayout();
        this.repaint();
    }
}

