/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.main;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Properties;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import se.prediktera.map.common.cleanup.CleanUpDialog;
import se.prediktera.map.main.Main_GUI;
import se.prediktera.map.main.Project_GUI;
import se.prediktera.map.main.PropertiesElement;
import se.prediktera.map.main.PropertiesPanel;

public class ProjectProperties
extends CleanUpDialog {
    public static final int MODAL_OK = 0;
    public static final int MODAL_ABORT = 1;
    private final PropertiesPanel propertiesPanel;
    private final JCheckBox checkInteraction = new JCheckBox("Interaction between cases");

    public ProjectProperties(Project_GUI project_GUI) {
        super(Main_GUI.get(), "Project Properties", true);
        this.propertiesPanel = new PropertiesPanel(project_GUI);
        this.jbInit();
        this.pack();
        this.setLocationRelativeTo(Main_GUI.get());
    }

    public void addProperties(Properties properties) {
        this.propertiesPanel.addProperties(properties);
    }

    public void addProperty(String string, String string2) {
        this.propertiesPanel.addProperty(string, string2);
    }

    public void setProperty(String string, String string2) {
        this.propertiesPanel.setProperty(string, string2);
    }

    public void clearProperties() {
        this.propertiesPanel.clearProperties();
    }

    public String getProjectProperties() {
        return this.propertiesPanel.getProperties(false);
    }

    public String getProjectPropertiesAll() {
        return this.propertiesPanel.getProperties(true);
    }

    public PropertiesElement getProperty(String string) {
        return this.propertiesPanel.getProperty(string);
    }

    public String getPropertyValue(String string, String string2) {
        PropertiesElement propertiesElement = this.propertiesPanel.getProperty(string);
        return propertiesElement != null ? propertiesElement.value : string2;
    }

    public boolean getPropertyValue(String string, boolean bl) {
        return Boolean.parseBoolean(this.getPropertyValue(string, String.valueOf(bl)));
    }

    public boolean hasInteractionBetweenCases() {
        return this.checkInteraction.isSelected();
    }

    public void setInteractionBetweenCases(boolean bl) {
        this.checkInteraction.setSelected(bl);
    }

    public void setProjectProperties(String string) {
        this.propertiesPanel.setText(string);
    }

    public void showModal() {
        super.setVisible(true);
    }

    @Override
    protected void cleanUpChild() {
    }

    private void jbInit() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setMinimumSize(new Dimension(548, 383));
        this.setResizable(true);
        JTabbedPane jTabbedPane = new JTabbedPane();
        jPanel.add((Component)jTabbedPane, "Center");
        JButton jButton = new JButton("Help");
        jButton.setMinimumSize(new Dimension(75, 27));
        jButton.setMnemonic('H');
        JButton jButton2 = new JButton("OK");
        jButton2.setMinimumSize(new Dimension(75, 27));
        jButton2.setMnemonic('O');
        jButton2.addActionListener(actionEvent -> this.dispose());
        JButton jButton3 = new JButton("Cancel");
        jButton3.setMinimumSize(new Dimension(75, 27));
        jButton3.setMnemonic('C');
        jButton3.addActionListener(actionEvent -> this.dispose());
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel.add((Component)jPanel2, "South");
        JPanel jPanel3 = new JPanel();
        jPanel2.add((Component)jPanel3, "East");
        jPanel3.add((Component)jButton2, null);
        jPanel3.add((Component)jButton3, null);
        jButton2.requestFocus();
        this.getContentPane().add((Component)jPanel, "Center");
        JPanel jPanel4 = new JPanel(new BorderLayout());
        jTabbedPane.add((Component)jPanel4, "Description");
        jPanel4.add((Component)new JLabel("Description"), "North");
        JScrollPane jScrollPane = new JScrollPane();
        jPanel4.add((Component)jScrollPane, "Center");
        jScrollPane.getViewport().add((Component)this.propertiesPanel, null);
    }
}

