/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.main;

import javax.swing.ImageIcon;
import se.prediktera.map.common.CMenu;
import se.prediktera.map.common.cleanup.CleanUpToolBar;
import se.prediktera.map.common.swing.flat.JFlatToggleButton;
import se.prediktera.map.components.paint.AbstractPaint;
import se.prediktera.map.main.GlobalMessageInterface;
import se.prediktera.map.main.Main_GUI;
import se.prediktera.map.main.ProjectLayout;
import se.prediktera.map.register.RegisterKeyManager;

public class ProjectToolbar
extends CleanUpToolBar
implements GlobalMessageInterface {
    private static final int BUTTONSIZE = 24;
    private JFlatToggleButton[] buttonLayout;
    private boolean doupdate = true;
    private ProjectLayout projectLayout;
    private byte projectTypes = (byte)-1;

    public ProjectToolbar(ProjectLayout projectLayout, byte by) {
        this.projectLayout = projectLayout;
        this.setBorder(null);
        this.setFloatable(false);
        this.setOpaque(false);
        this.buttonLayout = RegisterKeyManager.isPredikteraDevelopmentLicense() ? new JFlatToggleButton[5] : new JFlatToggleButton[4];
        for (int i = 0; i < this.buttonLayout.length; ++i) {
            this.buttonLayout[i] = new JFlatToggleButton(32, 32, false);
            this.buttonLayout[i].addItemListener(itemEvent -> this.updateLayout());
            this.add(this.buttonLayout[i]);
        }
        this.buttonLayout[0].setToolTipText("Show/Hide Graph Layout");
        ImageIcon imageIcon = AbstractPaint.createIcon(13, 24);
        imageIcon = new ImageIcon(Main_GUI.class.getResource("gif/graph_layout_button.png"));
        this.buttonLayout[0].setIcon(imageIcon);
        this.buttonLayout[0].setMenuIcon(AbstractPaint.createIcon(13));
        this.buttonLayout[1].setToolTipText("Show/Hide Table Layout");
        imageIcon = AbstractPaint.createIcon(9, 24);
        imageIcon = new ImageIcon(Main_GUI.class.getResource("gif/table_layout_button.png"));
        this.buttonLayout[1].setIcon(imageIcon);
        this.buttonLayout[1].setMenuIcon(AbstractPaint.createIcon(9));
        this.buttonLayout[2].setToolTipText("Show/Hide Plot Layout");
        imageIcon = AbstractPaint.createIcon(6, 24);
        imageIcon = new ImageIcon(Main_GUI.class.getResource("gif/plot_layout_button.png"));
        this.buttonLayout[2].setIcon(imageIcon);
        this.buttonLayout[2].setMenuIcon(AbstractPaint.createIcon(6));
        this.buttonLayout[3].setToolTipText("Show/Hide Model Layout");
        imageIcon = AbstractPaint.createIcon(3, 24);
        imageIcon = new ImageIcon(Main_GUI.class.getResource("gif/model_layout_button.png"));
        this.buttonLayout[3].setIcon(imageIcon);
        this.buttonLayout[3].setMenuIcon(AbstractPaint.createIcon(3));
        if (RegisterKeyManager.isPredikteraDevelopmentLicense()) {
            this.buttonLayout[4].setToolTipText("Show/Hide History Layout");
            this.buttonLayout[4].setIcon(AbstractPaint.createIcon(11));
        }
        this.updateProjectTypes(by);
    }

    public void setSelectedIndex(int n) {
        this.doupdate = false;
        this.buttonLayout[0].setSelected((n & 2) > 0);
        this.buttonLayout[1].setSelected((n & 4) > 0);
        this.buttonLayout[2].setSelected((n & 8) > 0);
        this.buttonLayout[3].setSelected((n & 0x40) > 0);
        if (RegisterKeyManager.isPredikteraDevelopmentLicense()) {
            this.buttonLayout[4].setSelected((n & 0x20) > 0);
        }
        this.checkEnabled();
        this.doupdate = true;
        this.updateLayout();
    }

    public void updateLayout() {
        if (this.doupdate && this.projectLayout != null) {
            this.setTypeSelected((byte)2, this.buttonLayout[0].isSelected());
            this.setTypeSelected((byte)4, this.buttonLayout[1].isSelected());
            this.setTypeSelected((byte)8, this.buttonLayout[2].isSelected());
            this.setTypeSelected((byte)64, this.buttonLayout[3].isSelected());
            if (RegisterKeyManager.isPredikteraDevelopmentLicense()) {
                this.setTypeSelected((byte)32, this.buttonLayout[4].isSelected());
            }
            this.checkEnabled();
            this.projectLayout.updateProjectTypes(this.projectTypes);
        }
    }

    public void updateMenu(CMenu cMenu) {
        cMenu.removeAll();
        cMenu.add(this.buttonLayout[0].createMenuItem("Show Graph"));
        cMenu.add(this.buttonLayout[1].createMenuItem("Show Tables"));
        cMenu.add(this.buttonLayout[2].createMenuItem("Show Plots"));
        cMenu.add(this.buttonLayout[3].createMenuItem("Show Models"));
        if (RegisterKeyManager.isPredikteraDevelopmentLicense()) {
            cMenu.add(this.buttonLayout[4].createMenuItem("Show History"));
        }
    }

    public final void updateProjectTypes(byte by) {
        if (this.projectTypes != by) {
            this.projectTypes = by;
            this.doupdate = false;
            this.buttonLayout[0].setSelected(this.isTypeSelected((byte)2));
            this.buttonLayout[1].setSelected(this.isTypeSelected((byte)4));
            this.buttonLayout[2].setSelected(this.isTypeSelected((byte)8));
            this.buttonLayout[3].setSelected(this.isTypeSelected((byte)64));
            if (RegisterKeyManager.isPredikteraDevelopmentLicense()) {
                this.buttonLayout[4].setSelected(this.isTypeSelected((byte)32));
            }
            this.checkEnabled();
            this.doupdate = true;
        }
    }

    @Override
    protected void cleanUpChild() {
        this.projectLayout = null;
    }

    private void checkEnabled() {
        int n = 0;
        JFlatToggleButton jFlatToggleButton = null;
        for (JFlatToggleButton jFlatToggleButton2 : this.buttonLayout) {
            if (!jFlatToggleButton2.isEnabled()) {
                jFlatToggleButton2.setEnabled(true);
            }
            if (!jFlatToggleButton2.isSelected()) continue;
            ++n;
            jFlatToggleButton = jFlatToggleButton2;
        }
        if (n == 1) {
            jFlatToggleButton.setEnabled(false);
        }
    }

    private boolean isTypeSelected(byte by) {
        return ProjectLayout.isTypeSelected(this.projectTypes, by);
    }

    private void setTypeSelected(byte by, boolean bl) {
        this.projectTypes = ProjectLayout.setTypeSelected(this.projectTypes, by, bl);
    }
}

