/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.main;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import se.prediktera.map.InitClass;
import se.prediktera.map.common.CMenu;
import se.prediktera.map.common.CMenuItem;
import se.prediktera.map.common.MapException;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.common.SwingTimer;
import se.prediktera.map.common.cleanup.CleanUpPanel;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.common.error.Logg;
import se.prediktera.map.common.interaction.InteractionArray;
import se.prediktera.map.common.interaction.InteractionGroup;
import se.prediktera.map.common.interaction.InteractionInterface;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.common.progress.ProgressManagerImpl;
import se.prediktera.map.common.resource.ResourceNode;
import se.prediktera.map.common.swing.EvinceBorderFactory;
import se.prediktera.map.common.swing.filechooser.jopensaveDialog;
import se.prediktera.map.common.swing.flat.JFlatButton;
import se.prediktera.map.components.paint.AbstractPaint;
import se.prediktera.map.data.datasettable.DataSetTableInfo;
import se.prediktera.map.dataimport.ImportHelper;
import se.prediktera.map.datasetcontainer.AbstractDataNode;
import se.prediktera.map.datasetcontainer.Case;
import se.prediktera.map.datasetcontainer.DataContainer;
import se.prediktera.map.datasetcontainer.DataTreeInterface;
import se.prediktera.map.datasetcontainer.DataTreeManager;
import se.prediktera.map.datasetcontainer.dataset.DataSet;
import se.prediktera.map.main.AbstractGUI;
import se.prediktera.map.main.DataMonitor;
import se.prediktera.map.main.Data_GUI;
import se.prediktera.map.main.Graph_GUI;
import se.prediktera.map.main.History_GUI;
import se.prediktera.map.main.IniManager;
import se.prediktera.map.main.Main_GUI;
import se.prediktera.map.main.Model_GUI;
import se.prediktera.map.main.Plot_GUI;
import se.prediktera.map.main.ProjectLayout;
import se.prediktera.map.main.ProjectPane;
import se.prediktera.map.main.ProjectProperties;
import se.prediktera.map.main.ProjectToolbar;
import se.prediktera.map.main.extclass.ExtClassLoader;
import se.prediktera.map.main.layer.AbstractLayerPanel;
import se.prediktera.map.main.script.ScriptHelper;
import se.prediktera.map.main.window.AbstractWindow;
import se.prediktera.map.main.window.EmptyWindow;
import se.prediktera.map.model.AbstractModel;

public class Project_GUI
extends CleanUpPanel
implements InteractionInterface {
    public static final byte NORMAL_MODE = 0;
    public static final byte PERFORMANCE_MODE = 1;
    private static byte mode = 0;
    public static final ImageIcon projectIcon = AbstractPaint.createIcon(10);
    public static final ImageIcon dotIcon = AbstractPaint.createIcon(19);
    protected Graph_GUI graph_GUI;
    protected Data_GUI data_GUI;
    protected Plot_GUI plot_GUI;
    protected History_GUI history_GUI;
    protected Model_GUI model_GUI;
    protected DataContainer rootNode;
    protected DataMonitor dataMonitor;
    private File projectFile = null;
    private String projectname;
    private final EmptyWindow emptyWindow = new EmptyWindow(this);
    private ProjectLayout projectLayout;
    private final CMenu jMenuGraph = new CMenu("Graph", false);
    private final CMenu jMenuData = new CMenu("Table", false);
    private final CMenu jMenuPlot = new CMenu("Plot", false);
    private final CMenu jMenuHistory = new CMenu("History", false);
    private final CMenu jMenuModel = new CMenu("Model", false);
    private ProjectToolbar layoutToolbar;
    public DataTreeManager dataTreeManager;
    private boolean layoutchanged = false;
    private boolean lockedlayout = false;
    private long saveVersion;
    private ProjectPane settingsWest;
    private ProjectPane settingsEast;
    private List<InteractionGroup> interactionGroupList = null;
    private InteractionInterface interactionInterface = null;
    private AbstractLayerPanel currentLayerPanel;
    private String constraints;
    private final JFlatButton save = new JFlatButton();
    private boolean projectChanged = false;
    private boolean isLoading = false;
    private boolean scriptMode = false;
    private boolean isTakingScreenshot = false;
    private boolean toolbarVisible = true;
    private boolean fullmodel = false;
    private final SwingTimer projectChangedTimer = new SwingTimer(200, actionEvent -> {
        Main_GUI main_GUI = Project_GUI.getMainGUI();
        if (!(this.isLoading || this.projectChanged || main_GUI == null || main_GUI.isDemoLicense())) {
            this.projectChanged = true;
            this.save.setEnabled(this.projectChanged);
            main_GUI.updateTitle(this);
        }
    });

    public static Project_GUI createNewProject(boolean bl, String string) {
        Project_GUI project_GUI = Project_GUI.createNewProject(bl);
        project_GUI.suggestProjectName(string);
        return project_GUI;
    }

    public static Project_GUI createNewProject(boolean bl) {
        Project_GUI project_GUI = new Project_GUI(null, 29);
        Main_GUI main_GUI = Main_GUI.get();
        if (main_GUI != null) {
            main_GUI.addProjectToDesktop(project_GUI, false);
        }
        Case case_ = project_GUI.createNewCase();
        project_GUI.updateDataTree(case_);
        project_GUI.model_GUI.createModelWindows(case_);
        if (bl && !ImportHelper.importData(project_GUI, case_, null, null, true)) {
            return null;
        }
        project_GUI.model_GUI.createModelWindows(case_);
        return project_GUI;
    }

    public static final byte getMode() {
        return mode;
    }

    public static final void setMode(byte by) {
        mode = by;
    }

    private static Main_GUI getMainGUI() {
        return Main_GUI.get();
    }

    public Project_GUI(ProgressManager progressManager, RandomInputStream randomInputStream, boolean bl) throws AbortException, Exception {
        this(progressManager, randomInputStream, bl, false);
    }

    public Project_GUI(ProgressManager progressManager, RandomInputStream randomInputStream, boolean bl, boolean bl2) throws AbortException, Exception {
        super("Project_GUI", new BorderLayout());
        MapProperty mapProperty;
        Object object;
        int n;
        RandomInputStream.FileFramework fileFramework;
        this.scriptMode = bl2;
        this.projectFile = randomInputStream.getFile();
        if (!bl) {
            this.projectname = this.projectFile.getName();
        }
        try {
            fileFramework = randomInputStream.readFileFramework(true);
        }
        catch (IOException iOException) {
            progressManager.Finish();
            JOptionPane.showMessageDialog(Project_GUI.getMainGUI(), "Evince cannot open this file:\n" + iOException.getMessage(), "Error opening file", 2, null);
            randomInputStream.close();
            throw new AbortException();
        }
        if (randomInputStream.getMAPversion() != 8 && !bl) {
            progressManager.Finish();
            n = JOptionPane.showConfirmDialog(Project_GUI.getMainGUI(), "Evince cannot open this file because the file is created\nin an older version of Evince with a different file format!\nDo you want to try to open the file as a template?", "Old Evince version", 0, 3, null);
            if (n == 0) {
                bl = true;
            } else {
                randomInputStream.close();
                throw new AbortException();
            }
        }
        if (randomInputStream.getSaveVersion() > (long)InitClass.Version.intValue() && (n = JOptionPane.showConfirmDialog(progressManager.getWindow(), "The project file you are trying to open was saved with a newer\nversion of Evince than the one you are running. We recommend that\nyou update to this newer version.\nTry to load anyway?", "Project file version mismatch", 0, 3, null)) == 1) {
            randomInputStream.close();
            throw new AbortException();
        }
        if (!ExtClassLoader.isLibrariesLoaded(fileFramework.libraries)) {
            if (progressManager != null) {
                progressManager.Finish();
            }
            if ((n = JOptionPane.showConfirmDialog(Project_GUI.getMainGUI(), "This file requires one or more libraries that are not loaded!\nThe libraries are either not installed or the license has expired\nDo you want try to open the file anyway?", "Libraries not loaded", 0, 3, null)) != 0) {
                randomInputStream.close();
                throw new AbortException();
            }
        }
        this.isLoading = true;
        this.dataTreeManager = new DataTreeManager(true, fileFramework.maxnumber);
        this.dataTreeManager.setProject(this);
        randomInputStream.setProject_GUI(this);
        if (!bl) {
            this.saveVersion = randomInputStream.getSaveVersion();
            DataTreeInterface dataTreeInterface = randomInputStream.resolveRoot();
            if (dataTreeInterface instanceof AbstractModel) {
                object = (AbstractModel)dataTreeInterface;
                this.rootNode = this.createRootNode();
                DataSet dataSet = ((AbstractModel)object).getDataSet();
                Case case_ = dataSet.getCase();
                case_.setName(dataSet.toString());
                this.rootNode.addTreeNode(case_);
                this.fullmodel = true;
            } else {
                this.rootNode = (DataContainer)randomInputStream.resolveRoot();
            }
            if (this.rootNode != null) {
                this.rootNode.setRootNode(this.dataTreeManager);
                for (int i = this.rootNode.getTreeNodeCount() - 1; i >= 0; --i) {
                    if (!this.rootNode.getTreeNodeAt(i).isNode()) continue;
                    DataTreeManager.LoadIntoMemory(this, progressManager, this.rootNode.getTreeNodeAt(i), false);
                }
                this.setDataSetsCreated(true);
            }
        }
        if ((mapProperty = randomInputStream.readProperties("Project_GUI")) != null && !this.fullmodel) {
            this.projectLayout = new ProjectLayout(this, mapProperty);
            this.lockedlayout = mapProperty.getPropertyBoolean("lock");
            this.layoutchanged = mapProperty.getPropertyBoolean("lchanged");
            this.toolbarVisible = mapProperty.getPropertyBoolean("tvisible", true);
        } else if (bl || this.fullmodel) {
            this.projectLayout = new ProjectLayout(this);
        }
        this.jbInit();
        if (bl || this.rootNode == null || this.fullmodel) {
            new Plot_GUI(this, this.jMenuPlot);
            new Data_GUI(this, this.jMenuData);
            if (!this.fullmodel) {
                bl = true;
            } else {
                this.lockedlayout = true;
                this.projectFile = null;
                this.projectname = null;
            }
        } else {
            new Plot_GUI(randomInputStream, this, progressManager, this.jMenuPlot);
            new Data_GUI(randomInputStream, this, progressManager, this.jMenuData);
        }
        new Graph_GUI(randomInputStream, this, this.jMenuGraph);
        new History_GUI(randomInputStream, this, this.jMenuHistory);
        new Model_GUI(randomInputStream, this, progressManager, this.jMenuModel);
        if (bl) {
            this.rootNode = this.createRootNode();
            this.rootNode.addTreeNode(this.data_GUI.getWindowContainer());
            this.rootNode.addTreeNode(this.plot_GUI.getWindowContainer());
            object = (ResourceNode)this.rootNode.getNodeByName("Resources");
            if (object == null) {
                object = new ResourceNode();
                this.rootNode.addTreeNode((DataTreeInterface)object);
            }
        }
        this.addToDesktop(randomInputStream);
        if (bl) {
            this.projectFile = null;
        }
        if (fileFramework.description != null) {
            this.graph_GUI.getProjectProperties().setProjectProperties(fileFramework.description);
        }
        this.dataMonitor.setCreated();
        this.data_GUI.setCreated();
        this.plot_GUI.setCreated();
        this.graph_GUI.setCreated();
        object = this.getCases();
        if (object.hasNext()) {
            this.model_GUI.createModelWindows((Case)object.next());
        }
        this.projectChanged = this.fullmodel;
        this.save.setEnabled(this.projectChanged);
        Project_GUI.getMainGUI().updateTitle(this);
        this.isLoading = false;
        if (this.fullmodel) {
            SwingUtilities.invokeLater(() -> {
                DataTreeInterface dataTreeInterface = randomInputStream.resolveRoot();
                AbstractModel abstractModel = (AbstractModel)dataTreeInterface;
                if (abstractModel != null) {
                    DataSet dataSet = abstractModel.getDataSet();
                    DataSetTableInfo dataSetTableInfo = new DataSetTableInfo();
                    this.data_GUI.createWindowFromWizard(dataSet, dataSetTableInfo);
                    this.dataMonitor.ReloadDataTree(abstractModel);
                }
                this.setProjectChanged();
            });
        }
    }

    public Project_GUI(String string) {
        super("Project_GUI", new BorderLayout());
        this.projectname = string;
        this.dataTreeManager = new DataTreeManager(true);
        this.dataTreeManager.setProject(this);
        this.rootNode = this.createRootNode();
        new Plot_GUI(this, this.jMenuPlot);
        new Graph_GUI(this, this.jMenuGraph);
        new Data_GUI(this, this.jMenuData);
        new History_GUI(this, this.jMenuHistory);
        new Model_GUI(this, this.jMenuModel);
        this.getProperties().setInteractionBetweenCases(true);
    }

    public Project_GUI(String string, int n) {
        super("Project_GUI", new BorderLayout());
        this.projectname = string;
        this.projectLayout = new ProjectLayout(this);
        this.dataTreeManager = new DataTreeManager(true);
        this.dataTreeManager.setProject(this);
        this.rootNode = this.createRootNode();
        try {
            this.jbInit();
            new Plot_GUI(this, this.jMenuPlot);
            new Graph_GUI(this, this.jMenuGraph);
            new Data_GUI(this, this.jMenuData);
            new History_GUI(this, this.jMenuHistory);
            new Model_GUI(this, this.jMenuModel);
            if (this.plot_GUI != null) {
                this.rootNode.addTreeNode(this.data_GUI.getWindowContainer());
                this.rootNode.addTreeNode(this.plot_GUI.getWindowContainer());
                this.addToDesktop(null);
                this.dataMonitor.setCreated();
            }
            this.graph_GUI.setCreated();
            this.layoutToolbar.setSelectedIndex(n);
        }
        catch (Exception exception) {
            ErrorHandler.logAndReportException(exception);
        }
    }

    public void addLayoutItems(CMenu cMenu) {
        if (this.layoutToolbar != null) {
            this.layoutToolbar.updateMenu(cMenu);
        }
    }

    public void applyAllChanges() {
        SwingUtilities.invokeLater(new ProgressManagerImpl(){

            @Override
            public Object doWork() {
                Project_GUI.this.dataTreeManager.PropagateAllChanges(Project_GUI.this.rootNode, this);
                return null;
            }
        });
    }

    public void applyOnTree(String string, DataTreeInterface dataTreeInterface) throws Exception {
        if (this.dataMonitor != null) {
            this.dataMonitor.apply(string, dataTreeInterface);
        }
    }

    public boolean closeProject() {
        return this.closeProject(true);
    }

    public boolean closeProject(boolean bl) {
        if (bl && this.projectChanged) {
            int n = JOptionPane.showConfirmDialog(IniManager.getMainFrame(), "Do you want to save the current changes in project \"" + this.getProjectName() + "\"?", "Save Confirmation", 1, 3);
            if (n == 0) {
                if (this.save(null, false, false, true)) {
                    Project_GUI.getMainGUI().addFileToRecent(this);
                    return true;
                }
                return false;
            }
            if (n != 1) {
                return false;
            }
        }
        SwingUtilities.invokeLater(() -> this.closeProjectNow());
        return true;
    }

    public void closeProjectNow() {
        Project_GUI.getMainGUI().removeProjectNoClose(this);
        this.cleanUp();
    }

    public Case createNewCase() {
        if (this.rootNode != null) {
            Case case_ = new Case(0, 0);
            this.rootNode.addTreeNodeSortedByType(case_);
            this.dataMonitor.ReloadDataTree(case_);
            return case_;
        }
        return null;
    }

    @Override
    public boolean doInteraction(InteractionInterface interactionInterface) {
        if (interactionInterface != null) {
            interactionInterface.prepareInteraction();
            return this.doInteractionOnly(interactionInterface);
        }
        return false;
    }

    public boolean doInteractionOnly() {
        return this.doInteractionOnly(null);
    }

    public boolean doInteractionOnly(InteractionInterface interactionInterface) {
        this.setProjectChanged();
        boolean bl = this.data_GUI.doInteraction(interactionInterface);
        return this.plot_GUI.doInteraction(interactionInterface) || bl;
    }

    @Override
    public void doQuickInteraction(InteractionInterface interactionInterface, int n, int n2, int n3, int n4) {
        this.plot_GUI.doQuickInteraction(interactionInterface, n, n2, n3, n4);
    }

    @Override
    public void finishInteraction() {
    }

    public void freeMemory() {
        ProgressManagerImpl progressManagerImpl = new ProgressManagerImpl(){

            @Override
            public Object doWork() {
                try {
                    this.setInfoText("Unloading Data from Memory");
                    Project_GUI.this.dataTreeManager.ClearDataFromMemory(Project_GUI.this.rootNode, 0, System.currentTimeMillis(), this);
                    System.gc();
                }
                catch (Exception exception) {
                    ErrorHandler.logAndShowEvinceErrorDialogForException(exception);
                }
                return null;
            }
        };
        SwingUtilities.invokeLater(progressManagerImpl);
    }

    public byte getAreasToShow() {
        return this.projectLayout.getProjectTypes();
    }

    public Iterator<Case> getCases() {
        return this.getCaseList().iterator();
    }

    public ArrayList<Case> getCaseList() {
        ArrayList<Case> arrayList = new ArrayList<Case>();
        if (this.rootNode != null) {
            int n = this.rootNode.getTreeNodeCount();
            for (int i = 0; i < n; ++i) {
                if (!(this.rootNode.getTreeNodeAt(i) instanceof Case)) continue;
                arrayList.add((Case)this.rootNode.getTreeNodeAt(i));
            }
        }
        return arrayList;
    }

    public String getConstraints() {
        return this.constraints;
    }

    public AbstractLayerPanel getCurrentLayerPanel() {
        return this.currentLayerPanel;
    }

    public Data_GUI getData_GUI() {
        return this.data_GUI;
    }

    public DataTreeManager getDataTreeManager() {
        return this.dataTreeManager;
    }

    public AbstractWindow getEmptyWindow() {
        return this.emptyWindow;
    }

    public Graph_GUI getGraph_GUI() {
        return this.graph_GUI;
    }

    public String getGUI_Name() {
        return this.getProjectName() + (this.projectChanged ? " *" : "");
    }

    public History_GUI getHistory_GUI() {
        return this.history_GUI;
    }

    public InteractionArray getInteractionArray(DataTreeInterface dataTreeInterface, int n, int n2, int n3) {
        return this.getInteractionGroup(n3).getInteractionArray(dataTreeInterface, n, n2);
    }

    public InteractionArray getInteractionArray(int n, int n2) {
        return this.getInteractionGroup(n2).getInteractionArray(n);
    }

    public InteractionInterface getInteractionInterface() {
        return this.interactionInterface;
    }

    public Model_GUI getModel_GUI() {
        return this.model_GUI;
    }

    public Plot_GUI getPlot_GUI() {
        return this.plot_GUI;
    }

    public Case getPrimaryCase() {
        Iterator<Case> iterator = this.getCases();
        Case case_ = null;
        while (iterator.hasNext()) {
            Case case_2 = iterator.next();
            if (!case_2.isVisibleInTree()) continue;
            if (case_ == null) {
                case_ = case_2;
            }
            if (!case_.hasData()) continue;
            return case_;
        }
        return case_;
    }

    public Case getOrCreatePrimaryCase() {
        Case case_ = this.getPrimaryCase();
        if (case_ == null || case_.hasData()) {
            case_ = this.createNewCase();
        }
        return case_;
    }

    public File getProjectFile() {
        return this.projectFile;
    }

    public JMenuBar getProjectMenuBar() {
        JMenuBar jMenuBar = new JMenuBar();
        jMenuBar.add(this.jMenuGraph);
        jMenuBar.add(this.jMenuData);
        jMenuBar.add(this.jMenuPlot);
        jMenuBar.add(this.jMenuModel);
        return jMenuBar;
    }

    public String getProjectName() {
        if (this.projectname != null) {
            return this.projectname;
        }
        if (this.projectFile != null) {
            return this.projectFile.getName();
        }
        return "Unnamed project";
    }

    public ProjectProperties getProperties() {
        return this.graph_GUI.getProjectProperties();
    }

    public AbstractDataNode getRootNode() {
        return this.rootNode;
    }

    public long getSaveVersion() {
        return this.saveVersion;
    }

    public DataTreeInterface getSelectedTreeNode() {
        if (this.dataMonitor != null) {
            return this.dataMonitor.getSelectedTreeNode();
        }
        return null;
    }

    public ProjectPane getSettingsEast() {
        return this.settingsEast;
    }

    public boolean hasInteractionBetweenCases() {
        ProjectProperties projectProperties = this.getProperties();
        if (projectProperties != null) {
            return projectProperties.hasInteractionBetweenCases();
        }
        return false;
    }

    public boolean hasProjectChanged() {
        return this.projectChanged;
    }

    public boolean isAllCreated() {
        return this.data_GUI.isAllCreated() && this.plot_GUI.isAllCreated();
    }

    public boolean isFullmodel() {
        return this.fullmodel;
    }

    public boolean isNewProject() {
        return this.projectname == null && this.projectFile == null;
    }

    public boolean isScriptMode() {
        return this.scriptMode;
    }

    public boolean isSpectralImage() {
        Case case_ = this.getPrimaryCase();
        if (case_ != null && case_.getOriginalMatrix() != null) {
            return case_.getOriginalMatrix().isFoldable();
        }
        return false;
    }

    public boolean isTakingScreenshot() {
        return this.isTakingScreenshot;
    }

    public boolean isToolbarVisible() {
        return this.toolbarVisible;
    }

    public boolean isVisibleGUI(AbstractGUI abstractGUI) {
        if (this.projectLayout != null) {
            return this.projectLayout.isVisibleGUI(abstractGUI);
        }
        return false;
    }

    @Override
    public void prepareInteraction() {
    }

    public void purgeSignal() {
        if (!this.isCleaned()) {
            this.data_GUI.PostGlobalMessage((byte)0, (byte)0);
            this.plot_GUI.PostGlobalMessage((byte)0, (byte)0);
            this.graph_GUI.PurgeSignal();
            if (this.history_GUI != null) {
                this.history_GUI.PurgeSignal();
            }
            if (this.model_GUI != null) {
                this.model_GUI.PurgeSignal();
            }
            if (this.dataMonitor != null) {
                this.dataMonitor.PurgeSignal();
            }
        }
    }

    public void renameSignal() {
        this.setProjectChanged();
        this.plot_GUI.PostGlobalMessage((byte)5, (byte)0);
    }

    public void save(boolean bl, boolean bl2) throws MapException, IOException {
        String string;
        File file;
        try {
            file = File.createTempFile("temp", "save", this.projectFile.getParentFile());
        }
        catch (IOException iOException) {
            throw new MapException(iOException.getMessage());
        }
        RandomOutputStream randomOutputStream = new RandomOutputStream(file, false, null);
        randomOutputStream.writeHeader(8);
        randomOutputStream.writeIndexTable();
        randomOutputStream.setStartIndex((byte)2, randomOutputStream.getFilePointer());
        if (this.graph_GUI == null) {
            Logg.error("graph_GUI is null", new Object[0]);
            string = "";
        } else {
            string = this.getProperties().getProjectProperties();
        }
        if (string == null) {
            Logg.error("Project description is null", new Object[0]);
            string = "";
        }
        randomOutputStream.writeUTF(string);
        randomOutputStream.setEndIndex((byte)2, randomOutputStream.getFilePointer());
        if (!bl) {
            File file2 = this.dataTreeManager.getFirstSaveFile(this.rootNode);
            if (file2 != null && !file2.exists()) {
                throw new MapException("Data file has been deleted: \"" + String.valueOf(file2) + "\"");
            }
            randomOutputStream.setStartIndex((byte)1, randomOutputStream.getFilePointer());
            this.dataTreeManager.SaveRoot(this.rootNode, randomOutputStream, DataTreeManager.incSaveIndex());
            randomOutputStream.setEndIndex((byte)1, randomOutputStream.getFilePointer());
        }
        randomOutputStream.setStartIndex((byte)8, randomOutputStream.getFilePointer());
        this.graph_GUI.Save(randomOutputStream);
        this.plot_GUI.Save(randomOutputStream);
        this.data_GUI.Save(randomOutputStream);
        this.history_GUI.Save(randomOutputStream);
        this.model_GUI.Save(randomOutputStream);
        this.dataMonitor.Save(randomOutputStream);
        this.saveProperties(randomOutputStream);
        randomOutputStream.setEndIndex((byte)8, randomOutputStream.getFilePointer());
        randomOutputStream.setStartIndex((byte)5, randomOutputStream.getFilePointer());
        this.takeScreenShot(randomOutputStream);
        randomOutputStream.setEndIndex((byte)5, randomOutputStream.getFilePointer());
        randomOutputStream.writeIndexTable();
        randomOutputStream.close();
        this.projectChanged = false;
        this.save.setEnabled(this.projectChanged);
        if (!bl) {
            this.projectname = this.projectFile.getName();
            Project_GUI.getMainGUI().updateTitle(this);
            Project_GUI.getMainGUI().selectCurrentProject(this);
        }
        if (!this.projectFile.delete()) {
            // empty if block
        }
        if (!file.renameTo(this.projectFile)) {
            Logg.error("Cannot rename temp file to project file", new Object[0]);
        }
        if (bl2) {
            Project_GUI.getMainGUI().removeProjectFromDesktop(this);
            this.cleanUp();
        }
        if (!bl && this.dataTreeManager != null) {
            this.dataTreeManager.setSaveFile(this.rootNode, this.projectFile);
        }
    }

    public boolean save(ProgressManager progressManager, boolean bl, final boolean bl2, final boolean bl3) {
        if (this.projectFile == null || bl) {
            String string = "Choose name for current project";
            if (bl2) {
                string = "Choose name for current template";
            }
            jopensaveDialog jopensaveDialog2 = new jopensaveDialog(string, Project_GUI.getMainGUI());
            jopensaveDialog2.setPreview(null, true);
            jopensaveDialog2.addExtension("map", "Evince Files (*.map)");
            File file = IniManager.getWorkDir((byte)0);
            jopensaveDialog2.setSelectedFile(new File(this.getProjectName()));
            if (file != null) {
                jopensaveDialog2.setCurrentDirectory(file);
            }
            if (jopensaveDialog2.saveshow()) {
                this.projectFile = jopensaveDialog2.getSelectedFile();
                if (!bl2) {
                    IniManager.setWorkDir((byte)0, jopensaveDialog2.getCurrentDirectory());
                }
            } else {
                return false;
            }
        }
        if (progressManager != null) {
            this.saveProject(progressManager, bl2, bl3);
        } else {
            progressManager = new ProgressManagerImpl(this){
                final /* synthetic */ Project_GUI this$0;
                {
                    this.this$0 = project_GUI;
                }

                @Override
                public Object doWork() {
                    this.this$0.saveProject(this, bl2, bl3);
                    this.Finish();
                    return null;
                }
            };
            progressManager.invokeNow();
        }
        return true;
    }

    public void saveProperties(RandomOutputStream randomOutputStream) throws IOException {
        randomOutputStream.beginProperty("Project_GUI");
        this.projectLayout.SaveProperty(randomOutputStream);
        randomOutputStream.writePropertyBoolean("lock", this.lockedlayout);
        randomOutputStream.writePropertyBoolean("lchanged", this.layoutchanged);
        randomOutputStream.writePropertyBoolean("tvisible", this.toolbarVisible);
        randomOutputStream.endProperty();
    }

    public void selectDataTree(DataTreeInterface dataTreeInterface) {
        if (this.dataMonitor != null) {
            this.dataMonitor.SelectDataTree(dataTreeInterface);
        }
    }

    public void setAreasToShow(int n) {
        this.layoutToolbar.updateProjectTypes((byte)n);
        this.projectLayout.updateProjectTypes((byte)n);
    }

    public void setConstrains(String string) {
        this.constraints = string;
    }

    public void setCurrentLayerPanel(AbstractLayerPanel abstractLayerPanel) {
        this.currentLayerPanel = abstractLayerPanel;
    }

    public void setData_GUI(Data_GUI data_GUI) {
        this.data_GUI = data_GUI;
    }

    public void setDataTreeFilter(int n) {
        this.dataMonitor.setFilter(n);
    }

    public void setGraph_GUI(Graph_GUI graph_GUI) {
        this.graph_GUI = graph_GUI;
    }

    public void setHistory_GUI(History_GUI history_GUI) {
        this.history_GUI = history_GUI;
    }

    @Override
    public void setInteractionFlag(byte by) {
    }

    public void setModel_GUI(Model_GUI model_GUI) {
        this.model_GUI = model_GUI;
    }

    public void setPlot_GUI(Plot_GUI plot_GUI) {
        this.plot_GUI = plot_GUI;
    }

    public void setProjectChanged() {
        this.projectChangedTimer.restart();
    }

    public void setProjectFile(File file) {
        this.projectFile = file;
        if (file != null) {
            this.projectname = jopensaveDialog.getFileName(file);
        }
    }

    public void setScriptMode() {
        this.scriptMode = true;
    }

    public void setSelectedWindow(DataTreeInterface dataTreeInterface) {
        if (this.dataMonitor != null) {
            this.dataMonitor.setInteractionObject(dataTreeInterface);
        }
    }

    public void setWindowProperties(Properties properties) throws Exception {
        this.data_GUI.setProperties(properties);
        this.plot_GUI.setProperties(properties);
        this.projectLayout.setProperties(properties);
        if (ScriptHelper.hasKey(properties, "toolbar")) {
            this.showToolbars(ScriptHelper.getPropertyBool(properties, "toolbar"));
            Project_GUI.getMainGUI().rebuildToolsMenu(this);
        }
        if (ScriptHelper.hasKey(properties, "projectname")) {
            this.projectname = ScriptHelper.getProperty(properties, "projectname");
            this.projectFile = null;
            Project_GUI.getMainGUI().updateTitle(this);
        }
    }

    public void showToolbars(boolean bl) {
        this.toolbarVisible = bl;
        this.graph_GUI.showToolbar(bl);
        this.data_GUI.showToolbar(bl);
        this.plot_GUI.showToolbar(bl);
        this.history_GUI.showToolbar(bl);
        this.model_GUI.showToolbar(bl);
        this.projectLayout.getProjectPane((byte)0).getNorthPanel().setVisible(bl);
    }

    public void statisticSignal() {
        this.plot_GUI.PostGlobalMessage((byte)6, (byte)0);
    }

    public void suggestProjectName(String string) {
        if (this.projectFile == null) {
            this.projectname = string;
            Main_GUI main_GUI = Project_GUI.getMainGUI();
            if (main_GUI != null) {
                main_GUI.updateTitle(this);
                main_GUI.selectCurrentProject(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedImage takeScreenShot(int n) {
        BufferedImage bufferedImage = null;
        this.isTakingScreenshot = true;
        try {
            double d;
            double d2 = this.getWidth();
            double d3 = this.getHeight();
            BufferedImage bufferedImage2 = new BufferedImage(n, n, 2);
            int n2 = 0;
            int n3 = 0;
            int n4 = n / 2 - 1;
            int n5 = n / 2 - 1;
            Graphics2D graphics2D = bufferedImage2.createGraphics();
            if (d2 > d3) {
                d = (double)n / d2;
                graphics2D.translate(0.0, ((double)n - d3 * d) * 0.5);
                n3 = (int)(((double)n - d3 * d) * 0.25);
                n5 -= 2 * n3;
            } else {
                d = (double)n / d3;
                graphics2D.translate(((double)n - d2 * d) * 0.5, 0.0);
                n2 = (int)(((double)n - d2 * d) * 0.25);
                n4 -= 2 * n2;
            }
            graphics2D.scale(d, d);
            this.paint(graphics2D);
            graphics2D.dispose();
            bufferedImage = new BufferedImage(n / 2, n / 2, 2);
            graphics2D = bufferedImage.createGraphics();
            graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            graphics2D.drawImage(bufferedImage2, 0, 0, n / 2, n / 2, null);
            graphics2D.setColor(Color.black);
            graphics2D.drawRect(n2, n3, n4, n5);
            graphics2D.dispose();
        }
        catch (Exception exception) {
            ErrorHandler.logAndReportException(exception);
        }
        finally {
            this.isTakingScreenshot = false;
        }
        return bufferedImage;
    }

    @Override
    public String toString() {
        return this.getGUI_Name();
    }

    public void touchSwapFile() {
        if (this.dataTreeManager != null) {
            this.dataTreeManager.touchSwapFile();
        }
    }

    public void updateDataTree(DataTreeInterface dataTreeInterface) {
        if (this.dataMonitor != null) {
            this.dataMonitor.UpdateDataTree(dataTreeInterface);
        }
    }

    public void updateNow() {
        if (this.dataMonitor != null) {
            this.dataMonitor.UpdateDataTree(null);
        }
    }

    public void updateUnhideablePanels(int n) {
        this.projectLayout.updateUnhideablePanels(n);
    }

    @Override
    protected void cleanUpChild() {
        if (this.graph_GUI != null) {
            this.graph_GUI.cleanUp();
        }
        if (this.model_GUI != null) {
            this.model_GUI.cleanUp();
        }
        if (this.history_GUI != null) {
            this.history_GUI.cleanUp();
        }
        if (this.data_GUI != null) {
            this.data_GUI.cleanUp();
        }
        if (this.plot_GUI != null) {
            this.plot_GUI.cleanUp();
        }
        if (this.rootNode != null) {
            this.rootNode.cleanUp();
        }
        if (this.dataMonitor != null) {
            this.dataMonitor.cleanUp();
        }
        if (this.dataTreeManager != null) {
            this.dataTreeManager.cleanUp();
        }
        if (this.layoutToolbar != null) {
            this.layoutToolbar.cleanUp();
        }
        if (this.emptyWindow != null) {
            this.emptyWindow.cleanUp();
        }
        if (this.settingsWest != null) {
            this.settingsWest.cleanUp();
        }
        if (this.settingsEast != null) {
            this.settingsEast.cleanUp();
        }
        if (this.projectLayout != null) {
            this.projectLayout.cleanUp();
        }
        this.interactionInterface = null;
    }

    void addToDesktop(RandomInputStream randomInputStream) {
        this.dataMonitor = new DataMonitor(this, randomInputStream);
        this.settingsWest.setCenterPanel(this.dataMonitor);
        this.projectLayout.setProjectPane(this.data_GUI, (byte)2);
        this.projectLayout.setProjectPane(this.plot_GUI, (byte)3);
        this.projectLayout.setProjectPane(this.graph_GUI, (byte)1);
        this.projectLayout.setProjectPane(this.history_GUI, (byte)5);
        this.projectLayout.setProjectPane(this.model_GUI, (byte)6);
    }

    private DataContainer createRootNode() {
        DataContainer dataContainer = new DataContainer("Project Root", -1);
        dataContainer.setRootNode(this.dataTreeManager);
        return dataContainer;
    }

    public InteractionGroup getInteractionGroup(int n) {
        if (this.interactionGroupList == null) {
            this.interactionGroupList = new ArrayList<InteractionGroup>();
        }
        for (InteractionGroup interactionGroup : this.interactionGroupList) {
            if (interactionGroup.getGroupID() != n) continue;
            return interactionGroup;
        }
        InteractionGroup interactionGroup = new InteractionGroup(n);
        this.interactionGroupList.add(interactionGroup);
        return interactionGroup;
    }

    private void jbInit() throws Exception {
        Serializable serializable;
        if (this.rootNode != null && (serializable = (ResourceNode)this.rootNode.getNodeByName("Resources")) == null) {
            serializable = new ResourceNode();
            this.rootNode.addTreeNode((DataTreeInterface)((Object)serializable));
        }
        this.setSize(800, 600);
        serializable = new JToolBar();
        ((JComponent)serializable).setBackground(Color.white);
        ((JToolBar)serializable).setFloatable(false);
        ((JComponent)serializable).setBorder(null);
        JFlatButton jFlatButton = new JFlatButton();
        jFlatButton.setToolTipText("Help Topics");
        jFlatButton.setIcon(new ImageIcon(Main_GUI.class.getResource("icons/common/help.png")));
        jFlatButton.addActionListener(actionEvent -> Main_GUI.showHelp(actionEvent));
        JFlatButton jFlatButton2 = new JFlatButton();
        jFlatButton2.setToolTipText("Open Project");
        jFlatButton2.setIcon(new ImageIcon(Main_GUI.class.getResource("icons/common/openFile.png")));
        jFlatButton2.addActionListener(actionEvent -> Project_GUI.getMainGUI().openProject(actionEvent, false));
        JFlatButton jFlatButton3 = new JFlatButton();
        jFlatButton3.setToolTipText("New Project");
        jFlatButton3.setBorderPainted(false);
        jFlatButton3.setIcon(new ImageIcon(Main_GUI.class.getResource("icons/common/newFile.png")));
        jFlatButton3.addActionListener(actionEvent -> Project_GUI.getMainGUI().newProject(actionEvent, true));
        this.save.setToolTipText("Save Project");
        this.save.setEnabled(this.projectChanged);
        this.save.setIcon(new ImageIcon(Main_GUI.class.getResource("icons/common/saveFile.png")));
        this.save.addActionListener(actionEvent -> Project_GUI.getMainGUI().saveSelectedFrame(false, false));
        ((Container)serializable).add(jFlatButton3, null);
        ((JToolBar)serializable).addSeparator();
        ((Container)serializable).add(jFlatButton2);
        ((Container)serializable).add(this.save);
        ((JToolBar)serializable).addSeparator();
        ((Container)serializable).add(jFlatButton);
        this.layoutToolbar = this.projectLayout.getToolbar();
        this.jMenuGraph.setMnemonic('G');
        this.jMenuData.setMnemonic('a');
        this.jMenuPlot.setMnemonic('P');
        this.jMenuModel.setMnemonic('M');
        this.jMenuHistory.setMnemonic('H');
        this.add((Component)this.projectLayout, "Center");
        this.settingsWest = this.projectLayout.getProjectPane((byte)0);
        this.settingsWest.setPreferredSize(new Dimension(190, 0));
        this.settingsWest.setNorthPanel((JComponent)serializable);
        this.settingsEast = this.projectLayout.getProjectPane((byte)4);
        this.settingsEast.setPreferredSize(new Dimension(190, 0));
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(EvinceBorderFactory.createEvinceBorder("Layout (show/hide)"));
        jPanel.setBackground(Color.white);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)this.layoutToolbar, gridBagConstraints);
        this.settingsWest.setSouthPanel(jPanel);
        CMenuItem cMenuItem = new CMenuItem("Apply All Changes", 80){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Project_GUI.this.applyAllChanges();
            }
        };
        cMenuItem.setIcon(new ImageIcon(Main_GUI.class.getResource("gif/update.png")));
    }

    private void saveProject(ProgressManager progressManager, boolean bl, boolean bl2) {
        try {
            progressManager.setInfoText("Save project file " + this.projectFile.getName());
            this.save(bl, bl2);
        }
        catch (MapException mapException) {
            progressManager.Finish();
            JOptionPane.showConfirmDialog(this, mapException.getMessage(), "Save error", -1, 0);
            mapException.printStackTrace();
        }
        catch (IOException iOException) {
            progressManager.Finish();
            ErrorHandler.logAndShowEvinceErrorDialogForException(iOException);
        }
    }

    private void setDataSetsCreated(boolean bl) {
        this.setDataSetsCreated(this.rootNode, bl);
        for (int i = 0; i < this.rootNode.getTreeNodeCount(); ++i) {
            DataTreeInterface dataTreeInterface = this.rootNode.getTreeNodeAt(i);
            if (!(dataTreeInterface instanceof Case) || ((Case)dataTreeInterface).getOriginalDataSet() == null) continue;
            ((Case)dataTreeInterface).getOriginalDataSet().setCreated(this, bl);
        }
    }

    private void setDataSetsCreated(DataTreeInterface dataTreeInterface, boolean bl) {
        for (int i = 0; i < dataTreeInterface.getTreeNodeCount(); ++i) {
            DataTreeInterface dataTreeInterface2 = dataTreeInterface.getTreeNodeAt(i);
            if (dataTreeInterface2 instanceof DataSet) {
                if (!(dataTreeInterface2.getTreeParent() instanceof DataContainer)) continue;
                ((DataSet)dataTreeInterface2).setCreated(this, bl);
                continue;
            }
            this.setDataSetsCreated(dataTreeInterface2, bl);
        }
    }

    private void takeScreenShot(RandomOutputStream randomOutputStream) {
        try {
            BufferedImage bufferedImage = this.takeScreenShot(400);
            if (bufferedImage != null) {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)bufferedImage, "png", byteArrayOutputStream);
                randomOutputStream.write(byteArrayOutputStream.toByteArray());
                byteArrayOutputStream.close();
            }
        }
        catch (IOException iOException) {
            ErrorHandler.logAndReportException(iOException);
        }
    }

    public static class AbortException
    extends Exception {
    }
}

