/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.main;

import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.io.File;
import java.util.List;
import javax.swing.JMenu;
import javax.swing.JPanel;
import se.prediktera.map.common.CMenuItem;
import se.prediktera.map.common.error.Logg;
import se.prediktera.map.common.update.UpdateHelper;
import se.prediktera.map.datasetcontainer.DataTreeInterface;
import se.prediktera.map.main.IniManager;
import se.prediktera.map.main.Main_GUI;
import se.prediktera.map.main.Project_GUI;

public class ProjectsContainer
extends JPanel {
    private final List<File> recentProject;
    private final CardLayout cardLayout = new CardLayout();
    private int constrainsIndex = 0;
    private Project_GUI currentProject;
    private final int MAX_RECENT_FILES = 40;

    public ProjectsContainer() {
        this.recentProject = IniManager.getRecentProject();
        this.setLayout(this.cardLayout);
        this.setBackground(Color.GRAY);
    }

    public void addFileToRecent(File file) {
        if (file != null) {
            for (int i = this.recentProject.size() - 1; i >= 0; --i) {
                if (!file.equals(this.recentProject.get(i))) continue;
                this.recentProject.remove(i);
            }
            this.recentProject.add(0, file);
            while (this.recentProject.size() > 40) {
                this.recentProject.remove(this.recentProject.size() - 1);
            }
            IniManager.SaveIni();
        }
    }

    public void addProject(Project_GUI project_GUI, boolean bl) {
        project_GUI.setConstrains(String.valueOf(this.constrainsIndex++));
        this.add((Component)project_GUI, project_GUI.getConstraints());
        if (!bl) {
            this.addFileToRecent(project_GUI.getProjectFile());
        }
        if (UpdateHelper.Product.isRunningProductEvince()) {
            try {
                Main_GUI.get().updateRecentFiles();
            }
            catch (Exception exception) {
                Logg.error("Error updating recent files", exception);
            }
        }
        this.setCurrentProject(project_GUI);
    }

    public boolean close() {
        return this.close(true);
    }

    public boolean close(boolean bl) {
        IniManager.SaveIni();
        for (int i = this.getNumberOfProject() - 1; i >= 0; --i) {
            Project_GUI project_GUI = this.getProjectAt(i);
            Main_GUI.get().updateTitle(project_GUI);
            if (project_GUI.closeProject(bl)) continue;
            this.setCurrentProject(project_GUI);
            return false;
        }
        this.currentProject = null;
        return true;
    }

    public Project_GUI getCurrentProject() {
        return this.currentProject;
    }

    public int getNumberOfProject() {
        return this.getComponentCount();
    }

    public Project_GUI getProjectAt(int n) {
        return (Project_GUI)this.getComponent(n);
    }

    public JMenu getProjectMenu(boolean bl) {
        JMenu jMenu = new JMenu("Switch to Project");
        for (int i = 0; i < this.getNumberOfProject(); ++i) {
            Project_GUI project_GUI = this.getProjectAt(i);
            CMenuItem cMenuItem = new CMenuItem(project_GUI);
            cMenuItem.setEnabled(bl && project_GUI != this.currentProject);
            cMenuItem.addActionListener(actionEvent -> {
                CMenuItem cMenuItem = (CMenuItem)actionEvent.getSource();
                this.setCurrentProject((Project_GUI)cMenuItem.getObject());
            });
            jMenu.add(cMenuItem);
        }
        return jMenu;
    }

    public List getRecentVector() {
        return this.recentProject;
    }

    public String getUniqueProjectName() {
        Object object = "Untitled Case";
        int n = 1;
        while (this.projectNameExists((String)object)) {
            object = "Untitled Case " + n++;
        }
        return object;
    }

    public boolean isEmpty() {
        return this.getComponentCount() == 0;
    }

    public boolean projectNameExists(String string) {
        for (int i = 0; i < this.getNumberOfProject(); ++i) {
            Project_GUI project_GUI = this.getProjectAt(i);
            if (!project_GUI.getGUI_Name().equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    public void reloadAllDataTrees(DataTreeInterface dataTreeInterface) {
        for (int i = 0; i < this.getNumberOfProject(); ++i) {
            this.getProjectAt(i).updateDataTree(dataTreeInterface);
        }
    }

    public void removeAllProjects() {
        Project_GUI project_GUI;
        for (int i = this.getNumberOfProject() - 1; i >= 0 && this.removeProject(project_GUI = this.getProjectAt(i)); --i) {
        }
    }

    public boolean removeProject(Project_GUI project_GUI) {
        return this.removeProject(project_GUI, true);
    }

    public boolean removeProject(Project_GUI project_GUI, boolean bl) {
        if (project_GUI.closeProject(bl)) {
            this.removeProjectNoClose(project_GUI);
            return true;
        }
        return false;
    }

    public void removeProjectNoClose(Project_GUI project_GUI) {
        this.remove(project_GUI);
        if (this.getNumberOfProject() > 0) {
            this.setCurrentProject(this.getProjectAt(this.getNumberOfProject() - 1));
        } else {
            this.setCurrentProject(null);
        }
        System.gc();
    }

    public void saveProject(Project_GUI project_GUI, boolean bl, boolean bl2) {
        project_GUI.save(null, bl, bl2, false);
        if (!bl2) {
            this.addFileToRecent(project_GUI.getProjectFile());
        }
        Main_GUI.get().updateRecentFiles();
    }

    public void setCurrentProject(Project_GUI project_GUI) {
        this.currentProject = project_GUI;
        Main_GUI.get().selectCurrentProject(project_GUI);
        if (project_GUI != null) {
            this.cardLayout.show(this, project_GUI.getConstraints());
            project_GUI.revalidate();
            project_GUI.repaint();
        }
    }

    public void touchSwapFiles() {
        for (int i = 0; i < this.getNumberOfProject(); ++i) {
            this.getProjectAt(i).touchSwapFile();
        }
    }

    public void updateNow() {
        for (int i = 0; i < this.getNumberOfProject(); ++i) {
            this.getProjectAt(i).updateNow();
        }
    }
}

