/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.main;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import se.prediktera.map.dataimport.AbstractDataSource;
import se.prediktera.map.datasetcontainer.Case;
import se.prediktera.map.main.Evince;
import se.prediktera.map.main.IniManager;
import se.prediktera.map.main.Project_GUI;
import se.prediktera.map.main.PropertiesElement;

public class PropertiesPanel
extends JPanel {
    private final PropertiesTableModel tableModel;
    private JTable jtable = null;
    private final JTextArea propertiesTextArea = new JTextArea();
    private final List<PropertiesElement> propertiesList = new ArrayList<PropertiesElement>();
    private PropertiesElement lastElement = null;
    private final Project_GUI projectGUI;

    public static void main(String[] stringArray) throws Exception {
        UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        JFrame jFrame = new JFrame();
        jFrame.setDefaultCloseOperation(3);
        Properties properties = new Properties();
        properties.put("Username", "Test user");
        properties.put("Serie number", "12345");
        properties.put("Comment", "Test comment");
        PropertiesPanel propertiesPanel = new PropertiesPanel(null, properties);
        jFrame.getContentPane().add((Component)propertiesPanel, "Center");
        jFrame.pack();
        jFrame.setLocationRelativeTo(null);
        jFrame.setVisible(true);
    }

    public static List<PropertiesElement> parsePropertiesProperties(List<PropertiesElement> list, String string) {
        if (string.length() > 0) {
            String[] stringArray;
            for (String string2 : stringArray = string.split("&&")) {
                String[] stringArray2 = string2.split("&#");
                String string3 = "Key";
                String string4 = "Value";
                if (stringArray2.length > 0) {
                    string3 = stringArray2[0];
                }
                if (stringArray2.length > 1) {
                    string4 = stringArray2[1];
                }
                if (string3.length() <= 0) continue;
                list.add(new PropertiesElement(string3, string4, false));
            }
            return list;
        }
        return null;
    }

    public static String parsePropertiesString(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        if (string == null || string.length() == 0) {
            return "";
        }
        ArrayList<PropertiesElement> arrayList = new ArrayList<PropertiesElement>();
        PropertiesPanel.parsePropertiesProperties(arrayList, string);
        for (PropertiesElement propertiesElement : arrayList) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append("\n");
            }
            stringBuilder.append(propertiesElement.key);
            if (propertiesElement.value == null || propertiesElement.value.length() <= 0 || propertiesElement.value.equals("Value")) continue;
            stringBuilder.append(": ");
            stringBuilder.append(propertiesElement.value);
        }
        return stringBuilder.toString();
    }

    public PropertiesPanel(Project_GUI project_GUI) {
        this.projectGUI = project_GUI;
        this.setLayout(new BorderLayout());
        JToolBar jToolBar = new JToolBar();
        jToolBar.setFloatable(false);
        this.tableModel = new PropertiesTableModel();
        JButton jButton = new JButton("Add");
        jButton.setIcon(new ImageIcon(Evince.class.getResource("gif/compplus.gif")));
        jButton.addActionListener(actionEvent -> {
            this.propertiesList.add(new PropertiesElement("Key", "Value", false));
            this.tableModel.fireTableStructureChanged();
            int n = this.propertiesList.size() - 1;
            this.jtable.setRowSelectionInterval(n, n);
        });
        jToolBar.add(jButton);
        JButton jButton2 = new JButton("Remove");
        jButton2.setIcon(new ImageIcon(Evince.class.getResource("gif/compminus.gif")));
        jButton2.addActionListener(actionEvent -> {
            int n = this.jtable.getSelectedRow();
            if (n >= 0) {
                this.propertiesList.remove(n);
                this.tableModel.fireTableStructureChanged();
                if (--n >= 0) {
                    this.jtable.setRowSelectionInterval(n, n);
                } else if (this.jtable.getRowCount() > 0) {
                    this.jtable.setRowSelectionInterval(0, 0);
                }
            }
        });
        jToolBar.add(jButton2);
        this.add((Component)jToolBar, "North");
        JSplitPane jSplitPane = new JSplitPane();
        jSplitPane.setOrientation(0);
        this.add((Component)jSplitPane, "Center");
        this.jtable = new JTable(this.tableModel);
        this.jtable.setSelectionMode(0);
        this.jtable.getSelectionModel().addListSelectionListener(listSelectionEvent -> {
            if (listSelectionEvent.getSource() == this.jtable.getSelectionModel()) {
                int n;
                if (this.lastElement != null && !this.lastElement.fixed) {
                    this.lastElement.value = this.propertiesTextArea.getText();
                }
                if ((n = this.jtable.getSelectedRow()) >= 0) {
                    this.lastElement = this.propertiesList.get(n);
                    this.propertiesTextArea.setText(this.lastElement.value);
                    this.propertiesTextArea.setEnabled(!this.lastElement.fixed);
                    this.propertiesTextArea.setEditable(!this.lastElement.fixed);
                }
            }
        });
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setViewportView(this.jtable);
        jSplitPane.setLeftComponent(jScrollPane);
        JScrollPane jScrollPane2 = new JScrollPane();
        jScrollPane2.setPreferredSize(new Dimension(200, 200));
        this.propertiesTextArea.setPreferredSize(new Dimension(0, 100));
        jScrollPane2.setViewportView(this.propertiesTextArea);
        jSplitPane.setRightComponent(jScrollPane2);
        jSplitPane.setDividerLocation(300);
    }

    public PropertiesPanel(Project_GUI project_GUI, Properties properties) {
        this(project_GUI);
        Set<Map.Entry<Object, Object>> set = properties.entrySet();
        for (Map.Entry<Object, Object> entry : set) {
            this.propertiesList.add(new PropertiesElement(String.valueOf(entry.getKey()), String.valueOf(entry.getValue()), false));
        }
        this.tableModel.fireTableStructureChanged();
        if (this.jtable.getRowCount() > 0) {
            this.jtable.setRowSelectionInterval(0, 0);
        }
    }

    public void addProperties(Properties properties) {
        Set<Map.Entry<Object, Object>> set = properties.entrySet();
        int n = set.size();
        if (n > 0) {
            for (Map.Entry<Object, Object> entry : set) {
                this.propertiesList.add(new PropertiesElement(String.valueOf(entry.getKey()), String.valueOf(entry.getValue()), false));
            }
        }
    }

    public void addProperty(String string, String string2) {
        this.propertiesList.add(new PropertiesElement(string, string2, false));
    }

    public void setProperty(String string, String string2) {
        PropertiesElement propertiesElement = this.getProperty(string);
        if (propertiesElement != null) {
            propertiesElement.setValue(string2);
        } else {
            this.propertiesList.add(new PropertiesElement(string, string2, false));
        }
    }

    public void clearProperties() {
        this.propertiesList.clear();
    }

    public String getProperties(boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        for (PropertiesElement propertiesElement : this.propertiesList) {
            if (propertiesElement.fixed && !bl) continue;
            stringBuilder.append(propertiesElement.key);
            stringBuilder.append("&#");
            stringBuilder.append(propertiesElement.value);
            stringBuilder.append("&&");
        }
        if (bl && stringBuilder.length() == 0) {
            stringBuilder.append("&&");
        }
        return stringBuilder.toString();
    }

    public PropertiesElement getProperty(String string) {
        for (PropertiesElement propertiesElement : this.propertiesList) {
            if (!propertiesElement.key.equalsIgnoreCase(string)) continue;
            return propertiesElement;
        }
        return null;
    }

    public void setText(String string) {
        PropertiesPanel.parsePropertiesProperties(this.propertiesList, string);
        this.propertiesList.add(new PropertiesElement("Username", IniManager.getUsername(), true));
        if (this.projectGUI != null) {
            File file;
            AbstractDataSource abstractDataSource;
            Case case_;
            File file2 = this.projectGUI.getProjectFile();
            if (file2 != null) {
                this.propertiesList.add(new PropertiesElement("Projectpath", file2.getAbsolutePath(), true));
            }
            if ((case_ = this.projectGUI.getPrimaryCase()) != null && (abstractDataSource = case_.getDataSource()) != null && (file = abstractDataSource.getDataSourceFile()) != null) {
                this.propertiesList.add(new PropertiesElement("Rawfile", file.getAbsolutePath(), true));
            }
        }
        if (this.propertiesList.size() > 0) {
            this.tableModel.fireTableStructureChanged();
            if (this.jtable.getRowCount() > 0) {
                this.jtable.setRowSelectionInterval(0, 0);
            }
        }
    }

    private class PropertiesTableModel
    extends AbstractTableModel
    implements TableModel {
        private PropertiesTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return "Key";
            }
            return "Value";
        }

        @Override
        public int getRowCount() {
            if (PropertiesPanel.this.propertiesList != null) {
                return PropertiesPanel.this.propertiesList.size();
            }
            return 0;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            PropertiesElement propertiesElement = PropertiesPanel.this.propertiesList.get(n);
            if (n2 == 0) {
                return propertiesElement.key;
            }
            return propertiesElement.value;
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            PropertiesElement propertiesElement = PropertiesPanel.this.propertiesList.get(n);
            return !propertiesElement.fixed;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            PropertiesElement propertiesElement = PropertiesPanel.this.propertiesList.get(n);
            if (n2 == 0) {
                propertiesElement.key = String.valueOf(object);
            } else {
                propertiesElement.value = String.valueOf(object);
                PropertiesPanel.this.propertiesTextArea.setText(propertiesElement.value);
            }
        }
    }
}

