/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.main;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import se.prediktera.map.common.cleanup.CleanUpDialog;
import se.prediktera.map.main.IniManager;

public class ProxyDialog
extends CleanUpDialog {
    private final JLabel jLabel1 = new JLabel("Host: (e.g. www.prediktera.com)");
    private final JTextField textHost = new JTextField();
    private final JLabel jLabel2 = new JLabel("Port: (-1 default)");
    private final JTextField textPort = new JTextField();
    private final JCheckBox checkProxy = new JCheckBox("Enable Proxy");
    private final JCheckBox checkAuthentication = new JCheckBox("Use Authentication");
    private final JLabel jLabel4 = new JLabel("Username:");
    private final JTextField textUser = new JTextField();
    private final JLabel jLabel5 = new JLabel("Password:");
    private final JTextField textPassword = new JTextField();

    public static void RunProxySettings() {
        new ProxyDialog().setVisible(true);
    }

    public ProxyDialog() {
        super(IniManager.getMainFrame(), true);
        this.jbInit();
        this.checkProxyChanged();
        this.checkAuthenticationChanged();
        this.pack();
        this.setLocationRelativeTo(IniManager.getMainFrame());
    }

    @Override
    protected void cleanUpChild() {
    }

    private void checkAuthenticationChanged() {
        this.jLabel4.setEnabled(this.checkProxy.isSelected() && this.checkAuthentication.isSelected());
        this.textUser.setEnabled(this.checkProxy.isSelected() && this.checkAuthentication.isSelected());
        this.jLabel5.setEnabled(this.checkProxy.isSelected() && this.checkAuthentication.isSelected());
        this.textPassword.setEnabled(this.checkProxy.isSelected() && this.checkAuthentication.isSelected());
    }

    private void checkProxyChanged() {
        this.jLabel1.setEnabled(this.checkProxy.isSelected());
        this.textHost.setEnabled(this.checkProxy.isSelected());
        this.jLabel2.setEnabled(this.checkProxy.isSelected());
        this.textPort.setEnabled(this.checkProxy.isSelected());
        this.checkAuthentication.setEnabled(this.checkProxy.isSelected());
        this.checkAuthenticationChanged();
    }

    private void jbInit() {
        JPanel jPanel = new JPanel(new BorderLayout());
        JButton jButton = new JButton("Cancel");
        JButton jButton2 = new JButton("OK");
        jButton.setPreferredSize(new Dimension(75, 27));
        jButton.addActionListener(actionEvent -> this.dispose());
        jButton2.setPreferredSize(new Dimension(75, 27));
        jButton2.addActionListener(actionEvent -> this.okPressed());
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        JPanel jPanel3 = new JPanel(new FlowLayout(2));
        jPanel3.setBorder(BorderFactory.createEmptyBorder());
        this.jLabel2.setRequestFocusEnabled(true);
        this.jLabel2.setHorizontalAlignment(4);
        this.jLabel2.setHorizontalTextPosition(11);
        this.textPort.setPreferredSize(new Dimension(80, 20));
        this.textPort.setText(IniManager.getProxyPort());
        this.checkProxy.addItemListener(itemEvent -> this.checkProxyChanged());
        this.checkProxy.setSelected(IniManager.hasProxy());
        this.textHost.setText(this.checkProxy.isSelected() ? IniManager.getProxyHost() : "");
        this.setTitle("Proxy Settings");
        jPanel.setPreferredSize(new Dimension(400, 300));
        this.checkAuthentication.addItemListener(itemEvent -> this.checkAuthenticationChanged());
        this.checkAuthentication.setSelected(IniManager.hasAuthentication());
        this.textUser.setText(this.checkAuthentication.isSelected() ? IniManager.getProxyUser() : "");
        this.textPassword.setText(this.checkAuthentication.isSelected() ? IniManager.getProxyPassword() : "");
        this.getContentPane().add((Component)jPanel, "Center");
        jPanel.add((Component)jPanel2, "Center");
        jPanel.add((Component)jPanel3, "South");
        jPanel3.add((Component)jButton2, null);
        jPanel3.add((Component)jButton, null);
        jPanel2.add((Component)this.jLabel1, new GridBagConstraints(0, 1, 4, 1, 0.0, 0.0, 17, 0, new Insets(0, 20, 0, 0), 0, 0));
        jPanel2.add((Component)this.textHost, new GridBagConstraints(0, 2, 4, 1, 1.0, 0.0, 10, 2, new Insets(0, 20, 10, 10), 0, 0));
        jPanel2.add((Component)this.textPort, new GridBagConstraints(3, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 10, 0, 10), 0, 0));
        jPanel2.add((Component)this.checkProxy, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 20, 10), 0, 0));
        jPanel2.add((Component)this.jLabel2, new GridBagConstraints(2, 3, 1, 1, 1.0, 0.0, 13, 2, new Insets(0, 0, 0, 0), 0, 0));
        jPanel2.add((Component)new JSeparator(), new GridBagConstraints(0, 8, 4, 1, 1.0, 1.0, 15, 2, new Insets(0, 0, 0, 0), 0, 0));
        jPanel2.add((Component)new JSeparator(), new GridBagConstraints(2, 4, 1, 1, 0.0, 0.0, 10, 0, new Insets(10, 0, 0, 0), 0, 0));
        jPanel2.add((Component)this.checkAuthentication, new GridBagConstraints(0, 5, 2, 1, 0.0, 0.0, 10, 0, new Insets(10, 10, 20, 0), 0, 0));
        jPanel2.add((Component)this.jLabel4, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 20, 5, 0), 0, 0));
        jPanel2.add((Component)this.textUser, new GridBagConstraints(1, 6, 3, 1, 0.0, 0.0, 10, 2, new Insets(0, 10, 5, 10), 0, 0));
        jPanel2.add((Component)this.jLabel5, new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 20, 0, 0), 0, 0));
        jPanel2.add((Component)this.textPassword, new GridBagConstraints(1, 7, 3, 1, 0.0, 0.0, 17, 2, new Insets(0, 10, 0, 10), 0, 0));
    }

    private void okPressed() {
        if (this.checkProxy.isSelected()) {
            IniManager.setProxySettings((byte)0, "TRUE");
            IniManager.setProxySettings((byte)1, this.textHost.getText());
            IniManager.setProxySettings((byte)2, this.textPort.getText());
        } else {
            IniManager.setProxySettings((byte)0, "FALSE");
            IniManager.setProxySettings((byte)1, "");
            IniManager.setProxySettings((byte)2, "");
        }
        if (this.checkProxy.isSelected() && this.checkAuthentication.isSelected()) {
            IniManager.setProxySettings((byte)5, "TRUE");
            IniManager.setProxySettings((byte)3, this.textUser.getText());
            IniManager.setProxySettings((byte)4, this.textPassword.getText());
        } else {
            IniManager.setProxySettings((byte)5, "TRUE");
            IniManager.setProxySettings((byte)3, "");
            IniManager.setProxySettings((byte)4, "");
        }
        this.dispose();
    }
}

