/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.main;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Base64;
import java.util.UUID;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.json.JSONObject;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.common.error.Logg;
import se.prediktera.map.common.progress.ProgressManagerImpl;
import se.prediktera.map.common.update.UpdateHelper;
import se.prediktera.map.main.Evince;
import se.prediktera.map.main.IniManager;
import se.prediktera.map.register.RegInfo;
import se.prediktera.map.register.UniqueIdManager;

public class RESTInvoker {
    public final boolean useTrustAllCerts;
    private static RESTInvoker instance;
    private final String baseUrl;

    public static RESTInvoker getInstance() {
        if (instance == null) {
            instance = new RESTInvoker(IniManager.getUserPage("api/"), false);
        }
        return instance;
    }

    private RESTInvoker(String string, boolean bl) {
        this.baseUrl = string;
        this.useTrustAllCerts = bl;
    }

    public String getLicenseText(String string, String string2, String string3) {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("uac", (Object)string3);
        return this.getDataFromServer(string, string2, jSONObject, (HttpRequestBase)new HttpPost(this.baseUrl + "license"));
    }

    public String getLicenseText(String string, String string2) {
        string = string.trim().split("\\s+")[0];
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("uac", (Object)string2);
        return this.getDataFromServer(null, null, string, jSONObject, (HttpRequestBase)new HttpPost(this.baseUrl + "license"));
    }

    public String createLicense(String string, String string2, String string3, String string4, String string5, String string6, String string7, String[] stringArray, String[] stringArray2, UpdateHelper.Product product) {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("userName", (Object)string3);
        jSONObject.put("firstName", (Object)string);
        jSONObject.put("lastName", (Object)string2);
        jSONObject.put("emailAddress", (Object)string3);
        jSONObject.put("organisation", (Object)string4);
        jSONObject.put("uac", (Object)string6);
        jSONObject.put("features", (Object)string7);
        jSONObject.put("product", (Object)product.toString());
        jSONObject.put("interests", (Object)stringArray);
        jSONObject.put("cameras", (Object)stringArray2);
        Logg.trace("Create trial data (-password): " + String.valueOf(jSONObject), new Object[0]);
        jSONObject.put("password", (Object)string5);
        return this.getDataFromServer(null, null, jSONObject, (HttpRequestBase)new HttpPost(this.baseUrl + "license/trial"));
    }

    public String logUser(RegInfo regInfo, UpdateHelper.Platform platform, UpdateHelper.Product product, UpdateHelper.UpdateVersion updateVersion) {
        JSONObject jSONObject = new JSONObject();
        String string = UniqueIdManager.generateOneUniqueId();
        jSONObject.put("userId", regInfo.ID == 0 && regInfo.isFeatureActive(RegInfo.LicenseFeature.HySpexRecorder) ? RegInfo.LicenseFeature.HySpexRecorder.getCode() : regInfo.ID);
        jSONObject.put("licenseId", regInfo.LID);
        if (regInfo.LID == 0 || regInfo.isArchived || regInfo.isUnbound()) {
            jSONObject.put("passiveClaim", (Object)RegInfo.getPassiveClaimToken(regInfo, string));
        } else {
            string = regInfo.getActiveSerial();
        }
        jSONObject.put("platform", platform.getTypeInt());
        jSONObject.put("type", product.getTypeInt());
        jSONObject.put("uac", (Object)string);
        jSONObject.put("version", (Object)updateVersion.format(false));
        jSONObject.put("timestamp", regInfo.TimeStamp);
        return this.getDataFromServer(null, null, jSONObject, (HttpRequestBase)new HttpPost(this.baseUrl + "log"));
    }

    public String getIPrequest() {
        return this.getDataFromServer(null, null, null, (HttpRequestBase)new HttpGet(this.baseUrl + "log/iprequest"));
    }

    private String getDataFromServer(String string, String string2, JSONObject jSONObject, HttpRequestBase httpRequestBase) {
        return this.getDataFromServer(string, string2, null, jSONObject, httpRequestBase);
    }

    private String getDataFromServer(String string, String string2, String string3, JSONObject jSONObject, HttpRequestBase httpRequestBase) {
        Object object;
        CloseableHttpResponse closeableHttpResponse;
        CloseableHttpClient closeableHttpClient = HttpClientBuilder.create().build();
        if (this.useTrustAllCerts) {
            closeableHttpResponse = new CloseableHttpResponse[]{new X509TrustManager(this){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }

                @Override
                public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) {
                }
            }};
            try {
                object = SSLContext.getInstance("SSL");
                ((SSLContext)object).init(null, (TrustManager[])closeableHttpResponse, new SecureRandom());
                closeableHttpClient = HttpClients.custom().setSSLContext((SSLContext)object).setSSLHostnameVerifier((HostnameVerifier)NoopHostnameVerifier.INSTANCE).build();
            }
            catch (KeyManagementException | NoSuchAlgorithmException generalSecurityException) {
                Logg.error("Failed to install ssl exception", generalSecurityException);
            }
        }
        try {
            Object object2;
            httpRequestBase.addHeader("Content-Type", "application/json");
            httpRequestBase.addHeader("X-CSRF-Token", "Fetch");
            if (string != null) {
                httpRequestBase.addHeader("Authorization", "Basic " + Base64.getEncoder().encodeToString((string + ":" + string2).getBytes()));
            } else if (string3 != null) {
                httpRequestBase.addHeader("Authorization", "Bearer " + string3);
            }
            if (jSONObject != null) {
                ((HttpEntityEnclosingRequestBase)httpRequestBase).setEntity((HttpEntity)new StringEntity(jSONObject.toString()));
            }
            if ((closeableHttpResponse = closeableHttpClient.execute((HttpUriRequest)httpRequestBase)).getStatusLine().getStatusCode() == 401) {
                if (string != null) {
                    throw new ErrorHandler.InformationMessageException("Username and password is incorrect", "Incorrect login");
                }
                if (string3 != null) {
                    throw new ErrorHandler.InformationMessageException("Activation code is incorrect", "Incorrect activation code");
                }
            }
            if (closeableHttpResponse.getStatusLine().getStatusCode() == 500) {
                throw new ErrorHandler.InformationMessageException("Status:500 Unknown error");
            }
            object = new BufferedReader(new InputStreamReader(closeableHttpResponse.getEntity().getContent()));
            try {
                String string4;
                StringBuilder stringBuilder = new StringBuilder();
                while ((string4 = ((BufferedReader)object).readLine()) != null) {
                    stringBuilder.append(string4);
                    stringBuilder.append("\n");
                }
                String string5 = stringBuilder.toString();
                if (string5.startsWith("{") && (object2 = new JSONObject(string5)).has("message")) {
                    throw new ErrorHandler.InformationMessageException(object2.getString("message"));
                }
                if (string5.startsWith("Error:")) {
                    throw new ErrorHandler.ErrorMessageException(string5.substring(7).trim());
                }
                if (string5.startsWith("Warning:")) {
                    throw new ErrorHandler.WarningMessageException(string5.substring(9).trim());
                }
                if (string5.startsWith("Information:")) {
                    throw new ErrorHandler.InformationMessageException(string5.substring(13).trim());
                }
                object2 = string5;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        ((BufferedReader)object).close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException iOException) {
                    throw new RuntimeException(iOException);
                }
            }
            ((BufferedReader)object).close();
            return object2;
        }
        finally {
            IOUtils.closeQuietly((Closeable)closeableHttpClient);
        }
    }

    public static String postServer(final JComponent jComponent, final PostInterface postInterface) {
        ProgressManagerImpl progressManagerImpl = new ProgressManagerImpl(jComponent){

            @Override
            public Object doWork() {
                this.setInfoText("Activating license");
                try {
                    return postInterface.post();
                }
                catch (ErrorHandler.MessageException messageException) {
                    this.Finish();
                    JOptionPane.showConfirmDialog(jComponent, messageException.getMessage() + "\nPlease contact license@prediktera.se for support", messageException.getTitle(), -1, messageException.getOptionType(), null);
                }
                catch (Exception exception) {
                    this.Finish();
                    Logg.warn("POST error", exception);
                    JOptionPane.showConfirmDialog(jComponent, "Cannot connect to Prediktera License server\nPlease check your internet connection and try again\n\nCause: " + exception.getMessage(), "Cannot connect", -1, 2, null);
                }
                return null;
            }
        };
        progressManagerImpl.invokeNow();
        return (String)progressManagerImpl.getResult();
    }

    public static void main(String[] stringArray) throws Exception {
        try {
            Evince.initNoShow();
            RegInfo regInfo = new RegInfo();
            regInfo.ID = 2108;
            regInfo.LID = 2382;
            regInfo.TimeStamp = 1692694713L;
            regInfo.serialUAC = "a";
            RESTInvoker rESTInvoker = new RESTInvoker("https://localhost:5001", true);
            String string = rESTInvoker.logUser(regInfo, UpdateHelper.getPlatform(), UpdateHelper.Product.Breeze, new UpdateHelper.UpdateVersion("2021.2.0"));
            System.out.println("License from log: " + string);
            String string2 = UUID.randomUUID().toString().substring(0, 6);
            string = rESTInvoker.createLicense("Thomas", "Rondahl", "thomas+" + string2 + "@prediktera.se", "Prediktera AB", "password", UniqueIdManager.generateOneUniqueId(), "", new String[]{"UAV"}, new String[]{"HySpex"}, UpdateHelper.Product.Breeze);
            System.out.println("License from create: " + string);
        }
        catch (Exception exception) {
            Logg.error("Init", exception);
        }
        System.exit(0);
    }

    public static interface PostInterface {
        public String post();
    }
}

