/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.main;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JPanel;
import se.prediktera.map.InitClass;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.main.Main_GUI;
import se.prediktera.map.register.RegInfo;
import se.prediktera.map.register.RegisterKeyManager;

public class StartUpFrame
extends JFrame {
    StartUpPanel startUpPanel = new StartUpPanel();

    public StartUpFrame() {
        try {
            this.jbInit();
            this.pack();
            this.setLocationRelativeTo(null);
        }
        catch (Exception exception) {
            ErrorHandler.logAndReportException(exception);
        }
    }

    private void jbInit() {
        this.setResizable(false);
        this.startUpPanel.setPreferredSize(new Dimension(500, 299));
        this.setTitle("Evince");
        this.getContentPane().add((Component)this.startUpPanel, "Center");
        this.setUndecorated(true);
    }

    private static class StartUpPanel
    extends JPanel {
        private final Font font = new Font("SansSerif", 0, 12);
        private final ImageIcon animationGif = new ImageIcon(Main_GUI.class.getResource("startup/evince_startup.gif"));

        private StartUpPanel() {
        }

        @Override
        public void paint(Graphics graphics) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            this.animationGif.paintIcon(this, graphics2D, 0, 0);
            graphics2D.setBackground(Color.black);
            graphics2D.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
            graphics2D.fillRect(0, this.getHeight() - 50, this.getWidth(), this.getHeight());
            graphics2D.setColor(Color.white);
            graphics2D.setFont(this.font);
            graphics2D.drawString("Copyright \u00a9 2002-2025 Prediktera AB. All Rights Reserved", 10, 270);
            StringBuilder stringBuilder = new StringBuilder("Prediktera Evince version ").append(InitClass.GetVersionString());
            RegInfo regInfo = RegisterKeyManager.getRegInfo();
            if (regInfo.isProfessional()) {
                stringBuilder.append(" Professional");
            }
            graphics2D.drawString(stringBuilder.toString(), 10, 290);
        }
    }
}

