/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.main;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import javax.swing.Timer;
import javax.swing.ToolTipManager;
import se.prediktera.map.common.progress.SwingWorker;
import se.prediktera.map.main.Evince;
import se.prediktera.map.main.IniManager;
import se.prediktera.map.main.Main_GUI;

public class StatusBar
extends JToolBar
implements ActionListener {
    private final JLabel statusMessage = new JLabel();
    private final JLabel labelUpdateInfo = new JLabel(" Update: N/A ");
    private final JLabel labelMemUsage = new JLabel();
    private final Timer timer = new Timer(5000, this);
    private SwingWorker statusBarAnimator;
    private String lastMessage = null;
    private int lastPriority = -1;

    public StatusBar() {
        this.statusMessage.setPreferredSize(new Dimension(5000, 15));
        this.statusMessage.setOpaque(true);
        this.setFloatable(false);
        this.add(this.statusMessage);
        JSeparator jSeparator = new JSeparator(1);
        jSeparator.setMaximumSize(new Dimension(5, Short.MAX_VALUE));
        this.add(jSeparator);
        this.add(this.labelUpdateInfo);
        this.labelUpdateInfo.setCursor(Cursor.getPredefinedCursor(12));
        this.labelUpdateInfo.addMouseListener(new MouseAdapter(this){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                Evince.showUpdateInformation();
            }
        });
        JSeparator jSeparator2 = new JSeparator(1);
        jSeparator2.setMaximumSize(new Dimension(5, Short.MAX_VALUE));
        this.add(jSeparator2);
        this.add(this.labelMemUsage);
        this.updateMemInfo();
        ToolTipManager.sharedInstance().registerComponent(this);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.resetStatusMessage();
    }

    @Override
    public String getToolTipText() {
        return this.statusMessage.getText();
    }

    public void resetStatusMessage() {
        this.timer.stop();
        this.lastPriority = -1;
        this.statusMessage.setText(null);
        this.statusMessage.setIcon(null);
    }

    public void setStatusMessage(MessageType messageType, String string, final int n) {
        if (this.lastPriority != -1 && this.lastPriority > this.getPriority(messageType)) {
            return;
        }
        this.timer.stop();
        if (this.statusBarAnimator != null) {
            if (string == null || !string.equals(this.lastMessage)) {
                this.statusBarAnimator.interrupt();
            } else {
                return;
            }
        }
        this.statusMessage.setText(string);
        this.statusMessage.setIcon(this.getIcon(messageType));
        if (messageType.equals((Object)MessageType.ERROR) || messageType.equals((Object)MessageType.WARNING)) {
            this.statusBarAnimator = new SwingWorker(this){
                final /* synthetic */ StatusBar this$0;
                {
                    this.this$0 = statusBar;
                }

                @Override
                public Object construct() {
                    JLabel jLabel = new JLabel();
                    Color color = new Color(jLabel.getForeground().getRGB());
                    Color color2 = new Color(jLabel.getBackground().getRGB());
                    try {
                        Thread.sleep(500L);
                        for (int i = 0; i < 2; ++i) {
                            this.this$0.statusMessage.setForeground(color2);
                            this.this$0.statusMessage.setBackground(Color.darkGray);
                            Thread.sleep(500L);
                            this.this$0.statusMessage.setForeground(color);
                            this.this$0.statusMessage.setBackground(color2);
                            Thread.sleep(500L);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this.this$0.statusMessage.setForeground(color);
                    this.this$0.statusMessage.setBackground(color2);
                    return null;
                }

                @Override
                public void finished() {
                    this.this$0.statusBarAnimator = null;
                    this.this$0.startTimer(n);
                }
            };
            this.statusBarAnimator.start();
        } else {
            this.startTimer(n);
        }
        this.lastPriority = this.getPriority(messageType);
        this.lastMessage = string;
    }

    public void setUpdateInfo(String string) {
        if (string == null) {
            this.labelUpdateInfo.setPreferredSize(new Dimension(0, 15));
        } else {
            this.labelUpdateInfo.setPreferredSize(new Dimension(200, 15));
        }
        this.labelUpdateInfo.setText(string);
    }

    public final void updateMemInfo() {
        Runtime runtime = Runtime.getRuntime();
        long l = runtime.maxMemory();
        long l2 = runtime.totalMemory();
        this.labelMemUsage.setText(" Mem Usage: " + IniManager.getFineSize(l2) + " of " + IniManager.getFineSize(l));
    }

    private Icon getIcon(MessageType messageType) {
        return switch (messageType.ordinal()) {
            case 3 -> null;
            case 1 -> new ImageIcon(Main_GUI.class.getResource("gif/warning.gif"));
            case 2 -> new ImageIcon(Main_GUI.class.getResource("gif/error.gif"));
            default -> new ImageIcon(Main_GUI.class.getResource("gif/information.gif"));
        };
    }

    private int getPriority(MessageType messageType) {
        return switch (messageType.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0, 3 -> 0;
            case 1 -> 1;
            case 2 -> 2;
        };
    }

    private void startTimer(int n) {
        if (n > 0) {
            this.timer.setInitialDelay(n * 1000);
            this.timer.start();
        }
    }

    public static enum MessageType {
        INFORMATION,
        WARNING,
        ERROR,
        NONE;

    }
}

