/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.main.extclass;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.nio.file.FileSystems;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import se.prediktera.map.InitClass;
import se.prediktera.map.common.Digest;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.connection.Url;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.common.error.Logg;
import se.prediktera.map.main.IniManager;
import se.prediktera.map.main.extclass.AbstractInfo;
import se.prediktera.map.main.extclass.DataTreeExtLibInterface;
import se.prediktera.map.main.extclass.DynamicClass;
import se.prediktera.map.main.extclass.ExtLibException;
import se.prediktera.map.main.extclass.InitInterface;
import se.prediktera.map.register.RegInfo;
import se.prediktera.map.register.RegisterKeyManager;
import se.prediktera.map.register.UniqueIdManager;

public class ExtClassLoader {
    private static final HashSet<LicenseLibrary> serialLoaded = new HashSet();
    private static final HashMap<Byte, List<AbstractInfo>> infoCacheMap = new HashMap();
    private static List<DynamicClass> dynClassList = new ArrayList<DynamicClass>();

    public static void checkUpdate(Vector<Block> vector, Vector<FileBlock> vector2, InputStream inputStream) throws IOException {
        int n;
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        DataInputStream dataInputStream = new DataInputStream(bufferedInputStream);
        int n2 = dataInputStream.readInt();
        int n3 = dataInputStream.readInt();
        for (n = 0; n < n3; ++n) {
            vector.addElement(new Block(dataInputStream));
        }
        n = dataInputStream.readInt();
        for (int i = 0; i < n; ++i) {
            vector2.addElement(new FileBlock(dataInputStream));
        }
        if (n2 > 1) {
            String string = System.getProperty("os.name");
            string = string == null ? "windows" : string.toLowerCase().split(" ", 2)[0];
            String string2 = System.getProperty("os.arch");
            string2 = string2 == null ? "" : string2.toLowerCase();
            String string3 = string + "." + string2;
            int n4 = dataInputStream.readInt();
            for (int i = 0; i < n4; ++i) {
                int n5;
                String string4 = dataInputStream.readUTF();
                int n6 = dataInputStream.readInt();
                if (string3.equals(string4) || string.equals(string4)) {
                    for (n5 = 0; n5 < n6; ++n5) {
                        vector2.addElement(new FileBlock(dataInputStream, string4));
                    }
                    break;
                }
                for (n5 = 0; n5 < n6; ++n5) {
                    new FileBlock(dataInputStream);
                }
            }
        }
        bufferedInputStream.close();
        dataInputStream.close();
    }

    public static boolean collectUpdateInfo(Vector<Block> vector, Vector<FileBlock> vector2, String string) {
        try {
            Url url = new Url(IniManager.getWebSite("evince/updateinfo.jsp"), true, true);
            DataOutputStream dataOutputStream = new DataOutputStream(url.getOutputStream());
            RegInfo regInfo = RegisterKeyManager.getRegInfo();
            dataOutputStream.writeBytes("user_id=" + regInfo.ID);
            dataOutputStream.writeBytes("&type=" + string);
            dataOutputStream.writeBytes("&uac=" + UniqueIdManager.generateOneUniqueId());
            dataOutputStream.flush();
            dataOutputStream.close();
            ExtClassLoader.checkUpdate(vector, vector2, url.getInputStream());
            return vector.size() > 0 || vector2.size() > 0;
        }
        catch (Exception exception) {
            Logg.error("Cannot connect to Prediktera Evince server", new Object[0]);
            return false;
        }
    }

    public static DataTreeExtLibInterface createExtLibNodeFromStream(int n, byte by, RandomInputStream randomInputStream, MapProperty mapProperty) throws IOException, ExtLibException {
        InitInterface initInterface = ExtClassLoader.getInitInterfaceFromSerial(n);
        return initInterface.createExtLibNodeFromStream(by, randomInputStream, mapProperty);
    }

    public static void findExtendedLibrariesByClassDir() {
        RegInfo regInfo = RegisterKeyManager.getRegInfo();
        if (regInfo != null) {
            for (LicenseLibrary licenseLibrary : LicenseLibrary.values()) {
                DynamicClass dynamicClass = ExtClassLoader.getDynamicClass(licenseLibrary.getClassDir());
                if (dynamicClass != null && !dynClassList.contains(dynamicClass)) {
                    dynClassList.add(dynamicClass);
                }
                if (regInfo.hasLibraryExpired(licenseLibrary)) continue;
                serialLoaded.add(licenseLibrary);
            }
        }
    }

    public static List<AbstractInfo> getAbstractInfoFromType(byte by) {
        Comparator comparator = (object, object2) -> {
            if (object instanceof AbstractInfo && object2 instanceof AbstractInfo) {
                return ((AbstractInfo)object).toString().compareTo(((AbstractInfo)object2).toString());
            }
            return 0;
        };
        return ExtClassLoader.getAbstractInfoFromType(by, comparator);
    }

    public static List<AbstractInfo> getAbstractInfoFromType(byte by, Comparator comparator) {
        Object object;
        List<AbstractInfo> list = infoCacheMap.get(by);
        if (list == null) {
            list = new ArrayList<AbstractInfo>();
            object = ExtClassLoader.getInitInterfaceIterator();
            while (object.hasNext()) {
                DynamicClass dynamicClass = (DynamicClass)object.next();
                AbstractInfo[] abstractInfoArray = dynamicClass.getInfo(by);
                if (abstractInfoArray == null) continue;
                for (AbstractInfo abstractInfo : abstractInfoArray) {
                    if (abstractInfo == null) continue;
                    list.add(abstractInfo);
                }
            }
            if (comparator != null) {
                Collections.sort(list, comparator);
            }
            infoCacheMap.put(by, list);
        }
        object = new ArrayList();
        for (AbstractInfo abstractInfo : list) {
            try {
                object.add((AbstractInfo)abstractInfo.clone());
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                ErrorHandler.logAndReportException(cloneNotSupportedException);
            }
        }
        return object;
    }

    public static DynamicClass getDynamicClass(String string) {
        try {
            return new DynamicClass(string);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static InitInterface getInitInterfaceFromSerial(int n) throws ExtLibException {
        if (n == LicenseLibrary.EVINCE.getSerial()) {
            return new InitClass();
        }
        DynamicClass dynamicClass = ExtClassLoader.getLibFromSerial(n);
        if (dynamicClass == null) {
            throw new ExtLibException("Library with serial " + n + " was not found!");
        }
        return dynamicClass;
    }

    public static Iterator<DynamicClass> getInitInterfaceIterator() {
        return dynClassList.iterator();
    }

    public static DynamicClass getLibFromSerial(int n) {
        for (DynamicClass dynamicClass : dynClassList) {
            if (dynamicClass.getLibrary().getSerial() != n) continue;
            return dynamicClass;
        }
        return null;
    }

    public static String getOSPath(String string) {
        if (string.contains(String.valueOf('\\'))) {
            return string.replace('\\', FileSystems.getDefault().getSeparator().toCharArray()[0]);
        }
        return string.replace('/', FileSystems.getDefault().getSeparator().toCharArray()[0]);
    }

    public static void Init() {
        Iterator<DynamicClass> iterator = ExtClassLoader.getInitInterfaceIterator();
        while (iterator.hasNext()) {
            iterator.next().Init();
        }
    }

    public static boolean isLibrariesLoaded(HashSet<Integer> hashSet) {
        for (Integer n : hashSet) {
            if (serialLoaded.contains((Object)LicenseLibrary.parseBySerial(n))) continue;
            return false;
        }
        return true;
    }

    public static boolean isLibraryLoaded(LicenseLibrary licenseLibrary) {
        return serialLoaded.contains((Object)licenseLibrary);
    }

    public static class Block {
        public int serial;
        public int version;
        public String versionString;
        public String name;
        public long size;

        public Block() {
        }

        public Block(DataInputStream dataInputStream) throws IOException {
            this.serial = dataInputStream.readInt();
            this.version = dataInputStream.readInt();
            this.versionString = dataInputStream.readUTF();
            this.name = dataInputStream.readUTF();
            this.size = dataInputStream.readLong();
        }

        public Block(int n, int n2, String string, String string2, long l) {
            this.serial = n;
            this.version = n2;
            this.versionString = string;
            this.name = string2;
            this.size = l;
        }

        public void write(DataOutputStream dataOutputStream) throws IOException {
            dataOutputStream.writeInt(this.serial);
            dataOutputStream.writeInt(this.version);
            dataOutputStream.writeUTF(this.versionString);
            dataOutputStream.writeUTF(this.name);
            dataOutputStream.writeLong(this.size);
        }
    }

    public static class FileBlock {
        private final String path;
        public byte[] digest = new byte[16];
        public long size;
        private boolean isNative = false;

        public FileBlock(DataInputStream dataInputStream) throws IOException {
            this(dataInputStream, null);
        }

        public FileBlock(DataInputStream dataInputStream, String string) throws IOException {
            this.isNative = string != null;
            this.path = dataInputStream.readUTF();
            for (int i = 0; i < this.digest.length; ++i) {
                this.digest[i] = dataInputStream.readByte();
            }
            this.size = dataInputStream.readLong();
        }

        public FileBlock(File file) {
            this.path = file.getPath();
            this.digest = Digest.calculate(file);
            this.size = file.length();
        }

        public String getLocalPath() {
            if (this.isNative) {
                for (int i = 0; i < this.path.length(); ++i) {
                    if (this.path.charAt(i) != FileSystems.getDefault().getSeparator().toCharArray()[0]) continue;
                    return this.path.substring(i + 1);
                }
            }
            return ExtClassLoader.getOSPath(this.path);
        }

        public String getZipPath() {
            return this.path;
        }

        public void write(DataOutputStream dataOutputStream) throws IOException {
            dataOutputStream.writeUTF(this.path);
            for (byte by : this.digest) {
                dataOutputStream.writeByte(by);
            }
            dataOutputStream.writeLong(this.size);
        }
    }

    public static enum LicenseLibrary {
        EVINCE("map", 1000),
        MDA("mda", 1004),
        IMAGE("image", 1008),
        STATISTICAL("statistical", 1011),
        BREEZE("breeze", 1014),
        BREEZEAPI("", 1015),
        SUPPORT("", 1016),
        NONE("", 0);

        private final String classDir;
        private final int serial;

        private LicenseLibrary(String string2, int n2) {
            this.classDir = string2;
            this.serial = n2;
        }

        public String getClassDir() {
            return this.classDir;
        }

        public int getSerial() {
            return this.serial;
        }

        public static LicenseLibrary parseBySerial(int n) {
            for (LicenseLibrary licenseLibrary : LicenseLibrary.values()) {
                if (licenseLibrary.getSerial() != n) continue;
                return licenseLibrary;
            }
            return NONE;
        }
    }

    public static class SimpleAuthenticator
    extends Authenticator {
        private final String username;
        private final String password;

        public SimpleAuthenticator(String string, String string2) {
            this.username = string;
            this.password = string2;
        }

        @Override
        protected PasswordAuthentication getPasswordAuthentication() {
            return new PasswordAuthentication(this.username, this.password.toCharArray());
        }
    }
}

