/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.main.hints;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.net.URISyntaxException;
import javax.swing.BorderFactory;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import se.prediktera.map.common.BrowserLauncher;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.common.wizard.WizardPageClass;

public class HintPage
extends WizardPageClass
implements HyperlinkListener {
    BorderLayout borderLayout1 = new BorderLayout();
    JPanel imagePanel;
    JPanel jPanel1 = new JPanel();
    JEditorPane information = new JEditorPane();
    GridBagLayout gridBagLayout1 = new GridBagLayout();

    public HintPage(Image image, String string) {
        if (image != null) {
            this.imagePanel = new ImagePanel(image);
        }
        this.information.setEditable(false);
        this.information.setContentType("text/html");
        this.information.setText(string);
        this.information.addHyperlinkListener(this);
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            ErrorHandler.logAndReportException(exception);
        }
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
        if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            try {
                BrowserLauncher.open(hyperlinkEvent.getURL().toURI());
            }
            catch (URISyntaxException uRISyntaxException) {
                uRISyntaxException.printStackTrace();
            }
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(this.borderLayout1);
        this.setBorder(BorderFactory.createEtchedBorder());
        this.information.setBorder(null);
        this.jPanel1.setBorder(BorderFactory.createEmptyBorder());
        this.jPanel1.setLayout(new BorderLayout());
        if (this.imagePanel != null) {
            this.add((Component)this.imagePanel, "West");
            this.imagePanel.setBackground(Color.white);
        }
        this.add((Component)this.jPanel1, "Center");
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setBorder(BorderFactory.createEmptyBorder());
        jScrollPane.setHorizontalScrollBarPolicy(31);
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.jPanel1.add((Component)jPanel, "Center");
        jPanel.add((Component)jScrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 1, new Insets(6, 6, 6, 24), 0, 0));
        jPanel.setBackground(Color.white);
        jScrollPane.setViewportView(this.information);
    }

    private class ImagePanel
    extends JPanel {
        private Image icon = null;
        private double scale;
        private final int padding = 5;

        public ImagePanel(Image image) {
            this.icon = image;
            double d = image.getWidth(null);
            double d2 = image.getHeight(null);
            this.scale = d > d2 ? 150.0 / d : 150.0 / d2;
            this.setPreferredSize(new Dimension(160, 160));
        }

        @Override
        public void paint(Graphics graphics) {
            super.paint(graphics);
            if (this.icon != null) {
                Graphics2D graphics2D = (Graphics2D)graphics;
                graphics2D.scale(this.scale, this.scale);
                graphics2D.drawImage(this.icon, 5, 5, null);
            }
        }
    }
}

