/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.main.layer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.common.cleanup.CleanUpDialog;
import se.prediktera.map.common.swing.ComboItem;
import se.prediktera.map.common.wizard.PageInterface;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.main.IniManager;
import se.prediktera.map.main.layer.AbstractSettingsBox;
import se.prediktera.map.plot.axisplot.settings.Axis.DataSearchPanel;
import se.prediktera.map.plot.axisplot.settings.DefaultSettingsCardPanel;
import se.prediktera.map.plot.axisplot.settings.SettingsBoxInterface;

public abstract class AbstractAdvancedFrame
extends CleanUpDialog
implements SettingsBoxInterface {
    protected JTabbedPane settingsTabbed = new JTabbedPane();
    protected AbstractSettingsBox settingsBox;
    protected DefaultSettingsCardPanel settingsCardPanel = new DefaultSettingsCardPanel(this);
    protected DataSearchPanel dataSearchPanel;
    private boolean packed = false;

    public AbstractAdvancedFrame(String string, AbstractSettingsBox abstractSettingsBox) {
        super(IniManager.getMainFrame(), string, true);
        this.settingsBox = abstractSettingsBox;
        this.jbInit();
    }

    public void radioButtonChanged(JRadioButton jRadioButton) {
        if (this.dataSearchPanel != null && this.settingsTabbed.getTabCount() == 2 && jRadioButton != null) {
            String string = jRadioButton.getText().toLowerCase();
            this.settingsTabbed.setEnabledAt(1, string.contains("value") || string.contains("data"));
        }
    }

    public abstract void Save(RandomOutputStream var1) throws IOException;

    public void showModal() {
        if (!this.packed) {
            this.pack();
            this.setLocationRelativeTo(null);
            this.packed = true;
        }
        this.settingsTabbed.setSelectedIndex(0);
        this.radioButtonChanged(this.settingsCardPanel.getCurrentRadioButton());
        for (int i = 0; i < this.settingsBox.getItemCount(); ++i) {
            ComboItem comboItem = (ComboItem)this.settingsBox.getItemAt(i);
            if (!comboItem.isMainitem()) continue;
            this.settingsCardPanel.setEnabled(comboItem.getType(), comboItem.isEnabled());
        }
        this.selectedPageShow();
        super.setVisible(true);
    }

    public abstract void SyncronizeComboBox(AbstractDataMatrix var1, int var2, int var3);

    protected abstract void applyChanges();

    @Override
    protected void cleanUpChild() {
        this.settingsTabbed.removeAll();
        this.settingsBox = null;
        if (this.settingsCardPanel != null) {
            this.settingsCardPanel.cleanUp();
            this.settingsCardPanel = null;
        }
    }

    private void jbInit() {
        JPanel jPanel = (JPanel)this.getContentPane();
        jPanel.setLayout(new BorderLayout());
        JButton jButton = new JButton("Cancel");
        jButton.setPreferredSize(new Dimension(73, 27));
        jButton.addActionListener(actionEvent -> this.dispose());
        jButton.setMnemonic('C');
        JButton jButton2 = new JButton("OK");
        jButton2.addActionListener(actionEvent -> {
            this.applyChanges();
            this.dispose();
        });
        jButton2.setPreferredSize(new Dimension(73, 27));
        jButton2.setMnemonic('O');
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel.add((Component)jPanel2, "South");
        JButton jButton3 = new JButton("Apply");
        jButton3.setPreferredSize(new Dimension(73, 27));
        jButton3.setMnemonic('A');
        jButton3.addActionListener(actionEvent -> this.applyChanges());
        JPanel jPanel3 = new JPanel();
        jPanel3.add((Component)jButton2, null);
        jPanel3.add((Component)jButton3, null);
        jPanel3.add((Component)jButton, null);
        jButton2.requestFocus();
        jPanel.add((Component)this.settingsTabbed, "Center");
        jPanel2.add((Component)jPanel3, "East");
        this.settingsTabbed.addChangeListener(changeEvent -> this.selectedPageShow());
        this.setMinimumSize(new Dimension(400, 400));
    }

    private void selectedPageShow() {
        Component component = this.settingsTabbed.getSelectedComponent();
        if (component instanceof PageInterface) {
            ((PageInterface)((Object)component)).pageShown();
        }
    }
}

