/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.main.layer;

import java.awt.Point;
import java.io.File;
import java.io.IOException;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JPopupMenu;
import javax.swing.tree.DefaultMutableTreeNode;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.common.cleanup.CleanUpPanel;
import se.prediktera.map.datasetcontainer.DataTreeClass;
import se.prediktera.map.datasetcontainer.DataTreeInterface;
import se.prediktera.map.datasetcontainer.DataTreeManager;
import se.prediktera.map.datasetcontainer.MemoryInterface;
import se.prediktera.map.datasetcontainer.event.DataTreeEvent;
import se.prediktera.map.datasetcontainer.event.DataTreeListener;
import se.prediktera.map.main.BrowserElement;
import se.prediktera.map.main.Project_GUI;
import se.prediktera.map.main.window.AbstractWindow_GUI;

public abstract class AbstractLayer
extends CleanUpPanel
implements DataTreeInterface,
MemoryInterface {
    protected String layerName;
    protected DefaultMutableTreeNode layerNode;
    private final int layerNumber;
    private boolean layerVisible;
    private Vector<DataTreeInterface> treeVector = new Vector();
    private Integer layerID;
    private DataTreeInterface nodeParent;
    private DataTreeManager dataTreeManager;
    protected boolean isloaded = false;
    protected long blockBegin = -1L;
    private int saveIndex = -1;
    private File saveFile;
    private BrowserElement browserElement;
    private boolean loadplots = false;
    protected boolean isCreated = false;

    public AbstractLayer(int n) {
        super("Layer");
        this.setLayout(new BoxLayout(this, 1));
        this.layerNumber = n;
        this.isloaded = true;
        this.layerVisible = false;
    }

    public AbstractLayer(RandomInputStream randomInputStream, MapProperty mapProperty) throws IOException {
        super("Layer");
        this.setLayout(new BoxLayout(this, 1));
        this.blockBegin = randomInputStream.getFilePointer();
        this.saveFile = randomInputStream.getFile();
        this.isloaded = false;
        this.layerID = randomInputStream.getDataTreeManager().addUniqueID(randomInputStream.getCT().id, this);
        if (mapProperty.hasProperty("lname")) {
            this.layerName = mapProperty.getLVStringUTF();
        }
        if (mapProperty.hasProperty("lvis")) {
            this.layerVisible = mapProperty.getLVBoolean();
        }
        this.layerNumber = mapProperty.getPropertyInt("layer_nr");
        if (mapProperty.hasProperty("plotv1")) {
            this.loadplots = true;
        }
        this.nodeParent = mapProperty.resolveNodeFromName(randomInputStream, "tp");
    }

    @Override
    public void addDataTreeChangeListener(DataTreeListener dataTreeListener) {
    }

    @Override
    public void addShortcut(DataTreeInterface dataTreeInterface) {
        this.treeVector.addElement(dataTreeInterface);
    }

    @Override
    public boolean addToPopup(Project_GUI project_GUI, DataTreeInterface dataTreeInterface, Point point, JPopupMenu jPopupMenu, boolean bl) {
        return false;
    }

    @Override
    public void addTreeNode(DataTreeInterface dataTreeInterface) {
        dataTreeInterface.setTreeParent(this);
        this.treeVector.addElement(dataTreeInterface);
    }

    @Override
    public void beginCalculations() {
    }

    @Override
    public void ClearFromMemory() throws IOException {
        this.isloaded = false;
    }

    @Override
    public boolean containsTreeNode(DataTreeInterface dataTreeInterface) {
        return this.treeVector.contains(dataTreeInterface);
    }

    public void copySettingsFrom(AbstractLayer abstractLayer) {
    }

    @Override
    public void endCalculations() {
    }

    @Override
    public long getBlockBegin() {
        return this.blockBegin;
    }

    public BrowserElement getBrowserWrapper() {
        return this.browserElement;
    }

    @Override
    public int getDataByteSize() {
        return 1000;
    }

    @Override
    public int getDataSize() {
        return 1000;
    }

    @Override
    public DataTreeManager getDataTreeManager() {
        if (this.dataTreeManager == null && this.nodeParent != null) {
            this.setDataTreeManager(this.nodeParent.getDataTreeManager(), false);
        }
        return this.dataTreeManager;
    }

    @Override
    public ImageIcon getIcon(byte by) {
        return null;
    }

    @Override
    public Integer getID() {
        if (this.layerID == null && this.getDataTreeManager() != null) {
            this.layerID = this.dataTreeManager.addUniqueID(null, this);
        }
        return this.layerID;
    }

    @Override
    public String getInformation() {
        StringBuilder stringBuilder = new StringBuilder("<HTML><BODY><table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" >");
        stringBuilder.append("<tr><td>Visible:</td><td>");
        stringBuilder.append(this.isLayerVisible() ? "True" : "False");
        stringBuilder.append("</td></tr>");
        return stringBuilder.toString();
    }

    @Override
    public long getLastUsed() {
        return 0L;
    }

    public DefaultMutableTreeNode getLayerNode() {
        return this.layerNode;
    }

    public int getLayerNr() {
        return this.layerNumber;
    }

    @Override
    public byte getMemoryState() {
        if (this.isloaded) {
            return 0;
        }
        return 1;
    }

    @Override
    public byte getNodeType() {
        return 4;
    }

    @Override
    public File getSaveFile() {
        return this.saveFile;
    }

    @Override
    public int getSaveIndex() {
        return this.saveIndex;
    }

    public AbstractLayer getTopLayer() {
        if (this.layerNode == null) {
            return null;
        }
        return (AbstractLayer)((DefaultMutableTreeNode)this.layerNode.getParent()).getUserObject();
    }

    @Override
    public DataTreeInterface getTreeNodeAt(int n) {
        return this.treeVector == null ? null : this.treeVector.elementAt(n);
    }

    @Override
    public int getTreeNodeCount() {
        return this.treeVector == null ? 0 : this.treeVector.size();
    }

    @Override
    public DataTreeInterface getTreeParent() {
        return this.nodeParent;
    }

    public void initiateGUI() {
    }

    @Override
    public void insertTreeNode(DataTreeInterface dataTreeInterface) {
        this.insertTreeNode(dataTreeInterface, 0);
    }

    public void insertTreeNode(DataTreeInterface dataTreeInterface, int n) {
        dataTreeInterface.setTreeParent(this);
        this.treeVector.insertElementAt(dataTreeInterface, n);
    }

    @Override
    public boolean isCalculating() {
        return false;
    }

    public boolean isLayerReady() {
        return this.isCreated;
    }

    public boolean isLayerVisible() {
        return this.layerVisible;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public boolean isLoaded() {
        return this.isloaded;
    }

    @Override
    public boolean isMemoryState(byte by) {
        return this.isloaded == (by == 0);
    }

    @Override
    public boolean isNode() {
        return true;
    }

    @Override
    public boolean isSupportClearMemory() {
        return false;
    }

    public boolean isTopLayer() {
        if (this.layerNode == null) {
            return false;
        }
        return ((DefaultMutableTreeNode)this.layerNode.getParent()).isRoot();
    }

    @Override
    public boolean isVisibleInTree() {
        return false;
    }

    public abstract void LoadData(RandomInputStream var1) throws IOException;

    @Override
    public void LoadIntoMemory(RandomInputStream randomInputStream) throws IOException {
        if (!this.isloaded) {
            this.isloaded = true;
            if (this.loadplots) {
                randomInputStream.readFileFramework(false);
                randomInputStream.seek(this.blockBegin);
                this.LoadData(randomInputStream);
            }
        }
    }

    public boolean PurgeSignal() {
        return false;
    }

    @Override
    public void removeDataTreeChangeListener(DataTreeListener dataTreeListener) {
    }

    @Override
    public boolean removeTreeNode(DataTreeInterface dataTreeInterface) {
        return this.treeVector == null ? false : this.treeVector.removeElement(dataTreeInterface);
    }

    public DataTreeInterface replaceNode(DataTreeInterface dataTreeInterface, DataTreeInterface dataTreeInterface2, boolean bl) {
        int n = this.treeVector.indexOf(dataTreeInterface);
        if (n >= 0) {
            if (dataTreeInterface2 != null) {
                if (dataTreeInterface instanceof DataTreeClass) {
                    DataTreeEvent dataTreeEvent = new DataTreeEvent((Object)this, dataTreeInterface, dataTreeInterface2);
                    ((DataTreeClass)dataTreeInterface).triggerReplaceEvent(dataTreeEvent);
                    dataTreeEvent.cleanUp();
                }
                this.treeVector.set(n, dataTreeInterface2);
                dataTreeInterface2.setTreeParent(this);
            }
            if (dataTreeInterface != null && bl) {
                dataTreeInterface.cleanUp();
            }
        } else {
            this.addTreeNode(dataTreeInterface2);
        }
        return dataTreeInterface2;
    }

    public abstract void SaveData(RandomOutputStream var1) throws IOException;

    @Override
    public void SaveData(RandomOutputStream randomOutputStream, int n) throws IOException {
        this.saveIndex = n;
        if (randomOutputStream.isStorePosition()) {
            this.blockBegin = randomOutputStream.getFilePointer();
            this.saveFile = randomOutputStream.getFile();
        }
        this.SaveData(randomOutputStream);
    }

    public abstract void SaveProperty(RandomOutputStream var1) throws IOException;

    @Override
    public void SaveProperty(RandomOutputStream randomOutputStream, int n) throws IOException {
        this.saveIndex = n;
        randomOutputStream.writePropertyStringUTF("lname", this.layerName);
        randomOutputStream.writePropertyBoolean("lvis", this.layerVisible);
        randomOutputStream.writePropertyInt("layer_nr", this.layerNumber);
        randomOutputStream.writePropertyBoolean("plotv1", true);
        randomOutputStream.writePropertyNode("tp", this.nodeParent);
        this.SaveProperty(randomOutputStream);
    }

    @Override
    public void setBlockBeginning(long l) {
        this.blockBegin = l;
    }

    public void setBrowserWrapper(BrowserElement browserElement) {
        this.browserElement = browserElement;
    }

    public void setCreated(AbstractWindow_GUI abstractWindow_GUI, boolean bl) {
        if (this.isCreated) {
            return;
        }
        this.isCreated = true;
        for (int i = 0; i < this.getTreeNodeCount(); ++i) {
            DataTreeInterface dataTreeInterface = this.getTreeNodeAt(i);
            if (!(dataTreeInterface instanceof AbstractLayer)) continue;
            ((AbstractLayer)dataTreeInterface).setCreated(abstractWindow_GUI, bl);
        }
    }

    @Override
    public void setDataTreeManager(DataTreeManager dataTreeManager, boolean bl) {
        if (bl || this.dataTreeManager != null && this.dataTreeManager != dataTreeManager) {
            this.layerID = null;
        }
        this.dataTreeManager = dataTreeManager;
        if (this.layerID == null && this.dataTreeManager != null) {
            this.layerID = this.dataTreeManager.addUniqueID(null, this);
        }
        for (int i = 0; i < this.getTreeNodeCount(); ++i) {
            this.getTreeNodeAt(i).setDataTreeManager(dataTreeManager, bl);
        }
    }

    public void setLayerName(String string) {
        this.layerName = string;
    }

    public void setLayerNode(DefaultMutableTreeNode defaultMutableTreeNode) {
        this.layerNode = defaultMutableTreeNode;
    }

    public boolean setLayerVisible(boolean bl) {
        if (this.layerVisible != bl) {
            this.layerVisible = bl;
            for (int i = 0; i < this.getTreeNodeCount(); ++i) {
                DataTreeInterface dataTreeInterface = this.getTreeNodeAt(i);
                if (!(dataTreeInterface instanceof AbstractLayer)) continue;
                AbstractLayer abstractLayer = (AbstractLayer)dataTreeInterface;
                abstractLayer.setLayerVisible(bl);
            }
            return true;
        }
        return false;
    }

    public void setLayerVisible(Double[] doubleArray) {
        this.setLayerVisible(doubleArray[0].intValue() != 0);
    }

    @Override
    public void setSaveFile(File file) {
        this.saveFile = file;
    }

    @Override
    public void setTreeParent(DataTreeInterface dataTreeInterface) {
        if (dataTreeInterface != null && dataTreeInterface != this.nodeParent) {
            this.nodeParent = dataTreeInterface;
            this.dataTreeManager = dataTreeInterface.getDataTreeManager();
            for (int i = 0; i < this.getTreeNodeCount(); ++i) {
                this.getTreeNodeAt(i).setTreeParent(this);
            }
        }
        if (this.layerID == null && this.dataTreeManager != null) {
            this.setDataTreeManager(this.dataTreeManager, false);
        }
    }

    @Override
    public void swapNodes(int n, int n2) {
        DataTreeInterface dataTreeInterface = this.treeVector.get(n);
        this.treeVector.set(n, this.treeVector.get(n2));
        this.treeVector.set(n2, dataTreeInterface);
    }

    @Override
    public String toString() {
        if (this.layerName != null) {
            return this.layerName;
        }
        return "Layers";
    }

    @Override
    protected void cleanUpChild() {
        DataTreeInterface dataTreeInterface;
        this.isCreated = false;
        while (this.treeVector != null && !this.treeVector.isEmpty() && (dataTreeInterface = this.getTreeNodeAt(0)) != null) {
            if ((this.dataTreeManager == null || this.dataTreeManager.hasDataMask(dataTreeInterface)) && !dataTreeInterface.cleanUp()) continue;
            this.treeVector.removeElementAt(0);
        }
        this.treeVector = null;
        if (this.dataTreeManager != null && this.layerID != null) {
            this.dataTreeManager.removeUniqueID(this.layerID);
            this.dataTreeManager = null;
        }
        this.layerID = null;
        if (this.nodeParent != null) {
            this.nodeParent.removeTreeNode(this);
            this.nodeParent = null;
        }
        this.layerNode = null;
    }
}

