/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.main.layer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.common.cleanup.CleanUpPanel;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.common.swing.PinCheckBox;
import se.prediktera.map.common.swing.flat.JFlatButton;
import se.prediktera.map.common.swing.treetable.AbstractTreeTableModel;
import se.prediktera.map.common.swing.treetable.JTreeTable;
import se.prediktera.map.common.swing.treetable.TreeTableModel;
import se.prediktera.map.components.tree.CustomNodeInterface;
import se.prediktera.map.datasetcontainer.DataTreeInterface;
import se.prediktera.map.main.GlobalMessageInterface;
import se.prediktera.map.main.Main_GUI;
import se.prediktera.map.main.ProjectPane;
import se.prediktera.map.main.Project_GUI;
import se.prediktera.map.main.layer.AbstractLayer;
import se.prediktera.map.main.layer.LayerContainer;
import se.prediktera.map.main.window.AbstractWindow;
import se.prediktera.map.main.window.AbstractWindow_GUI;
import se.prediktera.map.plot.axisplot.AbstractAxisLayer;

public abstract class AbstractLayerPanel
extends CleanUpPanel
implements GlobalMessageInterface {
    private static final Color bkcolor = Color.white;
    private static final ImageIcon VISIBILITY_IMAGE = new ImageIcon(Main_GUI.class.getResource("gif/eye.png"));
    protected DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode();
    protected LayerTreeTableModel layerTreeTableModel;
    private final JPanel emptySettingsPanel = new JPanel();
    private final BorderLayout settingsLayout = new BorderLayout();
    private final JPanel settingsPanel = new JPanel(this.settingsLayout);
    protected JPanel northPanel = new JPanel(new GridBagLayout());
    protected JTreeTable layerTreeTable;
    private final PinCheckBox panelLock = new PinCheckBox();
    private final JLabel windowName = new JLabel("Window name");
    protected JFlatButton newLayer = new JFlatButton(new ImageIcon(Main_GUI.class.getResource("icons/common/newFile.png")));
    protected JFlatButton removeLayer = new JFlatButton(new ImageIcon(Main_GUI.class.getResource("gif/delete.png")));
    protected JFlatButton renameLayer = new JFlatButton(new ImageIcon(Main_GUI.class.getResource("gif/rename.png")));
    protected JFlatButton moveLayerUp = new JFlatButton(new ImageIcon(Main_GUI.class.getResource("gifother/up.png")));
    protected JFlatButton moveLayerDown = new JFlatButton(new ImageIcon(Main_GUI.class.getResource("gifother/down.png")));
    protected int layer_nr = 1;
    protected int globalindex;
    private final JScrollPane scrollPaneSettings = new JScrollPane();
    protected JScrollPane jScrollPane1 = new JScrollPane();
    protected AbstractWindow_GUI gui;
    protected AbstractWindow window;
    private boolean created = false;
    private JPanel panel;
    private ProjectPane settingsEast;

    public AbstractLayerPanel(AbstractWindow abstractWindow, String[] stringArray, boolean bl) {
        super("PlotLayerPanel", new BorderLayout());
        this.setWindow(abstractWindow);
        this.layerTreeTableModel = new LayerTreeTableModel(this, this.rootNode, stringArray);
        this.layerTreeTable = new JTreeTable(this.layerTreeTableModel);
        TableColumn tableColumn = this.layerTreeTable.getColumnModel().getColumn(0);
        tableColumn.setHeaderRenderer(new DefaultTableCellRenderer(){

            @Override
            protected void setValue(Object object) {
                this.setOpaque(false);
                this.setIcon(VISIBILITY_IMAGE);
            }
        });
        this.jbInit(bl);
    }

    public AbstractLayerPanel(AbstractWindow abstractWindow, String[] stringArray, boolean bl, RandomInputStream randomInputStream, MapProperty mapProperty) throws IOException {
        this(abstractWindow, stringArray, bl);
        try {
            if (mapProperty.hasProperty("rlayers")) {
                int n = mapProperty.getLVInt();
                this.layer_nr = n + 1;
                for (int i = 0; i < n; ++i) {
                    DataTreeInterface dataTreeInterface = mapProperty.resolveNodeFromName(randomInputStream, "lnr" + i);
                    if (dataTreeInterface == null) continue;
                    this.rootNode.add(this.loadLayerTree((AbstractLayer)dataTreeInterface));
                }
                this.updateTable();
                if (this.layerTreeTable.getRowCount() > 0) {
                    this.layerTreeTable.setRowSelectionInterval(0, 0);
                    this.updateTable();
                }
            }
            if (mapProperty.hasProperty("locked")) {
                this.panelLock.setSelected(mapProperty.getLVBoolean());
            }
        }
        catch (Exception exception) {
            ErrorHandler.logAndReportException(exception);
        }
    }

    public abstract AbstractLayer addLayer(boolean var1);

    public void expandChildRowsForLayer(AbstractLayer abstractLayer) {
        this.layerTreeTable.getTree().expandPath(new TreePath(abstractLayer.getLayerNode().getPath()));
    }

    public void expandRowForLayer(AbstractLayer abstractLayer) {
        this.layerTreeTable.getTree().expandPath(this.getPathForLayer(abstractLayer));
    }

    public AbstractWindow_GUI getGUI() {
        return this.gui;
    }

    public AbstractLayer getLayerAtIndexRecursive(DataTreeInterface dataTreeInterface, int n) {
        int n2 = dataTreeInterface.getTreeNodeCount();
        for (int i = 0; i < n2; ++i) {
            DataTreeInterface dataTreeInterface2 = dataTreeInterface.getTreeNodeAt(i);
            if (!(dataTreeInterface2 instanceof AbstractLayer)) continue;
            AbstractLayer abstractLayer = (AbstractLayer)dataTreeInterface2;
            if (this.globalindex++ == n) {
                return abstractLayer;
            }
            dataTreeInterface2 = this.getLayerAtIndexRecursive(abstractLayer, n);
            if (dataTreeInterface2 == null) continue;
            return dataTreeInterface2;
        }
        return null;
    }

    public AbstractLayer getLayerAtRow(int n) {
        if (n < this.getLayerCount() && n >= 0) {
            return (AbstractLayer)this.layerTreeTable.getValueAt(n, 0);
        }
        return null;
    }

    public int getLayerCount() {
        return this.getLayerSizeRecursive(this.rootNode);
    }

    public JPanel getLayerSettingsPanel() {
        if (this.settingsPanel.getComponentCount() > 0) {
            return (JPanel)this.settingsPanel.getComponent(0);
        }
        return null;
    }

    public int getMainLayerCount() {
        return this.rootNode.getChildCount();
    }

    public DefaultMutableTreeNode getNodeForLayer(AbstractLayer abstractLayer) {
        TreeModel treeModel = this.layerTreeTable.getTree().getModel();
        return this.getNodeForLayer(treeModel, treeModel.getRoot(), abstractLayer);
    }

    public TreePath getPathForLayer(AbstractLayer abstractLayer) {
        TreeModel treeModel = this.layerTreeTable.getTree().getModel();
        ArrayList<Object> arrayList = this.getPathForLayer(treeModel, treeModel.getRoot(), abstractLayer);
        if (arrayList != null) {
            return new TreePath(arrayList.toArray());
        }
        return null;
    }

    public int getRowForLayer(AbstractLayer abstractLayer) {
        this.expandRowForLayer(abstractLayer);
        int n = this.layerTreeTable.getRowCount();
        for (int i = 0; i < n; ++i) {
            Object object = this.layerTreeTable.getValueAt(i, 0);
            if (object != abstractLayer) continue;
            return i;
        }
        return -1;
    }

    public AbstractLayer getSelectedLayer() {
        int n = this.layerTreeTable.getSelectedRow();
        if (n >= 0) {
            return this.getLayerAtRow(n);
        }
        return null;
    }

    public int getSubNumber(AbstractLayer abstractLayer) {
        DefaultMutableTreeNode defaultMutableTreeNode = abstractLayer.getLayerNode();
        int n = 0;
        for (int i = 0; i < defaultMutableTreeNode.getChildCount(); ++i) {
            AbstractLayer abstractLayer2 = (AbstractLayer)((DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i)).getUserObject();
            if (abstractLayer2.getLayerNr() <= n) continue;
            n = abstractLayer2.getLayerNr();
        }
        return n + 1;
    }

    public boolean isCreated() {
        return this.created && this.gui != null;
    }

    public boolean isLayerSelected(AbstractLayer abstractLayer) {
        AbstractLayer abstractLayer2 = this.getSelectedLayer();
        return abstractLayer2 != null && abstractLayer2.equals(abstractLayer);
    }

    public boolean isLocked() {
        return this.panelLock.isSelected() && this.window != null && !this.window.isCleaned();
    }

    public void layerRemoved(AbstractLayer abstractLayer, boolean bl) {
    }

    public abstract void layerSelected(AbstractLayer var1);

    public abstract void layerVisibleChanged(AbstractLayer var1);

    public void removeLayer() {
        int n;
        AbstractLayer abstractLayer;
        int n2 = this.layerTreeTable.getSelectedRow();
        if (n2 >= 0 && (abstractLayer = this.getLayerAtRow(n2)) != null && !(abstractLayer instanceof LayerContainer) && (n = JOptionPane.showConfirmDialog(this, "Are you really sure you want to delete this layer (and sublayers)?", "Delete Confirmation", 0, 3, null)) == 0) {
            this.layerRemoved(abstractLayer, abstractLayer.isLayerVisible() && abstractLayer.isLayerReady());
            this.removeRecursive(abstractLayer.getLayerNode());
            this.updateTable();
            if (n2 < this.layerTreeTable.getRowCount()) {
                this.layerTreeTable.setRowSelectionInterval(n2, n2);
            } else if (n2 > 0) {
                this.layerTreeTable.setRowSelectionInterval(n2 - 1, n2 - 1);
            }
        }
    }

    public void repaintTable() {
        if (this.layerTreeTable != null) {
            this.layerTreeTable.repaint();
        }
    }

    public void SaveProperty(RandomOutputStream randomOutputStream) throws IOException {
        randomOutputStream.writePropertyInt("rlayers", this.rootNode.getChildCount());
        for (int i = 0; i < this.rootNode.getChildCount(); ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.rootNode.getChildAt(i);
            randomOutputStream.writePropertyNode("lnr" + i, (DataTreeInterface)defaultMutableTreeNode.getUserObject());
        }
        randomOutputStream.writePropertyBoolean("locked", this.panelLock.isSelected());
    }

    public int selectLayer(AbstractLayer abstractLayer) {
        int n = this.getRowForLayer(abstractLayer);
        if (n < 0) {
            return -1;
        }
        this.layerTreeTable.setRowSelectionInterval(n, n);
        Rectangle rectangle = this.layerTreeTable.getCellRect(n, 0, true);
        Rectangle rectangle2 = this.layerTreeTable.getVisibleRect();
        if (rectangle.y < rectangle2.y || rectangle.y + rectangle.height > rectangle2.y + rectangle2.height) {
            rectangle2.y = rectangle.y - (rectangle2.height - rectangle.height) / 2;
            this.layerTreeTable.scrollRectToVisible(rectangle2);
        }
        return n;
    }

    public void selectLayer(int n) {
        if (n < this.layerTreeTable.getRowCount()) {
            this.layerTreeTable.setRowSelectionInterval(n, n);
        }
    }

    public byte SendGlobalMessage(byte by, byte by2) {
        if (by == 0) {
            return this.purgeSignalRecursive(this.rootNode);
        }
        return 0;
    }

    public void setAccessorPanel(JPanel jPanel) {
        if (jPanel != null) {
            JPanel jPanel2 = (JPanel)this.settingsLayout.getLayoutComponent("Center");
            if (jPanel2 == null) {
                jPanel2 = new JPanel(new BorderLayout());
                this.settingsPanel.add((Component)jPanel2, "Center");
            }
            jPanel2.add((Component)jPanel, "North");
        }
    }

    public void setAllEnabled(boolean bl) {
        this.newLayer.setEnabled(!this.isProtected() && bl);
        this.removeLayer.setEnabled(!this.isProtected() && bl);
        this.renameLayer.setEnabled(bl);
        this.moveLayerUp.setEnabled(bl);
        this.moveLayerDown.setEnabled(bl);
    }

    public void setCreated(AbstractWindow_GUI abstractWindow_GUI, boolean bl) {
        this.setWindowGui(abstractWindow_GUI);
        this.created = true;
    }

    public void setLayerSettingsPanel(JPanel jPanel) {
        Component component = this.settingsLayout.getLayoutComponent("North");
        if (component != null) {
            this.settingsPanel.remove(component);
        }
        if (jPanel == null) {
            this.settingsPanel.add((Component)this.emptySettingsPanel, "North");
        } else {
            if (jPanel instanceof AbstractLayer) {
                ((AbstractLayer)jPanel).initiateGUI();
            }
            this.settingsPanel.add((Component)jPanel, "North");
        }
        this.scrollPaneSettings.setViewportView(this.settingsPanel);
    }

    public void setNextLayerPanel(JPanel jPanel, ProjectPane projectPane) {
        this.panel = jPanel;
        this.settingsEast = projectPane;
    }

    public void setSelectedLayerVisible(boolean bl) {
        AbstractLayer abstractLayer = this.getSelectedLayer();
        if (abstractLayer != null && abstractLayer.isLayerVisible() != bl) {
            abstractLayer.setLayerVisible(bl);
            this.updateTable();
            this.layerVisibleChanged(abstractLayer);
        }
    }

    public void setTitle(String string, ImageIcon imageIcon) {
        this.windowName.setText(string);
        this.windowName.setIcon(imageIcon);
    }

    public void setTitleFromWindow(AbstractWindow abstractWindow) {
        if (abstractWindow != null) {
            this.setTitle(abstractWindow.toString(), abstractWindow.getIcon((byte)0));
        }
    }

    public void setWindow(AbstractWindow abstractWindow) {
        this.window = abstractWindow;
        if (abstractWindow != null) {
            this.setWindowGui(abstractWindow.getWindowGui());
            this.setTitleFromWindow(abstractWindow);
        }
    }

    public void setWindowGui(AbstractWindow_GUI abstractWindow_GUI) {
        if (this.gui == null) {
            this.gui = abstractWindow_GUI;
        }
    }

    public void updateTable() {
        if (this.layerTreeTable != null) {
            try {
                AbstractLayer abstractLayer = this.getSelectedLayer();
                this.layerTreeTable.getTree().setModel(this.layerTreeTableModel);
                this.layerTreeTable.updateUI();
                int n = this.layerTreeTable.getSelectedRow();
                if (n < 0 && this.layerTreeTable.getRowCount() > 0) {
                    if (abstractLayer != null && !abstractLayer.isCleaned()) {
                        this.selectLayer(abstractLayer);
                    } else {
                        this.layerTreeTable.setRowSelectionInterval(0, 0);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected DefaultMutableTreeNode addLayerIntern(AbstractLayer abstractLayer, String string, boolean bl) {
        return this.addLayerIntern(abstractLayer, string, bl, true);
    }

    protected DefaultMutableTreeNode addLayerIntern(AbstractLayer abstractLayer, String string, boolean bl, boolean bl2) {
        ++this.layer_nr;
        if (string != null) {
            abstractLayer.setLayerName(string);
        }
        abstractLayer.setLayerVisible(bl);
        LayerTreeNode layerTreeNode = new LayerTreeNode(abstractLayer);
        abstractLayer.setLayerNode(layerTreeNode);
        if (bl2) {
            this.rootNode.insert(layerTreeNode, 0);
        } else {
            this.rootNode.add(layerTreeNode);
        }
        SwingUtilities.invokeLater(() -> {
            this.updateTable();
            if (this.layerTreeTable != null && this.layerTreeTable.getRowCount() > 0) {
                this.layerTreeTable.setRowSelectionInterval(0, 0);
            }
        });
        return layerTreeNode;
    }

    protected DefaultMutableTreeNode addSubLayerIntern(AbstractLayer abstractLayer, AbstractLayer abstractLayer2, boolean bl) {
        if (abstractLayer != null && abstractLayer.getLayerNode() != null) {
            return this.addSubLayerIntern(abstractLayer, abstractLayer2, bl, true, true, true);
        }
        return null;
    }

    protected DefaultMutableTreeNode addSubLayerIntern(AbstractLayer abstractLayer, AbstractLayer abstractLayer2, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        int n;
        LayerTreeNode layerTreeNode = new LayerTreeNode(abstractLayer2);
        abstractLayer2.setLayerNode(layerTreeNode);
        abstractLayer2.setLayerVisible(bl);
        if (bl2) {
            abstractLayer.getLayerNode().insert(layerTreeNode, 0);
        } else {
            abstractLayer.getLayerNode().add(layerTreeNode);
        }
        if (bl4 || bl3) {
            this.layerTreeTable.getTree().expandPath(new TreePath(abstractLayer.getLayerNode().getPath()));
        }
        if (bl3 && (n = this.layerTreeTable.getTree().getRowForPath(new TreePath(layerTreeNode.getPath()))) >= 0) {
            this.layerTreeTable.setRowSelectionInterval(n, n);
        }
        if (!abstractLayer.containsTreeNode(abstractLayer2)) {
            if (bl2) {
                abstractLayer.insertTreeNode(abstractLayer2);
            } else {
                abstractLayer.addTreeNode(abstractLayer2);
            }
        }
        this.updateTable();
        return layerTreeNode;
    }

    @Override
    protected void cleanUpChild() {
        Enumeration<TreeNode> enumeration = this.rootNode.depthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            TreeNode treeNode = enumeration.nextElement();
            Object object = ((DefaultMutableTreeNode)treeNode).getUserObject();
            if (!(object instanceof AbstractLayer)) continue;
            ((AbstractLayer)object).cleanUp();
        }
        if (this.layerTreeTable != null) {
            this.layerTreeTable.cleanUp();
            this.layerTreeTable = null;
        }
    }

    protected void enableButtons(boolean bl) {
        this.newLayer.setEnabled(!this.isProtected());
        this.removeLayer.setEnabled(!this.isProtected() && bl);
        this.renameLayer.setEnabled(bl);
        this.moveLayerUp.setEnabled(bl);
        this.moveLayerDown.setEnabled(bl);
    }

    protected abstract Class[] getCTypes();

    protected DefaultMutableTreeNode getNodeForLayer(TreeModel treeModel, Object object, AbstractLayer abstractLayer) {
        int n = treeModel.getChildCount(object);
        for (int i = 0; i < n; ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treeModel.getChild(object, i);
            if (defaultMutableTreeNode.getUserObject() == abstractLayer) {
                return defaultMutableTreeNode;
            }
            if ((defaultMutableTreeNode = this.getNodeForLayer(treeModel, defaultMutableTreeNode, abstractLayer)) == null) continue;
            return defaultMutableTreeNode;
        }
        return null;
    }

    protected ArrayList<Object> getPathForLayer(TreeModel treeModel, Object object, AbstractLayer abstractLayer) {
        int n = treeModel.getChildCount(object);
        for (int i = 0; i < n; ++i) {
            ArrayList<Object> arrayList;
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treeModel.getChild(object, i);
            if (defaultMutableTreeNode.getUserObject() == abstractLayer) {
                arrayList = new ArrayList<Object>(1);
                arrayList.add(object);
                return arrayList;
            }
            arrayList = this.getPathForLayer(treeModel, defaultMutableTreeNode, abstractLayer);
            if (arrayList == null) continue;
            arrayList.add(0, object);
            return arrayList;
        }
        return null;
    }

    protected boolean isProtected() {
        return false;
    }

    protected void moveLayerDown() {
        this.moveLayerDown(this.getSelectedLayer());
    }

    protected void moveLayerDown(AbstractLayer abstractLayer) {
        if (abstractLayer == null) {
            return;
        }
        DataTreeInterface dataTreeInterface = abstractLayer.getTreeParent();
        if (dataTreeInterface != null) {
            for (int i = 0; i < dataTreeInterface.getTreeNodeCount() - 1; ++i) {
                if (!dataTreeInterface.getTreeNodeAt(i).equals(abstractLayer)) continue;
                DefaultMutableTreeNode defaultMutableTreeNode = abstractLayer.getLayerNode();
                TreeNode treeNode = defaultMutableTreeNode.getParent();
                if (!(treeNode instanceof DefaultMutableTreeNode)) break;
                DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)treeNode;
                if (i < defaultMutableTreeNode2.getChildCount() - 2) {
                    defaultMutableTreeNode2.insert(defaultMutableTreeNode, i + 1);
                } else {
                    defaultMutableTreeNode2.remove(defaultMutableTreeNode);
                    defaultMutableTreeNode2.add(defaultMutableTreeNode);
                }
                dataTreeInterface.swapNodes(i, i + 1);
                this.updateTable();
                this.repaintLayers();
                break;
            }
        }
    }

    protected String moveLayerDownTooltip() {
        return "Move Layer Down";
    }

    protected void moveLayerUp() {
        AbstractLayer abstractLayer = this.getSelectedLayer();
        if (abstractLayer == null) {
            return;
        }
        DataTreeInterface dataTreeInterface = abstractLayer.getTreeParent();
        if (dataTreeInterface != null) {
            for (int i = 1; i < dataTreeInterface.getTreeNodeCount(); ++i) {
                if (!dataTreeInterface.getTreeNodeAt(i).equals(abstractLayer)) continue;
                DefaultMutableTreeNode defaultMutableTreeNode = abstractLayer.getLayerNode();
                TreeNode treeNode = defaultMutableTreeNode.getParent();
                if (!(treeNode instanceof DefaultMutableTreeNode)) break;
                ((DefaultMutableTreeNode)treeNode).insert(defaultMutableTreeNode, i - 1);
                dataTreeInterface.swapNodes(i, i - 1);
                this.updateTable();
                this.repaintLayers();
                break;
            }
        }
    }

    protected String moveLayerUpTooltip() {
        return "Move Layer Up";
    }

    protected String newLayerTooltip() {
        return "Create New Main Layer";
    }

    protected String removeLayerTooltip() {
        return "Delete Layer";
    }

    protected void removeRecursive(DefaultMutableTreeNode defaultMutableTreeNode) {
        if (defaultMutableTreeNode != null) {
            for (int i = 0; i < defaultMutableTreeNode.getChildCount(); ++i) {
                this.removeRecursive((DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i));
            }
            ((DefaultMutableTreeNode)defaultMutableTreeNode.getParent()).remove(defaultMutableTreeNode);
            ((AbstractLayer)defaultMutableTreeNode.getUserObject()).cleanUp();
        }
    }

    protected String renameLayerTooltip() {
        return "Rename Layer";
    }

    protected abstract void repaintLayers();

    protected void updateContent() {
    }

    private void changeLayerPanel() {
        if (!this.panelLock.isSelected()) {
            if (this.settingsEast != null && this.panel != null) {
                Project_GUI project_GUI = this.getGUI().getProject_GUI();
                this.settingsEast.setCenterPanel(this.panel);
                if (this.panel instanceof AbstractLayerPanel) {
                    project_GUI.setCurrentLayerPanel((AbstractLayerPanel)this.panel);
                } else {
                    project_GUI.setCurrentLayerPanel(null);
                }
            }
            this.settingsEast = null;
            this.panel = null;
        }
    }

    private int getLayerSizeRecursive(DefaultMutableTreeNode defaultMutableTreeNode) {
        int n = 0;
        int n2 = defaultMutableTreeNode.getChildCount();
        for (int i = 0; i < n2; ++i) {
            n += this.getLayerSizeRecursive((DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i));
        }
        return n + defaultMutableTreeNode.getChildCount();
    }

    private void jbInit(boolean bl) {
        this.panelLock.setToolTipText("Lock Current Settings Panel");
        this.panelLock.addItemListener(itemEvent -> this.changeLayerPanel());
        JPanel jPanel = new JPanel(new BorderLayout());
        JToolBar jToolBar = new JToolBar();
        JSplitPane jSplitPane = new JSplitPane();
        jSplitPane.setPreferredSize(new Dimension(102, 0));
        jSplitPane.setOrientation(0);
        this.setPreferredSize(new Dimension(200, 0));
        if (bl) {
            this.layerTreeTable.getTree().setExpandsSelectedPaths(true);
            this.newLayer.setToolTipText(this.newLayerTooltip());
            this.newLayer.addActionListener(actionEvent -> this.addLayer(true));
            this.removeLayer.setToolTipText(this.removeLayerTooltip());
            this.removeLayer.addActionListener(actionEvent -> this.removeLayer());
            this.renameLayer.setToolTipText(this.renameLayerTooltip());
            this.renameLayer.addActionListener(actionEvent -> this.renameLayer());
            this.moveLayerUp.setToolTipText(this.moveLayerUpTooltip());
            this.moveLayerUp.addActionListener(actionEvent -> this.moveLayerUp());
            this.moveLayerDown.setToolTipText(this.moveLayerDownTooltip());
            this.moveLayerDown.addActionListener(actionEvent -> this.moveLayerDown());
            this.layerTreeTable.setBorder(BorderFactory.createEmptyBorder());
            this.layerTreeTable.setBackground(bkcolor);
            this.layerTreeTable.setCellSelectionEnabled(false);
            this.layerTreeTable.setColumnSelectionAllowed(false);
            this.layerTreeTable.setRowSelectionAllowed(true);
            this.layerTreeTable.getTableHeader().setReorderingAllowed(false);
            this.layerTreeTable.setSelectionMode(0);
            this.layerTreeTable.setDefaultRenderer(VisibleTableCellRenderer.class, new VisibleTableCellRenderer());
            this.layerTreeTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    int n = AbstractLayerPanel.this.layerTreeTable.rowAtPoint(mouseEvent.getPoint());
                    int n2 = AbstractLayerPanel.this.layerTreeTable.columnAtPoint(mouseEvent.getPoint());
                    AbstractLayer abstractLayer = AbstractLayerPanel.this.getLayerAtRow(n);
                    if (n2 == 0 && abstractLayer != null) {
                        abstractLayer.setLayerVisible(!abstractLayer.isLayerVisible());
                        AbstractLayerPanel.this.layerVisibleChanged(abstractLayer);
                        AbstractLayerPanel.this.layerTreeTable.repaint();
                    } else if (n2 == 2 && abstractLayer instanceof AbstractAxisLayer) {
                        ((AbstractAxisLayer)abstractLayer).getColorScalePanel().doClick();
                    }
                    AbstractLayerPanel.this.layerTreeTable.setRowSelectionInterval(n, n);
                    AbstractLayerPanel.this.layerSelected(abstractLayer);
                }
            });
            this.jScrollPane1.setHorizontalScrollBarPolicy(31);
            this.jScrollPane1.setVerticalScrollBarPolicy(22);
            this.jScrollPane1.setMaximumSize(new Dimension(300, 100));
            this.jScrollPane1.setPreferredSize(new Dimension(0, 100));
            this.jScrollPane1.setMinimumSize(new Dimension(0, 100));
        }
        this.layerTreeTable.getSelectionModel().addListSelectionListener(new LayerSelectionListener());
        this.scrollPaneSettings.setHorizontalScrollBarPolicy(31);
        this.scrollPaneSettings.setBorder(null);
        jSplitPane.setTopComponent(jPanel);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setBackground(Color.white);
        this.northPanel.setBackground(Color.white);
        jPanel2.add((Component)this.panelLock, "West");
        jPanel2.add(this.windowName);
        this.northPanel.add((Component)jPanel2, new GridBagConstraints(0, 0, 5, 1, 1.0, 0.0, 17, 2, new Insets(2, 4, 2, 4), 0, 0));
        if (bl) {
            jToolBar.setFloatable(false);
            jToolBar.add(this.newLayer);
            jToolBar.add(this.removeLayer);
            jToolBar.add(this.renameLayer);
            jToolBar.addSeparator();
            jToolBar.add(this.moveLayerUp);
            jToolBar.add(this.moveLayerDown);
            jPanel.add((Component)this.jScrollPane1, "Center");
            jPanel.add((Component)jToolBar, "South");
        }
        jPanel.setMaximumSize(new Dimension(276, 159));
        jPanel.add((Component)this.northPanel, "North");
        jSplitPane.setBottomComponent(this.scrollPaneSettings);
        this.add((Component)jSplitPane, "Center");
        this.jScrollPane1.setViewportView(this.layerTreeTable);
        this.jScrollPane1.getViewport().setBackground(this.layerTreeTable.getBackground());
        this.layerTreeTable.setBackground(Color.white);
        this.scrollPaneSettings.setViewportView(this.settingsPanel);
        this.settingsPanel.add((Component)this.emptySettingsPanel, "North");
    }

    private DefaultMutableTreeNode loadLayerTree(AbstractLayer abstractLayer) {
        LayerTreeNode layerTreeNode = new LayerTreeNode(abstractLayer);
        abstractLayer.setLayerNode(layerTreeNode);
        for (int i = 0; i < abstractLayer.getTreeNodeCount(); ++i) {
            if (!(abstractLayer.getTreeNodeAt(i) instanceof AbstractLayer)) continue;
            layerTreeNode.add(this.loadLayerTree((AbstractLayer)abstractLayer.getTreeNodeAt(i)));
        }
        return layerTreeNode;
    }

    private byte purgeSignalRecursive(DefaultMutableTreeNode defaultMutableTreeNode) {
        int n = defaultMutableTreeNode.getChildCount();
        for (int i = 0; i < n; ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i);
            byte by = this.purgeSignalRecursive(defaultMutableTreeNode2);
            if (by != 2 && !((AbstractLayer)defaultMutableTreeNode2.getUserObject()).PurgeSignal()) continue;
            return 2;
        }
        return 1;
    }

    private void renameLayer() {
        String string;
        AbstractLayer abstractLayer = this.getSelectedLayer();
        if (abstractLayer != null && !(abstractLayer instanceof LayerContainer) && (string = JOptionPane.showInputDialog(this, "Enter the new name for the layer", abstractLayer.toString())) != null) {
            abstractLayer.setLayerName(string);
            this.updateTable();
            this.updateContent();
        }
    }

    public class LayerTreeTableModel
    extends AbstractTreeTableModel
    implements TreeTableModel {
        protected final String[] cNames;
        private final Class[] cTypes;

        public LayerTreeTableModel(AbstractLayerPanel abstractLayerPanel, DefaultMutableTreeNode defaultMutableTreeNode, String[] stringArray) {
            super(defaultMutableTreeNode);
            this.cNames = stringArray;
            this.cTypes = abstractLayerPanel.getCTypes();
        }

        @Override
        public Object getChild(Object object, int n) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
            return defaultMutableTreeNode.getChildAt(n);
        }

        @Override
        public int getChildCount(Object object) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
            return defaultMutableTreeNode.getChildCount();
        }

        @Override
        public Class getColumnClass(int n) {
            return this.cTypes[n];
        }

        @Override
        public int getColumnCount() {
            return this.cNames.length;
        }

        @Override
        public String getColumnName(int n) {
            return this.cNames[n];
        }

        @Override
        public Object getValueAt(JTree jTree, Object object, int n, int n2) {
            if (object == null) {
                return null;
            }
            return ((DefaultMutableTreeNode)object).getUserObject();
        }

        @Override
        public boolean isCellEditable(Object object, int n) {
            return true;
        }
    }

    public class LayerTreeNode
    extends DefaultMutableTreeNode
    implements CustomNodeInterface {
        private final ImageIcon layerIcon;

        public LayerTreeNode(AbstractLayer abstractLayer) {
            super(abstractLayer);
            this.layerIcon = new ImageIcon(Main_GUI.class.getResource("gif/layer.gif"));
        }

        @Override
        public ImageIcon getIcon(byte by) {
            if (this.getUserObject() instanceof AbstractAxisLayer && this.getChildCount() == 0) {
                return this.layerIcon;
            }
            return null;
        }

        @Override
        public String getToolTipText() {
            return null;
        }
    }

    public class VisibleTableCellRenderer
    extends JCheckBox
    implements TableCellRenderer {
        public VisibleTableCellRenderer() {
            this.setToolTipText("Show/Hide");
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (object instanceof AbstractLayer) {
                this.setSelected(((AbstractLayer)object).isLayerVisible());
            }
            if (bl) {
                this.setBackground(jTable.getSelectionBackground());
            } else {
                this.setBackground(bkcolor);
            }
            return this;
        }
    }

    class LayerSelectionListener
    implements ListSelectionListener {
        LayerSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            AbstractLayer abstractLayer = AbstractLayerPanel.this.getSelectedLayer();
            AbstractLayerPanel.this.setLayerSettingsPanel(abstractLayer);
            if (abstractLayer != null) {
                AbstractLayerPanel.this.enableButtons(abstractLayer.isEnabled());
            }
        }
    }
}

