/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.main.layer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.common.swing.ComboBoxRenderer;
import se.prediktera.map.common.swing.ComboItem;
import se.prediktera.map.common.swing.JComboBoxCell;
import se.prediktera.map.common.swing.JComboButtonCell;
import se.prediktera.map.datasetcontainer.DataTreeInterface;
import se.prediktera.map.datasetcontainer.TransferNode;
import se.prediktera.map.datasetcontainer.classes.ClassTypes;
import se.prediktera.map.datasetcontainer.classes.InnerColumnClass;
import se.prediktera.map.datasetcontainer.classes.prediction.PredictionClasses;
import se.prediktera.map.datasetcontainer.datainfo.AbstractDataInfo;
import se.prediktera.map.datasetcontainer.datainfo.AbstractInnerColumn;
import se.prediktera.map.datasetcontainer.datainfo.DataGroupValues;
import se.prediktera.map.datasetcontainer.datainfo.DataImage;
import se.prediktera.map.datasetcontainer.datainfo.DataInfoEvent;
import se.prediktera.map.datasetcontainer.datainfo.DataInfoListener;
import se.prediktera.map.datasetcontainer.datainfo.Description;
import se.prediktera.map.datasetcontainer.datainfo.InnerColumnBooleanIncExc;
import se.prediktera.map.datasetcontainer.event.DataGroupListener;
import se.prediktera.map.datasetcontainer.event.DataTreeEvent;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.datasetcontainer.matrix.FoldMatrix;
import se.prediktera.map.datasetcontainer.matrix.NormalizedModelMatrix;
import se.prediktera.map.datasetcontainer.matrix.ReferenceMatrix;
import se.prediktera.map.datasetcontainer.matrix.event.DataMatrixEvent;
import se.prediktera.map.datasetcontainer.matrix.event.DataMatrixListener;
import se.prediktera.map.datasetcontainer.transform.Transformations;
import se.prediktera.map.main.layer.AbstractAdvancedFrame;
import se.prediktera.map.main.script.EvinceScriptCommands;
import se.prediktera.map.main.window.AbstractWindow_GUI;
import se.prediktera.map.plot.axisplot.settings.ComboBoxComment;
import se.prediktera.map.plot.axisplot.settings.ComboBoxDescription;
import se.prediktera.map.plot.axisplot.settings.SettingsBoxInterface;

public abstract class AbstractSettingsBox
extends JComboButtonCell
implements SettingsBoxInterface,
DropTargetListener,
DataInfoListener {
    protected AbstractDataMatrix matrix = null;
    protected AbstractWindow_GUI window_gui;
    private boolean hassecondaryitem = false;
    protected boolean isfinish = false;
    protected boolean isRowPrimary = false;
    protected boolean createbyLoad = false;
    private boolean creation = false;
    private boolean created = false;
    private boolean creatingadvancesettings = false;
    protected boolean matrixevent = false;
    protected int axisIndex = 0;
    protected int curType = -1;
    protected int initType = 1;
    private int loadIndex;
    private DataMatrixAdapter dataMatrixAdapter = new DataMatrixAdapter();
    private ComboItem item = null;
    private AbstractAdvancedFrame advanceSettings;
    protected MapProperty mapProperty;
    protected String prefix;
    protected SettingsBoxModel settingsBoxModel;
    private final BevelBorder dragBorder = new BevelBorder(1, Color.green, Color.green);
    private final Border normalBorder;
    protected boolean indexWithDescription = false;
    protected int docalculate = 0;

    public AbstractSettingsBox(AbstractDataMatrix abstractDataMatrix, int n) {
        this.matrix = abstractDataMatrix;
        this.initType = n;
        if (this.hasAdvanceSettings()) {
            this.button.setToolTipText("Show advanced settings");
            this.addActionListener(actionEvent -> this.getAdvanceSettings().showModal());
        } else {
            this.button.setEnabled(false);
        }
        this.settingsBoxModel = this.createSettingsBoxModel();
        this.setModel(this.settingsBoxModel);
        this.addItemListener(new ItemSelected());
        this.getComboBox().setRenderer(new SettingsBoxRenderer());
        new DropTarget(this, this);
        this.normalBorder = this.getBorder();
    }

    @Override
    public void addItem(Object object) {
        ComboItem comboItem = (ComboItem)object;
        if (comboItem.getType() >= 100) {
            this.hassecondaryitem = true;
        }
        this.settingsBoxModel.addElement(object);
    }

    public abstract void Calculate();

    public void Calculate(DataMatrixEvent dataMatrixEvent) {
        this.Calculate();
    }

    public void cleanUpAdvanceSettings() {
        if (this.advanceSettings != null) {
            this.advanceSettings.cleanUp();
            this.advanceSettings = null;
        }
    }

    @Override
    public boolean dataInfoEvent(DataInfoEvent dataInfoEvent) {
        if (this.isCleaned()) {
            return false;
        }
        byte by = dataInfoEvent.getType();
        if (by != 11 && by != 12) {
            this.updateComboItems(true, false);
            this.settingsBoxModel.updateSelectedItem();
        }
        return true;
    }

    @Override
    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        if (!this.isProtected()) {
            this.setBorder(this.dragBorder);
        }
    }

    @Override
    public void dragExit(DropTargetEvent dropTargetEvent) {
        this.setBorder(this.normalBorder);
    }

    @Override
    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        dropTargetDragEvent.acceptDrag(3);
    }

    @Override
    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        try {
            this.setBorder(this.normalBorder);
            Transferable transferable = dropTargetDropEvent.getTransferable();
            if (!transferable.isDataFlavorSupported(TransferNode.INFO_FLAVOR) || this.isProtected()) {
                dropTargetDropEvent.rejectDrop();
                if (this.isProtected()) {
                    JOptionPane.showConfirmDialog(this, "Cannot drag new data to this layer", "Cannot drop", -1, 1, null);
                }
                return;
            }
            TransferNode transferNode = (TransferNode)transferable.getTransferData(TransferNode.INFO_FLAVOR);
            DataTreeInterface dataTreeInterface = this.window_gui.getProject_GUI().dataTreeManager.getDataTreeInterface(transferNode.getNodeID());
            dropTargetDropEvent.acceptDrop(1);
            dropTargetDropEvent.getDropTargetContext().dropComplete(true);
            if (dataTreeInterface instanceof AbstractDataMatrix) {
                AbstractDataMatrix abstractDataMatrix = (AbstractDataMatrix)dataTreeInterface;
                if ((this.initType & abstractDataMatrix.getMatrixTag()) != 0 || this.hassecondaryitem) {
                    this.setMatrix(abstractDataMatrix, true);
                    if (abstractDataMatrix.getN() * abstractDataMatrix.getK() > 0) {
                        if ((this.initType & abstractDataMatrix.getMatrixTag()) == 0) {
                            this.setSelected(100, 0);
                        } else {
                            this.setSelected(0, 0);
                        }
                    } else if (this.hasMainType(5)) {
                        this.setSelected(5, 0);
                    } else if (this.hasMainType(1)) {
                        this.setSelected(1, 0);
                    } else if (this.hasMainType(2)) {
                        this.setSelected(2, 0);
                    }
                    Object object = this.getItemAt(this.getSelectedIndex());
                    this.settingsBoxModel.setSelectedItem(null);
                    this.settingsBoxModel.setSelectedItem(object);
                } else {
                    JOptionPane.showConfirmDialog(this.getParent(), "Cannot set matrix of different type", "Cannot drop", -1, 1, null);
                }
            }
        }
        catch (UnsupportedFlavorException | IOException exception) {
            ErrorHandler.logAndReportException(exception);
            dropTargetDropEvent.rejectDrop();
        }
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
    }

    public void forceUpdate() {
        this.setComboBoxWithData();
        this.updateComboItems(true, false);
        int n = this.item.getIndex();
        int n2 = this.item.getType();
        while (n > this.getItemCount() && --n >= 0) {
        }
        this.setSelected(n2, n < 0 ? 0 : n);
    }

    public AbstractAdvancedFrame getAdvanceSettings() {
        if (this.created && this.advanceSettings == null && !this.creatingadvancesettings) {
            try {
                this.creatingadvancesettings = true;
                if (this.mapProperty != null) {
                    this.mapProperty.setPrefix(this.prefix);
                    if (!this.mapProperty.getPropertyBoolean("adv")) {
                        this.mapProperty = null;
                    }
                }
                this.advanceSettings = this.createAdvanceSettings(this.mapProperty);
                this.mapProperty = null;
                if (this.advanceSettings != null) {
                    this.advanceSettings.SyncronizeComboBox(this.matrix, this.curType, this.axisIndex);
                }
            }
            catch (IOException iOException) {
                ErrorHandler.logAndShowEvinceErrorDialogForException(iOException);
            }
            finally {
                this.creatingadvancesettings = false;
            }
        }
        return this.advanceSettings;
    }

    public int getAxisIndex() {
        return this.axisIndex;
    }

    public final InnerColumnClass getClassColumn() {
        if (this.curType == 19) {
            PredictionClasses predictionClasses = this.getPredictionColumn();
            if (predictionClasses != null) {
                return (InnerColumnClass)predictionClasses.getInnerColumn(this.axisIndex);
            }
            return null;
        }
        Transformations transformations = this.getTransformations(this.curType == 7);
        if (transformations == null) {
            return null;
        }
        return (InnerColumnClass)transformations.getInnerColumn(this.axisIndex, 4);
    }

    public final double getCoord(int n, int n2) {
        if (n2 < 0) {
            return n;
        }
        if (this.isRowPrimary) {
            return this.matrix.getValue(n, n2);
        }
        return this.matrix.getValue(n2, n);
    }

    public final double getCoordPrimary(int n) {
        return this.getCoord(n, this.axisIndex);
    }

    public final double getCoordSecondary(int n) {
        return this.getCoord(this.axisIndex, n);
    }

    public final int getCoordSizePrimary() {
        return this.getDescriptionSizeSecondary();
    }

    public final int getCoordSizeSecondary() {
        return this.getDescriptionSizePrimary();
    }

    public final int getCoordSizeThirdly() {
        return this.getDescriptionSizeThirdly();
    }

    public int getCurType() {
        return this.curType;
    }

    public DataImage getDataImage() {
        return (DataImage)this.getGroupColumnByType(12, true);
    }

    public AbstractDataInfo getDataInfoFromAxis(int n) {
        return null;
    }

    public final String getDescriptionPrimary(int n) {
        return this.getDescriptionPrimary(n, 0);
    }

    public final String getDescriptionPrimary(int n, int n2) {
        AbstractDataMatrix abstractDataMatrix = this.matrix;
        if (abstractDataMatrix == null) {
            return "";
        }
        if (this.isRowPrimary) {
            return abstractDataMatrix.getColumnDescription(n, n2);
        }
        return abstractDataMatrix.getRowDescription(n, n2);
    }

    public final String getDescriptionSecondary(int n) {
        return this.getDescriptionSecondary(n, 0);
    }

    public final String getDescriptionSecondary(int n, int n2) {
        if (this.isRowPrimary) {
            return this.matrix.getRowDescription(n, n2);
        }
        return this.matrix.getColumnDescription(n, n2);
    }

    public final int getDescriptionSizePrimary() {
        if (this.isRowPrimary) {
            return this.matrix.getK();
        }
        return this.matrix.getN();
    }

    public final int getDescriptionSizeSecondary() {
        if (this.isRowPrimary) {
            return this.matrix.getN();
        }
        return this.matrix.getK();
    }

    public final int getDescriptionSizeThirdly() {
        if (this.matrix instanceof FoldMatrix) {
            return this.matrix.getFoldsize();
        }
        return 1;
    }

    public final int getFoldN() {
        if (this.matrix instanceof FoldMatrix) {
            return this.matrix.getFoldN();
        }
        return 0;
    }

    public final String getFoldName(int n) {
        return this.matrix.getFoldName(n);
    }

    public final int getFoldsize() {
        if (this.matrix instanceof FoldMatrix) {
            return this.matrix.getFoldsize();
        }
        return 0;
    }

    public String getMainString(int n) {
        return String.valueOf(this.getMainItem(n));
    }

    public AbstractDataMatrix getMatrix() {
        return this.matrix;
    }

    public String getNiceMainString(int n) {
        ComboItem comboItem = this.getMainItem(n);
        if (comboItem == null) {
            return null;
        }
        return comboItem.toNiceString();
    }

    public boolean getObservationTag() {
        return this.isRowPrimary;
    }

    public final int getOrigIndexPrimary(int n) {
        if (this.isRowPrimary) {
            return this.matrix.getNrefOrig(n);
        }
        return this.matrix.getKrefOrig(n);
    }

    public final int[] getOrigIndexPrimary(int[] nArray, int[] nArray2) {
        if (this.isRowPrimary) {
            return this.matrix.getNrefOrig(nArray, nArray2);
        }
        return this.matrix.getKrefOrig(nArray, nArray2);
    }

    public final int getOrigIndexSecondary(int n) {
        if (this.isRowPrimary) {
            return this.matrix.getKrefOrig(n);
        }
        return this.matrix.getNrefOrig(n);
    }

    public final int[] getOrigIndexSecondary(int[] nArray, int[] nArray2) {
        if (this.isRowPrimary) {
            return this.matrix.getKrefOrig(nArray, nArray2);
        }
        return this.matrix.getNrefOrig(nArray, nArray2);
    }

    public final int getReferenceIndexPrimary(int n) {
        int[] nArray = this.getReferencePrimary();
        if (nArray == null || nArray.length == 0 || n < 0) {
            return n;
        }
        if (n < nArray.length) {
            return nArray[n];
        }
        return nArray[nArray.length - 1];
    }

    public final int getReferenceIndexSecondary(int n) {
        int[] nArray = this.getReferenceSecondary();
        if (nArray == null || nArray.length == 0 || n < 0) {
            return n;
        }
        if (n < nArray.length) {
            return nArray[n];
        }
        return nArray[nArray.length - 1];
    }

    public ComboItem getSelectedComboItem() {
        return this.item;
    }

    public abstract byte getType();

    public AbstractWindow_GUI getWindow_GUI() {
        return this.window_gui;
    }

    public boolean hasAdvanceSettings() {
        return true;
    }

    public boolean hasMainType(int n) {
        return this.getMainItem(n) != null;
    }

    public final boolean hasMissing() {
        return this.matrix.hasMissing();
    }

    public boolean hasSecondaryItem() {
        return this.hassecondaryitem;
    }

    public final boolean isAdvanceSettingsCreated() {
        return this.advanceSettings != null;
    }

    public final boolean isAdvanceSettingsShowing() {
        if (this.advanceSettings != null) {
            return this.advanceSettings.isShowing();
        }
        return false;
    }

    public boolean isCreated() {
        return this.created;
    }

    public final boolean isFilter(int n, int n2) {
        if (this.axisIndex < 0) {
            return true;
        }
        if (this.isRowPrimary) {
            // empty if block
        }
        return this.matrix.isFilterAt(n, n2);
    }

    public boolean isFilterPrimary(int n) {
        return this.isFilter(n, this.axisIndex);
    }

    public final boolean isFilterSecondary(int n) {
        return this.isFilter(this.axisIndex, n);
    }

    public boolean isFinished() {
        return this.isfinish;
    }

    public final boolean isMissing(int n, int n2) {
        if (this.axisIndex < 0) {
            return true;
        }
        if (this.matrix.getFoldN() < 0 && !this.matrix.hasMissing()) {
            return false;
        }
        if (this.isRowPrimary) {
            return this.matrix.isMissing(n, n2);
        }
        return this.matrix.isMissing(n2, n);
    }

    public boolean isMissingPrimary(int n) {
        return this.isMissing(n, this.axisIndex);
    }

    public final boolean isMissingSecondary(int n) {
        return this.isMissing(this.axisIndex, n);
    }

    public boolean isProtected() {
        return false;
    }

    public void LoadProperty(RandomInputStream randomInputStream, MapProperty mapProperty) throws IOException {
        this.prefix = mapProperty.getPrefix();
        this.mapProperty = mapProperty;
        AbstractDataMatrix abstractDataMatrix = (AbstractDataMatrix)mapProperty.resolveNodeFromName(randomInputStream, "matrix");
        if (abstractDataMatrix != null) {
            this.matrix = abstractDataMatrix;
        }
        if (mapProperty.hasProperty("mtag") || mapProperty.hasProperty("ptag")) {
            this.initType = mapProperty.getLVInt();
        }
        this.isRowPrimary = mapProperty.hasProperty("istag") ? mapProperty.getLVBoolean() : this.isRowPrimary();
        this.loadIndex = mapProperty.getPropertyInt("lI");
        if (mapProperty.hasProperty("aI")) {
            this.axisIndex = mapProperty.getLVInt();
        }
        if (mapProperty.hasProperty("cT")) {
            this.curType = mapProperty.getLVInt();
        }
    }

    public void SaveProperty(RandomOutputStream randomOutputStream) throws IOException {
        randomOutputStream.writePropertyNode("matrix", this.matrix);
        randomOutputStream.writePropertyBoolean("istag", this.isRowPrimary);
        if (this.advanceSettings == null && this.mapProperty != null) {
            this.mapProperty.setPrefix(this.prefix);
            if (this.mapProperty.getPropertyBoolean("adv")) {
                this.getAdvanceSettings();
            }
        }
        randomOutputStream.writePropertyBoolean("adv", this.advanceSettings != null);
        if (this.advanceSettings != null) {
            this.advanceSettings.Save(randomOutputStream);
        }
        randomOutputStream.writePropertyInt("lI", super.getSelectedIndex());
        randomOutputStream.writePropertyInt("mtag", this.initType);
        randomOutputStream.writePropertyInt("aI", this.axisIndex);
        randomOutputStream.writePropertyInt("cT", this.curType);
    }

    public void setContentReady(boolean bl) {
    }

    public void setCreated(AbstractWindow_GUI abstractWindow_GUI, boolean bl) {
        if (this.created || abstractWindow_GUI == null) {
            return;
        }
        this.window_gui = abstractWindow_GUI;
        if (!this.created) {
            DataGroupValues dataGroupValues;
            if (this.hasMainType(7) || this.hasMainType(101)) {
                AbstractDataInfo abstractDataInfo;
                dataGroupValues = this.getTransformations(true);
                if (dataGroupValues != null) {
                    dataGroupValues.addListener(this.dataMatrixAdapter);
                }
                if ((dataGroupValues = this.getTransformations(false)) != null) {
                    dataGroupValues.addListener(this.dataMatrixAdapter);
                }
                if (this.hasMainType(7) && (abstractDataInfo = this.getDataInfoFromAxis(0)) != null) {
                    abstractDataInfo.addListener(this);
                }
                if (this.hasMainType(101) && (abstractDataInfo = this.getDataInfoFromAxis(1)) != null) {
                    abstractDataInfo.addListener(this);
                }
            }
            if (this.hasMainType(19) && (dataGroupValues = this.getPredictionColumn()) != null) {
                dataGroupValues.addListener(this.dataMatrixAdapter);
            }
            if (this.hasMainType(5) && (dataGroupValues = this.getDescriptionColumn()) != null) {
                dataGroupValues.addListener(this.dataMatrixAdapter);
            }
            this.created = true;
            this.createbyLoad = bl;
            this.creation = true;
            this.setMatrix(this.matrix, true, false);
            this.creation = false;
            this.createbyLoad = false;
        }
    }

    public void setMatrix(AbstractDataMatrix abstractDataMatrix, boolean bl) {
        this.setMatrix(abstractDataMatrix, bl, false);
    }

    public void setMatrix(AbstractDataMatrix abstractDataMatrix, boolean bl, boolean bl2) {
        if (this.creation || !abstractDataMatrix.equals(this.matrix)) {
            if (this.matrix != null) {
                this.matrix.removeDataTreeChangeListener(this.dataMatrixAdapter);
            }
            this.matrix = abstractDataMatrix;
            if (this.matrix != null) {
                this.isRowPrimary = this.isRowPrimary();
                this.matrix.addDataTreeChangeListener(this.dataMatrixAdapter);
                if (this.updateComboItems(true, bl2)) {
                    bl = false;
                }
                this.getComboBox().setToolTipText(this.matrix.getAbsolutePath());
            }
        }
        this.isfinish = false;
        if (this.createbyLoad) {
            super.setSelectedIndex(this.loadIndex);
            this.isfinish = true;
        } else {
            this.isfinish = true;
            if (bl && this.item != null) {
                this.setSelected(this.item.getType(), this.item.getIndex(), bl2);
            }
        }
    }

    public void setSelected(int n, int n2) {
        this.setSelected(n, n2, true);
    }

    public abstract void setSelected(int var1, int var2, boolean var3);

    public abstract void updateCalculation(boolean var1);

    public void updateClasses() {
        if (this.dataMatrixAdapter != null) {
            this.dataMatrixAdapter.dataGroupChanged(null, (byte)0);
        }
    }

    @Override
    protected void cleanUpChild() {
        AbstractDataInfo abstractDataInfo;
        Description description;
        Transformations transformations;
        super.cleanUpChild();
        this.created = false;
        if (this.matrix != null) {
            this.matrix.removeDataTreeChangeListener(this.dataMatrixAdapter);
        }
        if ((transformations = this.getTransformations(true)) != null) {
            transformations.removeListener(this.dataMatrixAdapter);
        }
        if ((transformations = this.getTransformations(false)) != null) {
            transformations.removeListener(this.dataMatrixAdapter);
        }
        if ((description = this.getDescriptionColumn()) != null) {
            description.removeListener(this.dataMatrixAdapter);
        }
        if ((abstractDataInfo = this.getDataInfoFromAxis(0)) != null) {
            abstractDataInfo.removeListener(this);
        }
        if ((abstractDataInfo = this.getDataInfoFromAxis(1)) != null) {
            abstractDataInfo.removeListener(this);
        }
        this.matrix = null;
        this.dataMatrixAdapter = null;
        this.item = null;
        this.window_gui = null;
        this.cleanUpAdvanceSettings();
        if (this.settingsBoxModel != null) {
            this.settingsBoxModel.removeAllElements();
            this.settingsBoxModel = null;
        }
    }

    protected abstract AbstractAdvancedFrame createAdvanceSettings(MapProperty var1) throws IOException;

    protected SettingsBoxModel createSettingsBoxModel() {
        return new SettingsBoxModel();
    }

    protected boolean creation() {
        return this.creation;
    }

    protected void dataMatrixChanged() {
    }

    protected abstract void fullRepaint();

    protected final ClassTypes getClasses() {
        InnerColumnClass innerColumnClass = this.getClassColumn();
        if (innerColumnClass == null) {
            return null;
        }
        return innerColumnClass.getObject();
    }

    protected int getDataSize(int n) {
        int n2 = -1;
        switch (n) {
            case 0: {
                n2 = this.getDescriptionSizePrimary();
                break;
            }
            case 100: {
                n2 = this.getDescriptionSizeSecondary();
                break;
            }
            case 7: 
            case 101: {
                Transformations transformations = this.getTransformations(n == 7);
                n2 = 0;
                if (transformations == null) break;
                n2 = transformations.getColumns(4);
                break;
            }
            case 19: {
                PredictionClasses predictionClasses = this.getPredictionColumn();
                n2 = 0;
                if (predictionClasses == null) break;
                n2 = predictionClasses.getColumnCount();
                break;
            }
            case 5: {
                Description description = this.getDescriptionColumn();
                if (description == null) {
                    if (this.matrix != null && (this.matrix.getMatrixTag() & 4) != 0) {
                        n2 = 1;
                        break;
                    }
                    n2 = 0;
                    break;
                }
                n2 = description.getColumnCount();
                break;
            }
            case 10: {
                n2 = this.getFoldsize();
                break;
            }
            case 21: {
                DataImage dataImage = this.getDataImage();
                n2 = 0;
                if (dataImage == null) break;
                n2 = dataImage.getColumnCount();
            }
        }
        return n2;
    }

    protected Description getDescriptionColumn() {
        return (Description)this.getGroupColumnByType(0, true);
    }

    protected final DataGroupValues getGroupColumnByType(int n, boolean bl) {
        AbstractDataInfo abstractDataInfo = this.getDataInfoFromAxis(bl ? 0 : 1);
        if (abstractDataInfo != null) {
            return abstractDataInfo.getGroupColumnByType(n);
        }
        return null;
    }

    protected final InnerColumnBooleanIncExc getIncExcColumn() {
        boolean bl;
        boolean bl2 = bl = this.initType == 1;
        if (this.matrix instanceof FoldMatrix) {
            bl = true;
        }
        return (InnerColumnBooleanIncExc)this.getGroupColumnByType(1, bl).getPrimaryColumn();
    }

    protected int getIndexByString(String string) {
        string = EvinceScriptCommands.removeSpace(string);
        JComboBoxCell jComboBoxCell = this.getComboBox();
        for (int i = 0; i < jComboBoxCell.getItemCount(); ++i) {
            String string2;
            ComboItem comboItem = (ComboItem)jComboBoxCell.getItemAt(i);
            if (comboItem.isMainitem() || !(string2 = EvinceScriptCommands.removeSpace(comboItem.toString())).equalsIgnoreCase(string)) continue;
            return i - this.getMainItemCount();
        }
        return -1;
    }

    protected AbstractDataMatrix getInitMatrix() {
        return this.matrix;
    }

    protected ComboItem getMainItem(int n) {
        JComboBoxCell jComboBoxCell = this.getComboBox();
        int n2 = this.settingsBoxModel == null ? jComboBoxCell.getItemCount() : this.getMainItemCount();
        for (int i = 0; i < n2; ++i) {
            ComboItem comboItem = (ComboItem)jComboBoxCell.getItemAt(i);
            if (comboItem.isMainitem()) {
                if (comboItem.getType() != n) continue;
                return comboItem;
            }
            return null;
        }
        return null;
    }

    protected int getMainItemCount() {
        if (this.settingsBoxModel != null) {
            return this.settingsBoxModel.getSize() - this.settingsBoxModel.indexSize;
        }
        return 0;
    }

    protected PredictionClasses getPredictionColumn() {
        PredictionClasses predictionClasses = (PredictionClasses)this.getGroupColumnByType(11, true);
        if (predictionClasses != null) {
            return predictionClasses.getSpecificPredictionClasses(this.matrix);
        }
        return null;
    }

    protected final int[] getReferencePrimary() {
        if (this.isRowPrimary) {
            return this.matrix.getNref();
        }
        return this.matrix.getKref();
    }

    protected final int[] getReferenceSecondary() {
        if (this.isRowPrimary) {
            return this.matrix.getKref();
        }
        return this.matrix.getNref();
    }

    protected Transformations getTransformations(boolean bl) {
        return (Transformations)this.getGroupColumnByType(10, bl);
    }

    protected void matrixEventFinished(DataTreeEvent dataTreeEvent) {
        this.matrixEventFinished(dataTreeEvent.getID());
    }

    protected abstract void matrixEventFinished(int var1);

    protected void setComboBoxWithData() {
        if (this.settingsBoxModel != null) {
            this.settingsBoxModel.setIndexSize(this.getDataSize(this.curType));
        }
    }

    protected abstract boolean setComboItems(boolean var1, boolean var2, boolean var3);

    protected void setMatrix(DataMatrixEvent dataMatrixEvent) {
        this.setMatrix(dataMatrixEvent.getMatrix(), false, false);
    }

    protected abstract void setSelectedChild();

    protected void SyncronizeComboBox() {
        AbstractAdvancedFrame abstractAdvancedFrame;
        if (this.created && (abstractAdvancedFrame = this.getAdvanceSettings()) != null && this.item != null) {
            abstractAdvancedFrame.SyncronizeComboBox(this.matrix, this.item.getType(), this.item.getIndex());
        }
    }

    protected boolean updateComboItems(boolean bl, boolean bl2) {
        int n;
        if (!this.shouldEnable(this.curType)) {
            if (this.hasMainType(1) && !(this instanceof ComboBoxComment)) {
                this.setSelected(1, 0);
            } else if (this.hasMainType(2)) {
                this.setSelected(2, 0);
            }
        }
        JComboBoxCell jComboBoxCell = this.getComboBox();
        if (this.settingsBoxModel != null) {
            ComboItem comboItem;
            this.settingsBoxModel.removeIndexSize();
            for (n = 0; n < jComboBoxCell.getItemCount() && (comboItem = (ComboItem)jComboBoxCell.getItemAt(n)).isMainitem(); ++n) {
                comboItem.setEnabled(this.shouldEnable(comboItem.getType()));
            }
        }
        n = this.setComboItems(this.createbyLoad, bl, bl2);
        this.setEnabledComboBox(this.getItemCount() > 1);
        return n != 0;
    }

    private int getOriginalIndex(ReferenceMatrix referenceMatrix, int n) throws Exception {
        try {
            return referenceMatrix.getReferenceNref()[n];
        }
        catch (Exception exception) {
            if (referenceMatrix.getRefRow() != 0) {
                return referenceMatrix.getRefRow();
            }
            throw new Exception("Could not find original index");
        }
    }

    private final boolean isRowPrimary() {
        AbstractDataMatrix abstractDataMatrix;
        boolean bl = true;
        if (this.matrix != null && this.matrix.isModel()) {
            boolean bl2 = bl = (this.matrix.getMatrixTag() & 2) != 0;
        }
        if ((abstractDataMatrix = this.getInitMatrix()) instanceof NormalizedModelMatrix && this.getType() > 2) {
            return false;
        }
        if (this.initType == 1) {
            return bl;
        }
        return !bl;
    }

    private boolean shouldEnable(int n) {
        return this.getDataSize(n) != 0;
    }

    private class DataMatrixAdapter
    implements DataMatrixListener,
    DataGroupListener {
        private DataMatrixAdapter() {
        }

        @Override
        public void dataGroupChanged(AbstractInnerColumn abstractInnerColumn, byte by) {
            if (AbstractSettingsBox.this.hasMainType(7) || AbstractSettingsBox.this.hasMainType(101) || AbstractSettingsBox.this.hasMainType(19) || AbstractSettingsBox.this.hasMainType(5)) {
                AbstractSettingsBox.this.updateComboItems(true, false);
                if (AbstractSettingsBox.this.settingsBoxModel != null && AbstractSettingsBox.this.axisIndex >= AbstractSettingsBox.this.settingsBoxModel.getIndexSize()) {
                    AbstractSettingsBox.this.axisIndex = Math.max(0, AbstractSettingsBox.this.settingsBoxModel.getIndexSize() - 1);
                }
                if (AbstractSettingsBox.this.curType == 7 || AbstractSettingsBox.this.curType == 101 || AbstractSettingsBox.this.curType == 19 || AbstractSettingsBox.this.curType == 5) {
                    AbstractSettingsBox.this.Calculate();
                    AbstractSettingsBox.this.fullRepaint();
                }
            }
        }

        @Override
        public void eventFinished(DataTreeEvent dataTreeEvent) {
            AbstractSettingsBox.this.matrixEventFinished(dataTreeEvent);
        }

        @Override
        public void matrixChanged(DataMatrixEvent dataMatrixEvent) {
            AbstractSettingsBox.this.matrixevent = true;
            AbstractSettingsBox.this.setMatrix(dataMatrixEvent);
            if (dataMatrixEvent.hasStructureChanged() || AbstractSettingsBox.this instanceof ComboBoxDescription) {
                AbstractSettingsBox.this.updateComboItems(true, false);
                AbstractSettingsBox.this.dataMatrixChanged();
            }
            if (AbstractSettingsBox.this.settingsBoxModel != null) {
                AbstractSettingsBox.this.settingsBoxModel.updateSelectedItem();
            }
            AbstractSettingsBox.this.Calculate(dataMatrixEvent);
            AbstractSettingsBox.this.matrixevent = false;
        }

        @Override
        public void nodeReplaced(DataTreeEvent dataTreeEvent) {
            AbstractDataMatrix abstractDataMatrix;
            DataTreeInterface dataTreeInterface = dataTreeEvent.getReplaceDataTreeInterface();
            if (dataTreeInterface instanceof AbstractDataMatrix && !(abstractDataMatrix = (AbstractDataMatrix)dataTreeInterface).isUpdating()) {
                AbstractSettingsBox.this.creation = true;
                AbstractSettingsBox.this.setMatrix(abstractDataMatrix, true);
                AbstractSettingsBox.this.creation = false;
                AbstractSettingsBox.this.SyncronizeComboBox();
                AbstractSettingsBox.this.dataMatrixChanged();
            }
        }

        @Override
        public void propertyChanged(DataTreeEvent dataTreeEvent) {
        }
    }

    protected class SettingsBoxModel
    extends DefaultComboBoxModel {
        protected int indexSize = 0;
        private DataGroupValues groupValues = null;

        protected SettingsBoxModel() {
        }

        public DataGroupValues getDataGroupValues() {
            return this.groupValues;
        }

        @Override
        public Object getElementAt(int n) {
            int n2;
            if (this.groupValues != null && this.groupValues.isCleaned()) {
                AbstractSettingsBox.this.setComboBoxWithData();
            }
            if (n < (n2 = this.getSize() - this.indexSize)) {
                return super.getElementAt(n);
            }
            String string = this.getNameByIndex(n -= n2);
            return new ComboItem(string, AbstractSettingsBox.this.curType, n, n, false);
        }

        public int getIndexSize() {
            return this.indexSize;
        }

        @Override
        public int getSize() {
            if (this.groupValues != null && this.groupValues.isCleaned()) {
                AbstractSettingsBox.this.setComboBoxWithData();
            }
            return super.getSize() + this.indexSize;
        }

        @Override
        public void removeAllElements() {
            this.removeIndexSize();
            super.removeAllElements();
        }

        public void removeIndexSize() {
            int n = this.getSize() - this.indexSize;
            this.fireIntervalRemoved(this, n, this.getSize());
            this.indexSize = 0;
            this.groupValues = null;
        }

        public void setIndexSize(int n) {
            if (n > 0) {
                this.indexSize = n;
                switch (AbstractSettingsBox.this.curType) {
                    case 7: 
                    case 101: {
                        this.groupValues = AbstractSettingsBox.this.getTransformations(AbstractSettingsBox.this.curType == 7);
                        break;
                    }
                    case 19: {
                        this.groupValues = AbstractSettingsBox.this.getPredictionColumn();
                        break;
                    }
                    case 5: {
                        this.groupValues = AbstractSettingsBox.this.getDescriptionColumn();
                        break;
                    }
                    case 21: {
                        this.groupValues = AbstractSettingsBox.this.getDataImage();
                    }
                }
                if (this.groupValues != null && this.groupValues.isCleaned()) {
                    this.groupValues = null;
                    this.indexSize = 0;
                    return;
                }
                int n2 = this.getSize() - n;
                this.fireIntervalAdded(this, n2, this.getSize());
            } else {
                this.indexSize = 0;
            }
        }

        public void updateSelectedItem() {
            String string;
            ComboItem comboItem = AbstractSettingsBox.this.getSelectedComboItem();
            if (comboItem != null && !comboItem.isMainitem() && (string = this.getNameByIndex(comboItem.getIndex())) != null && !string.equals("")) {
                comboItem.setName(string);
                AbstractSettingsBox.this.repaint();
            }
        }

        private String getNameByIndex(int n) {
            Object object = "";
            switch (AbstractSettingsBox.this.curType) {
                case 0: {
                    object = AbstractSettingsBox.this.getDescriptionPrimary(n);
                    int n2 = n;
                    if (AbstractSettingsBox.this.matrix instanceof ReferenceMatrix) {
                        try {
                            n2 = AbstractSettingsBox.this.getOriginalIndex((ReferenceMatrix)AbstractSettingsBox.this.matrix, n);
                        }
                        catch (Exception exception) {
                            n2 = n;
                        }
                    }
                    if (!AbstractSettingsBox.this.indexWithDescription) break;
                    object = n2 + 1 + ": " + (String)object;
                    break;
                }
                case 100: {
                    object = AbstractSettingsBox.this.getDescriptionSecondary(n);
                    if (!AbstractSettingsBox.this.indexWithDescription) break;
                    object = n + 1 + ": " + (String)object;
                    break;
                }
                case 7: 
                case 101: {
                    AbstractInnerColumn abstractInnerColumn;
                    if (!(this.groupValues instanceof Transformations) || (abstractInnerColumn = ((Transformations)this.groupValues).getInnerColumn(n, 4)) == null) break;
                    object = abstractInnerColumn.toString();
                    break;
                }
                case 19: {
                    if (this.groupValues == null) break;
                    object = String.valueOf(this.groupValues.getInnerColumn(n));
                    break;
                }
                case 5: {
                    if (this.groupValues != null) {
                        object = String.valueOf(this.groupValues.getInnerColumn(n));
                        break;
                    }
                    if (AbstractSettingsBox.this.matrix == null || (AbstractSettingsBox.this.matrix.getMatrixTag() & 4) == 0) break;
                    object = AbstractSettingsBox.this.matrix.toString();
                    break;
                }
                case 10: {
                    object = AbstractSettingsBox.this.getFoldName(n);
                    break;
                }
                case 21: {
                    if (this.groupValues == null) break;
                    object = String.valueOf(this.groupValues.getInnerColumn(n));
                }
            }
            return object;
        }
    }

    private class ItemSelected
    implements ItemListener {
        private ItemSelected() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() == 1) {
                AbstractSettingsBox.this.item = (ComboItem)itemEvent.getItem();
                String string = AbstractSettingsBox.this.item.toString();
                if (!"%SEPARATOR#".equals(string) && AbstractSettingsBox.this.item.isEnabled()) {
                    if (AbstractSettingsBox.this.advanceSettings != null) {
                        AbstractSettingsBox.this.SyncronizeComboBox();
                    }
                    if (AbstractSettingsBox.this.isfinish) {
                        AbstractSettingsBox.this.setSelected(AbstractSettingsBox.this.item.getType(), AbstractSettingsBox.this.item.getIndex());
                    }
                }
            }
        }
    }

    class SettingsBoxRenderer
    extends ComboBoxRenderer {
        private Font boldfont = null;

        SettingsBoxRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            Component component = super.getListCellRendererComponent(jList, object, n, bl, bl2);
            ComboItem comboItem = (ComboItem)object;
            if (AbstractSettingsBox.this.item != null && comboItem != null && comboItem.isMainitem() && comboItem.getType() == AbstractSettingsBox.this.item.getType()) {
                if (this.boldfont == null) {
                    this.boldfont = jList.getFont().deriveFont(1);
                }
                component.setFont(this.boldfont);
            } else {
                component.setFont(jList.getFont());
            }
            return component;
        }
    }
}

