/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.main.layer;

import java.io.IOException;
import javax.swing.ImageIcon;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.datasetcontainer.DataTreeInterface;
import se.prediktera.map.datasetcontainer.ShortcutInterface;
import se.prediktera.map.datasetcontainer.transform.AbstractTransform;
import se.prediktera.map.main.layer.AbstractLayer;

public class LayerContainer
extends AbstractLayer
implements ShortcutInterface {
    private AbstractTransform.Type type;
    private LayerContainer link;

    public LayerContainer(AbstractTransform.Type type) {
        super(0);
        this.type = type;
        switch (type) {
            case globalAdd: {
                this.setLayerName("Classes");
                break;
            }
            case localAdd: {
                this.setLayerName("Additions");
                break;
            }
            case localUpdate: {
                this.setLayerName("Updates");
            }
        }
        this.setEnabled(false);
    }

    public LayerContainer(LayerContainer layerContainer) {
        super(0);
        this.type = layerContainer.getTransformationType();
        this.link = layerContainer.link == null ? layerContainer : layerContainer.link;
        this.setEnabled(false);
    }

    public LayerContainer(RandomInputStream randomInputStream, MapProperty mapProperty) throws IOException {
        super(randomInputStream, mapProperty);
        if (mapProperty.hasProperty("type")) {
            switch (mapProperty.getLVByte()) {
                case 0: {
                    this.type = AbstractTransform.Type.globalAdd;
                    break;
                }
                case 1: {
                    this.type = AbstractTransform.Type.localAdd;
                    break;
                }
                case 2: {
                    this.type = AbstractTransform.Type.localUpdate;
                }
            }
        }
        this.link = (LayerContainer)mapProperty.resolveNodeFromName(randomInputStream, "lnk");
        this.setEnabled(false);
    }

    @Override
    public void addTreeNode(DataTreeInterface dataTreeInterface) {
        if (this.link == null) {
            super.addTreeNode(dataTreeInterface);
        } else {
            this.link.addTreeNode(dataTreeInterface);
        }
    }

    @Override
    public void addTreeNode(DataTreeInterface dataTreeInterface, DataTreeInterface dataTreeInterface2) {
        this.addTreeNode(dataTreeInterface);
    }

    @Override
    public boolean containsTreeNode(DataTreeInterface dataTreeInterface) {
        if (this.link == null) {
            return super.containsTreeNode(dataTreeInterface);
        }
        return this.link.containsTreeNode(dataTreeInterface);
    }

    @Override
    public ImageIcon getIcon(byte by) {
        if (this.link == null) {
            return super.getIcon(by);
        }
        return this.link.getIcon(by);
    }

    @Override
    public String getInformation() {
        if (this.link == null) {
            return super.getInformation();
        }
        return this.link.getInformation();
    }

    @Override
    public byte getNodeType() {
        return 7;
    }

    public AbstractTransform.Type getTransformationType() {
        return this.type;
    }

    @Override
    public DataTreeInterface getTreeNodeAt(int n) {
        if (this.link == null) {
            return super.getTreeNodeAt(n);
        }
        return this.link.getTreeNodeAt(n);
    }

    @Override
    public int getTreeNodeCount() {
        if (this.link == null) {
            return super.getTreeNodeCount();
        }
        return this.link.getTreeNodeCount();
    }

    @Override
    public byte getTreeType() {
        return 5;
    }

    @Override
    public void insertTreeNode(DataTreeInterface dataTreeInterface, int n) {
        super.insertTreeNode(dataTreeInterface, n);
    }

    @Override
    public boolean isLayerVisible() {
        if (this.link == null) {
            return super.isLayerVisible();
        }
        return this.link.isLayerVisible();
    }

    @Override
    public boolean isShortcut() {
        return this.link != null;
    }

    @Override
    public void LoadData(RandomInputStream randomInputStream) throws IOException {
    }

    @Override
    public boolean removeTreeNode(DataTreeInterface dataTreeInterface) {
        if (this.link == null) {
            return super.removeTreeNode(dataTreeInterface);
        }
        return this.link.removeTreeNode(dataTreeInterface);
    }

    @Override
    public DataTreeInterface replaceNode(DataTreeInterface dataTreeInterface, DataTreeInterface dataTreeInterface2, boolean bl) {
        if (this.link == null) {
            return super.replaceNode(dataTreeInterface, dataTreeInterface2, bl);
        }
        return this.link.replaceNode(dataTreeInterface, dataTreeInterface2, bl);
    }

    @Override
    public void SaveData(RandomOutputStream randomOutputStream) throws IOException {
    }

    @Override
    public void SaveProperty(RandomOutputStream randomOutputStream) throws IOException {
        switch (this.type) {
            case globalAdd: {
                randomOutputStream.writePropertyByte("type", (byte)0);
                break;
            }
            case localAdd: {
                randomOutputStream.writePropertyByte("type", (byte)1);
                break;
            }
            case localUpdate: {
                randomOutputStream.writePropertyByte("type", (byte)2);
            }
        }
        randomOutputStream.writePropertyNode("lnk", this.link);
    }

    @Override
    public boolean setLayerVisible(boolean bl) {
        if (this.link == null) {
            return super.setLayerVisible(bl);
        }
        return this.link.setLayerVisible(bl);
    }

    @Override
    public void swapNodes(int n, int n2) {
        if (this.link == null) {
            super.swapNodes(n, n2);
        } else {
            this.link.swapNodes(n, n2);
        }
    }

    @Override
    public String toString() {
        if (this.link == null) {
            return super.toString();
        }
        return this.link.toString();
    }
}

