/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.main.newproject;

import java.awt.Dimension;
import java.awt.Image;
import java.util.List;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.common.wizard.AbstractWizard;
import se.prediktera.map.common.wizard.AbstractWizardInfo;
import se.prediktera.map.common.wizard.ComponentBaner;
import se.prediktera.map.common.wizard.SelectWizardPage;
import se.prediktera.map.common.wizard.WizardDialog;
import se.prediktera.map.common.wizard.WizardPageClass;
import se.prediktera.map.datasetcontainer.DataTreeInterface;
import se.prediktera.map.main.Project_GUI;
import se.prediktera.map.main.ProjectsContainer;
import se.prediktera.map.main.newproject.AbstractProjectInfo;
import se.prediktera.map.main.newproject.type.OpenInfo;
import se.prediktera.map.main.newproject.type.RecentInfo;
import se.prediktera.map.main.newproject.type.ScriptPage;
import se.prediktera.map.main.newproject.type.TemplateInfo;

public class NewProjectWizard
extends AbstractWizard {
    private SelectWizardPage page1;
    private final boolean isnew;

    public NewProjectWizard(boolean bl) {
        this.isnew = bl;
        try {
            this.page1 = new SelectWizardPage(this, null, true);
            this.addPage(this.page1, "Project Selection");
            if (bl) {
                this.curWizard = this.page1.setCurWizardFromName(new TemplateInfo(this));
            }
        }
        catch (Exception exception) {
            ErrorHandler.logAndShowEvinceErrorDialogForException(exception);
        }
    }

    @Override
    public void addExtern(List<AbstractWizardInfo> list, DataTreeInterface dataTreeInterface) {
        list.add(new TemplateInfo(this));
        list.add(new ScriptPage(this));
        list.add(new RecentInfo(this));
        list.add(new OpenInfo());
    }

    @Override
    public boolean canFinish() {
        this.curWizard = this.page1.getWizardInfo();
        return this.curWizard != null && ((AbstractProjectInfo)this.curWizard).canFinish() && super.canFinish();
    }

    public Project_GUI createProject(ProjectsContainer projectsContainer) {
        this.curWizard = this.page1.getWizardInfo();
        return ((AbstractProjectInfo)this.curWizard).createProject(projectsContainer);
    }

    @Override
    public int executeWizard() {
        this.setPreferredSize(new Dimension(500, 400));
        this.wizardWindow = new WizardDialog("Project Wizard", this, true, true, false);
        return this.wizardWindow.executeWizard(this.isnew ? 1 : 0);
    }

    @Override
    public boolean finished() {
        return this.canFinish();
    }

    @Override
    public Image getBanner() {
        if (this.banner == null) {
            this.banner = new ComponentBaner(150, 300, -1);
        }
        return this.banner;
    }

    @Override
    public String getDescription() {
        return "Project";
    }

    @Override
    public ImageIcon getIcon() {
        return Project_GUI.projectIcon;
    }

    @Override
    public int getPaintType() {
        return 19;
    }

    @Override
    protected boolean canNext() {
        return this.page1.getWizardInfo() != null && ((AbstractProjectInfo)this.curWizard).canNext() && super.canNext();
    }

    @Override
    protected void cleanUpChild() {
        super.cleanUpChild();
        if (this.page1 != null) {
            this.page1.cleanUp();
            this.page1 = null;
        }
    }

    @Override
    protected String getHelpID() {
        return "evinceCreateproject";
    }

    protected String getTitleInfo() {
        if (this.page1.getWizardInfo() != null) {
            return this.page1.getWizardInfo().toString();
        }
        return "";
    }

    @Override
    protected void pageChangedLocal(WizardPageClass wizardPageClass, int n) {
        if (this.page1 != null) {
            this.curWizard = this.page1.getWizardInfo();
        }
        if (n == 0) {
            this.removePagesKeepOne();
            if (this.page1 != null && this.curWizard != null) {
                Vector<JComponent> vector = this.curWizard.createWizard();
                if (vector != null) {
                    for (int i = 0; i < vector.size(); ++i) {
                        this.addPage(vector.elementAt(i), "page");
                    }
                }
                this.page1.getWizardInfo().beginWizard();
            }
        }
    }
}

