/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.main.newproject;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.common.swing.ViewportWithBackground;
import se.prediktera.map.common.wizard.WizardPageClass;
import se.prediktera.map.main.IniManager;
import se.prediktera.map.main.Project_GUI;
import se.prediktera.map.main.PropertiesPanel;
import se.prediktera.map.main.newproject.ItemClass;
import se.prediktera.map.main.newproject.ProjectPreviewPanel;
import se.prediktera.map.main.script.ScriptFile;
import se.prediktera.map.main.script.ScriptManager;

public class ProjectPanel
extends WizardPageClass {
    protected JList fileList = new JList(){

        @Override
        public String getToolTipText(MouseEvent mouseEvent) {
            int n = this.locationToIndex(mouseEvent.getPoint());
            Object e = this.getModel().getElementAt(n);
            if (e instanceof ItemClass) {
                return ((ItemClass)e).getFile().getPath();
            }
            return null;
        }
    };
    protected final JLabel labelInfo = new JLabel("Info");
    protected final Vector<ItemClass> listVector = new Vector();
    private ProjectPreviewPanel myPreviewPanel = new ProjectPreviewPanel();
    private final int type;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProjectPanel(int n) {
        this.type = n;
        try {
            this.fileList.setSelectionMode(0);
            this.jbInit();
            if (n == 0) {
                this.labelInfo.setText("Select Recent Project");
                List<File> list = IniManager.getRecentProject();
                for (File file : list) {
                    if (!file.exists()) continue;
                    RandomInputStream randomInputStream = null;
                    try {
                        randomInputStream = new RandomInputStream(null, file, null);
                        RandomInputStream.FileFramework fileFramework = randomInputStream.readFileFramework(false);
                        String string = file.getName().toUpperCase();
                        string = string.substring(0, string.length() - 4);
                        String string2 = PropertiesPanel.parsePropertiesString(fileFramework.description);
                        this.listVector.addElement(new ItemClass(string, file, string2, randomInputStream.getProjectImage()));
                    }
                    catch (IOException iOException) {}
                    continue;
                    finally {
                        if (randomInputStream == null) continue;
                        randomInputStream.tryClose();
                    }
                }
            } else if (n == 1) {
                this.labelInfo.setText("Select Template");
            } else if (n == 2 || n == 3) {
                this.labelInfo.setText("Select Routine Analysis");
                ArrayList<ScriptFile> arrayList = null;
                if (n == 2) {
                    arrayList = ScriptManager.getScriptFiles("Custom", null);
                } else {
                    arrayList = ScriptManager.listScriptFromServer();
                    this.fileList.setSelectionMode(2);
                }
                Collections.sort(arrayList);
                for (ScriptFile scriptFile : arrayList) {
                    if (scriptFile.getSubType() != null && scriptFile.getSubType().equalsIgnoreCase("breeze")) continue;
                    StringBuilder stringBuilder = new StringBuilder().append(scriptFile.getScriptInfo());
                    if (scriptFile.getShortcut().length() > 0) {
                        stringBuilder.append("\n\nShortcut: ").append(scriptFile.getShortcut());
                    }
                    ItemClass itemClass = new ItemClass(scriptFile.getName(), scriptFile.getFile(), stringBuilder.toString(), null);
                    itemClass.setObject(scriptFile);
                    this.listVector.addElement(itemClass);
                }
            }
            this.fileList.setListData(this.listVector);
            this.fileList.addListSelectionListener(new ListListener());
            if (this.listVector.size() > 0) {
                this.fileList.setSelectedIndex(0);
            }
        }
        catch (Exception exception) {
            ErrorHandler.logAndShowEvinceErrorDialogForException(exception);
        }
    }

    @Override
    public void arrowKeyPressed(boolean bl) {
        int n = this.fileList.getSelectedIndex();
        if (bl && n > 0) {
            this.fileList.setSelectedIndex(n - 1);
        }
        if (!bl && ++n < this.listVector.size()) {
            this.fileList.setSelectedIndex(n);
        }
    }

    public ItemClass getSelectedItem() {
        int n = this.fileList.getSelectedIndex();
        if (n >= 0 && n < this.listVector.size()) {
            ItemClass itemClass = this.listVector.elementAt(n);
            if (this.type == 1) {
                if (itemClass.getFile() != null) {
                    IniManager.setWorkPath((byte)3, this.getName(itemClass.getFile()));
                } else if (itemClass.getTemplateInfo() != null) {
                    IniManager.setWorkPath((byte)3, itemClass.getTemplateInfo().toString());
                }
            }
            return itemClass;
        }
        return null;
    }

    public int[] getSelectedItems() {
        return this.fileList.getSelectedIndices();
    }

    public Object[] getSelectedValues() {
        return this.fileList.getSelectedValues();
    }

    public boolean hasFiles() {
        return !this.listVector.isEmpty();
    }

    public boolean isSingleItem() {
        return this.listVector.size() == 1;
    }

    @Override
    protected void cleanUpChild() {
        if (this.myPreviewPanel != null) {
            this.myPreviewPanel.cleanUp();
            this.myPreviewPanel = null;
        }
    }

    private String getName(File file) {
        String string = file.getName();
        if (string.indexOf(46) >= 0) {
            return string.substring(0, string.length() - 4);
        }
        return string;
    }

    private void jbInit() throws Exception {
        Dimension dimension = new Dimension(200, 300);
        GradientPaint gradientPaint = new GradientPaint(0.0f, 0.0f, new Color(255, 255, 255, 200), dimension.width, dimension.height, new Color(200, 200, 200, 200));
        ViewportWithBackground viewportWithBackground = new ViewportWithBackground(gradientPaint, dimension);
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setViewport(viewportWithBackground);
        jScrollPane.setMaximumSize(jScrollPane.getPreferredSize());
        jScrollPane.setMinimumSize(jScrollPane.getPreferredSize());
        this.fileList.setOpaque(false);
        this.fileList.setCellRenderer(new myListCellRenderer());
        this.setLayout(new GridBagLayout());
        this.labelInfo.setFont(new Font("Dialog", 1, 12));
        this.add((Component)this.labelInfo, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 17, 0, new Insets(12, 12, 0, 0), 0, 0));
        this.add((Component)jScrollPane, new GridBagConstraints(0, 1, 1, 1, 0.0, 1.0, 10, 1, new Insets(7, 12, 11, 0), 0, 0));
        this.add((Component)this.myPreviewPanel, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 12, 8, 12), 0, 0));
        jScrollPane.getViewport().add((Component)this.fileList, null);
    }

    class ListListener
    implements ListSelectionListener {
        ListListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            ItemClass itemClass;
            if (ProjectPanel.this.listVector.size() > 0 && (itemClass = (ItemClass)ProjectPanel.this.fileList.getSelectedValue()) != null) {
                if (itemClass.getFile() != null && itemClass.getObject() == null) {
                    ProjectPanel.this.myPreviewPanel.configure(itemClass.getFile());
                } else {
                    ProjectPanel.this.myPreviewPanel.updateTextArea(itemClass.getDescription());
                }
                ProjectPanel.this.myPreviewPanel.updateImage(itemClass.getImage());
            }
        }
    }

    class myListCellRenderer
    extends JLabel
    implements ListCellRenderer {
        public myListCellRenderer() {
            this.setHorizontalAlignment(2);
            this.setVerticalAlignment(0);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            this.setOpaque(bl || jList.isOpaque());
            this.setText(object.toString());
            if (ProjectPanel.this.type != 1) {
                this.setIcon(Project_GUI.dotIcon);
            }
            return this;
        }
    }
}

