/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.main.newproject;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.io.File;
import java.io.IOException;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.cleanup.CleanUpPanel;
import se.prediktera.map.common.opensave.PreviewInterface;
import se.prediktera.map.common.swing.EvinceBorderFactory;
import se.prediktera.map.common.swing.filechooser.jopensaveDialog;
import se.prediktera.map.main.PropertiesPanel;

public class ProjectPreviewPanel
extends CleanUpPanel
implements PreviewInterface {
    private final JTextArea textAreaNotes = new JTextArea("");
    private final ExamplePanel previewPanel = new ExamplePanel();
    private Image image = null;

    public ProjectPreviewPanel() {
        super(new GridBagLayout());
        this.textAreaNotes.setFont(new Font("Dialog", 0, 11));
        this.textAreaNotes.setOpaque(false);
        this.textAreaNotes.setEditable(false);
        this.textAreaNotes.setLineWrap(true);
        this.textAreaNotes.setWrapStyleWord(true);
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setHorizontalScrollBarPolicy(31);
        jScrollPane.setBorder(EvinceBorderFactory.createEvinceBorder("Description"));
        jScrollPane.setOpaque(false);
        jScrollPane.getViewport().setOpaque(false);
        this.setPreferredSize(new Dimension(250, 300));
        this.setMinimumSize(new Dimension(250, 300));
        this.add((Component)jScrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        jScrollPane.getViewport().add((Component)this.textAreaNotes, null);
        this.add((Component)this.previewPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void configure(File file) {
        if (file == null || !file.isFile()) {
            this.textAreaNotes.setText("");
            return;
        }
        RandomInputStream randomInputStream = null;
        try {
            randomInputStream = new RandomInputStream(null, file, null);
            RandomInputStream.FileFramework fileFramework = randomInputStream.readFileFramework(false);
            randomInputStream.goToIndex((byte)9);
            StringBuilder stringBuilder = new StringBuilder("Name: ").append(jopensaveDialog.getFileName(file)).append("\n");
            stringBuilder.append(PropertiesPanel.parsePropertiesString(fileFramework.description));
            this.updateTextArea(stringBuilder.toString());
            this.updateImage(randomInputStream.getProjectImage());
        }
        catch (IOException iOException) {
        }
        finally {
            if (randomInputStream != null) {
                try {
                    randomInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void updateImage(Image image) {
        this.image = image;
        this.previewPanel.repaint();
    }

    public void updateTextArea(String string) {
        if (string == null) {
            this.textAreaNotes.setText("");
        } else {
            this.textAreaNotes.setText(string);
        }
        this.textAreaNotes.setCaretPosition(0);
    }

    @Override
    protected void cleanUpChild() {
    }

    private class ExamplePanel
    extends JPanel {
        public ExamplePanel() {
            this.setBorder(EvinceBorderFactory.createEvinceBorder("Preview"));
            this.setPreferredSize(new Dimension(200, 200));
            this.setMinimumSize(new Dimension(200, 200));
        }

        @Override
        public void paint(Graphics graphics) {
            super.paint(graphics);
            double d = this.getWidth();
            double d2 = this.getHeight();
            if (ProjectPreviewPanel.this.image == null) {
                graphics.setColor(Color.darkGray);
                FontMetrics fontMetrics = graphics.getFontMetrics();
                graphics.drawString("Not available", (int)(d / 2.0 - (double)(fontMetrics.stringWidth("Not available") / 2)), (int)(d2 / 2.0 + (double)(fontMetrics.getHeight() / 2)));
            } else {
                int n = ProjectPreviewPanel.this.image.getHeight(null);
                int n2 = ProjectPreviewPanel.this.image.getWidth(null);
                graphics.drawImage(ProjectPreviewPanel.this.image, (int)((d - (double)n2) / 2.0), (int)((d2 - (double)n) / 2.0), null);
            }
        }
    }
}

