/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.main.newproject.type;

import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.common.wizard.AbstractWizard;
import se.prediktera.map.main.Main_GUI;
import se.prediktera.map.main.Project_GUI;
import se.prediktera.map.main.ProjectsContainer;
import se.prediktera.map.main.newproject.AbstractProjectInfo;
import se.prediktera.map.main.newproject.NewProjectWizard;
import se.prediktera.map.main.newproject.type.ListPage;

public class RecentInfo
extends AbstractProjectInfo {
    private static final ImageIcon imageIcon = new ImageIcon(NewProjectWizard.class.getResource("image/recent.gif"));
    private ListPage listPage;

    public RecentInfo(AbstractWizard abstractWizard) {
        try {
            this.listPage = new ListPage(abstractWizard, 0);
        }
        catch (Exception exception) {
            ErrorHandler.logAndReportException(exception);
        }
    }

    @Override
    public boolean canFinish() {
        return this.listPage.getSelectedItem() != null;
    }

    @Override
    public boolean canNext() {
        return this.listPage.hasFiles();
    }

    @Override
    public Project_GUI createProject(ProjectsContainer projectsContainer) {
        Main_GUI.get().openProject(this.listPage.getSelectedItem().getFile(), false);
        return null;
    }

    @Override
    public Vector<JComponent> createWizard() {
        Vector<JComponent> vector = new Vector<JComponent>();
        vector.add(this.listPage);
        return vector;
    }

    @Override
    public ImageIcon getWizardImage() {
        return imageIcon;
    }

    @Override
    public String getWizardInfo() {
        return "Allows the user to select a recently opened project to continue working on.";
    }

    @Override
    public String toString() {
        return "Recent";
    }

    @Override
    protected void cleanUpChild() {
        if (this.listPage != null) {
            this.listPage.cleanUp();
            this.listPage = null;
        }
    }
}

